/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jogg;

public class Page {
    private static int[] crc_lookup = new int[256];
    public byte[] header_base;
    public int header;
    public int header_len;
    public byte[] body_base;
    public int body;
    public int body_len;

    private static final int crc_entry(int index) {
        int r = index << 24;
        int i = 0;
        while (i < 8) {
            r = (r & Integer.MIN_VALUE) != 0 ? r << 1 ^ 0x4C11DB7 : (r <<= 1);
            ++i;
        }
        return r & 0xFFFFFFFF;
    }

    int version() {
        return this.header_base[this.header + 4] & 0xFF;
    }

    int continued() {
        return this.header_base[this.header + 5] & 1;
    }

    public int bos() {
        return this.header_base[this.header + 5] & 2;
    }

    public int eos() {
        return this.header_base[this.header + 5] & 4;
    }

    public long granulepos() {
        long foo = this.header_base[this.header + 13] & 0xFF;
        foo = foo << 8 | (long)(this.header_base[this.header + 12] & 0xFF);
        foo = foo << 8 | (long)(this.header_base[this.header + 11] & 0xFF);
        foo = foo << 8 | (long)(this.header_base[this.header + 10] & 0xFF);
        foo = foo << 8 | (long)(this.header_base[this.header + 9] & 0xFF);
        foo = foo << 8 | (long)(this.header_base[this.header + 8] & 0xFF);
        foo = foo << 8 | (long)(this.header_base[this.header + 7] & 0xFF);
        foo = foo << 8 | (long)(this.header_base[this.header + 6] & 0xFF);
        return foo;
    }

    public int serialno() {
        return this.header_base[this.header + 14] & 0xFF | (this.header_base[this.header + 15] & 0xFF) << 8 | (this.header_base[this.header + 16] & 0xFF) << 16 | (this.header_base[this.header + 17] & 0xFF) << 24;
    }

    int pageno() {
        return this.header_base[this.header + 18] & 0xFF | (this.header_base[this.header + 19] & 0xFF) << 8 | (this.header_base[this.header + 20] & 0xFF) << 16 | (this.header_base[this.header + 21] & 0xFF) << 24;
    }

    void checksum() {
        int crc_reg = 0;
        int i = 0;
        while (i < this.header_len) {
            crc_reg = crc_reg << 8 ^ crc_lookup[crc_reg >>> 24 & 0xFF ^ this.header_base[this.header + i] & 0xFF];
            ++i;
        }
        i = 0;
        while (i < this.body_len) {
            crc_reg = crc_reg << 8 ^ crc_lookup[crc_reg >>> 24 & 0xFF ^ this.body_base[this.body + i] & 0xFF];
            ++i;
        }
        this.header_base[this.header + 22] = (byte)crc_reg;
        this.header_base[this.header + 23] = (byte)(crc_reg >>> 8);
        this.header_base[this.header + 24] = (byte)(crc_reg >>> 16);
        this.header_base[this.header + 25] = (byte)(crc_reg >>> 24);
    }

    static {
        int i = 0;
        while (i < crc_lookup.length) {
            Page.crc_lookup[i] = Page.crc_entry(i);
            ++i;
        }
    }
}

