/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jheora;

import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class YUVBuffer
implements ImageProducer {
    private static final int VAL_RANGE = 256;
    private static final int SHIFT = 16;
    private static final int CR_FAC = 91881;
    private static final int CB_FAC = 116129;
    private static final int CR_DIFF_FAC = 46801;
    private static final int CB_DIFF_FAC = 22553;
    private static int[] r_tab = new int[768];
    private static int[] g_tab = new int[768];
    private static int[] b_tab = new int[768];
    public int y_width;
    public int y_height;
    public int y_stride;
    public int uv_width;
    public int uv_height;
    public int uv_stride;
    public short[] data;
    public int y_offset;
    public int u_offset;
    public int v_offset;
    private int[] pixels;
    private int pix_size;
    private boolean newPixels;
    private ColorModel colorModel;

    public void addConsumer(ImageConsumer ic) {
    }

    public boolean isConsumer(ImageConsumer ic) {
        return false;
    }

    public void removeConsumer(ImageConsumer ic) {
    }

    public void requestTopDownLeftRightResend(ImageConsumer ic) {
    }

    public void startProduction(ImageConsumer ic) {
        ic.setColorModel(this.colorModel);
        ic.setHints(30);
        ic.setDimensions(this.y_width, this.y_height);
        this.prepareRGBData(0, 0, this.y_width, this.y_height);
        ic.setPixels(0, 0, this.y_width, this.y_height, this.colorModel, this.pixels, 0, this.y_width);
        ic.imageComplete(3);
    }

    private final synchronized void prepareRGBData(int x, int y, int width, int height) {
        if (!this.newPixels) {
            return;
        }
        int size = width * height;
        try {
            if (size != this.pix_size) {
                this.pixels = new int[size];
                this.pix_size = size;
            }
            this.YUVtoRGB(x, y, width, height);
        }
        catch (Throwable t) {
            // empty catch block
        }
        this.newPixels = false;
    }

    public synchronized void newPixels() {
        this.newPixels = true;
    }

    public Object getObject(int x, int y, int width, int height) {
        return this;
    }

    private final void YUVtoRGB(int x, int y, int width, int height) {
        int YPtr = this.y_offset + x + y * this.y_stride;
        int YPtr2 = YPtr + this.y_stride;
        int UPtr = this.u_offset + x / 2 + y / 2 * this.uv_stride;
        int VPtr = this.v_offset + x / 2 + y / 2 * this.uv_stride;
        int RGBPtr = 0;
        int RGBPtr2 = width;
        int width2 = width / 2;
        int height2 = height / 2;
        int YStep = this.y_stride * 2 - width2 * 2;
        int UVStep = this.uv_stride - width2;
        int RGBStep = width;
        int i = 0;
        while (i < height2) {
            int j = 0;
            while (j < width2) {
                int UFactor = this.data[UPtr++] - 128;
                int VFactor = this.data[VPtr++] - 128;
                int GFactor = UFactor * 46801 + VFactor * 22553 - 0x1000000;
                UFactor = UFactor * 91881 + 0x1000000;
                VFactor = VFactor * 116129 + 0x1000000;
                int YVal = this.data[YPtr] << 16;
                this.pixels[RGBPtr] = r_tab[YVal + VFactor >> 16] | b_tab[YVal + UFactor >> 16] | g_tab[YVal - GFactor >> 16];
                YVal = this.data[YPtr + 1] << 16;
                this.pixels[RGBPtr + 1] = r_tab[YVal + VFactor >> 16] | b_tab[YVal + UFactor >> 16] | g_tab[YVal - GFactor >> 16];
                YVal = this.data[YPtr2] << 16;
                this.pixels[RGBPtr2] = r_tab[YVal + VFactor >> 16] | b_tab[YVal + UFactor >> 16] | g_tab[YVal - GFactor >> 16];
                YVal = this.data[YPtr2 + 1] << 16;
                this.pixels[RGBPtr2 + 1] = r_tab[YVal + VFactor >> 16] | b_tab[YVal + UFactor >> 16] | g_tab[YVal - GFactor >> 16];
                YPtr += 2;
                YPtr2 += 2;
                RGBPtr += 2;
                RGBPtr2 += 2;
                ++j;
            }
            YPtr += YStep;
            YPtr2 += YStep;
            UPtr += UVStep;
            VPtr += UVStep;
            RGBPtr += RGBStep;
            RGBPtr2 += RGBStep;
            ++i;
        }
    }

    private static final short clamp255(int val) {
        val -= 255;
        val = -(255 + (val >> 31 & val));
        return (short)(-(val >> 31 & val));
    }

    private static final void SetupRgbYuvAccelerators() {
        int i = 0;
        while (i < 768) {
            YUVBuffer.r_tab[i] = YUVBuffer.clamp255(i - 256) << 16;
            YUVBuffer.g_tab[i] = YUVBuffer.clamp255(i - 256) << 8;
            YUVBuffer.b_tab[i] = YUVBuffer.clamp255(i - 256) | 0xFF000000;
            ++i;
        }
    }

    private final /* synthetic */ void this() {
        this.newPixels = true;
        this.colorModel = ColorModel.getRGBdefault();
    }

    public YUVBuffer() {
        this.this();
    }

    static {
        YUVBuffer.SetupRgbYuvAccelerators();
    }
}

