/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.player;

import com.fluendo.player.StatusListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.MemoryImageSource;
import java.util.Enumeration;
import java.util.Vector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Status
extends Component
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    private static final int NONE = 0;
    private static final int BUTTON1 = 1;
    private static final int BUTTON2 = 2;
    private static final int SEEKER = 3;
    private static final int SEEKBAR = 4;
    private static final int SEEK_END = 60;
    public static final int STATE_STOPPED = 0;
    public static final int STATE_PAUSED = 1;
    public static final int STATE_PLAYING = 2;
    private int bufferPercent;
    private boolean buffering;
    private String message;
    private String error;
    private Rectangle r;
    private Component component;
    private Font font;
    private boolean haveAudio;
    private boolean havePercent;
    private boolean seekable;
    private int clicked;
    private Color button1Color;
    private Color button2Color;
    private Color seekColor;
    private int state;
    private double position;
    private long time;
    private double duration;
    private String speaker;
    private Image speakerImg;
    private Vector listeners;

    public void addStatusListener(StatusListener l) {
        this.listeners.addElement(l);
    }

    public void removeStatusListener(StatusListener l) {
        this.listeners.remove(l);
    }

    public void notifyNewState(int newState) {
        Enumeration e = this.listeners.elements();
        while (e.hasMoreElements()) {
            ((StatusListener)e.nextElement()).newState(newState);
        }
    }

    public void notifySeek(double position) {
        Enumeration e = this.listeners.elements();
        while (e.hasMoreElements()) {
            ((StatusListener)e.nextElement()).newSeek(position);
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    private final void paintBox(Graphics g) {
        g.setColor(Color.darkGray);
        g.drawRect(0, 0, this.r.width - 1, this.r.height - 1);
        g.setColor(Color.black);
        g.fillRect(1, 1, this.r.width - 2, this.r.height - 2);
    }

    private final void paintPercent(Graphics g) {
        if (this.havePercent) {
            g.setColor(Color.white);
            g.drawString("" + this.bufferPercent + '%', this.r.width - 38, this.r.height - 2);
        }
    }

    private final void paintPlayPause(Graphics g) {
        int x = 1;
        int y = 1;
        int w = this.r.height - 2;
        int h = this.r.height - 2;
        g.setColor(Color.darkGray);
        g.drawRect(x, y, w, h);
        g.setColor(this.button1Color);
        g.fillRect(x + 1, y + 1, w - 1, h - 1);
        if (this.state == 2) {
            g.setColor(Color.white);
            g.fillRect((int)((double)w * 0.4), (int)((double)h * 0.4), (int)((double)w * 0.2), (int)((double)h * 0.5));
            g.fillRect((int)((double)w * 0.7), (int)((double)h * 0.4), (int)((double)w * 0.2), (int)((double)h * 0.5));
        } else {
            int[] triangleX = new int[]{(int)((double)w * 0.4), (int)((double)w * 0.4), (int)((double)w * 0.9)};
            int[] triangleY = new int[]{(int)((double)w * 0.3), (int)((double)w * 0.9), (int)((double)w * 0.6)};
            g.setColor(Color.white);
            g.fillPolygon(triangleX, triangleY, 3);
        }
    }

    private final void paintStop(Graphics g) {
        int x = this.r.height + 1;
        int y = 1;
        int w = this.r.height - 2;
        int h = this.r.height - 2;
        g.setColor(Color.darkGray);
        g.drawRect(x, y, w, h);
        g.setColor(this.button2Color);
        g.fillRect(x + 1, y + 1, w - 1, h - 1);
        g.setColor(Color.white);
        g.fillRect(this.r.height + (int)((double)w * 0.4), (int)((double)w * 0.4), (int)((double)w * 0.5), (int)((double)w * 0.5));
    }

    private final void paintMessage(Graphics g, int pos) {
        if (this.message != null) {
            g.setColor(Color.white);
            g.drawString(this.message, pos, this.r.height - 2);
        }
    }

    private final void paintBuffering(Graphics g, int pos) {
        g.setColor(Color.white);
        g.drawString("Buffering", pos, this.r.height - 2);
    }

    private final void paintSeekBar(Graphics g) {
        int end = this.r.width - 60 - this.r.height * 2;
        int base = this.r.height * 2 + 1;
        g.setColor(Color.darkGray);
        g.drawRect(base, 2, end, this.r.height - 4);
        int pos = (int)((double)end * this.position);
        g.setColor(Color.gray);
        g.fillRect(base + 2, 5, pos, this.r.height - 9);
        g.setColor(Color.white);
        g.drawLine(pos + base + 1, 1, pos + base + 7, 1);
        g.drawLine(pos + base + 1, this.r.height - 1, pos + base + 7, this.r.height - 1);
        g.drawLine(pos + base, 2, pos + base, this.r.height - 2);
        g.drawLine(pos + base + 8, 2, pos + base + 8, this.r.height - 2);
        g.setColor(this.seekColor);
        g.fillRect(pos + base + 1, 2, 7, this.r.height - 3);
    }

    private final void paintTime(Graphics g) {
        if (this.time < 0L) {
            return;
        }
        long sec = this.time % 60L;
        long min = this.time / 60L;
        long hour = min / 60L;
        this.r = this.getBounds();
        int end = this.r.width - 50;
        g.setColor(Color.white);
        g.drawString("" + hour + ':' + ((min %= 60L) < 10L ? "0" + min : "" + min) + ':' + (sec < 10L ? "0" + sec : "" + sec), end, this.r.height - 2);
    }

    private final void paintSpeaker(Graphics g) {
        if (this.haveAudio) {
            g.drawImage(this.speakerImg, this.r.width - 12, this.r.height - 11, null);
        }
    }

    public void paint(Graphics g) {
        if (!this.isVisible()) {
            return;
        }
        this.r = this.getBounds();
        Image img = this.component.createImage(this.r.width, this.r.height);
        if (img == null) {
            return;
        }
        Graphics g2 = img.getGraphics();
        if (g2 == null) {
            return;
        }
        g2.setFont(this.font);
        this.paintBox(g2);
        if (this.seekable) {
            this.paintPlayPause(g2);
            this.paintStop(g2);
            if (this.buffering) {
                this.paintPercent(g2);
                this.paintBuffering(g2, this.r.height * 2 + 3);
            } else if (this.state == 0) {
                this.paintMessage(g2, this.r.height * 2 + 3);
            } else {
                this.paintSeekBar(g2);
                this.paintTime(g2);
            }
        } else if (this.buffering) {
            this.paintBuffering(g2, 2);
            this.paintPercent(g2);
        } else {
            this.paintMessage(g2, 2);
            this.paintTime(g2);
        }
        this.paintSpeaker(g2);
        g.drawImage(img, this.r.x, this.r.y, null);
        img.flush();
    }

    public void setBufferPercent(boolean buffering, int bp) {
        this.buffering = buffering;
        this.bufferPercent = bp;
        this.component.repaint();
    }

    public void setTime(double seconds) {
        if (this.clicked == 0) {
            this.time = seconds < this.duration ? (long)seconds : (long)this.duration;
            this.position = (double)this.time / this.duration;
            this.component.repaint();
        }
    }

    public void setDuration(double seconds) {
        this.duration = seconds;
        this.component.repaint();
    }

    public void setMessage(String m) {
        this.message = m;
        this.component.repaint();
    }

    public void setHaveAudio(boolean a) {
        this.haveAudio = a;
        this.component.repaint();
    }

    public void setHavePercent(boolean p) {
        this.havePercent = p;
        this.component.repaint();
    }

    public void setSeekable(boolean s) {
        this.seekable = s;
        this.component.repaint();
    }

    public void setState(int aState) {
        this.state = aState;
        this.component.repaint();
    }

    private final boolean intersectButton1(MouseEvent e) {
        if (this.r == null) {
            return false;
        }
        boolean bl = false;
        if (e.getX() >= 0 && e.getX() <= this.r.height - 2 && e.getY() > 0 && e.getY() <= this.r.height - 2) {
            bl = true;
        }
        return bl;
    }

    private final boolean intersectButton2(MouseEvent e) {
        if (this.r == null) {
            return false;
        }
        boolean bl = false;
        if (e.getX() >= this.r.height && e.getX() <= this.r.height + this.r.height - 2 && e.getY() > 0 && e.getY() <= this.r.height - 2) {
            bl = true;
        }
        return bl;
    }

    private final boolean intersectSeeker(MouseEvent e) {
        this.r = this.getBounds();
        int end = this.r.width - 60 - this.r.height * 2;
        int pos = (int)((double)end * this.position) + this.r.height * 2 + 1;
        boolean bl = false;
        if (e.getX() >= pos && e.getX() <= pos + 9 && e.getY() > 0 && e.getY() <= this.r.height - 2) {
            bl = true;
        }
        return bl;
    }

    private final boolean intersectSeekbar(MouseEvent e) {
        this.r = this.getBounds();
        int end = this.r.width - 60;
        boolean bl = false;
        if (e.getX() >= this.r.height * 2 && e.getX() <= end && e.getY() > 0 && e.getY() <= this.r.height - 2) {
            bl = true;
        }
        return bl;
    }

    private final int findComponent(MouseEvent e) {
        if (this.intersectButton1(e)) {
            return 1;
        }
        if (this.intersectButton2(e)) {
            return 2;
        }
        if (this.intersectSeeker(e)) {
            return 3;
        }
        if (this.intersectSeekbar(e)) {
            return 4;
        }
        return 0;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (this.seekable) {
            e.translatePoint(-1, -1);
            this.clicked = this.findComponent(e);
            if (this.clicked == 4 && this.state != 0) {
                this.clicked = 3;
                this.seekColor = Color.gray;
                this.mouseDragged(e);
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.seekable) {
            e.translatePoint(-1, -1);
            int comp = this.findComponent(e);
            if (this.clicked != comp) {
                if (this.clicked == 3) {
                    comp = this.clicked;
                } else {
                    return;
                }
            }
            switch (comp) {
                case 1: {
                    if (this.state == 2) {
                        this.state = 1;
                        this.notifyNewState(this.state);
                        break;
                    }
                    this.state = 2;
                    this.notifyNewState(this.state);
                    break;
                }
                case 2: {
                    this.state = 0;
                    this.notifyNewState(this.state);
                    break;
                }
                case 3: {
                    if (this.state == 0) break;
                    this.notifySeek(this.position);
                    break;
                }
                case 4: {
                    break;
                }
                case 0: {
                    break;
                }
            }
            this.clicked = 0;
            this.component.repaint();
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.seekable) {
            e.translatePoint(-1, -1);
            if (this.clicked == 3) {
                int end = this.r.width - 60 - this.r.height * 2;
                double pos = (double)(e.getX() - (this.r.height * 2 + 5)) / (double)end;
                this.position = pos < 0.0 ? 0.0 : (pos > 1.0 ? 1.0 : pos);
                this.time = (long)(this.duration * this.position);
                this.component.repaint();
            }
        }
    }

    public void mouseMoved(MouseEvent e) {
        if (this.seekable) {
            e.translatePoint(-1, -1);
            if (this.intersectButton1(e)) {
                this.button1Color = Color.gray;
            } else {
                this.button1Color = Color.black;
                if (this.intersectButton2(e)) {
                    this.button2Color = Color.gray;
                } else {
                    this.button2Color = Color.black;
                    this.seekColor = this.intersectSeeker(e) ? Color.gray : Color.black;
                }
            }
            this.component.repaint();
        }
    }

    private final /* synthetic */ void this() {
        this.font = new Font("SansSerif", 0, 10);
        this.clicked = 0;
        this.state = 0;
        this.position = 0.0;
        this.speaker = "\u0000\u0000\u0000\u0000\u0000\u00ef\u0000\u0000\u00efU\u0017\u001e\u0000\u0000\u0000\u0000\u00ef\u00ef\u0000\u0000\u0000\u00efU\u0018\u0000\u0000\u0000\u00ef\u0000\u00ef\u0000\u00ef\u0000\u0000\u00ef\u0013\u00ef\u00ef\u00ef\u0000\u001c\u00ef\u0000Z\u00ef\u0000\u00ef\\\u00ef\u0000)+F\u00ef\u0000\u0000\u00ef\u0000\u00efr\u00efIbz\u0091\u00ef\u0000\u0000\u00ef\u0000\u00efr\u00ef\u00ef\u00ef\u00be\u00d3\u00ef\u0000Z\u00ef\u0000\u00ef\\\u0000\u0000\u0000\u00ef\u00ef\u00ef\u0000\u00ef\u0000\u0000\u00ef\u0000\u0000\u0000\u0000\u0000\u00ef\u00ef\u0000\u0000\u0000\u00ef\\\u0000\u0000\u0000\u0000\u0000\u0000\u00ef\u0000\u0000\u00ef\\\u0000\u0000";
        this.listeners = new Vector();
    }

    public Status(Component comp) {
        this.this();
        int[] pixels = new int[120];
        this.component = comp;
        int i = 0;
        while (i < 120) {
            pixels[i] = 0xFF000000 | this.speaker.charAt(i) << 16 | this.speaker.charAt(i) << 8 | this.speaker.charAt(i);
            ++i;
        }
        this.speakerImg = comp.getToolkit().createImage(new MemoryImageSource(12, 10, pixels, 0, 12));
        this.button1Color = Color.black;
        this.button2Color = Color.black;
        this.seekColor = Color.black;
    }
}

