/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.player;

import com.fluendo.jst.BusHandler;
import com.fluendo.jst.Event;
import com.fluendo.jst.Message;
import com.fluendo.player.AboutFrame;
import com.fluendo.player.Configure;
import com.fluendo.player.CortadoPipeline;
import com.fluendo.player.Status;
import com.fluendo.player.StatusListener;
import com.fluendo.utils.Debug;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import java.util.Hashtable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Cortado
extends Applet
implements Runnable,
MouseMotionListener,
MouseListener,
BusHandler,
StatusListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private static Cortado cortado;
    private static CortadoPipeline pipeline;
    private static final String[] showStatusVals;
    private static final int STATUS_AUTO = 0;
    private static final int STATUS_SHOW = 1;
    private static final int STATUS_HIDE = 2;
    private String urlString;
    private boolean seekable;
    private boolean audio;
    private boolean video;
    private boolean keepAspect;
    private boolean autoPlay;
    private int bufferSize;
    private String userId;
    private String password;
    private int bufferLow;
    private int bufferHigh;
    private int debug;
    private double duration;
    private boolean statusRunning;
    private Thread statusThread;
    private Status status;
    private int statusHeight;
    private boolean inStatus;
    private boolean isBuffering;
    private int desiredState;
    private boolean isEOS;
    private boolean isError;
    private int showStatus;
    private int hideTimeout;
    private int hideCounter;
    private boolean mayHide;
    private PopupMenu menu;
    private Hashtable params;
    private Configure configure;
    private Dimension appletDimension;

    public String getAppletInfo() {
        return "Title: Fluendo media player \nAuthor: Wim Taymans \nA Java based network multimedia player.";
    }

    public String getRevision() {
        return "$Revision: 4059 $";
    }

    public String[][] getParameterInfo() {
        String[][] info = new String[][]{{"url", "URL", "The media file to play"}, {"seekable", "boolean", "Can you seek in this file (default false)"}, {"duration", "float", "Total duration of the file in seconds (default unknown)"}, {"audio", "boolean", "Enable audio playback (default true)"}, {"video", "boolean", "Enable video playback (default true)"}, {"statusHeight", "int", "The height of the status area (default 12)"}, {"autoPlay", "boolean", "Automatically start playback (default true)"}, {"showStatus", "enum", "Show status area (auto|show|hide) (default auto)"}, {"hideTimeout", "int", "Timeout in seconds to hide the status area when showStatus is auto (default 0)"}, {"keepAspect", "boolean", "Use aspect ratio of video (default true)"}, {"bufferSize", "int", "The size of the prebuffer in Kbytes (default 100)"}, {"bufferLow", "int", "Percent of empty buffer (default 10)"}, {"bufferHigh", "int", "Percent of full buffer (default 70)"}, {"userId", "string", "userId for basic authentication (default null)"}, {"password", "string", "password for basic authentication (default null)"}, {"debug", "int", "Debug level 0 - 4 (default = 3)"}};
        return info;
    }

    public void setParam(String name, String value) {
        this.params.put(name, value);
    }

    public void restart() {
        this.stop();
        this.init();
        this.start();
    }

    public String getParam(String name, String def) {
        String result = (String)this.params.get(name);
        if (result == null) {
            try {
                result = this.getParameter(name);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (result == null) {
            result = def;
        }
        return result;
    }

    public int getEnum(String name, String[] vals, String def) {
        String val = this.getParam(name, def);
        int i = 0;
        while (i < vals.length) {
            if (vals[i].equals(val)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public static void shutDown(Throwable error) {
        Debug.log(3, "shutting down: reason: " + error.getMessage());
        error.printStackTrace();
        cortado.stop();
    }

    public synchronized void init() {
        URL documentBase;
        cortado = this;
        System.out.println("init()");
        if (pipeline != null) {
            this.stop();
        }
        pipeline = new CortadoPipeline();
        this.configure = new Configure();
        this.urlString = this.getParam("url", null);
        this.seekable = String.valueOf(this.getParam("seekable", "false")).equals("true");
        this.duration = Double.valueOf(this.getParam("duration", "-1.0"));
        this.audio = String.valueOf(this.getParam("audio", "true")).equals("true");
        this.video = String.valueOf(this.getParam("video", "true")).equals("true");
        this.statusHeight = Integer.valueOf(this.getParam("statusHeight", "12"));
        this.autoPlay = String.valueOf(this.getParam("autoPlay", "true")).equals("true");
        this.showStatus = this.getEnum("showStatus", showStatusVals, "auto");
        this.hideTimeout = Integer.valueOf(this.getParam("hideTimeout", "0"));
        this.keepAspect = String.valueOf(this.getParam("keepAspect", "true")).equals("true");
        this.bufferSize = Integer.valueOf(this.getParam("bufferSize", "200"));
        this.bufferLow = Integer.valueOf(this.getParam("bufferLow", "10"));
        this.bufferHigh = Integer.valueOf(this.getParam("bufferHigh", "70"));
        this.debug = Integer.valueOf(this.getParam("debug", "3"));
        this.userId = this.getParam("userId", null);
        this.password = this.getParam("password", null);
        if (System.getProperty("java.vendor").toUpperCase().startsWith("MICROSOFT", 0)) {
            this.seekable = false;
        }
        Debug.level = this.debug;
        Debug.log(3, "build info: " + this.configure.buildInfo);
        Debug.log(3, "revision: " + this.getRevision());
        pipeline.setUrl(this.urlString);
        pipeline.setUserId(this.userId);
        pipeline.setPassword(this.password);
        pipeline.enableAudio(this.audio);
        pipeline.enableVideo(this.video);
        pipeline.setBufferSize(this.bufferSize);
        pipeline.setBufferLow(this.bufferLow);
        pipeline.setBufferHigh(this.bufferHigh);
        try {
            documentBase = this.getDocumentBase();
            Debug.log(3, "Document base: " + documentBase);
        }
        catch (Throwable t) {
            documentBase = null;
        }
        pipeline.setDocumentBase(documentBase);
        pipeline.setComponent(this);
        pipeline.getBus().addHandler(this);
        this.setBackground(Color.black);
        this.setForeground(Color.white);
        this.status = new Status(this);
        this.status.setHaveAudio(this.audio);
        this.status.setHavePercent(true);
        this.status.setSeekable(this.seekable);
        this.status.setDuration(this.duration);
        this.inStatus = false;
        boolean bl = false;
        if (this.hideTimeout == 0) {
            bl = true;
        }
        this.mayHide = bl;
        this.hideCounter = 0;
        if (this.showStatus != 2) {
            this.status.setVisible(true);
        } else {
            this.status.setVisible(false);
        }
        this.menu = new PopupMenu();
        this.menu.add("About...");
        this.menu.addActionListener(this);
        this.add(this.menu);
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("About...")) {
            AboutFrame about = new AboutFrame(pipeline);
            about.d.setVisible(true);
        }
    }

    public Graphics getGraphics() {
        Graphics g = super.getGraphics();
        if (this.status != null && this.status.isVisible()) {
            g.setClip(0, 0, this.getSize().width, this.getSize().height - this.statusHeight);
        } else {
            g.setClip(0, 0, this.getSize().width, this.getSize().height);
        }
        return g;
    }

    public Dimension getSize() {
        if (this.appletDimension == null) {
            this.appletDimension = super.getSize();
        }
        return this.appletDimension;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void run() {
        try {
            this.realRun();
        }
        catch (Throwable t) {
            Cortado.shutDown(t);
        }
    }

    private final void realRun() {
        Debug.log(3, "entering status thread");
        while (this.statusRunning) {
            try {
                long now = pipeline.getPosition() / 1000000L;
                this.status.setTime(now);
                Thread.sleep(1000L);
                if (this.hideCounter <= 0) continue;
                --this.hideCounter;
                if (this.hideCounter != 0) continue;
                this.mayHide = true;
                this.setStatusVisible(false, false);
            }
            catch (Exception e) {
                if (!this.statusRunning) continue;
                e.printStackTrace();
            }
        }
        Debug.log(3, "exit status thread");
    }

    public void paint(Graphics g) {
        int dwidth = this.getSize().width;
        int dheight = this.getSize().height;
        if (dwidth <= 0 || dheight <= this.statusHeight) {
            this.appletDimension = null;
            return;
        }
        if (this.status != null && this.status.isVisible()) {
            this.status.setBounds(0, dheight - this.statusHeight, dwidth, this.statusHeight);
            this.status.paint(g);
        }
    }

    private final void setStatusVisible(boolean b, boolean force) {
        if (this.status.isVisible() == b) {
            return;
        }
        if (!b && !this.mayHide) {
            return;
        }
        if (!force) {
            if (this.showStatus == 1 && !b) {
                return;
            }
            if (this.showStatus == 2 && b) {
                return;
            }
        }
        if (this.isError && !b) {
            return;
        }
        if (this.inStatus && !b) {
            return;
        }
        this.status.setVisible(b);
        this.repaint();
    }

    private final boolean intersectStatus(MouseEvent e) {
        boolean bl = false;
        if (e.getY() > this.getSize().height - this.statusHeight) {
            bl = true;
        }
        this.inStatus = bl;
        return this.inStatus;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
        this.setStatusVisible(false, false);
    }

    public void mousePressed(MouseEvent e) {
        if (this.intersectStatus(e)) {
            int y = this.getSize().height - this.statusHeight;
            e.translatePoint(0, -y);
            this.status.mousePressed(e);
        } else if ((e.getModifiers() & 4) == 4) {
            this.menu.show(this, e.getX(), e.getY());
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.intersectStatus(e)) {
            int y = this.getSize().height - this.statusHeight;
            e.translatePoint(0, -y);
            this.status.mouseReleased(e);
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.intersectStatus(e)) {
            int y = this.getSize().height - this.statusHeight;
            this.setStatusVisible(true, false);
            e.translatePoint(0, -y);
            this.status.mouseDragged(e);
        } else {
            this.setStatusVisible(false, false);
        }
    }

    public void mouseMoved(MouseEvent e) {
        if (this.intersectStatus(e)) {
            int y = this.getSize().height - this.statusHeight;
            this.setStatusVisible(true, false);
            e.translatePoint(0, -y);
            this.status.mouseMoved(e);
        } else {
            this.setStatusVisible(false, false);
        }
    }

    public void handleMessage(Message msg) {
        block0 : switch (msg.getType()) {
            case 2: 
            case 4: {
                System.out.println(msg.toString());
                if (this.isError) break;
                this.status.setMessage(msg.parseErrorString());
                this.status.setState(0);
                pipeline.setState(1);
                this.setStatusVisible(true, true);
                this.isError = true;
                break;
            }
            case 1: {
                Debug.log(3, "EOS: playback ended");
                if (this.isError) break;
                this.status.setState(0);
                this.status.setMessage("Playback ended");
                this.isEOS = true;
                pipeline.setState(1);
                this.setStatusVisible(true, false);
                break;
            }
            case 8192: {
                System.out.println(msg.toString());
                break;
            }
            case 524288: {
                if (this.isError) break;
                this.status.setMessage(msg.parseResourceString());
                this.setStatusVisible(true, false);
                break;
            }
            case 32: {
                if (this.isError) break;
                boolean busy = msg.parseBufferingBusy();
                int percent = msg.parseBufferingPercent();
                if (busy) {
                    if (!this.isBuffering) {
                        Debug.log(3, "PAUSE: we are buffering");
                        if (this.desiredState == 3) {
                            pipeline.setState(2);
                        }
                        this.isBuffering = true;
                        this.setStatusVisible(true, false);
                    }
                    this.status.setBufferPercent(busy, percent);
                    break;
                }
                if (this.isBuffering) {
                    Debug.log(3, "PLAY: we finished buffering");
                    if (this.desiredState == 3) {
                        pipeline.setState(3);
                    }
                    this.isBuffering = false;
                    this.setStatusVisible(false, false);
                }
                this.status.setBufferPercent(busy, percent);
                break;
            }
            case 64: {
                if (msg.getSrc() != pipeline) break;
                int old = msg.parseStateChangedOld();
                int next = msg.parseStateChangedNext();
                switch (next) {
                    case 2: {
                        if (!this.isError && !this.isEOS) {
                            this.status.setMessage("Paused");
                        }
                        this.status.setState(1);
                        break block0;
                    }
                    case 3: {
                        if (!this.isError && !this.isEOS) {
                            this.status.setMessage("Playing");
                            this.setStatusVisible(false, false);
                            if (!this.mayHide) {
                                this.hideCounter = this.hideTimeout;
                            }
                        }
                        this.status.setState(2);
                        break block0;
                    }
                    case 1: {
                        if (!this.isError && !this.isEOS) {
                            this.status.setMessage("Stopped");
                            this.setStatusVisible(true, false);
                        }
                        this.status.setState(0);
                        break block0;
                    }
                }
                break;
            }
        }
    }

    public void doPause() {
        this.isError = false;
        this.isEOS = false;
        this.status.setMessage("Pause");
        this.desiredState = 2;
        pipeline.setState(this.desiredState);
    }

    public void doPlay() {
        this.isError = false;
        this.isEOS = false;
        this.status.setMessage("Play");
        this.desiredState = 3;
        pipeline.setState(this.desiredState);
    }

    public void doStop() {
        this.status.setMessage("Stop");
        this.desiredState = 1;
        pipeline.setState(this.desiredState);
    }

    public void doSeek(double aPos) {
        Event event = Event.newSeek(5, (int)(aPos * 100.0 * 10000.0));
        boolean res = pipeline.sendEvent(event);
        if (!res) {
            Debug.log(2, "seek failed");
        }
    }

    public void newState(int aState) {
        switch (aState) {
            case 1: {
                this.doPause();
                break;
            }
            case 2: {
                this.doPlay();
                break;
            }
            case 0: {
                this.doStop();
                break;
            }
        }
    }

    public void newSeek(double aPos) {
        this.doSeek(aPos);
    }

    public synchronized void start() {
        System.out.println("start()");
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.status.addStatusListener(this);
        this.desiredState = this.autoPlay ? 3 : 2;
        int res = pipeline.setState(this.desiredState);
        if (this.statusThread != null) {
            throw new RuntimeException("invalid state");
        }
        this.statusThread = new Thread((Runnable)this, "cortado-StatusThread-" + Debug.genId());
        this.statusRunning = true;
        this.statusThread.start();
    }

    public synchronized void stop() {
        System.out.println("stop()");
        this.statusRunning = false;
        this.desiredState = 1;
        if (pipeline != null) {
            System.out.println("pipeline stop");
            pipeline.setState(this.desiredState);
            System.out.println("pipeline shutdown");
            pipeline.shutDown();
            System.out.println("pipeline stopped");
            pipeline = null;
        }
        if (this.statusThread != null) {
            try {
                this.statusThread.interrupt();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.statusThread.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.statusThread = null;
        }
    }

    private final /* synthetic */ void this() {
        this.statusHeight = 20;
        this.params = new Hashtable();
    }

    public Cortado() {
        this.this();
    }

    static {
        showStatusVals = new String[]{"auto", "show", "hide"};
    }
}

