/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jheora;

import com.fluendo.jheora.Constants;
import com.fluendo.jheora.Info;
import com.fluendo.jheora.Playback;
import com.jcraft.jogg.Buffer;

public class Quant {
    private static final int MIN_DEQUANT_VAL = 2;
    private static final int IDCT_SCALE_FACTOR = 2;

    private static final int ilog(long v) {
        int ret = 0;
        while (v != 0L) {
            ++ret;
            v >>= 1;
        }
        return ret;
    }

    private static final int _read_qtable_range(Info ci, Buffer opb, int N) {
        int qi = 0;
        opb.readB(Quant.ilog(N - 1));
        while (qi < 63) {
            int range = opb.readB(Quant.ilog(62 - qi));
            if (++range <= 0) {
                return -20;
            }
            qi += range;
            opb.readB(Quant.ilog(N - 1));
        }
        return 0;
    }

    public static int readQTables(Info ci, Buffer opb) {
        long value;
        long bits = opb.readB(4);
        ++bits;
        int x = 0;
        while (x < 64) {
            value = opb.readB((int)bits);
            if (bits < 0L) {
                return -20;
            }
            ci.QThreshTable[x] = (int)value;
            ++x;
        }
        bits = opb.readB(4);
        ++bits;
        x = 0;
        while (x < 64) {
            value = opb.readB((int)bits);
            if (bits < 0L) {
                return -20;
            }
            ci.DcScaleFactorTable[x] = (short)value;
            ++x;
        }
        int N = opb.readB(9);
        if (++N != 3) {
            return -20;
        }
        ci.qmats = new short[N * 64];
        ci.MaxQMatrixIndex = N;
        int y = 0;
        while (y < N) {
            x = 0;
            while (x < 64) {
                value = opb.readB(8);
                if (bits < 0L) {
                    return -20;
                }
                ci.qmats[(y << 6) + x] = (short)value;
                ++x;
            }
            ++y;
        }
        int ret = Quant._read_qtable_range(ci, opb, N);
        if (ret < 0) {
            return ret;
        }
        int flag = opb.readB(1);
        if (flag < 0) {
            return -20;
        }
        if (flag != 0 && (ret = Quant._read_qtable_range(ci, opb, N)) < 0) {
            return ret;
        }
        flag = opb.readB(1);
        if (flag < 0) {
            return -20;
        }
        if (flag != 0 && (ret = Quant._read_qtable_range(ci, opb, N)) < 0) {
            return ret;
        }
        flag = opb.readB(1);
        if (flag < 0) {
            return -20;
        }
        if (flag != 0) {
            ret = Quant._read_qtable_range(ci, opb, N);
            if (ret < 0) {
                return ret;
            }
        } else {
            flag = opb.readB(1);
            if (flag < 0) {
                return -20;
            }
        }
        if ((flag = opb.readB(1)) < 0) {
            return -20;
        }
        if (flag != 0) {
            ret = Quant._read_qtable_range(ci, opb, N);
            if (ret < 0) {
                return ret;
            }
        } else {
            flag = opb.readB(1);
            if (flag < 0) {
                return -20;
            }
        }
        if ((flag = opb.readB(1)) < 0) {
            return -20;
        }
        if (flag != 0) {
            ret = Quant._read_qtable_range(ci, opb, N);
            if (ret < 0) {
                return ret;
            }
        } else {
            flag = opb.readB(1);
            if (flag < 0) {
                return -20;
            }
        }
        System.arraycopy(ci.qmats, 0, ci.Y_coeffs, 0, 64);
        System.arraycopy(ci.qmats, 64, ci.UV_coeffs, 0, 64);
        System.arraycopy(ci.qmats, 128, ci.Inter_coeffs, 0, 64);
        return 0;
    }

    static void BuildQuantIndex_Generic(Playback pbi) {
        int i = 0;
        while (i < 64) {
            int j = Constants.dequant_index[i];
            pbi.quant_index[j] = i++;
        }
    }

    static void init_dequantizer(Playback pbi, int scale_factor, byte QIndex) {
        short[] Inter_coeffs = pbi.Inter_coeffs;
        short[] Y_coeffs = pbi.Y_coeffs;
        short[] UV_coeffs = pbi.UV_coeffs;
        short[] DcScaleFactorTable = pbi.DcScaleFactorTable;
        short[] UVDcScaleFactorTable = pbi.DcScaleFactorTable;
        Quant.BuildQuantIndex_Generic(pbi);
        int i = 0;
        while (i < 64) {
            int j = pbi.quant_index[i];
            pbi.dequant_Y_coeffs[j] = Y_coeffs[i];
            pbi.dequant_Inter_coeffs[j] = Inter_coeffs[i];
            pbi.dequant_UV_coeffs[j] = UV_coeffs[i];
            pbi.dequant_InterUV_coeffs[j] = Inter_coeffs[i];
            ++i;
        }
        pbi.dequant_Y_coeffs[0] = (short)(DcScaleFactorTable[QIndex] * pbi.dequant_Y_coeffs[0] / 100);
        if (pbi.dequant_Y_coeffs[0] < 4) {
            pbi.dequant_Y_coeffs[0] = 4;
        }
        pbi.dequant_Y_coeffs[0] = (short)(pbi.dequant_Y_coeffs[0] << 2);
        pbi.dequant_UV_coeffs[0] = (short)(UVDcScaleFactorTable[QIndex] * pbi.dequant_UV_coeffs[0] / 100);
        if (pbi.dequant_UV_coeffs[0] < 4) {
            pbi.dequant_UV_coeffs[0] = 4;
        }
        pbi.dequant_UV_coeffs[0] = (short)(pbi.dequant_UV_coeffs[0] << 2);
        pbi.dequant_Inter_coeffs[0] = (short)(DcScaleFactorTable[QIndex] * pbi.dequant_Inter_coeffs[0] / 100);
        if (pbi.dequant_Inter_coeffs[0] < 8) {
            pbi.dequant_Inter_coeffs[0] = 8;
        }
        pbi.dequant_Inter_coeffs[0] = (short)(pbi.dequant_Inter_coeffs[0] << 2);
        pbi.dequant_InterUV_coeffs[0] = (short)(UVDcScaleFactorTable[QIndex] * pbi.dequant_InterUV_coeffs[0] / 100);
        if (pbi.dequant_InterUV_coeffs[0] < 8) {
            pbi.dequant_InterUV_coeffs[0] = 8;
        }
        pbi.dequant_InterUV_coeffs[0] = (short)(pbi.dequant_InterUV_coeffs[0] << 2);
        i = 1;
        while (i < 64) {
            pbi.dequant_Y_coeffs[i] = (short)(scale_factor * pbi.dequant_Y_coeffs[i] / 100);
            if (pbi.dequant_Y_coeffs[i] < 2) {
                pbi.dequant_Y_coeffs[i] = 2;
            }
            pbi.dequant_Y_coeffs[i] = (short)(pbi.dequant_Y_coeffs[i] << 2);
            pbi.dequant_UV_coeffs[i] = (short)(scale_factor * pbi.dequant_UV_coeffs[i] / 100);
            if (pbi.dequant_UV_coeffs[i] < 2) {
                pbi.dequant_UV_coeffs[i] = 2;
            }
            pbi.dequant_UV_coeffs[i] = (short)(pbi.dequant_UV_coeffs[i] << 2);
            pbi.dequant_Inter_coeffs[i] = (short)(scale_factor * pbi.dequant_Inter_coeffs[i] / 100);
            if (pbi.dequant_Inter_coeffs[i] < 4) {
                pbi.dequant_Inter_coeffs[i] = 4;
            }
            pbi.dequant_Inter_coeffs[i] = (short)(pbi.dequant_Inter_coeffs[i] << 2);
            pbi.dequant_InterUV_coeffs[i] = (short)(scale_factor * pbi.dequant_InterUV_coeffs[i] / 100);
            if (pbi.dequant_InterUV_coeffs[i] < 4) {
                pbi.dequant_InterUV_coeffs[i] = 4;
            }
            pbi.dequant_InterUV_coeffs[i] = (short)(pbi.dequant_InterUV_coeffs[i] << 2);
            ++i;
        }
    }

    public static void UpdateQ(Playback pbi, int NewQ) {
        int qscale = NewQ;
        if (qscale < pbi.QThreshTable[63]) {
            qscale = pbi.QThreshTable[63];
        } else if (qscale > pbi.QThreshTable[0]) {
            qscale = pbi.QThreshTable[0];
        }
        pbi.FrameQIndex = 63;
        while (pbi.FrameQIndex >= 0) {
            if (pbi.FrameQIndex == 0 || pbi.QThreshTable[pbi.FrameQIndex] >= NewQ) break;
            --pbi.FrameQIndex;
        }
        Quant.init_dequantizer(pbi, qscale, (byte)pbi.FrameQIndex);
    }
}

