/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jheora;

import com.fluendo.jheora.Colorspace;
import com.fluendo.jheora.Comment;
import com.fluendo.jheora.HuffEntry;
import com.fluendo.jheora.Huffman;
import com.fluendo.jheora.Quant;
import com.jcraft.jogg.Buffer;
import com.jcraft.jogg.Packet;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Info {
    public int width;
    public int height;
    public int frame_width;
    public int frame_height;
    public int offset_x;
    public int offset_y;
    public int fps_numerator;
    public int fps_denominator;
    public int aspect_numerator;
    public int aspect_denominator;
    public Colorspace colorspace;
    public int target_bitrate;
    public int quality;
    public int quick_p;
    public byte version_major;
    public byte version_minor;
    public byte version_subminor;
    public long keyframe_frequency_force;
    int[] QThreshTable;
    short[] DcScaleFactorTable;
    int MaxQMatrixIndex;
    short[] qmats;
    short[] Y_coeffs;
    short[] UV_coeffs;
    short[] Inter_coeffs;
    HuffEntry[] HuffRoot;
    byte[] LoopFilterLimitValues;

    private static final void _tp_readbuffer(Buffer opb, byte[] buf, int len) {
        int i = 0;
        while (i < len) {
            buf[i] = (byte)opb.readB(8);
            ++i;
        }
    }

    private static final int _tp_readlsbint(Buffer opb) {
        int value = opb.readB(8);
        value |= opb.readB(8) << 8;
        value |= opb.readB(8) << 16;
        return value |= opb.readB(8) << 24;
    }

    private final int unpackInfo(Buffer opb) {
        this.version_major = (byte)opb.readB(8);
        this.version_minor = (byte)opb.readB(8);
        this.version_subminor = (byte)opb.readB(8);
        if (this.version_major != 3) {
            return -22;
        }
        if (this.version_minor > 2) {
            return -22;
        }
        this.width = opb.readB(16) << 4;
        this.height = opb.readB(16) << 4;
        this.frame_width = opb.readB(24);
        this.frame_height = opb.readB(24);
        this.offset_x = opb.readB(8);
        this.offset_y = opb.readB(8);
        this.fps_numerator = opb.readB(32);
        this.fps_denominator = opb.readB(32);
        this.aspect_numerator = opb.readB(24);
        this.aspect_denominator = opb.readB(24);
        this.colorspace = Colorspace.spaces[opb.readB(8)];
        this.target_bitrate = opb.readB(24);
        this.quality = opb.readB(6);
        this.keyframe_frequency_force = 1 << opb.readB(5);
        if (opb.readB(5) == -1) {
            return -20;
        }
        return 0;
    }

    static int unpackComment(Comment tc, Buffer opb) {
        int len = Info._tp_readlsbint(opb);
        if (len < 0) {
            return -20;
        }
        byte[] tmp = new byte[len];
        Info._tp_readbuffer(opb, tmp, len);
        tc.vendor = new String(tmp);
        int comments = Info._tp_readlsbint(opb);
        if (comments < 0) {
            tc.clear();
            return -20;
        }
        tc.user_comments = new String[comments];
        int i = 0;
        while (i < comments) {
            len = Info._tp_readlsbint(opb);
            if (len < 0) {
                tc.clear();
                return -20;
            }
            tmp = new byte[len];
            Info._tp_readbuffer(opb, tmp, len);
            tc.user_comments[i] = new String(tmp);
            ++i;
        }
        return 0;
    }

    private final int readFilterTables(Buffer opb) {
        int bits = opb.readB(3);
        int i = 0;
        while (i < 64) {
            int value = opb.readB(bits);
            this.LoopFilterLimitValues[i] = (byte)value;
            ++i;
        }
        if (bits < 0) {
            return -20;
        }
        return 0;
    }

    private final int unpackTables(Buffer opb) {
        int ret = this.readFilterTables(opb);
        if (ret != 0) {
            return ret;
        }
        ret = Quant.readQTables(this, opb);
        if (ret != 0) {
            return ret;
        }
        ret = Huffman.readHuffmanTrees(this.HuffRoot, opb);
        if (ret != 0) {
            return ret;
        }
        return ret;
    }

    public void clear() {
        this.qmats = null;
        Huffman.clearHuffmanTrees(this.HuffRoot);
    }

    public int decodeHeader(Comment cc, Packet op) {
        Buffer opb = new Buffer();
        opb.readinit(op.packet_base, op.packet, op.bytes);
        byte[] id = new byte[6];
        int typeflag = opb.readB(8);
        if ((typeflag & 0x80) == 0) {
            return -21;
        }
        Info._tp_readbuffer(opb, id, 6);
        if (!"theora".equals(new String(id))) {
            return -21;
        }
        switch (typeflag) {
            case 128: {
                if (op.b_o_s == 0) {
                    return -20;
                }
                if (this.version_major != 0) {
                    return -20;
                }
                long ret = this.unpackInfo(opb);
                return (int)ret;
            }
            case 129: {
                if (this.version_major == 0) {
                    return -20;
                }
                long ret = Info.unpackComment(cc, opb);
                return (int)ret;
            }
            case 130: {
                if (this.version_major == 0 || cc.vendor == null) {
                    return -20;
                }
                long ret = this.unpackTables(opb);
                return (int)ret;
            }
        }
        if (this.version_major == 0 || cc.vendor == null || this.HuffRoot[0] == null) {
            return -20;
        }
        return -25;
    }

    private final /* synthetic */ void this() {
        this.QThreshTable = new int[64];
        this.DcScaleFactorTable = new short[64];
        this.Y_coeffs = new short[64];
        this.UV_coeffs = new short[64];
        this.Inter_coeffs = new short[64];
        this.HuffRoot = new HuffEntry[80];
        this.LoopFilterLimitValues = new byte[64];
    }

    public Info() {
        this.this();
    }
}

