/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.AnnotationRef;
import ome.xml.model.Channel;
import ome.xml.model.Dataset;
import ome.xml.model.Experimenter;
import ome.xml.model.Image;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Pixels;
import ome.xml.model.Plane;
import ome.xml.model.Plate;
import ome.xml.model.PlateAcquisition;
import ome.xml.model.Project;
import ome.xml.model.ROI;
import ome.xml.model.Reagent;
import ome.xml.model.Reference;
import ome.xml.model.Screen;
import ome.xml.model.Well;
import ome.xml.model.WellSample;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Annotation
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/SA/2011-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Annotation.class);
    private String namespace;
    private String id;
    private String description;
    private List<Annotation> annotationList = new ArrayList<Annotation>();
    private List<Image> image_BackReferenceList = new ArrayList<Image>();
    private List<Pixels> pixels_BackReferenceList = new ArrayList<Pixels>();
    private List<Plane> plane_BackReferenceList = new ArrayList<Plane>();
    private List<Channel> channel_BackReferenceList = new ArrayList<Channel>();
    private List<Project> project_BackReferenceList = new ArrayList<Project>();
    private List<Dataset> dataset_BackReferenceList = new ArrayList<Dataset>();
    private List<Experimenter> experimenter_BackReferenceList = new ArrayList<Experimenter>();
    private List<ROI> roi_backReferenceList = new ArrayList<ROI>();
    private List<Plate> plate_BackReferenceList = new ArrayList<Plate>();
    private List<Reagent> reagent_BackReferenceList = new ArrayList<Reagent>();
    private List<Screen> screen_BackReferenceList = new ArrayList<Screen>();
    private List<PlateAcquisition> plateAcquisition_BackReferenceList = new ArrayList<PlateAcquisition>();
    private List<Well> well_BackReferenceList = new ArrayList<Well>();
    private List<WellSample> wellSample_BackReferenceList = new ArrayList<WellSample>();

    public Annotation() {
    }

    public Annotation(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        List<Element> Description_nodeList;
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"Annotation".equals(tagName)) {
            LOGGER.debug("Expecting node name of Annotation got {}", (Object)tagName);
        }
        if (element.hasAttribute("Namespace")) {
            this.setNamespace(String.valueOf(element.getAttribute("Namespace")));
        }
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException(String.format("Annotation missing required ID property.", new Object[0]));
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
        if ((Description_nodeList = Annotation.getChildrenByTagName(element, "Description")).size() > 1) {
            throw new RuntimeException(String.format("Description node list size %d != 1", Description_nodeList.size()));
        }
        if (Description_nodeList.size() != 0) {
            this.setDescription(String.valueOf(Description_nodeList.get(0).getTextContent()));
        }
        List<Element> AnnotationRef_nodeList = Annotation.getChildrenByTagName(element, "AnnotationRef");
        for (Element AnnotationRef_element : AnnotationRef_nodeList) {
            AnnotationRef annotationList_reference = new AnnotationRef();
            annotationList_reference.setID(AnnotationRef_element.getAttribute("ID"));
            model.addReference(this, annotationList_reference);
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        if (reference instanceof AnnotationRef) {
            Annotation o_casted = (Annotation)o;
            this.annotationList.add(o_casted);
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int sizeOfLinkedAnnotationList() {
        return this.annotationList.size();
    }

    public List<Annotation> copyLinkedAnnotationList() {
        return new ArrayList<Annotation>(this.annotationList);
    }

    public Annotation getLinkedAnnotation(int index) {
        return this.annotationList.get(index);
    }

    public Annotation setLinkedAnnotation(int index, Annotation o) {
        return this.annotationList.set(index, o);
    }

    public boolean linkAnnotation(Annotation o) {
        return this.annotationList.add(o);
    }

    public boolean unlinkAnnotation(Annotation o) {
        return this.annotationList.remove(o);
    }

    public int sizeOfLinkedImageList() {
        return this.image_BackReferenceList.size();
    }

    public List<Image> copyLinkedImageList() {
        return new ArrayList<Image>(this.image_BackReferenceList);
    }

    public Image getLinkedImage(int index) {
        return this.image_BackReferenceList.get(index);
    }

    public Image setLinkedImage(int index, Image o) {
        return this.image_BackReferenceList.set(index, o);
    }

    public boolean linkImage(Image o) {
        return this.image_BackReferenceList.add(o);
    }

    public boolean unlinkImage(Image o) {
        return this.image_BackReferenceList.remove(o);
    }

    public int sizeOfLinkedPixelsList() {
        return this.pixels_BackReferenceList.size();
    }

    public List<Pixels> copyLinkedPixelsList() {
        return new ArrayList<Pixels>(this.pixels_BackReferenceList);
    }

    public Pixels getLinkedPixels(int index) {
        return this.pixels_BackReferenceList.get(index);
    }

    public Pixels setLinkedPixels(int index, Pixels o) {
        return this.pixels_BackReferenceList.set(index, o);
    }

    public boolean linkPixels(Pixels o) {
        return this.pixels_BackReferenceList.add(o);
    }

    public boolean unlinkPixels(Pixels o) {
        return this.pixels_BackReferenceList.remove(o);
    }

    public int sizeOfLinkedPlaneList() {
        return this.plane_BackReferenceList.size();
    }

    public List<Plane> copyLinkedPlaneList() {
        return new ArrayList<Plane>(this.plane_BackReferenceList);
    }

    public Plane getLinkedPlane(int index) {
        return this.plane_BackReferenceList.get(index);
    }

    public Plane setLinkedPlane(int index, Plane o) {
        return this.plane_BackReferenceList.set(index, o);
    }

    public boolean linkPlane(Plane o) {
        return this.plane_BackReferenceList.add(o);
    }

    public boolean unlinkPlane(Plane o) {
        return this.plane_BackReferenceList.remove(o);
    }

    public int sizeOfLinkedChannelList() {
        return this.channel_BackReferenceList.size();
    }

    public List<Channel> copyLinkedChannelList() {
        return new ArrayList<Channel>(this.channel_BackReferenceList);
    }

    public Channel getLinkedChannel(int index) {
        return this.channel_BackReferenceList.get(index);
    }

    public Channel setLinkedChannel(int index, Channel o) {
        return this.channel_BackReferenceList.set(index, o);
    }

    public boolean linkChannel(Channel o) {
        return this.channel_BackReferenceList.add(o);
    }

    public boolean unlinkChannel(Channel o) {
        return this.channel_BackReferenceList.remove(o);
    }

    public int sizeOfLinkedProjectList() {
        return this.project_BackReferenceList.size();
    }

    public List<Project> copyLinkedProjectList() {
        return new ArrayList<Project>(this.project_BackReferenceList);
    }

    public Project getLinkedProject(int index) {
        return this.project_BackReferenceList.get(index);
    }

    public Project setLinkedProject(int index, Project o) {
        return this.project_BackReferenceList.set(index, o);
    }

    public boolean linkProject(Project o) {
        return this.project_BackReferenceList.add(o);
    }

    public boolean unlinkProject(Project o) {
        return this.project_BackReferenceList.remove(o);
    }

    public int sizeOfLinkedDatasetList() {
        return this.dataset_BackReferenceList.size();
    }

    public List<Dataset> copyLinkedDatasetList() {
        return new ArrayList<Dataset>(this.dataset_BackReferenceList);
    }

    public Dataset getLinkedDataset(int index) {
        return this.dataset_BackReferenceList.get(index);
    }

    public Dataset setLinkedDataset(int index, Dataset o) {
        return this.dataset_BackReferenceList.set(index, o);
    }

    public boolean linkDataset(Dataset o) {
        return this.dataset_BackReferenceList.add(o);
    }

    public boolean unlinkDataset(Dataset o) {
        return this.dataset_BackReferenceList.remove(o);
    }

    public int sizeOfLinkedExperimenterList() {
        return this.experimenter_BackReferenceList.size();
    }

    public List<Experimenter> copyLinkedExperimenterList() {
        return new ArrayList<Experimenter>(this.experimenter_BackReferenceList);
    }

    public Experimenter getLinkedExperimenter(int index) {
        return this.experimenter_BackReferenceList.get(index);
    }

    public Experimenter setLinkedExperimenter(int index, Experimenter o) {
        return this.experimenter_BackReferenceList.set(index, o);
    }

    public boolean linkExperimenter(Experimenter o) {
        return this.experimenter_BackReferenceList.add(o);
    }

    public boolean unlinkExperimenter(Experimenter o) {
        return this.experimenter_BackReferenceList.remove(o);
    }

    public int sizeOfLinkedROIList() {
        return this.roi_backReferenceList.size();
    }

    public List<ROI> copyLinkedROIList() {
        return new ArrayList<ROI>(this.roi_backReferenceList);
    }

    public ROI getLinkedROI(int index) {
        return this.roi_backReferenceList.get(index);
    }

    public ROI setLinkedROI(int index, ROI o) {
        return this.roi_backReferenceList.set(index, o);
    }

    public boolean linkROI(ROI o) {
        return this.roi_backReferenceList.add(o);
    }

    public boolean unlinkROI(ROI o) {
        return this.roi_backReferenceList.remove(o);
    }

    public int sizeOfLinkedPlateList() {
        return this.plate_BackReferenceList.size();
    }

    public List<Plate> copyLinkedPlateList() {
        return new ArrayList<Plate>(this.plate_BackReferenceList);
    }

    public Plate getLinkedPlate(int index) {
        return this.plate_BackReferenceList.get(index);
    }

    public Plate setLinkedPlate(int index, Plate o) {
        return this.plate_BackReferenceList.set(index, o);
    }

    public boolean linkPlate(Plate o) {
        return this.plate_BackReferenceList.add(o);
    }

    public boolean unlinkPlate(Plate o) {
        return this.plate_BackReferenceList.remove(o);
    }

    public int sizeOfLinkedReagentList() {
        return this.reagent_BackReferenceList.size();
    }

    public List<Reagent> copyLinkedReagentList() {
        return new ArrayList<Reagent>(this.reagent_BackReferenceList);
    }

    public Reagent getLinkedReagent(int index) {
        return this.reagent_BackReferenceList.get(index);
    }

    public Reagent setLinkedReagent(int index, Reagent o) {
        return this.reagent_BackReferenceList.set(index, o);
    }

    public boolean linkReagent(Reagent o) {
        return this.reagent_BackReferenceList.add(o);
    }

    public boolean unlinkReagent(Reagent o) {
        return this.reagent_BackReferenceList.remove(o);
    }

    public int sizeOfLinkedScreenList() {
        return this.screen_BackReferenceList.size();
    }

    public List<Screen> copyLinkedScreenList() {
        return new ArrayList<Screen>(this.screen_BackReferenceList);
    }

    public Screen getLinkedScreen(int index) {
        return this.screen_BackReferenceList.get(index);
    }

    public Screen setLinkedScreen(int index, Screen o) {
        return this.screen_BackReferenceList.set(index, o);
    }

    public boolean linkScreen(Screen o) {
        return this.screen_BackReferenceList.add(o);
    }

    public boolean unlinkScreen(Screen o) {
        return this.screen_BackReferenceList.remove(o);
    }

    public int sizeOfLinkedPlateAcquisitionList() {
        return this.plateAcquisition_BackReferenceList.size();
    }

    public List<PlateAcquisition> copyLinkedPlateAcquisitionList() {
        return new ArrayList<PlateAcquisition>(this.plateAcquisition_BackReferenceList);
    }

    public PlateAcquisition getLinkedPlateAcquisition(int index) {
        return this.plateAcquisition_BackReferenceList.get(index);
    }

    public PlateAcquisition setLinkedPlateAcquisition(int index, PlateAcquisition o) {
        return this.plateAcquisition_BackReferenceList.set(index, o);
    }

    public boolean linkPlateAcquisition(PlateAcquisition o) {
        return this.plateAcquisition_BackReferenceList.add(o);
    }

    public boolean unlinkPlateAcquisition(PlateAcquisition o) {
        return this.plateAcquisition_BackReferenceList.remove(o);
    }

    public int sizeOfLinkedWellList() {
        return this.well_BackReferenceList.size();
    }

    public List<Well> copyLinkedWellList() {
        return new ArrayList<Well>(this.well_BackReferenceList);
    }

    public Well getLinkedWell(int index) {
        return this.well_BackReferenceList.get(index);
    }

    public Well setLinkedWell(int index, Well o) {
        return this.well_BackReferenceList.set(index, o);
    }

    public boolean linkWell(Well o) {
        return this.well_BackReferenceList.add(o);
    }

    public boolean unlinkWell(Well o) {
        return this.well_BackReferenceList.remove(o);
    }

    public int sizeOfLinkedWellSampleList() {
        return this.wellSample_BackReferenceList.size();
    }

    public List<WellSample> copyLinkedWellSampleList() {
        return new ArrayList<WellSample>(this.wellSample_BackReferenceList);
    }

    public WellSample getLinkedWellSample(int index) {
        return this.wellSample_BackReferenceList.get(index);
    }

    public WellSample setLinkedWellSample(int index, WellSample o) {
        return this.wellSample_BackReferenceList.set(index, o);
    }

    public boolean linkWellSample(WellSample o) {
        return this.wellSample_BackReferenceList.add(o);
    }

    public boolean unlinkWellSample(WellSample o) {
        return this.wellSample_BackReferenceList.remove(o);
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    protected Element asXMLElement(Document document, Element Annotation_element) {
        if (Annotation_element == null) {
            Annotation_element = document.createElementNS(NAMESPACE, "Annotation");
        }
        if (this.namespace != null) {
            Annotation_element.setAttribute("Namespace", this.namespace.toString());
        }
        if (this.id != null) {
            Annotation_element.setAttribute("ID", this.id.toString());
        }
        if (this.description != null) {
            Element description_element = document.createElementNS(NAMESPACE, "Description");
            description_element.setTextContent(this.description.toString());
            Annotation_element.appendChild(description_element);
        }
        if (this.annotationList != null) {
            for (Annotation annotationList_value : this.annotationList) {
                AnnotationRef o = new AnnotationRef();
                o.setID(annotationList_value.getID());
                Annotation_element.appendChild(o.asXMLElement(document));
            }
        }
        if (this.image_BackReferenceList != null) {
            // empty if block
        }
        if (this.pixels_BackReferenceList != null) {
            // empty if block
        }
        if (this.plane_BackReferenceList != null) {
            // empty if block
        }
        if (this.channel_BackReferenceList != null) {
            // empty if block
        }
        if (this.project_BackReferenceList != null) {
            // empty if block
        }
        if (this.dataset_BackReferenceList != null) {
            // empty if block
        }
        if (this.experimenter_BackReferenceList != null) {
            // empty if block
        }
        if (this.roi_backReferenceList != null) {
            // empty if block
        }
        if (this.plate_BackReferenceList != null) {
            // empty if block
        }
        if (this.reagent_BackReferenceList != null) {
            // empty if block
        }
        if (this.screen_BackReferenceList != null) {
            // empty if block
        }
        if (this.plateAcquisition_BackReferenceList != null) {
            // empty if block
        }
        if (this.well_BackReferenceList != null) {
            // empty if block
        }
        if (this.wellSample_BackReferenceList != null) {
            // empty if block
        }
        return super.asXMLElement(document, Annotation_element);
    }
}

