/*
 * Decompiled with CFR 0.152.
 */
package ucar.units;

import ucar.units.BaseQuantity;
import ucar.units.BaseUnit;
import ucar.units.NameException;
import ucar.units.NoSuchUnitException;
import ucar.units.OffsetUnit;
import ucar.units.PrefixDBException;
import ucar.units.ScaledUnit;
import ucar.units.Unit;
import ucar.units.UnitDBImpl;
import ucar.units.UnitException;
import ucar.units.UnitExistsException;
import ucar.units.UnitImpl;
import ucar.units.UnitName;
import ucar.units.UnitSystemException;
import ucar.units.UnitSystemImpl;

public final class SI
extends UnitSystemImpl {
    private static SI si;
    public static final Unit AMOUNT_OF_SUBSTANCE_UNIT;
    public static final Unit ELECTRIC_CURRENT_UNIT;
    public static final Unit LENGTH_UNIT;
    public static final Unit LUMINOUS_INTENSITY_UNIT;
    public static final Unit MASS_UNIT;
    public static final Unit PLANE_ANGLE_UNIT;
    public static final Unit SOLID_ANGLE_UNIT;
    public static final Unit THERMODYNAMIC_TEMPERATURE_UNIT;
    public static final Unit TIME_UNIT;
    public static final BaseUnit AMPERE;
    public static final BaseUnit CANDELA;
    public static final BaseUnit KELVIN;
    public static final BaseUnit KILOGRAM;
    public static final BaseUnit METER;
    public static final BaseUnit METRE;
    public static final BaseUnit MOLE;
    public static final BaseUnit SECOND;
    public static final BaseUnit RADIAN;
    public static final BaseUnit STERADIAN;
    public static final Unit HERTZ;
    public static final Unit NEWTON;
    public static final Unit PASCAL;
    public static final Unit JOULE;
    public static final Unit WATT;
    public static final Unit COULOMB;
    public static final Unit VOLT;
    public static final Unit FARAD;
    public static final Unit OHM;
    public static final Unit SIEMENS;
    public static final Unit WEBER;
    public static final Unit TESLA;
    public static final Unit HENRY;
    public static final Unit DEGREE_CELSIUS;
    public static final Unit LUMEN;
    public static final Unit LUX;
    public static final Unit BECQUEREL;
    public static final Unit GRAY;
    public static final Unit SIEVERT;
    public static final Unit MINUTE;
    public static final Unit HOUR;
    public static final Unit DAY;
    public static final Unit ARC_DEGREE;
    public static final Unit ARC_MINUTE;
    public static final Unit ARC_SECOND;
    public static final Unit LITER;
    public static final Unit LITRE;
    public static final Unit METRIC_TON;
    public static final Unit TONNE;
    public static final Unit NAUTICAL_MILE;
    public static final Unit KNOT;
    public static final Unit ANGSTROM;
    public static final Unit ARE;
    public static final Unit HECTARE;
    public static final Unit BARN;
    public static final Unit BAR;
    public static final Unit GAL;
    public static final Unit CURIE;
    public static final Unit ROENTGEN;
    public static final Unit RAD;
    public static final Unit REM;

    private static BaseUnit bu(String name, String symbol, BaseQuantity quantity) throws NameException, UnitExistsException {
        return BaseUnit.getOrCreate(UnitName.newUnitName(name, null, symbol), quantity);
    }

    private static Unit du(String name, String symbol, Unit definition) throws NameException {
        return definition.clone(UnitName.newUnitName(name, null, symbol));
    }

    private SI() throws UnitExistsException, NameException, PrefixDBException, NoSuchUnitException {
        super(SI.baseUnitDB(), SI.derivedUnitDB());
    }

    private static UnitDBImpl baseUnitDB() throws NameException, UnitExistsException, NoSuchUnitException {
        UnitDBImpl db = new UnitDBImpl(9, 9);
        db.addUnit(AMPERE);
        db.addUnit(CANDELA);
        db.addUnit(KELVIN);
        db.addUnit(KILOGRAM);
        db.addUnit(METER);
        db.addUnit(MOLE);
        db.addUnit(SECOND);
        db.addUnit(RADIAN);
        db.addUnit(STERADIAN);
        db.addAlias("metre", "meter");
        return db;
    }

    private static UnitDBImpl derivedUnitDB() throws NameException, UnitExistsException, NoSuchUnitException {
        UnitDBImpl db = new UnitDBImpl(42, 43);
        db.addUnit(HERTZ);
        db.addUnit(NEWTON);
        db.addUnit(PASCAL);
        db.addUnit(JOULE);
        db.addUnit(WATT);
        db.addUnit(COULOMB);
        db.addUnit(VOLT);
        db.addUnit(FARAD);
        db.addUnit(OHM);
        db.addUnit(SIEMENS);
        db.addUnit(WEBER);
        db.addUnit(TESLA);
        db.addUnit(HENRY);
        db.addUnit(DEGREE_CELSIUS);
        db.addUnit(LUMEN);
        db.addUnit(LUX);
        db.addUnit(BECQUEREL);
        db.addUnit(GRAY);
        db.addUnit(SIEVERT);
        db.addUnit(MINUTE);
        db.addUnit(HOUR);
        db.addUnit(DAY);
        db.addUnit(ARC_DEGREE);
        db.addUnit(ARC_MINUTE);
        db.addUnit(ARC_SECOND);
        db.addUnit(LITER);
        db.addUnit(METRIC_TON);
        db.addUnit(NAUTICAL_MILE);
        db.addUnit(KNOT);
        db.addUnit(ANGSTROM);
        db.addUnit(ARE);
        db.addUnit(HECTARE);
        db.addUnit(BARN);
        db.addUnit(BAR);
        db.addUnit(GAL);
        db.addUnit(CURIE);
        db.addUnit(ROENTGEN);
        db.addUnit(RAD);
        db.addUnit(REM);
        db.addAlias("litre", "liter", "l");
        db.addAlias("tonne", "metric ton");
        db.addSymbol("tne", "tonne");
        return db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SI instance() throws UnitSystemException {
        if (si != null) return si;
        Class<SI> clazz = SI.class;
        synchronized (SI.class) {
            if (si != null) return si;
            try {
                si = new SI();
            }
            catch (UnitException e) {
                throw new UnitSystemException("Couldn't initialize class SI", e);
            }
            return si;
        }
    }

    public static void main(String[] args) throws Exception {
        SI si = SI.instance();
    }

    static {
        BaseUnit ampere = null;
        BaseUnit candela = null;
        BaseUnit kelvin = null;
        BaseUnit kilogram = null;
        BaseUnit meter = null;
        BaseUnit mole = null;
        BaseUnit second = null;
        BaseUnit radian = null;
        BaseUnit steradian = null;
        Unit hertz = null;
        Unit newton = null;
        Unit pascal = null;
        Unit joule = null;
        Unit watt = null;
        Unit coulomb = null;
        Unit volt = null;
        Unit farad = null;
        Unit ohm = null;
        Unit siemens = null;
        Unit weber = null;
        Unit tesla = null;
        Unit henry = null;
        Unit degree_celsius = null;
        Unit lumen = null;
        Unit lux = null;
        Unit becquerel = null;
        Unit gray = null;
        Unit sievert = null;
        Unit minute = null;
        Unit hour = null;
        Unit day = null;
        Unit arc_degree = null;
        Unit arc_minute = null;
        Unit arc_second = null;
        Unit liter = null;
        Unit metric_ton = null;
        Unit nautical_mile = null;
        Unit knot = null;
        Unit angstrom = null;
        Unit are = null;
        Unit hectare = null;
        Unit barn = null;
        Unit bar = null;
        Unit gal = null;
        Unit curie = null;
        Unit roentgen = null;
        Unit rad = null;
        Unit rem = null;
        try {
            ampere = SI.bu("ampere", "A", BaseQuantity.ELECTRIC_CURRENT);
            candela = SI.bu("candela", "cd", BaseQuantity.LUMINOUS_INTENSITY);
            kelvin = SI.bu("kelvin", "K", BaseQuantity.THERMODYNAMIC_TEMPERATURE);
            kilogram = SI.bu("kilogram", "kg", BaseQuantity.MASS);
            meter = SI.bu("meter", "m", BaseQuantity.LENGTH);
            mole = SI.bu("mole", "mol", BaseQuantity.AMOUNT_OF_SUBSTANCE);
            second = SI.bu("second", "s", BaseQuantity.TIME);
            radian = SI.bu("radian", "rad", BaseQuantity.PLANE_ANGLE);
            steradian = SI.bu("steradian", "sr", BaseQuantity.SOLID_ANGLE);
            hertz = SI.du("hertz", "Hz", second.raiseTo(-1));
            newton = SI.du("newton", "N", kilogram.multiplyBy(meter).divideBy(second.raiseTo(2)));
            pascal = SI.du("pascal", "Pa", newton.divideBy(meter.raiseTo(2)));
            joule = SI.du("joule", "J", newton.multiplyBy(meter));
            watt = SI.du("watt", "W", joule.divideBy(second));
            coulomb = SI.du("coulomb", "C", ampere.multiplyBy(second));
            volt = SI.du("volt", "V", watt.divideBy(ampere));
            farad = SI.du("farad", "F", coulomb.divideBy(volt));
            ohm = SI.du("ohm", "Ohm", volt.divideBy(ampere));
            siemens = SI.du("siemens", "S", ohm.raiseTo(-1));
            weber = SI.du("weber", "Wb", volt.multiplyBy(second));
            tesla = SI.du("tesla", "T", weber.divideBy(meter.raiseTo(2)));
            henry = SI.du("henry", "H", weber.divideBy(ampere));
            degree_celsius = SI.du("degree celsius", "Cel", new OffsetUnit(kelvin, 273.15));
            lumen = SI.du("lumen", "lm", candela.multiplyBy(steradian));
            lux = SI.du("lux", "lx", lumen.divideBy(meter.raiseTo(2)));
            becquerel = SI.du("becquerel", "Bq", hertz);
            gray = SI.du("gray", "Gy", joule.divideBy(kilogram));
            sievert = SI.du("sievert", "Sv", joule.divideBy(kilogram));
            minute = SI.du("minute", "min", new ScaledUnit(60.0, second));
            hour = SI.du("hour", "h", new ScaledUnit(60.0, (UnitImpl)minute));
            day = SI.du("day", "d", new ScaledUnit(24.0, (UnitImpl)hour));
            arc_degree = SI.du("arc degree", "deg", new ScaledUnit(Math.PI / 180, radian));
            arc_minute = SI.du("arc minute", "'", new ScaledUnit(0.016666666666666666, (UnitImpl)arc_degree));
            arc_second = SI.du("arc second", "\"", new ScaledUnit(0.016666666666666666, (UnitImpl)arc_minute));
            liter = SI.du("liter", "L", new ScaledUnit(0.001, (UnitImpl)meter.raiseTo(3)));
            metric_ton = SI.du("metric ton", "t", new ScaledUnit(1000.0, kilogram));
            nautical_mile = SI.du("nautical mile", "nmi", new ScaledUnit(1852.0, meter));
            knot = SI.du("knot", "kt", nautical_mile.divideBy(hour));
            angstrom = SI.du("angstrom", null, new ScaledUnit(1.0E-10, meter));
            are = SI.du("are", "are", new ScaledUnit(10.0, meter).raiseTo(2));
            hectare = SI.du("hectare", "ha", new ScaledUnit(100.0, (UnitImpl)are));
            barn = SI.du("barn", "b", new ScaledUnit(1.0E-28, (UnitImpl)meter.raiseTo(2)));
            bar = SI.du("bar", "bar", new ScaledUnit(100000.0, (UnitImpl)pascal));
            gal = SI.du("gal", "Gal", new ScaledUnit(0.01, meter).divideBy(second.raiseTo(2)));
            curie = SI.du("curie", "Ci", new ScaledUnit(3.7E10, (UnitImpl)becquerel));
            roentgen = SI.du("roentgen", "R", new ScaledUnit(2.58E-4, (UnitImpl)coulomb.divideBy(kilogram)));
            rad = SI.du("rad", "rd", new ScaledUnit(0.01, (UnitImpl)gray));
            rem = SI.du("rem", "rem", new ScaledUnit(0.01, (UnitImpl)sievert));
        }
        catch (UnitException e) {
            String reason = e.getMessage();
            System.err.println("Couldn't initialize class SI" + reason == null ? "" : ": " + reason);
        }
        AMOUNT_OF_SUBSTANCE_UNIT = mole;
        ELECTRIC_CURRENT_UNIT = ampere;
        LENGTH_UNIT = meter;
        LUMINOUS_INTENSITY_UNIT = candela;
        MASS_UNIT = kilogram;
        PLANE_ANGLE_UNIT = radian;
        SOLID_ANGLE_UNIT = steradian;
        THERMODYNAMIC_TEMPERATURE_UNIT = kelvin;
        TIME_UNIT = second;
        AMPERE = ampere;
        CANDELA = candela;
        KELVIN = kelvin;
        KILOGRAM = kilogram;
        METRE = METER = meter;
        MOLE = mole;
        SECOND = second;
        RADIAN = radian;
        STERADIAN = steradian;
        HERTZ = hertz;
        NEWTON = newton;
        PASCAL = pascal;
        JOULE = joule;
        WATT = watt;
        COULOMB = coulomb;
        VOLT = volt;
        FARAD = farad;
        OHM = ohm;
        SIEMENS = siemens;
        WEBER = weber;
        TESLA = tesla;
        HENRY = henry;
        DEGREE_CELSIUS = degree_celsius;
        LUMEN = lumen;
        LUX = lux;
        BECQUEREL = becquerel;
        GRAY = gray;
        SIEVERT = sievert;
        MINUTE = minute;
        HOUR = hour;
        DAY = day;
        ARC_DEGREE = arc_degree;
        ARC_MINUTE = arc_minute;
        ARC_SECOND = arc_second;
        LITRE = LITER = liter;
        TONNE = METRIC_TON = metric_ton;
        NAUTICAL_MILE = nautical_mile;
        KNOT = knot;
        ANGSTROM = angstrom;
        ARE = are;
        HECTARE = hectare;
        BARN = barn;
        BAR = bar;
        GAL = gal;
        CURIE = curie;
        ROENTGEN = roentgen;
        RAD = rad;
        REM = rem;
    }
}

