/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.PercentFraction;
import ome.xml.model.primitives.PositiveInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TransmittanceRange
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2011-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(TransmittanceRange.class);
    private PositiveInteger cutIn;
    private PercentFraction transmittance;
    private PositiveInteger cutOut;
    private NonNegativeInteger cutInTolerance;
    private NonNegativeInteger cutOutTolerance;

    public TransmittanceRange() {
    }

    public TransmittanceRange(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"TransmittanceRange".equals(tagName)) {
            LOGGER.debug("Expecting node name of TransmittanceRange got {}", (Object)tagName);
        }
        if (element.hasAttribute("CutIn")) {
            this.setCutIn(PositiveInteger.valueOf(element.getAttribute("CutIn")));
        }
        if (element.hasAttribute("Transmittance")) {
            this.setTransmittance(PercentFraction.valueOf(element.getAttribute("Transmittance")));
        }
        if (element.hasAttribute("CutOut")) {
            this.setCutOut(PositiveInteger.valueOf(element.getAttribute("CutOut")));
        }
        if (element.hasAttribute("CutInTolerance")) {
            this.setCutInTolerance(NonNegativeInteger.valueOf(element.getAttribute("CutInTolerance")));
        }
        if (element.hasAttribute("CutOutTolerance")) {
            this.setCutOutTolerance(NonNegativeInteger.valueOf(element.getAttribute("CutOutTolerance")));
        }
    }

    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public PositiveInteger getCutIn() {
        return this.cutIn;
    }

    public void setCutIn(PositiveInteger cutIn) {
        this.cutIn = cutIn;
    }

    public PercentFraction getTransmittance() {
        return this.transmittance;
    }

    public void setTransmittance(PercentFraction transmittance) {
        this.transmittance = transmittance;
    }

    public PositiveInteger getCutOut() {
        return this.cutOut;
    }

    public void setCutOut(PositiveInteger cutOut) {
        this.cutOut = cutOut;
    }

    public NonNegativeInteger getCutInTolerance() {
        return this.cutInTolerance;
    }

    public void setCutInTolerance(NonNegativeInteger cutInTolerance) {
        this.cutInTolerance = cutInTolerance;
    }

    public NonNegativeInteger getCutOutTolerance() {
        return this.cutOutTolerance;
    }

    public void setCutOutTolerance(NonNegativeInteger cutOutTolerance) {
        this.cutOutTolerance = cutOutTolerance;
    }

    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    protected Element asXMLElement(Document document, Element TransmittanceRange_element) {
        if (TransmittanceRange_element == null) {
            TransmittanceRange_element = document.createElementNS(NAMESPACE, "TransmittanceRange");
        }
        if (this.cutIn != null) {
            TransmittanceRange_element.setAttribute("CutIn", this.cutIn.toString());
        }
        if (this.transmittance != null) {
            TransmittanceRange_element.setAttribute("Transmittance", this.transmittance.toString());
        }
        if (this.cutOut != null) {
            TransmittanceRange_element.setAttribute("CutOut", this.cutOut.toString());
        }
        if (this.cutInTolerance != null) {
            TransmittanceRange_element.setAttribute("CutInTolerance", this.cutInTolerance.toString());
        }
        if (this.cutOutTolerance != null) {
            TransmittanceRange_element.setAttribute("CutOutTolerance", this.cutOutTolerance.toString());
        }
        return super.asXMLElement(document, TransmittanceRange_element);
    }
}

