/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.gui;

import java.io.File;
import java.io.FileFilter;
import loci.formats.IFormatReader;

public class FormatFileFilter
extends javax.swing.filechooser.FileFilter
implements FileFilter,
Comparable {
    private IFormatReader reader;
    private boolean allowOpen;
    private String desc;

    public FormatFileFilter(IFormatReader reader) {
        this(reader, true);
    }

    public FormatFileFilter(IFormatReader reader, boolean allowOpen) {
        this.reader = reader;
        this.allowOpen = allowOpen;
        StringBuffer sb = new StringBuffer(reader.getFormat());
        String[] exts = reader.getSuffixes();
        boolean first = true;
        for (int i = 0; i < exts.length; ++i) {
            if (exts[i] == null || exts[i].equals("")) continue;
            if (first) {
                sb.append(" (");
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append("*.");
            sb.append(exts[i]);
        }
        sb.append(")");
        this.desc = sb.toString();
    }

    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        return this.reader.isThisType(f.getPath(), this.allowOpen);
    }

    public IFormatReader getReader() {
        return this.reader;
    }

    public String getDescription() {
        return this.desc;
    }

    public String toString() {
        return "FormatFileFilter: " + this.desc;
    }

    public int compareTo(Object o) {
        return this.desc.compareTo(((javax.swing.filechooser.FileFilter)o).getDescription());
    }
}

