/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.Annotation;
import ome.xml.model.AnnotationRef;
import ome.xml.model.Image;
import ome.xml.model.MicrobeamManipulation;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.Union;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ROI
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/ROI/2011-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(ROI.class);
    private String namespace;
    private String id;
    private String name;
    private Union union;
    private List<Annotation> annotationList = new ArrayList<Annotation>();
    private String description;
    private List<Image> image_BackReferenceList = new ArrayList<Image>();
    private List<MicrobeamManipulation> microbeamManipulation_BackReferenceList = new ArrayList<MicrobeamManipulation>();

    public ROI() {
    }

    public ROI(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        List<Element> Union_nodeList;
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"ROI".equals(tagName)) {
            LOGGER.debug("Expecting node name of ROI got {}", (Object)tagName);
        }
        if (element.hasAttribute("Namespace")) {
            this.setNamespace(String.valueOf(element.getAttribute("Namespace")));
        }
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException(String.format("ROI missing required ID property.", new Object[0]));
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
        if (element.hasAttribute("Name")) {
            this.setName(String.valueOf(element.getAttribute("Name")));
        }
        if ((Union_nodeList = ROI.getChildrenByTagName(element, "Union")).size() > 1) {
            throw new RuntimeException(String.format("Union node list size %d != 1", Union_nodeList.size()));
        }
        if (Union_nodeList.size() != 0) {
            this.setUnion(new Union(Union_nodeList.get(0), model));
        }
        List<Element> AnnotationRef_nodeList = ROI.getChildrenByTagName(element, "AnnotationRef");
        for (Element AnnotationRef_element : AnnotationRef_nodeList) {
            AnnotationRef annotationList_reference = new AnnotationRef();
            annotationList_reference.setID(AnnotationRef_element.getAttribute("ID"));
            model.addReference(this, annotationList_reference);
        }
        List<Element> Description_nodeList = ROI.getChildrenByTagName(element, "Description");
        if (Description_nodeList.size() > 1) {
            throw new RuntimeException(String.format("Description node list size %d != 1", Description_nodeList.size()));
        }
        if (Description_nodeList.size() != 0) {
            this.setDescription(String.valueOf(Description_nodeList.get(0).getTextContent()));
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        if (reference instanceof AnnotationRef) {
            Annotation o_casted = (Annotation)o;
            o_casted.linkROI(this);
            this.annotationList.add(o_casted);
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Union getUnion() {
        return this.union;
    }

    public void setUnion(Union union) {
        this.union = union;
    }

    public int sizeOfLinkedAnnotationList() {
        return this.annotationList.size();
    }

    public List<Annotation> copyLinkedAnnotationList() {
        return new ArrayList<Annotation>(this.annotationList);
    }

    public Annotation getLinkedAnnotation(int index) {
        return this.annotationList.get(index);
    }

    public Annotation setLinkedAnnotation(int index, Annotation o) {
        return this.annotationList.set(index, o);
    }

    public boolean linkAnnotation(Annotation o) {
        o.linkROI(this);
        return this.annotationList.add(o);
    }

    public boolean unlinkAnnotation(Annotation o) {
        o.unlinkROI(this);
        return this.annotationList.remove(o);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int sizeOfLinkedImageList() {
        return this.image_BackReferenceList.size();
    }

    public List<Image> copyLinkedImageList() {
        return new ArrayList<Image>(this.image_BackReferenceList);
    }

    public Image getLinkedImage(int index) {
        return this.image_BackReferenceList.get(index);
    }

    public Image setLinkedImage(int index, Image o) {
        return this.image_BackReferenceList.set(index, o);
    }

    public boolean linkImage(Image o) {
        return this.image_BackReferenceList.add(o);
    }

    public boolean unlinkImage(Image o) {
        return this.image_BackReferenceList.remove(o);
    }

    public int sizeOfLinkedMicrobeamManipulationList() {
        return this.microbeamManipulation_BackReferenceList.size();
    }

    public List<MicrobeamManipulation> copyLinkedMicrobeamManipulationList() {
        return new ArrayList<MicrobeamManipulation>(this.microbeamManipulation_BackReferenceList);
    }

    public MicrobeamManipulation getLinkedMicrobeamManipulation(int index) {
        return this.microbeamManipulation_BackReferenceList.get(index);
    }

    public MicrobeamManipulation setLinkedMicrobeamManipulation(int index, MicrobeamManipulation o) {
        return this.microbeamManipulation_BackReferenceList.set(index, o);
    }

    public boolean linkMicrobeamManipulation(MicrobeamManipulation o) {
        return this.microbeamManipulation_BackReferenceList.add(o);
    }

    public boolean unlinkMicrobeamManipulation(MicrobeamManipulation o) {
        return this.microbeamManipulation_BackReferenceList.remove(o);
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    protected Element asXMLElement(Document document, Element ROI_element) {
        if (ROI_element == null) {
            ROI_element = document.createElementNS(NAMESPACE, "ROI");
        }
        if (this.namespace != null) {
            ROI_element.setAttribute("Namespace", this.namespace.toString());
        }
        if (this.id != null) {
            ROI_element.setAttribute("ID", this.id.toString());
        }
        if (this.name != null) {
            ROI_element.setAttribute("Name", this.name.toString());
        }
        if (this.union != null) {
            ROI_element.appendChild(this.union.asXMLElement(document));
        }
        if (this.annotationList != null) {
            for (Annotation annotationList_value : this.annotationList) {
                AnnotationRef o = new AnnotationRef();
                o.setID(annotationList_value.getID());
                ROI_element.appendChild(o.asXMLElement(document));
            }
        }
        if (this.description != null) {
            Element description_element = document.createElementNS(NAMESPACE, "Description");
            description_element.setTextContent(this.description.toString());
            ROI_element.appendChild(description_element);
        }
        if (this.image_BackReferenceList != null) {
            // empty if block
        }
        if (this.microbeamManipulation_BackReferenceList != null) {
            // empty if block
        }
        return super.asXMLElement(document, ROI_element);
    }
}

