/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.tools;

import java.io.IOException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;

public class PrintDomains {
    public static void main(String[] args) {
        IFormatReader[] readers = new ImageReader().getReaders();
        Hashtable domains = new Hashtable();
        for (String domain : FormatTools.ALL_DOMAINS) {
            domains.put(domain, new Vector());
        }
        for (IFormatReader reader : readers) {
            try {
                String[] readerDomains;
                for (String domain : readerDomains = reader.getPossibleDomains("")) {
                    ((Vector)domains.get(domain)).add(reader);
                }
            }
            catch (FormatException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Object[] domainKeys = domains.keySet().toArray(new String[domains.size()]);
        Arrays.sort(domainKeys);
        for (Object domain : domainKeys) {
            System.out.println((String)domain + ":");
            Vector r = (Vector)domains.get(domain);
            for (IFormatReader reader : r) {
                System.out.println("  " + reader.getFormat());
            }
        }
    }
}

