/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.xml.XMLTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.in.DefaultMetadataOptions;
import loci.formats.in.MetadataLevel;
import loci.formats.in.MetamorphHandler;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.IFDList;
import loci.formats.tiff.PhotoInterp;
import loci.formats.tiff.TiffIFDEntry;
import loci.formats.tiff.TiffParser;
import loci.formats.tiff.TiffRational;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.PositiveInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.helpers.DefaultHandler;

public class MetamorphReader
extends BaseTiffReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetamorphReader.class);
    public static final String SHORT_DATE_FORMAT = "yyyyMMdd HH:mm:ss";
    public static final String MEDIUM_DATE_FORMAT = "yyyyMMdd HH:mm:ss.SSS";
    public static final String LONG_DATE_FORMAT = "dd/MM/yyyy HH:mm:ss:SSS";
    public static final String[] ND_SUFFIX = new String[]{"nd"};
    public static final String[] STK_SUFFIX = new String[]{"stk", "tif", "tiff"};
    private static final int METAMORPH_ID = 33628;
    private static final int UIC1TAG = 33628;
    private static final int UIC2TAG = 33629;
    private static final int UIC3TAG = 33630;
    private static final int UIC4TAG = 33631;
    private String imageName;
    private String imageCreationDate;
    private long[] emWavelength;
    private double[] wave;
    private String binning;
    private double zoom;
    private double stepSize;
    private Double exposureTime;
    private Vector<String> waveNames;
    private Vector<String> stageNames;
    private long[] internalStamps;
    private double[] zDistances;
    private double[] stageX;
    private double[] stageY;
    private double zStart;
    private Double sizeX = null;
    private Double sizeY = null;
    private double tempZ;
    private boolean validZ;
    private int mmPlanes;
    private MetamorphReader[][] stkReaders;
    private String[][] stks;
    private String ndFilename;
    private boolean canLookForND = true;
    private boolean[] firstSeriesChannels;

    public MetamorphReader() {
        super("Metamorph STK", new String[]{"stk", "nd", "tif", "tiff"});
        this.domains = new String[]{"Light Microscopy"};
        this.hasCompanionFiles = true;
        this.suffixSufficient = false;
    }

    public boolean isThisType(String name, boolean open) {
        Location location = new Location(name);
        if (!location.exists()) {
            return false;
        }
        if (MetamorphReader.checkSuffix(name, "nd")) {
            return true;
        }
        if (open) {
            String[] list;
            location = location.getAbsoluteFile();
            Location parent = location.getParentFile();
            for (String f : list = parent.list(true)) {
                if (!MetamorphReader.checkSuffix(f, "nd") || !MetamorphReader.checkSuffix(name, this.suffixes)) continue;
                return true;
            }
        }
        return super.isThisType(name, open);
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        TiffParser tp = new TiffParser(stream);
        IFD ifd = tp.getFirstIFD();
        if (ifd == null) {
            return false;
        }
        String software = ifd.getIFDTextValue(305);
        boolean validSoftware = software != null && software.trim().toLowerCase().startsWith("metamorph");
        return validSoftware || ifd.containsKey(33628) && ifd.containsKey(33630) && ifd.containsKey(33631);
    }

    public boolean isSingleFile(String id) throws FormatException, IOException {
        return !MetamorphReader.checkSuffix(id, ND_SUFFIX);
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        String[] files;
        if (MetamorphReader.checkSuffix(id, ND_SUFFIX)) {
            return 0;
        }
        Location l = new Location(id).getAbsoluteFile();
        for (String file2 : files = l.getParentFile().list()) {
            if (!MetamorphReader.checkSuffix(file2, ND_SUFFIX) || !l.getName().startsWith(file2.substring(0, file2.lastIndexOf(".")))) continue;
            return 0;
        }
        return 2;
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        if (!noPixels && this.stks == null) {
            return new String[]{this.currentId};
        }
        if (this.stks == null) {
            return new String[0];
        }
        Vector<String> v = new Vector<String>();
        if (this.ndFilename != null) {
            v.add(this.ndFilename);
        }
        if (!noPixels) {
            for (String stk : this.stks[this.getSeries()]) {
                if (stk == null || !new Location(stk).exists()) continue;
                v.add(stk);
            }
        }
        return v.toArray(new String[v.size()]);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        String file2;
        FormatTools.assertId(this.currentId, true, 1);
        if (this.stks == null) {
            return super.openBytes(no, buf, x, y, w, h);
        }
        int[] coords = FormatTools.getZCTCoords(this, no % this.getSizeZ());
        int ndx = no / this.getSizeZ();
        if (this.stks[this.series].length == 1) {
            ndx = 0;
        }
        if ((file2 = this.stks[this.series][ndx]) == null) {
            return buf;
        }
        this.stkReaders[this.series][ndx].setId(file2);
        int plane = this.stks[this.series].length == 1 ? no : coords[0];
        this.stkReaders[this.series][ndx].openBytes(plane, buf, x, y, w, h);
        this.stkReaders[this.series][ndx].close();
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.stkReaders != null) {
            for (MetamorphReader[] s : this.stkReaders) {
                if (s == null) continue;
                for (MetamorphReader reader : s) {
                    if (reader == null) continue;
                    reader.close(fileOnly);
                }
            }
        }
        if (!fileOnly) {
            this.imageCreationDate = null;
            this.imageName = null;
            this.emWavelength = null;
            this.stks = null;
            this.mmPlanes = 0;
            this.ndFilename = null;
            this.wave = null;
            this.binning = null;
            this.stepSize = 0.0;
            this.zoom = 0.0;
            this.exposureTime = null;
            this.stageNames = null;
            this.waveNames = null;
            this.internalStamps = null;
            this.stageY = null;
            this.stageX = null;
            this.zDistances = null;
            this.firstSeriesChannels = null;
            this.sizeY = null;
            this.sizeX = null;
            this.tempZ = 0.0;
            this.validZ = false;
            this.stkReaders = null;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (MetamorphReader.checkSuffix(id, ND_SUFFIX)) {
            String[] dirList;
            LOGGER.info("Initializing " + id);
            String stkFile = id.substring(0, id.lastIndexOf("."));
            if (stkFile.indexOf(File.separator) != -1) {
                stkFile = stkFile.substring(stkFile.lastIndexOf(File.separator) + 1);
            }
            Location parent = new Location(id).getAbsoluteFile().getParentFile();
            LOGGER.info("Looking for STK file in {}", (Object)parent.getAbsolutePath());
            for (String f : dirList = parent.list(true)) {
                int underscore = f.indexOf("_");
                if (underscore < 0) {
                    underscore = f.indexOf(".");
                }
                if (underscore < 0) {
                    underscore = f.length();
                }
                String prefix = f.substring(0, underscore);
                if (!f.equals(stkFile) && !stkFile.startsWith(prefix) || !MetamorphReader.checkSuffix(f, STK_SUFFIX)) continue;
                stkFile = new Location(parent.getAbsolutePath(), f).getAbsolutePath();
                break;
            }
            if (!MetamorphReader.checkSuffix(stkFile, STK_SUFFIX)) {
                throw new FormatException("STK file not found in " + parent.getAbsolutePath() + ".");
            }
            super.initFile(stkFile);
        } else {
            super.initFile(id);
        }
        Location ndfile = null;
        if (MetamorphReader.checkSuffix(id, ND_SUFFIX)) {
            ndfile = new Location(id);
        } else if (this.canLookForND) {
            String[] list;
            Location stk = new Location(id).getAbsoluteFile();
            String stkName = stk.getName();
            String stkPrefix = stkName;
            if (stkPrefix.indexOf("_") >= 0) {
                stkPrefix = stkPrefix.substring(0, stkPrefix.indexOf("_") + 1);
            }
            Location parent = stk.getParentFile();
            for (String f : list = parent.list(true)) {
                if (!MetamorphReader.checkSuffix(f, ND_SUFFIX)) continue;
                String prefix = f.substring(0, f.lastIndexOf("."));
                if (prefix.indexOf("_") >= 0) {
                    prefix = prefix.substring(0, prefix.indexOf("_") + 1);
                }
                if (!stkName.startsWith(prefix) && !prefix.equals(stkPrefix)) continue;
                ndfile = new Location(parent, f).getAbsoluteFile();
                if (prefix.equals(stkPrefix)) break;
            }
        }
        String creationTime = null;
        if (ndfile != null && ndfile.exists() && (this.fileGroupOption(id) == 0 || this.isGroupFiles())) {
            int f;
            int i;
            String[] lines;
            int zc = this.getSizeZ();
            int cc = this.getSizeC();
            int tc = this.getSizeT();
            int nstages = 0;
            String z = null;
            String c = null;
            String t = null;
            Vector<Boolean> hasZ = new Vector<Boolean>();
            this.waveNames = new Vector();
            this.stageNames = new Vector();
            boolean useWaveNames = true;
            this.ndFilename = ndfile.getAbsolutePath();
            for (String line : lines = DataTools.readFile(this.ndFilename).split("\n")) {
                int comma = line.indexOf(",");
                if (comma <= 0) continue;
                String key = line.substring(1, comma - 1).trim();
                String value = line.substring(comma + 1).trim();
                this.addGlobalMeta(key, value);
                if (key.equals("NZSteps")) {
                    z = value;
                    continue;
                }
                if (key.equals("NWavelengths")) {
                    c = value;
                    continue;
                }
                if (key.equals("NTimePoints")) {
                    t = value;
                    continue;
                }
                if (key.startsWith("WaveDoZ")) {
                    hasZ.add(new Boolean(value.toLowerCase()));
                    continue;
                }
                if (key.startsWith("WaveName")) {
                    this.waveNames.add(value.substring(1, value.length() - 1));
                    continue;
                }
                if (key.startsWith("Stage")) {
                    this.stageNames.add(value);
                    continue;
                }
                if (key.startsWith("StartTime")) {
                    creationTime = value;
                    continue;
                }
                if (key.equals("ZStepSize")) {
                    char separator = new DecimalFormatSymbols().getDecimalSeparator();
                    value = value.replace('.', separator);
                    value = value.replace(',', separator);
                    this.stepSize = Double.parseDouble(value);
                    continue;
                }
                if (key.equals("NStagePositions")) {
                    nstages = Integer.parseInt(value);
                    continue;
                }
                if (!key.equals("WaveInFileName")) continue;
                useWaveNames = Boolean.parseBoolean(value);
            }
            if (z != null) {
                zc = Integer.parseInt(z);
            }
            if (c != null) {
                cc = Integer.parseInt(c);
            }
            if (t != null) {
                tc = Integer.parseInt(t);
            }
            if (cc == 0) {
                cc = 1;
            }
            int numFiles = cc * tc;
            if (nstages > 0) {
                numFiles *= nstages;
            }
            int seriesCount = nstages == 0 ? 1 : nstages;
            this.firstSeriesChannels = new boolean[cc];
            Arrays.fill(this.firstSeriesChannels, true);
            boolean differentZs = false;
            for (int i2 = 0; i2 < cc; ++i2) {
                boolean hasZ2;
                boolean hasZ1 = i2 < hasZ.size() && (Boolean)hasZ.get(i2) != false;
                boolean bl = hasZ2 = i2 != 0 && i2 - 1 < hasZ.size() && (Boolean)hasZ.get(i2 - 1) != false;
                if (i2 <= 0 || hasZ1 == hasZ2) continue;
                if (!differentZs) {
                    seriesCount *= 2;
                }
                differentZs = true;
            }
            int channelsInFirstSeries = cc;
            if (differentZs) {
                channelsInFirstSeries = 0;
                for (i = 0; i < cc; ++i) {
                    if (((Boolean)hasZ.get(i)).booleanValue()) {
                        ++channelsInFirstSeries;
                        continue;
                    }
                    this.firstSeriesChannels[i] = false;
                }
            }
            this.stks = new String[seriesCount][];
            if (seriesCount == 1) {
                this.stks[0] = new String[numFiles];
            } else if (differentZs) {
                int stages = nstages == 0 ? 1 : nstages;
                for (int i3 = 0; i3 < stages; ++i3) {
                    this.stks[i3 * 2] = new String[channelsInFirstSeries * tc];
                    this.stks[i3 * 2 + 1] = new String[(cc - channelsInFirstSeries) * tc];
                }
            } else {
                for (i = 0; i < this.stks.length; ++i) {
                    this.stks[i] = new String[numFiles / this.stks.length];
                }
            }
            String prefix = ndfile.getPath();
            prefix = prefix.substring(prefix.lastIndexOf(File.separator) + 1, prefix.lastIndexOf("."));
            int[] pt = new int[seriesCount];
            for (int i4 = 0; i4 < tc; ++i4) {
                int ns = nstages == 0 ? 1 : nstages;
                for (int s = 0; s < ns; ++s) {
                    for (int j = 0; j < cc; ++j) {
                        boolean validZ = j >= hasZ.size() || (Boolean)hasZ.get(j) != false;
                        int seriesNdx = s * (seriesCount / ns);
                        this.stks[seriesNdx][pt[seriesNdx += seriesCount == 1 || validZ ? 0 : 1]] = prefix;
                        if (j < this.waveNames.size() && this.waveNames.get(j) != null) {
                            String[] stringArray = this.stks[seriesNdx];
                            int n = pt[seriesNdx];
                            stringArray[n] = stringArray[n] + "_w" + (j + 1);
                            if (useWaveNames) {
                                String waveName = this.waveNames.get(j);
                                waveName = waveName.replace('_', '-');
                                String[] stringArray2 = this.stks[seriesNdx];
                                int n2 = pt[seriesNdx];
                                stringArray2[n2] = stringArray2[n2] + waveName;
                            }
                        }
                        if (nstages > 0) {
                            String[] stringArray = this.stks[seriesNdx];
                            int n = pt[seriesNdx];
                            stringArray[n] = stringArray[n] + "_s" + (s + 1);
                        }
                        if (tc > 1) {
                            String[] stringArray = this.stks[seriesNdx];
                            int n = pt[seriesNdx];
                            stringArray[n] = stringArray[n] + "_t" + (i4 + 1) + ".STK";
                        } else {
                            String[] stringArray = this.stks[seriesNdx];
                            int n = pt[seriesNdx];
                            stringArray[n] = stringArray[n] + ".STK";
                        }
                        int n = seriesNdx;
                        pt[n] = pt[n] + 1;
                    }
                }
            }
            ndfile = ndfile.getAbsoluteFile();
            for (int s = 0; s < this.stks.length; ++s) {
                for (f = 0; f < this.stks[s].length; ++f) {
                    Location l = new Location(ndfile.getParent(), this.stks[s][f]);
                    this.stks[s][f] = this.getRealSTKFile(l);
                }
            }
            int q = 0;
            f = 0;
            String file2 = this.stks[q][f];
            while (file2 == null) {
                if (f < this.stks[q].length - 1) {
                    ++f;
                } else if (q < this.stks.length - 1) {
                    ++q;
                    f = 0;
                }
                file2 = this.stks[q][f];
            }
            RandomAccessInputStream s = new RandomAccessInputStream(file2);
            TiffParser tp = new TiffParser(s);
            IFD ifd = tp.getFirstIFD();
            s.close();
            this.core[0].sizeX = (int)ifd.getImageWidth();
            this.core[0].sizeY = (int)ifd.getImageLength();
            this.core[0].sizeZ = zc;
            this.core[0].sizeC = cc;
            this.core[0].sizeT = tc;
            this.core[0].imageCount = zc * tc * cc;
            this.core[0].dimensionOrder = "XYZCT";
            if (this.stks != null && this.stks.length > 1) {
                CoreMetadata[] newCore = new CoreMetadata[this.stks.length];
                for (int i5 = 0; i5 < this.stks.length; ++i5) {
                    newCore[i5] = new CoreMetadata();
                    newCore[i5].sizeX = this.getSizeX();
                    newCore[i5].sizeY = this.getSizeY();
                    newCore[i5].sizeZ = this.getSizeZ();
                    newCore[i5].sizeC = this.getSizeC();
                    newCore[i5].sizeT = this.getSizeT();
                    newCore[i5].pixelType = this.getPixelType();
                    newCore[i5].imageCount = this.getImageCount();
                    newCore[i5].dimensionOrder = this.getDimensionOrder();
                    newCore[i5].rgb = this.isRGB();
                    newCore[i5].littleEndian = this.isLittleEndian();
                    newCore[i5].interleaved = this.isInterleaved();
                    newCore[i5].orderCertain = true;
                }
                if (this.stks.length > nstages) {
                    int ns = nstages == 0 ? 1 : nstages;
                    for (int j = 0; j < ns; ++j) {
                        newCore[j * 2].sizeC = this.stks[j * 2].length / this.getSizeT();
                        newCore[j * 2 + 1].sizeC = this.stks[j * 2 + 1].length / newCore[j * 2 + 1].sizeT;
                        newCore[j * 2 + 1].sizeZ = 1;
                        newCore[j * 2].imageCount = newCore[j * 2].sizeC * newCore[j * 2].sizeT * newCore[j * 2].sizeZ;
                        newCore[j * 2 + 1].imageCount = newCore[j * 2 + 1].sizeC * newCore[j * 2 + 1].sizeT;
                    }
                }
                this.core = newCore;
            }
        }
        if (this.stks == null) {
            this.stkReaders = new MetamorphReader[1][1];
            this.stkReaders[0][0] = new MetamorphReader();
            this.stkReaders[0][0].setCanLookForND(false);
        } else {
            this.stkReaders = new MetamorphReader[this.stks.length][];
            for (int i = 0; i < this.stks.length; ++i) {
                this.stkReaders[i] = new MetamorphReader[this.stks[i].length];
                for (int j = 0; j < this.stkReaders[i].length; ++j) {
                    this.stkReaders[i][j] = new MetamorphReader();
                    this.stkReaders[i][j].setCanLookForND(false);
                    if (j <= 0) continue;
                    this.stkReaders[i][j].setMetadataOptions(new DefaultMetadataOptions(MetadataLevel.MINIMUM));
                }
            }
        }
        Vector<String> timestamps = null;
        MetamorphHandler handler = null;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this, true);
        String detectorID = MetadataTools.createLSID("Detector", 0, 0);
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            String comment;
            this.setSeries(i);
            handler = new MetamorphHandler(this.getSeriesMetadata());
            String instrumentID = MetadataTools.createLSID("Instrument", i);
            store.setInstrumentID(instrumentID, i);
            store.setImageInstrumentRef(instrumentID, i);
            if (i == 0) {
                store.setDetectorID(detectorID, 0, 0);
                store.setDetectorType(this.getDetectorType("Other"), 0, 0);
            }
            if ((comment = this.getFirstComment(i)) != null && comment.startsWith("<MetaData>")) {
                XMLTools.parseXML(comment, (DefaultHandler)handler);
            }
            if (creationTime != null) {
                String date = DateTools.formatDate(creationTime, SHORT_DATE_FORMAT);
                store.setImageAcquiredDate(date, 0);
            } else if (i > 0) {
                MetadataTools.setDefaultCreationDate(store, id, i);
            }
            store.setImageName(this.makeImageName(i), i);
            if (this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM) continue;
            store.setImageDescription("", i);
            store.setImagingEnvironmentTemperature(handler.getTemperature(), i);
            if (this.sizeX == null) {
                this.sizeX = handler.getPixelSizeX();
            }
            if (this.sizeY == null) {
                this.sizeY = handler.getPixelSizeY();
            }
            if (this.sizeX > 0.0) {
                store.setPixelsPhysicalSizeX(new PositiveFloat(this.sizeX), i);
            }
            if (this.sizeY > 0.0) {
                store.setPixelsPhysicalSizeY(new PositiveFloat(this.sizeY), i);
            }
            if (this.zDistances != null) {
                this.stepSize = this.zDistances[0];
            }
            if (this.stepSize > 0.0) {
                store.setPixelsPhysicalSizeZ(new PositiveFloat(this.stepSize), i);
            }
            int waveIndex = 0;
            for (int c = 0; c < this.getEffectiveSizeC(); ++c) {
                if (this.firstSeriesChannels == null || this.stageNames != null && this.stageNames.size() == this.getSeriesCount()) {
                    waveIndex = c;
                } else if (this.firstSeriesChannels != null) {
                    int s = i % 2;
                    while (this.firstSeriesChannels[waveIndex] == (s == 1) && waveIndex < this.firstSeriesChannels.length) {
                        ++waveIndex;
                    }
                }
                if (this.waveNames != null && waveIndex < this.waveNames.size()) {
                    store.setChannelName(this.waveNames.get(waveIndex), i, c);
                }
                if (handler.getBinning() != null) {
                    this.binning = handler.getBinning();
                }
                if (this.binning != null) {
                    store.setDetectorSettingsBinning(this.getBinning(this.binning), i, c);
                }
                if (handler.getReadOutRate() != 0.0) {
                    store.setDetectorSettingsReadOutRate(handler.getReadOutRate(), i, c);
                }
                store.setDetectorSettingsID(detectorID, i, c);
                if (this.wave != null && waveIndex < this.wave.length && (int)this.wave[waveIndex] >= 1) {
                    store.setChannelLightSourceSettingsWavelength(new PositiveInteger((int)this.wave[waveIndex]), i, c);
                    String lightSourceID = MetadataTools.createLSID("LightSource", i, c);
                    store.setLaserID(lightSourceID, i, c);
                    store.setChannelLightSourceSettingsID(lightSourceID, i, c);
                    store.setLaserType(this.getLaserType("Other"), i, c);
                    store.setLaserLaserMedium(this.getLaserMedium("Other"), i, c);
                }
                ++waveIndex;
            }
            timestamps = handler.getTimestamps();
            for (int t = 0; t < timestamps.size(); ++t) {
                this.addSeriesMeta("timestamp " + t, DateTools.formatDate(timestamps.get(t), MEDIUM_DATE_FORMAT));
            }
            long startDate = 0L;
            if (timestamps.size() > 0) {
                startDate = DateTools.getTime(timestamps.get(0), MEDIUM_DATE_FORMAT);
            }
            Double positionX = new Double(handler.getStagePositionX());
            Double positionY = new Double(handler.getStagePositionY());
            Vector<Double> exposureTimes = handler.getExposures();
            if (exposureTimes.size() == 0) {
                for (int p = 0; p < this.getImageCount(); ++p) {
                    exposureTimes.add(this.exposureTime);
                }
            }
            int lastFile = -1;
            IFD lastIFD = null;
            long[] lastOffsets = null;
            double distance = this.zStart;
            for (int p = 0; p < this.getImageCount(); ++p) {
                int[] coords = this.getZCTCoords(p);
                Double deltaT = new Double(0.0);
                Double exposureTime = new Double(0.0);
                Double xmlZPosition = null;
                int fileIndex = this.getIndex(0, 0, coords[2]) / this.getSizeZ();
                if (fileIndex >= 0) {
                    String file3;
                    String string = file3 = this.stks == null ? this.currentId : this.stks[i][fileIndex];
                    if (file3 != null) {
                        RandomAccessInputStream stream = new RandomAccessInputStream(file3);
                        TiffParser tp = new TiffParser(stream);
                        tp.checkHeader();
                        if (fileIndex != lastFile) {
                            lastFile = fileIndex;
                            lastOffsets = tp.getIFDOffsets();
                        }
                        lastIFD = tp.getIFD(lastOffsets[p % lastOffsets.length]);
                        stream.close();
                        comment = lastIFD.getComment();
                        if (comment != null) {
                            comment = comment.trim();
                        }
                        handler = new MetamorphHandler(this.getSeriesMetadata());
                        if (comment != null && comment.startsWith("<MetaData>")) {
                            XMLTools.parseXML(comment, (DefaultHandler)handler);
                        }
                        timestamps = handler.getTimestamps();
                        exposureTimes = handler.getExposures();
                        Vector<Double> zPositions = handler.getZPositions();
                        if (zPositions != null && zPositions.size() > 0) {
                            xmlZPosition = zPositions.get(0);
                        }
                    }
                }
                int index = 0;
                if (timestamps.size() > 0) {
                    if (coords[2] < timestamps.size()) {
                        index = coords[2];
                    }
                    String stamp = timestamps.get(index);
                    long ms = DateTools.getTime(stamp, MEDIUM_DATE_FORMAT);
                    deltaT = new Double((double)(ms - startDate) / 1000.0);
                } else if (this.internalStamps != null && p < this.internalStamps.length) {
                    long delta = this.internalStamps[p] - this.internalStamps[0];
                    deltaT = new Double((double)delta / 1000.0);
                    if (coords[2] < exposureTimes.size()) {
                        index = coords[2];
                    }
                }
                if (index < exposureTimes.size()) {
                    exposureTime = exposureTimes.get(index);
                }
                store.setPlaneDeltaT(deltaT, i, p);
                store.setPlaneExposureTime(exposureTime, i, p);
                if (this.stageX != null && p < this.stageX.length) {
                    store.setPlanePositionX(this.stageX[p], i, p);
                }
                if (this.stageY != null && p < this.stageY.length) {
                    store.setPlanePositionY(this.stageY[p], i, p);
                }
                if (this.zDistances != null && p < this.zDistances.length) {
                    if (p > 0) {
                        distance = this.zDistances[p] != 0.0 ? (distance += this.zDistances[p]) : (distance += this.zDistances[0]);
                    }
                    store.setPlanePositionZ(distance, i, p);
                    continue;
                }
                if (xmlZPosition == null) continue;
                store.setPlanePositionZ(xmlZPosition, i, p);
            }
        }
        this.setSeries(0);
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        String filename;
        super.initStandardMetadata();
        this.core[0].sizeZ = 1;
        this.core[0].sizeT = 0;
        int rgbChannels = this.getSizeC();
        TiffIFDEntry uic1tagEntry = null;
        TiffIFDEntry uic2tagEntry = null;
        TiffIFDEntry uic4tagEntry = null;
        try {
            uic1tagEntry = this.tiffParser.getFirstIFDEntry(33628);
            uic2tagEntry = this.tiffParser.getFirstIFDEntry(33629);
            uic4tagEntry = this.tiffParser.getFirstIFDEntry(33631);
        }
        catch (IllegalArgumentException exc) {
            LOGGER.debug("Unknown tag", exc);
        }
        try {
            if (uic4tagEntry != null) {
                this.mmPlanes = uic4tagEntry.getValueCount();
            }
            if (uic2tagEntry != null) {
                this.parseUIC2Tags(uic2tagEntry.getValueOffset());
            }
            if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
                if (uic4tagEntry != null) {
                    this.parseUIC4Tags(uic4tagEntry.getValueOffset());
                }
                if (uic1tagEntry != null) {
                    this.parseUIC1Tags(uic1tagEntry.getValueOffset(), uic1tagEntry.getValueCount());
                }
            }
            this.in.seek(uic4tagEntry.getValueOffset());
        }
        catch (NullPointerException exc) {
            LOGGER.debug("", exc);
        }
        catch (IOException exc) {
            LOGGER.debug("Failed to parse proprietary tags", exc);
        }
        try {
            PhotoInterp check;
            TiffRational[] tiffRationalArray;
            IFD firstIFD = (IFD)this.ifds.get(0);
            long[] uic2 = firstIFD.getIFDLongArray(33629);
            if (uic2 == null) {
                throw new FormatException("Invalid Metamorph file. Tag 33629 not found.");
            }
            this.core[0].imageCount = uic2.length;
            Object entry = firstIFD.getIFDValue(33630);
            if (entry instanceof TiffRational[]) {
                tiffRationalArray = (TiffRational[])entry;
            } else {
                TiffRational[] tiffRationalArray2 = new TiffRational[1];
                tiffRationalArray = tiffRationalArray2;
                tiffRationalArray2[0] = (TiffRational)entry;
            }
            TiffRational[] uic3 = tiffRationalArray;
            this.wave = new double[uic3.length];
            Vector<Double> uniqueWavelengths = new Vector<Double>();
            for (int i = 0; i < uic3.length; ++i) {
                this.wave[i] = uic3[i].doubleValue();
                this.addSeriesMeta("Wavelength [" + MetamorphReader.intFormatMax(i, this.mmPlanes) + "]", this.wave[i]);
                Double v = new Double(this.wave[i]);
                if (uniqueWavelengths.contains(v)) continue;
                uniqueWavelengths.add(v);
            }
            if (this.getSizeC() == 1) {
                this.core[0].sizeC = uniqueWavelengths.size();
            }
            IFDList tempIFDs = new IFDList();
            long[] oldOffsets = firstIFD.getStripOffsets();
            long[] stripByteCounts = firstIFD.getStripByteCounts();
            int rowsPerStrip = (int)firstIFD.getRowsPerStrip()[0];
            int stripsPerImage = this.getSizeY() / rowsPerStrip;
            if (stripsPerImage * rowsPerStrip != this.getSizeY()) {
                ++stripsPerImage;
            }
            if ((check = firstIFD.getPhotometricInterpretation()) == PhotoInterp.RGB_PALETTE) {
                firstIFD.putIFDValue(262, PhotoInterp.BLACK_IS_ZERO);
            }
            this.emWavelength = firstIFD.getIFDLongArray(33630);
            for (int i = 0; i < this.getImageCount(); ++i) {
                IFD temp = new IFD(firstIFD);
                long[] newOffsets = new long[stripsPerImage];
                if (stripsPerImage * (i + 1) <= oldOffsets.length) {
                    System.arraycopy(oldOffsets, stripsPerImage * i, newOffsets, 0, stripsPerImage);
                } else {
                    System.arraycopy(oldOffsets, 0, newOffsets, 0, stripsPerImage);
                    long image = stripByteCounts[0] / (long)rowsPerStrip * (long)this.getSizeY();
                    int q = 0;
                    while (q < stripsPerImage) {
                        int n = q++;
                        newOffsets[n] = newOffsets[n] + (long)i * image;
                    }
                }
                temp.putIFDValue(273, newOffsets);
                long[] newByteCounts = new long[stripsPerImage];
                if (stripsPerImage * i < stripByteCounts.length) {
                    System.arraycopy(stripByteCounts, stripsPerImage * i, newByteCounts, 0, stripsPerImage);
                } else {
                    Arrays.fill(newByteCounts, stripByteCounts[0]);
                }
                temp.putIFDValue(279, newByteCounts);
                tempIFDs.add(temp);
            }
            this.ifds = tempIFDs;
        }
        catch (IllegalArgumentException exc) {
            LOGGER.debug("Unknown tag", exc);
        }
        catch (NullPointerException exc) {
            LOGGER.debug("", exc);
        }
        catch (FormatException exc) {
            LOGGER.debug("Failed to build list of IFDs", exc);
        }
        String descr = ((IFD)this.ifds.get(0)).getComment();
        if (descr != null) {
            String[] lines = descr.split("\n");
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i].trim();
                int colon = line.indexOf(": ");
                String descrValue = null;
                if (colon < 0) {
                    if (line.length() <= 0) continue;
                    descrValue = line;
                    continue;
                }
                if (i == 0) {
                    int dot = line.lastIndexOf(".", colon);
                    if (dot >= 0) {
                        descrValue = line.substring(0, dot + 1);
                    }
                    line = line.substring(dot + 1);
                    colon -= dot + 1;
                }
                if (descrValue != null) {
                    sb.append(descrValue);
                    if (!descrValue.endsWith(".")) {
                        sb.append(".");
                    }
                    sb.append("  ");
                }
                String key = line.substring(0, colon);
                String value = line.substring(colon + 2);
                this.addSeriesMeta(key, value);
                if (key.equals("Exposure")) {
                    if (value.indexOf("=") != -1) {
                        value = value.substring(value.indexOf("=") + 1).trim();
                    }
                    if (value.indexOf(" ") != -1) {
                        value = value.substring(0, value.indexOf(" "));
                    }
                    try {
                        char separator = new DecimalFormatSymbols().getDecimalSeparator();
                        value = value.replace('.', separator);
                        value = value.replace(',', separator);
                        double exposure = Double.parseDouble(value);
                        this.exposureTime = new Double(exposure / 1000.0);
                    }
                    catch (NumberFormatException e) {}
                    continue;
                }
                if (!key.equals("Bit Depth")) continue;
                if (value.indexOf("-") != -1) {
                    value = value.substring(0, value.indexOf("-"));
                }
                try {
                    this.core[0].bitsPerPixel = Integer.parseInt(value);
                    continue;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            descr = sb.toString().trim();
            if (descr.equals("")) {
                this.metadata.remove("Comment");
            } else {
                this.addSeriesMeta("Comment", descr);
            }
        }
        this.core[0].sizeT = this.getImageCount() / (this.getSizeZ() * (this.getSizeC() / rgbChannels));
        if (this.getSizeT() * this.getSizeZ() * (this.getSizeC() / rgbChannels) != this.getImageCount()) {
            this.core[0].sizeT = 1;
            this.core[0].sizeZ = this.getImageCount() / (this.getSizeC() / rgbChannels);
        }
        if ((filename = this.currentId.substring(this.currentId.lastIndexOf(File.separator) + 1)).indexOf("_t") != -1 && this.getSizeT() > 1) {
            int z = this.getSizeZ();
            this.core[0].sizeZ = this.getSizeT();
            this.core[0].sizeT = z;
        }
        if (this.getSizeZ() == 0) {
            this.core[0].sizeZ = 1;
        }
        if (this.getSizeT() == 0) {
            this.core[0].sizeT = 1;
        }
        if (this.getSizeZ() * this.getSizeT() * (this.isRGB() ? 1 : this.getSizeC()) != this.getImageCount()) {
            this.core[0].sizeZ = this.getImageCount();
            this.core[0].sizeT = 1;
            if (!this.isRGB()) {
                this.core[0].sizeC = 1;
            }
        }
    }

    private String getRealSTKFile(Location l) {
        if (l.exists()) {
            return l.getAbsolutePath();
        }
        String name = l.getName();
        String parent = l.getParent();
        if (name.indexOf("_") > 0) {
            Location p;
            String prefix = name.substring(0, name.indexOf("_"));
            String suffix = name.substring(name.indexOf("_"));
            String basePrefix = new Location(this.currentId).getName();
            int end = basePrefix.indexOf("_");
            if (end < 0) {
                end = basePrefix.indexOf(".");
            }
            if (!(basePrefix = basePrefix.substring(0, end)).equals(prefix) && (p = new Location(parent, name = basePrefix + suffix)).exists()) {
                return p.getAbsolutePath();
            }
        }
        if (name.indexOf("%") != -1 && !(l = new Location(parent, name = name.replaceAll("%", "-"))).exists() && !(l = new Location(parent, name = name.substring(0, name.lastIndexOf(".")) + ".TIF")).exists()) {
            l = new Location(parent, name = name.substring(0, name.lastIndexOf(".")) + ".tif");
            return l.exists() ? l.getAbsolutePath() : null;
        }
        if (!(l.exists() || (l = new Location(parent, name = name.substring(0, name.lastIndexOf(".")) + ".TIF")).exists() || (l = new Location(parent, name = name.substring(0, name.lastIndexOf(".")) + ".tif")).exists())) {
            l = new Location(parent, name = name.substring(0, name.lastIndexOf(".")) + ".stk");
            return l.exists() ? l.getAbsolutePath() : null;
        }
        return l.getAbsolutePath();
    }

    private String getFirstComment(int i) throws IOException {
        if (this.stks != null && this.stks[i][0] != null) {
            RandomAccessInputStream stream = new RandomAccessInputStream(this.stks[i][0]);
            TiffParser tp = new TiffParser(stream);
            String comment = tp.getComment();
            stream.close();
            return comment;
        }
        return ((IFD)this.ifds.get(0)).getComment();
    }

    private String makeImageName(int i) {
        String name = "";
        if (this.stageNames != null && this.stageNames.size() > 0) {
            int stagePosition = i / (this.getSeriesCount() / this.stageNames.size());
            name = name + "Stage " + this.stageNames.get(stagePosition) + "; ";
        }
        if (this.firstSeriesChannels != null) {
            for (int c = 0; c < this.firstSeriesChannels.length; ++c) {
                if (this.firstSeriesChannels[c] != (i % 2 == 0) || c >= this.waveNames.size()) continue;
                name = name + this.waveNames.get(c) + "/";
            }
            if (name.length() > 0) {
                name = name.substring(0, name.length() - 1);
            }
        }
        return name;
    }

    void parseUIC2Tags(long uic2offset) throws IOException {
        long saveLoc = this.in.getFilePointer();
        this.in.seek(uic2offset);
        this.zDistances = new double[this.mmPlanes];
        this.internalStamps = new long[this.mmPlanes];
        for (int i = 0; i < this.mmPlanes; ++i) {
            String iAsString = MetamorphReader.intFormatMax(i, this.mmPlanes);
            if (this.in.getFilePointer() + 8L > this.in.length()) break;
            this.zDistances[i] = this.readRational(this.in).doubleValue();
            this.addSeriesMeta("zDistance[" + iAsString + "]", this.zDistances[i]);
            if (this.zDistances[i] != 0.0) {
                ++this.core[0].sizeZ;
            }
            String cDate = MetamorphReader.decodeDate(this.in.readInt());
            String cTime = MetamorphReader.decodeTime(this.in.readInt());
            this.internalStamps[i] = DateTools.getTime(cDate + " " + cTime, LONG_DATE_FORMAT);
            this.addSeriesMeta("creationDate[" + iAsString + "]", cDate);
            this.addSeriesMeta("creationTime[" + iAsString + "]", cTime);
            this.in.skip(8L);
        }
        if (this.getSizeZ() == 0) {
            this.core[0].sizeZ = 1;
        }
        this.in.seek(saveLoc);
    }

    private void parseUIC4Tags(long uic4offset) throws IOException {
        long saveLoc = this.in.getFilePointer();
        this.in.seek(uic4offset);
        if (this.in.getFilePointer() + 2L >= this.in.length()) {
            return;
        }
        this.tempZ = 0.0;
        this.validZ = false;
        short id = this.in.readShort();
        while (id != 0) {
            switch (id) {
                case 28: {
                    this.readStagePositions();
                    break;
                }
                case 29: {
                    this.readRationals(new String[]{"cameraXChipOffset", "cameraYChipOffset"});
                    break;
                }
                case 37: {
                    this.readStageLabels();
                    break;
                }
                case 40: {
                    this.readRationals(new String[]{"UIC4 absoluteZ"});
                    break;
                }
                case 41: {
                    this.readAbsoluteZValid();
                    break;
                }
                case 46: {
                    this.in.skipBytes(this.mmPlanes * 8);
                    break;
                }
                default: {
                    this.in.skipBytes(4);
                }
            }
            id = this.in.readShort();
        }
        this.in.seek(saveLoc);
        if (this.validZ) {
            this.zStart = this.tempZ;
        }
    }

    private void readStagePositions() throws IOException {
        this.stageX = new double[this.mmPlanes];
        this.stageY = new double[this.mmPlanes];
        for (int i = 0; i < this.mmPlanes; ++i) {
            String pos = MetamorphReader.intFormatMax(i, this.mmPlanes);
            this.stageX[i] = this.readRational(this.in).doubleValue();
            this.stageY[i] = this.readRational(this.in).doubleValue();
            this.addSeriesMeta("stageX[" + pos + "]", this.stageX[i]);
            this.addSeriesMeta("stageY[" + pos + "]", this.stageY[i]);
            this.addGlobalMeta("X position for position #" + (this.getSeries() + 1), this.stageX[i]);
            this.addGlobalMeta("Y position for position #" + (this.getSeries() + 1), this.stageY[i]);
        }
    }

    private void readRationals(String[] labels) throws IOException {
        for (int i = 0; i < this.mmPlanes; ++i) {
            String pos = MetamorphReader.intFormatMax(i, this.mmPlanes);
            for (int q = 0; q < labels.length; ++q) {
                double v = this.readRational(this.in).doubleValue();
                if (labels[q].endsWith("absoluteZ") && i == 0) {
                    this.tempZ = v;
                }
                this.addSeriesMeta(labels[q] + "[" + pos + "]", v);
            }
        }
    }

    void readStageLabels() throws IOException {
        for (int i = 0; i < this.mmPlanes; ++i) {
            String iAsString = MetamorphReader.intFormatMax(i, this.mmPlanes);
            int strlen = this.in.readInt();
            this.addSeriesMeta("stageLabel[" + iAsString + "]", this.in.readString(strlen));
        }
    }

    void readAbsoluteZValid() throws IOException {
        for (int i = 0; i < this.mmPlanes; ++i) {
            int valid = this.in.readInt();
            this.addSeriesMeta("absoluteZValid[" + MetamorphReader.intFormatMax(i, this.mmPlanes) + "]", valid);
            if (i != 0) continue;
            this.validZ = valid == 1;
        }
    }

    private void parseUIC1Tags(long uic1offset, int uic1count) throws IOException {
        long saveLoc = this.in.getFilePointer();
        this.in.seek(uic1offset);
        this.tempZ = 0.0;
        this.validZ = false;
        for (int i = 0; i < uic1count && this.in.getFilePointer() < this.in.length(); ++i) {
            int currentID = this.in.readInt();
            long valOrOffset = (long)this.in.readInt() & 0xFFFFFFFFL;
            long lastOffset = this.in.getFilePointer();
            String key = this.getKey(currentID);
            Object value = String.valueOf(valOrOffset);
            block0 : switch (currentID) {
                case 3: {
                    value = valOrOffset != 0L ? "on" : "off";
                    break;
                }
                case 4: 
                case 5: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 38: 
                case 39: {
                    value = this.readRational(this.in, valOrOffset);
                    break;
                }
                case 6: 
                case 25: {
                    this.in.seek(valOrOffset);
                    int num = this.in.readInt();
                    if ((long)num + this.in.getFilePointer() >= this.in.length()) {
                        num = (int)(this.in.length() - this.in.getFilePointer() - 1L);
                    }
                    value = this.in.readString(num);
                    break;
                }
                case 7: {
                    this.in.seek(valOrOffset);
                    int num = this.in.readInt();
                    this.imageName = this.in.readString(num);
                    value = this.imageName;
                    break;
                }
                case 8: {
                    if (valOrOffset == 1L) {
                        value = "inside";
                        break;
                    }
                    if (valOrOffset == 2L) {
                        value = "outside";
                        break;
                    }
                    value = "off";
                    break;
                }
                case 17: {
                    this.in.seek(valOrOffset);
                    String thedate = MetamorphReader.decodeDate(this.in.readInt());
                    String thetime = MetamorphReader.decodeTime(this.in.readInt());
                    this.imageCreationDate = thedate + " " + thetime;
                    value = this.imageCreationDate;
                    break;
                }
                case 16: {
                    this.in.seek(valOrOffset);
                    String thedate = MetamorphReader.decodeDate(this.in.readInt());
                    String thetime = MetamorphReader.decodeTime(this.in.readInt());
                    value = thedate + " " + thetime;
                    break;
                }
                case 26: {
                    this.in.seek(valOrOffset);
                    int standardLUT = this.in.readInt();
                    switch (standardLUT) {
                        case 0: {
                            value = "monochrome";
                            break block0;
                        }
                        case 1: {
                            value = "pseudocolor";
                            break block0;
                        }
                        case 2: {
                            value = "Red";
                            break block0;
                        }
                        case 3: {
                            value = "Green";
                            break block0;
                        }
                        case 4: {
                            value = "Blue";
                            break block0;
                        }
                        case 5: {
                            value = "user-defined";
                            break block0;
                        }
                    }
                    value = "monochrome";
                    break;
                }
                case 34: {
                    value = String.valueOf(this.in.readInt());
                    break;
                }
                case 46: {
                    this.in.seek(valOrOffset);
                    int xBin = this.in.readInt();
                    int yBin = this.in.readInt();
                    this.binning = xBin + "x" + yBin;
                    value = this.binning;
                    break;
                }
                case 40: {
                    if (valOrOffset == 0L) break;
                    this.in.seek(valOrOffset);
                    this.readRationals(new String[]{"UIC1 absoluteZ"});
                    break;
                }
                case 41: {
                    if (valOrOffset == 0L) break;
                    this.in.seek(valOrOffset);
                    this.readAbsoluteZValid();
                    break;
                }
                case 49: {
                    this.in.seek(valOrOffset);
                    this.readPlaneData();
                }
            }
            this.addSeriesMeta(key, value);
            this.in.seek(lastOffset);
            if ("Zoom".equals(key) && value != null) {
                this.zoom = Double.parseDouble(value.toString());
            }
            if ("XCalibration".equals(key) && value != null) {
                this.sizeX = value instanceof TiffRational ? Double.valueOf(((TiffRational)value).doubleValue()) : new Double(value.toString());
            }
            if (!"YCalibration".equals(key) || value == null) continue;
            this.sizeY = value instanceof TiffRational ? Double.valueOf(((TiffRational)value).doubleValue()) : new Double(value.toString());
        }
        this.in.seek(saveLoc);
        if (this.validZ) {
            this.zStart = this.tempZ;
        }
    }

    public static String decodeDate(int julian) {
        long a;
        long z = julian + 1;
        if (z < 2299161L) {
            a = z;
        } else {
            long alpha = (long)(((double)z - 1867216.25) / 36524.25);
            a = z + 1L + alpha - alpha / 4L;
        }
        long b = a > 1721423L ? a + 1524L : a + 1158L;
        long c = (long)(((double)b - 122.1) / 365.25);
        long d = (long)(365.25 * (double)c);
        long e = (long)((double)(b - d) / 30.6001);
        short day = (short)(b - d - (long)(30.6001 * (double)e));
        short month = (short)((double)e < 13.5 ? e - 1L : e - 13L);
        short year = (short)((double)month > 2.5 ? c - 4716L : c - 4715L);
        return MetamorphReader.intFormat(day, 2) + "/" + MetamorphReader.intFormat(month, 2) + "/" + year;
    }

    public static String decodeTime(int millis) {
        Calendar time = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        time.setTimeInMillis(millis);
        String hours = MetamorphReader.intFormat(time.get(11), 2);
        String minutes = MetamorphReader.intFormat(time.get(12), 2);
        String seconds = MetamorphReader.intFormat(time.get(13), 2);
        String ms = MetamorphReader.intFormat(time.get(14), 3);
        return hours + ":" + minutes + ":" + seconds + ":" + ms;
    }

    public static String intFormat(int myint, int digits) {
        return String.format("%0" + digits + "d", myint);
    }

    public static String intFormatMax(int myint, int maxint) {
        return MetamorphReader.intFormat(myint, String.valueOf(maxint).length());
    }

    private TiffRational readRational(RandomAccessInputStream s) throws IOException {
        return this.readRational(s, s.getFilePointer());
    }

    private TiffRational readRational(RandomAccessInputStream s, long offset) throws IOException {
        s.seek(offset);
        int num = s.readInt();
        int denom = s.readInt();
        return new TiffRational(num, denom);
    }

    private void setCanLookForND(boolean v) {
        FormatTools.assertId(this.currentId, false, 1);
        this.canLookForND = v;
    }

    private void readPlaneData() throws IOException {
        this.in.skipBytes(4);
        int keyLength = this.in.read();
        String key = this.in.readString(keyLength);
        this.in.skipBytes(4);
        int type = this.in.read();
        int index = 0;
        switch (type) {
            case 1: {
                this.in.skipBytes(1);
                while (this.getGlobalMeta("Channel #" + index + " " + key) != null) {
                    ++index;
                }
                this.addGlobalMeta("Channel #" + index + " " + key, this.in.readDouble());
                break;
            }
            case 2: {
                int valueLength = this.in.read();
                String value = this.in.readString(valueLength);
                if (valueLength == 0) {
                    this.in.skipBytes(4);
                    valueLength = this.in.read();
                    value = this.in.readString(valueLength);
                }
                while (this.getGlobalMeta("Channel #" + index + " " + key) != null) {
                    ++index;
                }
                this.addGlobalMeta("Channel #" + index + " " + key, value);
                if (!key.equals("_IllumSetting_")) break;
                if (this.waveNames == null) {
                    this.waveNames = new Vector();
                }
                this.waveNames.add(value);
            }
        }
    }

    private String getKey(int id) {
        switch (id) {
            case 0: {
                return "AutoScale";
            }
            case 1: {
                return "MinScale";
            }
            case 2: {
                return "MaxScale";
            }
            case 3: {
                return "Spatial Calibration";
            }
            case 4: {
                return "XCalibration";
            }
            case 5: {
                return "YCalibration";
            }
            case 6: {
                return "CalibrationUnits";
            }
            case 7: {
                return "Name";
            }
            case 8: {
                return "ThreshState";
            }
            case 9: {
                return "ThreshStateRed";
            }
            case 11: {
                return "ThreshStateGreen";
            }
            case 12: {
                return "ThreshStateBlue";
            }
            case 13: {
                return "ThreshStateLo";
            }
            case 14: {
                return "ThreshStateHi";
            }
            case 15: {
                return "Zoom";
            }
            case 16: {
                return "DateTime";
            }
            case 17: {
                return "LastSavedTime";
            }
            case 18: {
                return "currentBuffer";
            }
            case 19: {
                return "grayFit";
            }
            case 20: {
                return "grayPointCount";
            }
            case 21: {
                return "grayX";
            }
            case 22: {
                return "grayY";
            }
            case 23: {
                return "grayMin";
            }
            case 24: {
                return "grayMax";
            }
            case 25: {
                return "grayUnitName";
            }
            case 26: {
                return "StandardLUT";
            }
            case 27: {
                return "Wavelength";
            }
            case 28: {
                return "StagePosition";
            }
            case 29: {
                return "CameraChipOffset";
            }
            case 30: {
                return "OverlayMask";
            }
            case 31: {
                return "OverlayCompress";
            }
            case 32: {
                return "Overlay";
            }
            case 33: {
                return "SpecialOverlayMask";
            }
            case 34: {
                return "SpecialOverlayCompress";
            }
            case 35: {
                return "SpecialOverlay";
            }
            case 36: {
                return "ImageProperty";
            }
            case 38: {
                return "AutoScaleLoInfo";
            }
            case 39: {
                return "AutoScaleHiInfo";
            }
            case 40: {
                return "AbsoluteZ";
            }
            case 41: {
                return "AbsoluteZValid";
            }
            case 42: {
                return "Gamma";
            }
            case 43: {
                return "GammaRed";
            }
            case 44: {
                return "GammaGreen";
            }
            case 45: {
                return "GammaBlue";
            }
            case 46: {
                return "CameraBin";
            }
            case 47: {
                return "NewLUT";
            }
            case 48: {
                return "ImagePropertyEx";
            }
            case 49: {
                return "PlaneProperty";
            }
            case 50: {
                return "UserLutTable";
            }
            case 51: {
                return "RedAutoScaleInfo";
            }
            case 52: {
                return "RedAutoScaleLoInfo";
            }
            case 53: {
                return "RedAutoScaleHiInfo";
            }
            case 54: {
                return "RedMinScaleInfo";
            }
            case 55: {
                return "RedMaxScaleInfo";
            }
            case 56: {
                return "GreenAutoScaleInfo";
            }
            case 57: {
                return "GreenAutoScaleLoInfo";
            }
            case 58: {
                return "GreenAutoScaleHiInfo";
            }
            case 59: {
                return "GreenMinScaleInfo";
            }
            case 60: {
                return "GreenMaxScaleInfo";
            }
            case 61: {
                return "BlueAutoScaleInfo";
            }
            case 62: {
                return "BlueAutoScaleLoInfo";
            }
            case 63: {
                return "BlueAutoScaleHiInfo";
            }
            case 64: {
                return "BlueMinScaleInfo";
            }
            case 65: {
                return "BlueMaxScaleInfo";
            }
            case 66: {
                return "OverlayPlaneColor";
            }
        }
        return null;
    }
}

