/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.BinaryFile;
import ome.xml.model.Channel;
import ome.xml.model.FilterSet;
import ome.xml.model.FilterSetRef;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.ObjectiveSettings;
import ome.xml.model.Reference;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.PixelType;
import ome.xml.model.primitives.PositiveInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OTF
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2011-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(OTF.class);
    private PositiveInteger sizeX;
    private PositiveInteger sizeY;
    private PixelType type;
    private String id;
    private Boolean opticalAxisAveraged;
    private ObjectiveSettings objectiveSettings;
    private FilterSet filterSet;
    private BinaryFile binaryFile;
    private List<Channel> channel_BackReferenceList = new ArrayList<Channel>();

    public OTF() {
    }

    public OTF(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        List<Element> ObjectiveSettings_nodeList;
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"OTF".equals(tagName)) {
            LOGGER.debug("Expecting node name of OTF got {}", (Object)tagName);
        }
        if (element.hasAttribute("SizeX")) {
            this.setSizeX(PositiveInteger.valueOf(element.getAttribute("SizeX")));
        }
        if (element.hasAttribute("SizeY")) {
            this.setSizeY(PositiveInteger.valueOf(element.getAttribute("SizeY")));
        }
        if (element.hasAttribute("Type")) {
            this.setType(PixelType.fromString(element.getAttribute("Type")));
        }
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException(String.format("OTF missing required ID property.", new Object[0]));
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
        if (element.hasAttribute("OpticalAxisAveraged")) {
            this.setOpticalAxisAveraged(Boolean.valueOf(element.getAttribute("OpticalAxisAveraged")));
        }
        if ((ObjectiveSettings_nodeList = OTF.getChildrenByTagName(element, "ObjectiveSettings")).size() > 1) {
            throw new RuntimeException(String.format("ObjectiveSettings node list size %d != 1", ObjectiveSettings_nodeList.size()));
        }
        if (ObjectiveSettings_nodeList.size() != 0) {
            this.setObjectiveSettings(new ObjectiveSettings(ObjectiveSettings_nodeList.get(0), model));
        }
        List<Element> FilterSetRef_nodeList = OTF.getChildrenByTagName(element, "FilterSetRef");
        for (Element FilterSetRef_element : FilterSetRef_nodeList) {
            FilterSetRef filterSet_reference = new FilterSetRef();
            filterSet_reference.setID(FilterSetRef_element.getAttribute("ID"));
            model.addReference(this, filterSet_reference);
        }
        List<Element> BinaryFile_nodeList = OTF.getChildrenByTagName(element, "BinaryFile");
        if (BinaryFile_nodeList.size() > 1) {
            throw new RuntimeException(String.format("BinaryFile node list size %d != 1", BinaryFile_nodeList.size()));
        }
        if (BinaryFile_nodeList.size() != 0) {
            this.setBinaryFile(new BinaryFile(BinaryFile_nodeList.get(0), model));
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        if (reference instanceof FilterSetRef) {
            FilterSet o_casted = (FilterSet)o;
            o_casted.linkOTF(this);
            this.filterSet = o_casted;
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public PositiveInteger getSizeX() {
        return this.sizeX;
    }

    public void setSizeX(PositiveInteger sizeX) {
        this.sizeX = sizeX;
    }

    public PositiveInteger getSizeY() {
        return this.sizeY;
    }

    public void setSizeY(PositiveInteger sizeY) {
        this.sizeY = sizeY;
    }

    public PixelType getType() {
        return this.type;
    }

    public void setType(PixelType type) {
        this.type = type;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public Boolean getOpticalAxisAveraged() {
        return this.opticalAxisAveraged;
    }

    public void setOpticalAxisAveraged(Boolean opticalAxisAveraged) {
        this.opticalAxisAveraged = opticalAxisAveraged;
    }

    public ObjectiveSettings getObjectiveSettings() {
        return this.objectiveSettings;
    }

    public void setObjectiveSettings(ObjectiveSettings objectiveSettings) {
        this.objectiveSettings = objectiveSettings;
    }

    public FilterSet getLinkedFilterSet() {
        return this.filterSet;
    }

    public void linkFilterSet(FilterSet o) {
        this.filterSet = o;
    }

    public void unlinkFilterSet(FilterSet o) {
        if (this.filterSet == o) {
            this.filterSet = null;
        }
    }

    public BinaryFile getBinaryFile() {
        return this.binaryFile;
    }

    public void setBinaryFile(BinaryFile binaryFile) {
        this.binaryFile = binaryFile;
    }

    public int sizeOfLinkedChannelList() {
        return this.channel_BackReferenceList.size();
    }

    public List<Channel> copyLinkedChannelList() {
        return new ArrayList<Channel>(this.channel_BackReferenceList);
    }

    public Channel getLinkedChannel(int index) {
        return this.channel_BackReferenceList.get(index);
    }

    public Channel setLinkedChannel(int index, Channel o) {
        return this.channel_BackReferenceList.set(index, o);
    }

    public boolean linkChannel(Channel o) {
        return this.channel_BackReferenceList.add(o);
    }

    public boolean unlinkChannel(Channel o) {
        return this.channel_BackReferenceList.remove(o);
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    protected Element asXMLElement(Document document, Element OTF_element) {
        if (OTF_element == null) {
            OTF_element = document.createElementNS(NAMESPACE, "OTF");
        }
        if (this.sizeX != null) {
            OTF_element.setAttribute("SizeX", this.sizeX.toString());
        }
        if (this.sizeY != null) {
            OTF_element.setAttribute("SizeY", this.sizeY.toString());
        }
        if (this.type != null) {
            OTF_element.setAttribute("Type", this.type.toString());
        }
        if (this.id != null) {
            OTF_element.setAttribute("ID", this.id.toString());
        }
        if (this.opticalAxisAveraged != null) {
            OTF_element.setAttribute("OpticalAxisAveraged", this.opticalAxisAveraged.toString());
        }
        if (this.objectiveSettings != null) {
            OTF_element.appendChild(this.objectiveSettings.asXMLElement(document));
        }
        if (this.filterSet != null) {
            FilterSetRef o = new FilterSetRef();
            o.setID(this.filterSet.getID());
            OTF_element.appendChild(o.asXMLElement(document));
        }
        if (this.binaryFile != null) {
            OTF_element.appendChild(this.binaryFile.asXMLElement(document));
        }
        if (this.channel_BackReferenceList != null) {
            // empty if block
        }
        return super.asXMLElement(document, OTF_element);
    }
}

