/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataStore;

public class FitsReader
extends FormatReader {
    private static final int LINE_LENGTH = 80;
    private long pixelOffset;

    public FitsReader() {
        super("Flexible Image Transport System", new String[]{"fits", "fts"});
        this.domains = new String[]{"Astronomy", "Unknown"};
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.in.seek(this.pixelOffset);
        this.readPlane(this.in, x, y, w, h, buf);
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.pixelOffset = 0L;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        String line = this.in.readString(80);
        if (!line.startsWith("SIMPLE")) {
            throw new FormatException("Unsupported FITS file.");
        }
        String key = "";
        String value = "";
        while (true) {
            int ndx;
            int comment;
            if ((comment = (line = this.in.readString(80)).indexOf("/", ndx = line.indexOf("="))) < 0) {
                comment = line.length();
            }
            if (ndx >= 0) {
                key = line.substring(0, ndx).trim();
                value = line.substring(ndx + 1, comment).trim();
            } else {
                key = line.trim();
            }
            if (key.equals("END") && this.getSizeX() > 0) break;
            if (key.equals("BITPIX")) {
                int bits = Integer.parseInt(value);
                boolean fp = bits < 0;
                boolean signed = bits != 8;
                bits = Math.abs(bits) / 8;
                this.core[0].pixelType = FormatTools.pixelTypeFromBytes(bits, signed, fp);
            } else if (key.equals("NAXIS1")) {
                this.core[0].sizeX = Integer.parseInt(value);
            } else if (key.equals("NAXIS2")) {
                this.core[0].sizeY = Integer.parseInt(value);
            } else if (key.equals("NAXIS3")) {
                this.core[0].sizeZ = Integer.parseInt(value);
            }
            this.addGlobalMeta(key, value);
        }
        while (this.in.read() == 32) {
        }
        this.pixelOffset = this.in.getFilePointer() - 1L;
        this.core[0].sizeC = 1;
        this.core[0].sizeT = 1;
        if (this.getSizeZ() == 0) {
            this.core[0].sizeZ = 1;
        }
        this.core[0].imageCount = this.core[0].sizeZ;
        this.core[0].rgb = false;
        this.core[0].littleEndian = false;
        this.core[0].interleaved = false;
        this.core[0].dimensionOrder = "XYZCT";
        this.core[0].indexed = false;
        this.core[0].falseColor = false;
        this.core[0].metadataComplete = true;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        MetadataTools.setDefaultCreationDate(store, id, 0);
    }
}

