/*
 * Decompiled with CFR 0.152.
 */
package bioformatsconverter;

import java.awt.image.ColorModel;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.StringTokenizer;
import loci.common.services.ServiceFactory;
import loci.formats.ChannelSeparator;
import loci.formats.ClassList;
import loci.formats.FormatException;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.in.DefaultMetadataOptions;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.out.APNGWriter;
import loci.formats.out.OMETiffWriter;
import loci.formats.services.OMEXMLService;
import ome.xml.model.enums.PixelType;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.PositiveInteger;

public class Main {
    private static boolean imageopen = false;
    private static String filename = "";
    private static boolean collectmeta = true;
    private static boolean collectmetaorig = false;
    private static boolean filtermeta = false;
    private static int savemode = 0;
    private static int stackmode = 0;

    public static void progress(int i, int size) {
        float prog = (float)(i + 1) / (float)size * 100.0f;
        prog = Main.Round(prog, 2);
        System.out.print("\r\r      Progress = " + prog + " %");
        if ((double)prog == 100.0) {
            System.out.println("\n");
        }
    }

    public static float Round(float Rval, int Rpl) {
        float p = (float)Math.pow(10.0, Rpl);
        float tmp = Math.round(Rval *= p);
        return tmp / p;
    }

    public static void saveImageToOMETIFF(String in_fn, String out_dn) throws Exception {
        if (in_fn.length() == 0) {
            System.out.println("\nERROR: Input filename is NULL!\n");
            return;
        }
        if (out_dn.length() == 0) {
            System.out.println("\nERROR: Output dirname is NULL!\n");
            return;
        }
        ServiceFactory factory = new ServiceFactory();
        OMEXMLService service = factory.getInstance(OMEXMLService.class);
        OMEXMLMetadata meta = service.createOMEXMLMetadata();
        ClassList<IFormatReader> defaultClasses = new ClassList<IFormatReader>("readers.txt", IFormatReader.class);
        IFormatReader myimagereader = new ImageReader(defaultClasses);
        myimagereader.setMetadataOptions(new DefaultMetadataOptions(MetadataLevel.ALL));
        myimagereader.setOriginalMetadataPopulated(collectmetaorig);
        myimagereader.setMetadataFiltered(filtermeta);
        myimagereader.setMetadataStore(meta);
        myimagereader = new ChannelSeparator(myimagereader);
        myimagereader.setId(in_fn);
        MetadataStore metarestore = myimagereader.getMetadataStore();
        MetadataRetrieve metaretrieve = (MetadataRetrieve)((Object)metarestore);
        int index = in_fn.lastIndexOf("/");
        String infilname = index != -1 ? in_fn.substring(index + 1, in_fn.length()) : in_fn;
        infilname = infilname.replace('.', '_');
        System.out.println("Number of Images in Current File: " + myimagereader.getSeriesCount() + "\n");
        int series = myimagereader.getSeriesCount();
        for (int s = 0; s < series; ++s) {
            int i = 0;
            myimagereader.setSeries(s);
            metarestore = myimagereader.getMetadataStore();
            metaretrieve = (MetadataRetrieve)((Object)metarestore);
            int sdigits = Integer.toString(s).length();
            String snumb = Integer.toString(s);
            if (sdigits == 1) {
                snumb = "S00" + snumb;
            } else if (sdigits == 2) {
                snumb = "S0" + snumb;
            }
            int numbimgs = myimagereader.getImageCount();
            int xres = (Integer)metaretrieve.getPixelsSizeX(0).getValue();
            int yres = (Integer)metaretrieve.getPixelsSizeY(0).getValue();
            int zres = (Integer)metaretrieve.getPixelsSizeZ(0).getValue();
            int cres = (Integer)metaretrieve.getPixelsSizeC(0).getValue();
            int tres = (Integer)metaretrieve.getPixelsSizeT(0).getValue();
            PositiveFloat xsize = metaretrieve.getPixelsPhysicalSizeX(0);
            PositiveFloat ysize = metaretrieve.getPixelsPhysicalSizeY(0);
            PositiveFloat zsize = metaretrieve.getPixelsPhysicalSizeZ(0);
            String dimorder = myimagereader.getDimensionOrder();
            System.out.println("    Series: Image " + (s + 1) + " of " + series);
            System.out.println("    =============================================");
            System.out.println("    Image INFO:");
            System.out.println("    (" + xres + "," + yres + "," + zres + ") (" + cres + "," + tres + ")");
            System.out.println("    Number of images to save: " + numbimgs);
            System.out.println("    Dimensions Order: " + dimorder);
            System.out.println("    (voxel size) X: " + xsize + " Y: " + ysize + " Z: " + zsize);
            System.out.println("    TimeStart: (sec) " + metaretrieve.getImageAcquiredDate(s));
            System.out.println("    TimeStep: (sec) " + metaretrieve.getPixelsTimeIncrement(s));
            System.out.println("    =============================================");
            System.out.println("    Saving to OME-TIFF...");
            for (int t = 0; t < tres; ++t) {
                System.out.println("Timepoint: " + t + " of " + tres);
                int tdigits = Integer.toString(t).length();
                String tnumb = Integer.toString(t);
                if (tdigits == 1) {
                    tnumb = "00" + tnumb;
                } else if (tdigits == 2) {
                    tnumb = "0" + tnumb;
                }
                String timeoutdirname = out_dn + snumb + "_T" + tnumb + "/";
                new File(timeoutdirname).mkdir();
                for (int z = 0; z < zres; ++z) {
                    int zdigits = Integer.toString(z).length();
                    String znumb = Integer.toString(z);
                    if (zdigits == 1) {
                        znumb = "00" + znumb;
                    } else if (zdigits == 2) {
                        znumb = "0" + znumb;
                    }
                    Main.progress(i, numbimgs);
                    for (int c = 0; c < cres; ++c) {
                        int cdigits = Integer.toString(c).length();
                        String cnumb = Integer.toString(c);
                        if (cdigits == 1) {
                            cnumb = "00" + cnumb;
                        } else if (cdigits == 2) {
                            cnumb = "0" + cnumb;
                        }
                        String channeloutdirname = timeoutdirname + "C" + cnumb + "/";
                        new File(channeloutdirname).mkdir();
                        String savefilename = channeloutdirname + infilname + "_T" + tnumb + "_Z" + znumb + "_C" + cnumb + ".tif";
                        byte[] imagebytes = myimagereader.openBytes(myimagereader.getIndex(z, c, t));
                        if (z == 0) {
                            FileWriter fstream = new FileWriter(channeloutdirname + "voxelscale.txt");
                            BufferedWriter out = new BufferedWriter(fstream);
                            out.write("x " + xsize);
                            out.newLine();
                            out.write("y " + ysize);
                            out.newLine();
                            out.write("z " + zsize);
                            out.newLine();
                            out.close();
                            fstream = new FileWriter(channeloutdirname + "voxelspacing.txt");
                            out = new BufferedWriter(fstream);
                            out.write("x " + xsize);
                            out.newLine();
                            out.write("y " + ysize);
                            out.newLine();
                            out.write("z " + zsize);
                            out.newLine();
                            out.close();
                        }
                        metarestore.setPixelsSizeX(new PositiveInteger(xres), 0);
                        metarestore.setPixelsSizeY(new PositiveInteger(yres), 0);
                        metarestore.setPixelsSizeZ(new PositiveInteger(1), 0);
                        metarestore.setPixelsSizeC(new PositiveInteger(1), 0);
                        metarestore.setPixelsSizeT(new PositiveInteger(1), 0);
                        metarestore.setPixelsPhysicalSizeX(xsize, 0);
                        metarestore.setPixelsPhysicalSizeY(ysize, 0);
                        metarestore.setPixelsPhysicalSizeZ(zsize, 0);
                        OMETiffWriter ometiffwriter = new OMETiffWriter();
                        ometiffwriter.setMetadataRetrieve((MetadataRetrieve)((Object)metarestore));
                        ometiffwriter.setId(savefilename);
                        ometiffwriter.saveBytes(0, imagebytes);
                        ometiffwriter.close();
                        ++i;
                    }
                }
            }
        }
    }

    public static void saveImageToOMETIFF_Zstack(String in_fn, String out_dn) throws Exception {
        if (in_fn.length() == 0) {
            System.out.println("\nERROR: Input filename is NULL!\n");
            return;
        }
        if (out_dn.length() == 0) {
            System.out.println("\nERROR: Output dirname is NULL!\n");
            return;
        }
        ServiceFactory factory = new ServiceFactory();
        OMEXMLService service = factory.getInstance(OMEXMLService.class);
        OMEXMLMetadata meta = service.createOMEXMLMetadata();
        ClassList<IFormatReader> defaultClasses = new ClassList<IFormatReader>("readers.txt", IFormatReader.class);
        System.out.println("Loading file: " + in_fn);
        IFormatReader myimagereader = new ImageReader(defaultClasses);
        myimagereader.setMetadataOptions(new DefaultMetadataOptions(MetadataLevel.ALL));
        myimagereader.setOriginalMetadataPopulated(collectmetaorig);
        myimagereader.setMetadataFiltered(filtermeta);
        myimagereader.setMetadataStore(meta);
        myimagereader = new ChannelSeparator(myimagereader);
        try {
            myimagereader.setId(in_fn);
        }
        catch (FormatException exc) {
            System.out.println(exc.toString());
            exc.printStackTrace();
        }
        catch (IOException exc) {
            System.out.println(exc.toString());
            exc.printStackTrace();
        }
        MetadataStore metarestore = myimagereader.getMetadataStore();
        MetadataRetrieve metaretrieve = (MetadataRetrieve)((Object)metarestore);
        int index = in_fn.lastIndexOf("/");
        String infilname = index != -1 ? in_fn.substring(index + 1, in_fn.length()) : in_fn;
        infilname = infilname.replace('.', '_');
        System.out.println("Number of Images in Current File: " + myimagereader.getSeriesCount() + "\n");
        int series = myimagereader.getSeriesCount();
        for (int s = 0; s < series; ++s) {
            int i = 0;
            myimagereader.setSeries(s);
            metarestore = myimagereader.getMetadataStore();
            metaretrieve = (MetadataRetrieve)((Object)metarestore);
            int sdigits = Integer.toString(s).length();
            String snumb = Integer.toString(s);
            if (sdigits == 1) {
                snumb = "S00" + snumb;
            } else if (sdigits == 2) {
                snumb = "S0" + snumb;
            }
            int numbimgs = myimagereader.getImageCount();
            int xres = (Integer)metaretrieve.getPixelsSizeX(0).getValue();
            int yres = (Integer)metaretrieve.getPixelsSizeY(0).getValue();
            int zres = (Integer)metaretrieve.getPixelsSizeZ(0).getValue();
            int cres = (Integer)metaretrieve.getPixelsSizeC(0).getValue();
            int tres = (Integer)metaretrieve.getPixelsSizeT(0).getValue();
            PositiveFloat xsize = metaretrieve.getPixelsPhysicalSizeX(0);
            PositiveFloat ysize = metaretrieve.getPixelsPhysicalSizeY(0);
            PositiveFloat zsize = metaretrieve.getPixelsPhysicalSizeZ(0);
            String dimorder = myimagereader.getDimensionOrder();
            System.out.println("    Series: Image " + (s + 1) + " of " + series);
            System.out.println("    =============================================");
            System.out.println("    Image INFO:");
            System.out.println("    (" + xres + "," + yres + "," + zres + ") (" + cres + "," + tres + ")");
            System.out.println("    Number of images to save: " + numbimgs);
            System.out.println("    Dimensions Order: " + dimorder);
            System.out.println("    (voxel size) X: " + xsize + " Y: " + ysize + " Z: " + zsize);
            System.out.println("    TimeStart: (sec) " + metaretrieve.getImageAcquiredDate(s));
            System.out.println("    TimeStep: (sec) " + metaretrieve.getPixelsTimeIncrement(s));
            System.out.println("    =============================================");
            System.out.println("    Saving to OME-TIFF...");
            for (int t = 0; t < tres; ++t) {
                System.out.println("Timepoint: " + t + " of " + tres);
                int tdigits = Integer.toString(t).length();
                String tnumb = Integer.toString(t);
                if (tdigits == 1) {
                    tnumb = "T00" + tnumb;
                } else if (tdigits == 2) {
                    tnumb = "T0" + tnumb;
                }
                for (int c = 0; c < cres; ++c) {
                    System.out.println("Channel: " + c + " of " + cres);
                    int cdigits = Integer.toString(c).length();
                    String cnumb = Integer.toString(c);
                    if (cdigits == 1) {
                        cnumb = "C00" + cnumb;
                    } else if (cdigits == 2) {
                        cnumb = "C0" + cnumb;
                    }
                    String savefilename = out_dn + snumb + "_" + tnumb + "_" + cnumb + "_" + infilname + ".tiff";
                    metarestore.setPixelsSizeX(new PositiveInteger(xres), 0);
                    metarestore.setPixelsSizeY(new PositiveInteger(yres), 0);
                    metarestore.setPixelsSizeZ(new PositiveInteger(zres), 0);
                    metarestore.setPixelsSizeC(new PositiveInteger(1), 0);
                    metarestore.setPixelsSizeT(new PositiveInteger(1), 0);
                    metarestore.setPixelsPhysicalSizeX(xsize, 0);
                    metarestore.setPixelsPhysicalSizeY(ysize, 0);
                    metarestore.setPixelsPhysicalSizeZ(zsize, 0);
                    OMETiffWriter ometiffwriter = new OMETiffWriter();
                    ometiffwriter.setMetadataRetrieve((MetadataRetrieve)((Object)metarestore));
                    ometiffwriter.setId(savefilename);
                    for (int z = 0; z < zres; ++z) {
                        Main.progress(i, numbimgs);
                        byte[] imagebytes = myimagereader.openBytes(myimagereader.getIndex(z, c, t));
                        ometiffwriter.saveBytes(0, imagebytes);
                        ++i;
                    }
                    ometiffwriter.close();
                }
            }
        }
    }

    public static void saveImageToOMETIFF_ZCstack(String in_fn, String out_dn) throws Exception {
        if (in_fn.length() == 0) {
            System.out.println("\nERROR: Input filename is NULL!\n");
            return;
        }
        if (out_dn.length() == 0) {
            System.out.println("\nERROR: Output dirname is NULL!\n");
            return;
        }
        ServiceFactory factory = new ServiceFactory();
        OMEXMLService service = factory.getInstance(OMEXMLService.class);
        OMEXMLMetadata meta = service.createOMEXMLMetadata();
        ClassList<IFormatReader> defaultClasses = new ClassList<IFormatReader>("readers.txt", IFormatReader.class);
        IFormatReader myimagereader = new ImageReader(defaultClasses);
        myimagereader.setMetadataOptions(new DefaultMetadataOptions(MetadataLevel.ALL));
        myimagereader.setOriginalMetadataPopulated(collectmetaorig);
        myimagereader.setMetadataFiltered(filtermeta);
        myimagereader.setMetadataStore(meta);
        myimagereader = new ChannelSeparator(myimagereader);
        try {
            myimagereader.setId(in_fn);
        }
        catch (FormatException exc) {
            exc.printStackTrace();
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
        MetadataStore metarestore = myimagereader.getMetadataStore();
        MetadataRetrieve metaretrieve = (MetadataRetrieve)((Object)metarestore);
        System.out.println("Number of Images in Current File: " + myimagereader.getSeriesCount() + "\n");
        int series = myimagereader.getSeriesCount();
        int index = in_fn.lastIndexOf("/");
        String infilname = index != -1 ? in_fn.substring(index + 1, in_fn.length()) : in_fn;
        infilname = infilname.replace('.', '_');
        for (int s = 0; s < series; ++s) {
            int i = 0;
            myimagereader.setSeries(s);
            metarestore = myimagereader.getMetadataStore();
            metaretrieve = (MetadataRetrieve)((Object)metarestore);
            int sdigits = Integer.toString(s).length();
            String snumb = Integer.toString(s);
            if (sdigits == 1) {
                snumb = "S00" + snumb;
            } else if (sdigits == 2) {
                snumb = "S0" + snumb;
            }
            int numbimgs = myimagereader.getImageCount();
            int xres = (Integer)metaretrieve.getPixelsSizeX(0).getValue();
            int yres = (Integer)metaretrieve.getPixelsSizeY(0).getValue();
            int zres = (Integer)metaretrieve.getPixelsSizeZ(0).getValue();
            int cres = (Integer)metaretrieve.getPixelsSizeC(0).getValue();
            int tres = (Integer)metaretrieve.getPixelsSizeT(0).getValue();
            int samples = (Integer)metaretrieve.getChannelSamplesPerPixel(s, 0).getValue();
            PositiveFloat xsize = metaretrieve.getPixelsPhysicalSizeX(0);
            PositiveFloat ysize = metaretrieve.getPixelsPhysicalSizeY(0);
            PositiveFloat zsize = metaretrieve.getPixelsPhysicalSizeZ(0);
            String dimorder = myimagereader.getDimensionOrder();
            System.out.println("    Series: Image " + (s + 1) + " of " + series);
            System.out.println("    =============================================");
            System.out.println("    Image INFO:");
            System.out.println("    (" + xres + "," + yres + "," + zres + ") (" + cres + "," + tres + ")");
            System.out.println("    Samples per Channel: " + samples);
            System.out.println("    Number of images to save: " + numbimgs);
            System.out.println("    Dimensions Order: " + dimorder);
            System.out.println("    (voxel size) X: " + xsize + " Y: " + ysize + " Z: " + zsize);
            System.out.println("    TimeStart: (sec) " + metaretrieve.getImageAcquiredDate(s));
            System.out.println("    TimeStep: (sec) " + metaretrieve.getPixelsTimeIncrement(s));
            System.out.println("    =============================================");
            System.out.println("    Saving to OME-TIFF...");
            for (int t = 0; t < tres; ++t) {
                System.out.println("Timepoint: " + t + " of " + tres);
                int tdigits = Integer.toString(t).length();
                String tnumb = Integer.toString(t);
                if (tdigits == 1) {
                    tnumb = "T00" + tnumb;
                } else if (tdigits == 2) {
                    tnumb = "T0" + tnumb;
                }
                String savefilename = out_dn + snumb + "_" + tnumb + "_" + infilname + ".tiff";
                metarestore.setPixelsSizeX(new PositiveInteger(xres), 0);
                metarestore.setPixelsSizeY(new PositiveInteger(yres), 0);
                metarestore.setPixelsSizeZ(new PositiveInteger(zres), 0);
                metarestore.setPixelsSizeC(new PositiveInteger(cres), 0);
                metarestore.setPixelsSizeT(new PositiveInteger(1), 0);
                metarestore.setPixelsPhysicalSizeX(xsize, 0);
                metarestore.setPixelsPhysicalSizeY(ysize, 0);
                metarestore.setPixelsPhysicalSizeZ(zsize, 0);
                OMETiffWriter ometiffwriter = new OMETiffWriter();
                ometiffwriter.setMetadataRetrieve((MetadataRetrieve)((Object)metarestore));
                ometiffwriter.setId(savefilename);
                for (int z = 0; z < zres; ++z) {
                    Main.progress(i, numbimgs);
                    byte[] allchannelsimagebytes = new byte[xres * yres * cres];
                    for (int c = 0; c < cres; ++c) {
                        byte[] imagebytes = myimagereader.openBytes(myimagereader.getIndex(z, c, t));
                        int offset = 0;
                        for (int kk = 0; kk < imagebytes.length; ++kk) {
                            offset = xres * yres * c;
                            allchannelsimagebytes[offset + kk] = imagebytes[kk];
                        }
                        ++i;
                    }
                    ometiffwriter.saveBytes(0, allchannelsimagebytes);
                }
                ometiffwriter.close();
            }
        }
    }

    public static void saveImageToOMETIFF_ZCTstack(String in_fn, String out_dn) throws Exception {
        if (in_fn.length() == 0) {
            System.out.println("\nERROR: Input filename is NULL!\n");
            return;
        }
        if (out_dn.length() == 0) {
            System.out.println("\nERROR: Output dirname is NULL!\n");
            return;
        }
        ServiceFactory factory = new ServiceFactory();
        OMEXMLService service = factory.getInstance(OMEXMLService.class);
        OMEXMLMetadata meta = service.createOMEXMLMetadata();
        ClassList<IFormatReader> defaultClasses = new ClassList<IFormatReader>("readers.txt", IFormatReader.class);
        IFormatReader myimagereader = new ImageReader(defaultClasses);
        myimagereader.setMetadataOptions(new DefaultMetadataOptions(MetadataLevel.ALL));
        myimagereader.setOriginalMetadataPopulated(collectmetaorig);
        myimagereader.setMetadataFiltered(filtermeta);
        myimagereader.setMetadataStore(meta);
        myimagereader = new ChannelSeparator(myimagereader);
        try {
            myimagereader.setId(in_fn);
        }
        catch (FormatException exc) {
            exc.printStackTrace();
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
        MetadataStore metarestore = myimagereader.getMetadataStore();
        MetadataRetrieve metaretrieve = (MetadataRetrieve)((Object)metarestore);
        System.out.println("Number of Images in Current File: " + myimagereader.getSeriesCount() + "\n");
        int series = myimagereader.getSeriesCount();
        for (int s = 0; s < series; ++s) {
            boolean eostack = false;
            int i = 0;
            myimagereader.setSeries(s);
            metarestore = myimagereader.getMetadataStore();
            metaretrieve = (MetadataRetrieve)((Object)metarestore);
            int sdigits = Integer.toString(s).length();
            String snumb = Integer.toString(s);
            if (sdigits == 1) {
                snumb = "S00" + snumb;
            } else if (sdigits == 2) {
                snumb = "S0" + snumb;
            }
            int numbimgs = myimagereader.getImageCount();
            int xres = (Integer)metaretrieve.getPixelsSizeX(0).getValue();
            int yres = (Integer)metaretrieve.getPixelsSizeY(0).getValue();
            int zres = (Integer)metaretrieve.getPixelsSizeZ(0).getValue();
            int cres = (Integer)metaretrieve.getPixelsSizeC(0).getValue();
            int tres = (Integer)metaretrieve.getPixelsSizeT(0).getValue();
            int samples = (Integer)metaretrieve.getChannelSamplesPerPixel(s, 0).getValue();
            PositiveFloat xsize = metaretrieve.getPixelsPhysicalSizeX(0);
            PositiveFloat ysize = metaretrieve.getPixelsPhysicalSizeY(0);
            PositiveFloat zsize = metaretrieve.getPixelsPhysicalSizeZ(0);
            String dimorder = myimagereader.getDimensionOrder();
            System.out.println("    Series: Image " + (s + 1) + " of " + series);
            System.out.println("    =============================================");
            System.out.println("    Image INFO:");
            System.out.println("    (" + xres + "," + yres + "," + zres + ") (" + cres + "," + tres + ")");
            System.out.println("    Number of images to save: " + numbimgs);
            System.out.println("    Dimensions Order: " + dimorder);
            System.out.println("    (voxel size) X: " + xsize + " Y: " + ysize + " Z: " + zsize);
            System.out.println("    TimeStart: (sec) " + metaretrieve.getImageAcquiredDate(s));
            System.out.println("    TimeStep: (sec) " + metaretrieve.getPixelsTimeIncrement(s));
            System.out.println("    =============================================");
            System.out.println("    Saving to OME-TIFF...");
            int index = in_fn.lastIndexOf("/");
            String infilname = index != -1 ? in_fn.substring(index + 1, in_fn.length()) : in_fn;
            infilname = infilname.replace('.', '_');
            String savefilename = out_dn + snumb + "_" + infilname + ".tiff";
            metarestore.setPixelsSizeX(new PositiveInteger(xres), 0);
            metarestore.setPixelsSizeY(new PositiveInteger(yres), 0);
            metarestore.setPixelsSizeZ(new PositiveInteger(zres), 0);
            metarestore.setPixelsSizeC(new PositiveInteger(cres), 0);
            metarestore.setPixelsSizeT(new PositiveInteger(tres), 0);
            metarestore.setPixelsPhysicalSizeX(xsize, 0);
            metarestore.setPixelsPhysicalSizeY(ysize, 0);
            metarestore.setPixelsPhysicalSizeZ(zsize, 0);
            metarestore.setChannelSamplesPerPixel(new PositiveInteger(1), 0, 0);
            OMETiffWriter ometiffwriter = new OMETiffWriter();
            ometiffwriter.setMetadataRetrieve((MetadataRetrieve)((Object)metarestore));
            ometiffwriter.setId(savefilename);
            for (int t = 0; t < tres; ++t) {
                System.out.println("Timepoint: " + t + " of " + tres);
                for (int z = 0; z < zres; ++z) {
                    Main.progress(i, numbimgs);
                    byte[] allchannelsimagebytes = new byte[xres * yres * cres];
                    for (int c = 0; c < cres; ++c) {
                        byte[] imagebytes = myimagereader.openBytes(myimagereader.getIndex(z, c, t));
                        int offset = 0;
                        for (int kk = 0; kk < imagebytes.length; ++kk) {
                            offset = xres * yres * c;
                            allchannelsimagebytes[offset + kk] = imagebytes[kk];
                        }
                        ++i;
                    }
                    ometiffwriter.saveBytes(0, allchannelsimagebytes);
                }
            }
        }
    }

    public static void saveImageToPNG_multichannel(String in_fn, String out_dn) throws Exception {
        if (in_fn.length() == 0) {
            System.out.println("\nERROR: Input filename is NULL!\n");
            return;
        }
        if (out_dn.length() == 0) {
            System.out.println("\nERROR: Output dirname is NULL!\n");
            return;
        }
        System.out.println("Loading file: " + in_fn);
        ServiceFactory factory = new ServiceFactory();
        OMEXMLService service = factory.getInstance(OMEXMLService.class);
        OMEXMLMetadata meta = service.createOMEXMLMetadata();
        ClassList<IFormatReader> defaultClasses = new ClassList<IFormatReader>("readers.txt", IFormatReader.class);
        IFormatReader myimagereader = new ImageReader(defaultClasses);
        myimagereader.setOriginalMetadataPopulated(collectmetaorig);
        myimagereader.setMetadataFiltered(filtermeta);
        myimagereader.setMetadataStore(meta);
        myimagereader = new ChannelSeparator(myimagereader);
        myimagereader.setId(in_fn);
        MetadataRetrieve metaretrieve = (MetadataRetrieve)((Object)myimagereader.getMetadataStore());
        MetadataStore metarestore = myimagereader.getMetadataStore();
        OMEXMLMetadata omexmlmetadata = (OMEXMLMetadata)metaretrieve;
        int index = in_fn.lastIndexOf("/");
        String infilname = index != -1 ? in_fn.substring(index + 1, in_fn.length()) : in_fn;
        infilname = infilname.replace('.', '_');
        Object buffimage = null;
        int i = 0;
        System.out.println("Number of Images in Current File: " + myimagereader.getSeriesCount());
        int series = myimagereader.getSeriesCount();
        for (int s = 0; s < series; ++s) {
            myimagereader.setSeries(s);
            metarestore = myimagereader.getMetadataStore();
            metaretrieve = (MetadataRetrieve)((Object)metarestore);
            int sdigits = Integer.toString(s).length();
            String snumb = Integer.toString(s);
            if (sdigits == 1) {
                snumb = "S00" + snumb;
            } else if (sdigits == 2) {
                snumb = "S0" + snumb;
            }
            int numbimgs = myimagereader.getImageCount();
            int xres = (Integer)metaretrieve.getPixelsSizeX(0).getValue();
            int yres = (Integer)metaretrieve.getPixelsSizeY(0).getValue();
            int zres = (Integer)metaretrieve.getPixelsSizeZ(0).getValue();
            int cres = (Integer)metaretrieve.getPixelsSizeC(0).getValue();
            int tres = (Integer)metaretrieve.getPixelsSizeT(0).getValue();
            int samples = (Integer)metaretrieve.getChannelSamplesPerPixel(s, 0).getValue();
            PixelType type = metaretrieve.getPixelsType(0);
            PositiveFloat xsize = metaretrieve.getPixelsPhysicalSizeX(0);
            PositiveFloat ysize = metaretrieve.getPixelsPhysicalSizeY(0);
            PositiveFloat zsize = metaretrieve.getPixelsPhysicalSizeZ(0);
            String dimorder = myimagereader.getDimensionOrder();
            System.out.println("    Series Image " + (s + 1) + " of " + series);
            System.out.println("    =============================================");
            System.out.println("    Image INFO:");
            System.out.println("    (" + xres + "," + yres + "," + zres + ") (" + cres + "," + tres + ")");
            System.out.println("    Channel Samples: " + samples);
            System.out.println("    Number of images to save: " + numbimgs);
            System.out.println("    Dimensions Order: " + dimorder);
            System.out.println("    (voxel size) X: " + xsize + " Y: " + ysize + " Z: " + zsize);
            System.out.println("    TimeStart: (sec) " + metaretrieve.getImageAcquiredDate(s));
            System.out.println("    TimeStep: (sec) " + metaretrieve.getPixelsTimeIncrement(s));
            if (type == PixelType.UINT8) {
                System.out.println("    PixelType: UINT8");
            }
            if (type == PixelType.UINT16) {
                System.out.println("    PixelType: UINT16");
            }
            if (type == PixelType.UINT32) {
                System.out.println("    PixelType: UINT32");
            }
            if (type == PixelType.INT8) {
                System.out.println("    PixelType: INT8");
            }
            if (type == PixelType.INT16) {
                System.out.println("    PixelType: INT16");
            }
            if (type == PixelType.INT32) {
                System.out.println("    PixelType: INT32");
            }
            if (type == PixelType.FLOAT) {
                System.out.println("    PixelType: FLOAT");
            }
            if (type == PixelType.DOUBLE) {
                System.out.println("    PixelType: DOUBLE");
            }
            if (type == PixelType.DOUBLECOMPLEX) {
                System.out.println("    PixelType: DOUBLECOMPLEX");
            }
            if (type == PixelType.BIT) {
                System.out.println("    PixelType: BIT");
            }
            System.out.println("    =============================================");
            System.out.println("    Saving to OME-TIFF...");
            for (int t = 0; t < tres; ++t) {
                System.out.println("Timepoint: " + t + " of " + tres);
                int tdigits = Integer.toString(t).length();
                String tnumb = Integer.toString(t);
                if (tdigits == 1) {
                    tnumb = "00" + tnumb;
                } else if (tdigits == 2) {
                    tnumb = "0" + tnumb;
                }
                String timeoutdirname = out_dn + infilname + "_T" + tnumb;
                for (int z = 0; z < zres; ++z) {
                    int zdigits = Integer.toString(z).length();
                    String znumb = Integer.toString(z);
                    if (zdigits == 1) {
                        znumb = "00" + znumb;
                    } else if (zdigits == 2) {
                        znumb = "0" + znumb;
                    }
                    Main.progress(z, zres);
                    byte[] allchannelsimagebytes = new byte[xres * yres * 3];
                    for (int kkk = 0; kkk < allchannelsimagebytes.length; ++kkk) {
                        allchannelsimagebytes[kkk] = 0;
                    }
                    for (int c = 0; c < cres; ++c) {
                        byte[] imagebytes = myimagereader.openBytes(myimagereader.getIndex(z, c, t));
                        int offset = 0;
                        boolean helper = false;
                        for (int kk = 0; kk < allchannelsimagebytes.length / 3; ++kk) {
                            offset = xres * yres * c;
                            if (type == PixelType.UINT8 || type == PixelType.INT8) {
                                allchannelsimagebytes[offset + kk] = imagebytes[kk];
                                continue;
                            }
                            if (type == PixelType.UINT16 || type == PixelType.INT16) {
                                int value = 0;
                                value = imagebytes[2 * kk];
                                value <<= 8;
                                value += imagebytes[2 * kk + 1];
                                value = (int)((double)value + 32767.5);
                                allchannelsimagebytes[offset + kk] = (byte)((double)value / 65535.0 * 255.0);
                                continue;
                            }
                            System.out.println("UNSUPPORTED DATA FORMAT!");
                        }
                        ++i;
                    }
                    new File(timeoutdirname + "/").mkdir();
                    String savefilename = timeoutdirname + "/" + infilname + "_" + snumb + "_T" + tnumb + "_Z" + znumb + ".png";
                    if (z == 0) {
                        FileWriter fstream = new FileWriter(timeoutdirname + "/" + "voxelscale.txt");
                        BufferedWriter out = new BufferedWriter(fstream);
                        out.write("x " + xsize);
                        out.newLine();
                        out.write("y " + ysize);
                        out.newLine();
                        out.write("z " + zsize);
                        out.newLine();
                        out.close();
                        fstream = new FileWriter(timeoutdirname + "/" + "voxelspacing.txt");
                        out = new BufferedWriter(fstream);
                        out.write("x " + xsize);
                        out.newLine();
                        out.write("y " + ysize);
                        out.newLine();
                        out.write("z " + zsize);
                        out.newLine();
                        out.close();
                    }
                    metarestore.setPixelsSizeX(new PositiveInteger(xres), 0);
                    metarestore.setPixelsSizeY(new PositiveInteger(yres), 0);
                    metarestore.setPixelsSizeZ(new PositiveInteger(1), 0);
                    metarestore.setPixelsSizeC(new PositiveInteger(3), 0);
                    metarestore.setChannelSamplesPerPixel(new PositiveInteger(3), 0, 0);
                    metarestore.setPixelsType(PixelType.UINT8, 0);
                    APNGWriter pngwriter = new APNGWriter();
                    pngwriter.setMetadataRetrieve((MetadataRetrieve)((Object)metarestore));
                    pngwriter.setColorModel(ColorModel.getRGBdefault());
                    pngwriter.setId(savefilename);
                    pngwriter.saveBytes(0, allchannelsimagebytes);
                    pngwriter.close();
                    metarestore.setPixelsSizeZ(new PositiveInteger(zres), 0);
                    metarestore.setPixelsSizeC(new PositiveInteger(cres), 0);
                    metarestore.setChannelSamplesPerPixel(new PositiveInteger(samples), 0, 0);
                    metarestore.setPixelsType(type, 0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readSettings(String fn) {
        File aFile = new File(fn);
        String filecontents = new String();
        filecontents = "";
        try {
            BufferedReader input = new BufferedReader(new FileReader(aFile));
            try {
                String line = null;
                while ((line = input.readLine()) != null) {
                    filecontents = filecontents + "\r\n" + line;
                }
            }
            finally {
                input.close();
            }
        }
        catch (IOException ex) {
            System.out.println("ERROR: Settings.txt file could not be found!");
        }
        StringTokenizer st = new StringTokenizer(filecontents);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals("savemode:")) {
                token = st.nextToken();
                if (token.equals("TIFF")) {
                    System.out.println("savemode: TIFF");
                    savemode = 1;
                    continue;
                }
                if (!token.equals("PNG")) continue;
                System.out.println("savemode: PNG");
                savemode = 2;
                continue;
            }
            if (!token.equals("stackmode:")) continue;
            token = st.nextToken();
            if (token.equals("SINGLE_TIFFS")) {
                System.out.println("tiffmode: single tiffs");
                stackmode = 1;
                continue;
            }
            if (token.equals("Z_STACK_TIFFS")) {
                System.out.println("tiffmode: Z_STACK tiffs");
                stackmode = 2;
                continue;
            }
            if (token.equals("ZC_STACK_TIFFS")) {
                System.out.println("tiffmode: ZC_STACK tiffs");
                stackmode = 3;
                continue;
            }
            if (token.equals("ZCT_STACK_TIFFS")) {
                System.out.println("tiffmode: ZCT_STACK tiffs");
                stackmode = 4;
                continue;
            }
            if (token.equals("SINGLE_PNG")) {
                System.out.println("tiffmode: ZCT_STACK tiffs");
                stackmode = 5;
                continue;
            }
            if (!token.equals("MULTICHANNEL_PNG")) continue;
            System.out.println("tiffmode: ZCT_STACK tiffs");
            stackmode = 6;
        }
    }

    public static void main(String[] args) throws Exception {
        System.out.println("=============================================");
        System.out.println("BIOFORMATSCONVERTER");
        System.out.println("author: Jerome Avondo.");
        System.out.println("");
        System.out.println("=============================================");
        Main.readSettings("settings.txt");
        if (savemode == 0 || stackmode == 0) {
            System.out.println("ERROR: Reading the Setting.txt file");
            return;
        }
        System.out.println("=============================================");
        System.out.println("");
        String inputdir = "IN/";
        File dir = new File(inputdir);
        String[] children = dir.list();
        if (children == null) {
            System.out.println("ERROR: Could not find the IN/ directory!");
            return;
        }
        for (int i = 0; i < children.length; ++i) {
            String current_file = inputdir + children[i];
            String outputsubdir = children[i];
            outputsubdir = outputsubdir.replace(".", "_");
            outputsubdir = outputsubdir + "/";
            boolean dircreate = new File("OUT/" + outputsubdir).mkdir();
            if (dircreate) {
                // empty if block
            }
            boolean fileexists = new File(current_file).exists();
            boolean isdirectory = new File(current_file).isDirectory();
            if (fileexists && !isdirectory) {
                System.out.println("=============================================");
                System.out.println("CURRENT FILE: " + current_file);
                System.out.println("File : " + (i + 1) + " of " + children.length);
                System.out.println("=============================================");
                if (savemode == 1) {
                    if (stackmode == 1) {
                        System.out.println("SAVEMODE: SINGLE_TIFFS");
                        Main.saveImageToOMETIFF(current_file, "OUT/" + outputsubdir);
                        continue;
                    }
                    if (stackmode == 2) {
                        System.out.println("SAVEMODE: Z_STACKS");
                        Main.saveImageToOMETIFF_Zstack(current_file, "OUT/" + outputsubdir);
                        continue;
                    }
                    if (stackmode == 3) {
                        System.out.println("SAVEMODE: ZC_STACKS");
                        Main.saveImageToOMETIFF_ZCstack(current_file, "OUT/" + outputsubdir);
                        continue;
                    }
                    if (stackmode != 4) continue;
                    System.out.println("SAVEMODE: ZCT_STACKS");
                    Main.saveImageToOMETIFF_ZCTstack(current_file, "OUT/" + outputsubdir);
                    continue;
                }
                if (savemode != 2) continue;
                if (stackmode == 5) {
                    System.out.println("SAVEMODE: SINGLE_PNG");
                    Main.saveImageToPNG_multichannel(current_file, "OUT/" + outputsubdir);
                    continue;
                }
                if (stackmode != 6) continue;
                System.out.println("SAVEMODE: MULTICHANNEL_PNG");
                Main.saveImageToPNG_multichannel(current_file, "OUT/" + outputsubdir);
                continue;
            }
            System.out.println("ERROR: Could not find " + current_file + " !");
            return;
        }
        System.out.println("=============================================");
        System.out.println("Finished...");
    }
}

