/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.in;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import ij.gui.GenericDialog;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.Label;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import loci.plugins.in.ImportProcess;
import loci.plugins.in.ImporterDialog;
import loci.plugins.util.WindowTools;

public class MainDialog
extends ImporterDialog
implements FocusListener,
ItemListener,
MouseListener {
    public static final String INFO_DEFAULT = "<i>Select an option for a detailed explanation. Documentation written by Glen MacDonald and Curtis Rueden.</i>";
    protected Checkbox autoscaleBox;
    protected Choice colorModeChoice;
    protected Checkbox concatenateBox;
    protected Checkbox cropBox;
    protected Checkbox groupFilesBox;
    protected Checkbox ungroupFilesBox;
    protected Checkbox openAllSeriesBox;
    protected Checkbox showMetadataBox;
    protected Checkbox showOMEXMLBox;
    protected Checkbox showROIsBox;
    protected Checkbox specifyRangesBox;
    protected Checkbox splitZBox;
    protected Checkbox splitTBox;
    protected Checkbox splitCBox;
    protected Choice stackFormatChoice;
    protected Choice stackOrderChoice;
    protected Checkbox swapDimsBox;
    protected Checkbox virtualBox;
    protected Map<Component, String> infoTable;
    protected JEditorPane infoPane;

    public MainDialog(ImportProcess process) {
        super(process);
    }

    protected boolean needPrompt() {
        return !this.process.isWindowless();
    }

    protected GenericDialog constructDialog() {
        GenericDialog gd = new GenericDialog("Bio-Formats Import Options");
        this.addCheckbox(gd, "autoscale");
        this.addChoice(gd, "colorMode");
        this.addCheckbox(gd, "concatenate");
        this.addCheckbox(gd, "crop");
        this.addCheckbox(gd, "groupFiles");
        this.addCheckbox(gd, "ungroupFiles");
        this.addCheckbox(gd, "openAllSeries");
        this.addCheckbox(gd, "quiet");
        this.addCheckbox(gd, "showMetadata");
        this.addCheckbox(gd, "showOMEXML");
        this.addCheckbox(gd, "showROIs");
        this.addCheckbox(gd, "specifyRanges");
        this.addCheckbox(gd, "splitFocalPlanes");
        this.addCheckbox(gd, "splitTimepoints");
        this.addCheckbox(gd, "splitWindows");
        this.addChoice(gd, "stackFormat");
        this.addChoice(gd, "stackOrder");
        this.addCheckbox(gd, "swapDimensions");
        this.addCheckbox(gd, "virtual");
        this.rebuildDialog(gd);
        return gd;
    }

    protected boolean harvestResults(GenericDialog gd) {
        this.options.setAutoscale(gd.getNextBoolean());
        this.options.setColorMode(this.options.getColorModes()[gd.getNextChoiceIndex()]);
        this.options.setConcatenate(gd.getNextBoolean());
        this.options.setCrop(gd.getNextBoolean());
        this.options.setGroupFiles(gd.getNextBoolean());
        this.options.setUngroupFiles(gd.getNextBoolean());
        this.options.setOpenAllSeries(gd.getNextBoolean());
        this.options.setQuiet(gd.getNextBoolean());
        this.options.setShowMetadata(gd.getNextBoolean());
        this.options.setShowOMEXML(gd.getNextBoolean());
        this.options.setShowROIs(gd.getNextBoolean());
        this.options.setSpecifyRanges(gd.getNextBoolean());
        this.options.setSplitFocalPlanes(gd.getNextBoolean());
        this.options.setSplitTimepoints(gd.getNextBoolean());
        this.options.setSplitChannels(gd.getNextBoolean());
        this.options.setStackFormat(this.options.getStackFormats()[gd.getNextChoiceIndex()]);
        this.options.setStackOrder(this.options.getStackOrders()[gd.getNextChoiceIndex()]);
        this.options.setSwapDimensions(gd.getNextBoolean());
        this.options.setVirtual(gd.getNextBoolean());
        return true;
    }

    public void focusGained(FocusEvent e) {
        Object src = e.getSource();
        String text = this.infoTable.get(src);
        this.infoPane.setText("<html>" + text);
        this.infoPane.setCaretPosition(0);
    }

    public void focusLost(FocusEvent e) {
    }

    public void itemStateChanged(ItemEvent e) {
        this.verifyOptions(e.getSource());
    }

    public void mouseEntered(MouseEvent e) {
        Object src = e.getSource();
        if (src instanceof Component) {
            ((Component)src).requestFocusInWindow();
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    private void rebuildDialog(GenericDialog gd) {
        Vector<Component> boxes = null;
        Vector<Component> choices = null;
        Vector<Label> labels = null;
        Label colorModeLabel = null;
        Label stackFormatLabel = null;
        Label stackOrderLabel = null;
        Component[] c = gd.getComponents();
        if (c != null) {
            boxes = new Vector<Component>();
            choices = new Vector<Component>();
            labels = new Vector<Label>();
            for (int i = 0; i < c.length; ++i) {
                Component item;
                if (c[i] instanceof Checkbox) {
                    item = (Checkbox)c[i];
                    item.addFocusListener(this);
                    ((Checkbox)item).addItemListener(this);
                    item.addMouseListener(this);
                    boxes.add(item);
                    continue;
                }
                if (c[i] instanceof Choice) {
                    item = (Choice)c[i];
                    item.addFocusListener(this);
                    ((Choice)item).addItemListener(this);
                    item.addMouseListener(this);
                    choices.add(item);
                    continue;
                }
                if (!(c[i] instanceof Label)) continue;
                labels.add((Label)c[i]);
            }
            int boxIndex = 0;
            int choiceIndex = 0;
            int labelIndex = 0;
            this.autoscaleBox = (Checkbox)boxes.get(boxIndex++);
            this.colorModeChoice = (Choice)choices.get(choiceIndex++);
            colorModeLabel = (Label)labels.get(labelIndex++);
            this.concatenateBox = (Checkbox)boxes.get(boxIndex++);
            this.cropBox = (Checkbox)boxes.get(boxIndex++);
            this.groupFilesBox = (Checkbox)boxes.get(boxIndex++);
            this.ungroupFilesBox = (Checkbox)boxes.get(boxIndex++);
            this.openAllSeriesBox = (Checkbox)boxes.get(boxIndex++);
            int n = ++boxIndex;
            this.showMetadataBox = (Checkbox)boxes.get(n);
            int n2 = ++boxIndex;
            this.showOMEXMLBox = (Checkbox)boxes.get(n2);
            int n3 = ++boxIndex;
            this.showROIsBox = (Checkbox)boxes.get(n3);
            int n4 = ++boxIndex;
            this.specifyRangesBox = (Checkbox)boxes.get(n4);
            int n5 = ++boxIndex;
            this.splitZBox = (Checkbox)boxes.get(n5);
            int n6 = ++boxIndex;
            this.splitTBox = (Checkbox)boxes.get(n6);
            int n7 = ++boxIndex;
            this.splitCBox = (Checkbox)boxes.get(n7);
            this.stackFormatChoice = (Choice)choices.get(choiceIndex++);
            stackFormatLabel = (Label)labels.get(labelIndex++);
            this.stackOrderChoice = (Choice)choices.get(choiceIndex++);
            stackOrderLabel = (Label)labels.get(labelIndex++);
            int n8 = ++boxIndex;
            this.swapDimsBox = (Checkbox)boxes.get(n8);
            int n9 = ++boxIndex;
            ++boxIndex;
            this.virtualBox = (Checkbox)boxes.get(n9);
        }
        this.verifyOptions(null);
        this.infoTable = new HashMap<Component, String>();
        this.infoTable.put(this.autoscaleBox, this.options.getAutoscaleInfo());
        this.infoTable.put(this.colorModeChoice, this.options.getColorModeInfo());
        this.infoTable.put(colorModeLabel, this.options.getColorModeInfo());
        this.infoTable.put(this.concatenateBox, this.options.getConcatenateInfo());
        this.infoTable.put(this.cropBox, this.options.getCropInfo());
        this.infoTable.put(this.groupFilesBox, this.options.getGroupFilesInfo());
        this.infoTable.put(this.ungroupFilesBox, this.options.getUngroupFilesInfo());
        this.infoTable.put(this.openAllSeriesBox, this.options.getOpenAllSeriesInfo());
        this.infoTable.put(this.showMetadataBox, this.options.getShowMetadataInfo());
        this.infoTable.put(this.showOMEXMLBox, this.options.getShowOMEXMLInfo());
        this.infoTable.put(this.showROIsBox, this.options.getShowROIsInfo());
        this.infoTable.put(this.specifyRangesBox, this.options.getSpecifyRangesInfo());
        this.infoTable.put(this.splitZBox, this.options.getSplitFocalPlanesInfo());
        this.infoTable.put(this.splitTBox, this.options.getSplitTimepointsInfo());
        this.infoTable.put(this.splitCBox, this.options.getSplitChannelsInfo());
        this.infoTable.put(this.stackFormatChoice, this.options.getStackFormatInfo());
        this.infoTable.put(stackFormatLabel, this.options.getStackFormatInfo());
        this.infoTable.put(this.stackOrderChoice, this.options.getStackOrderInfo());
        this.infoTable.put(stackOrderLabel, this.options.getStackOrderInfo());
        this.infoTable.put(this.swapDimsBox, this.options.getSwapDimensionsInfo());
        this.infoTable.put(this.virtualBox, this.options.getVirtualInfo());
        String cols = "pref, 3dlu, pref:grow, 10dlu, pref, 10dlu, fill:150dlu";
        String rows = "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 9dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 9dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref";
        PanelBuilder builder = new PanelBuilder(new FormLayout(cols, rows));
        CellConstraints cc = new CellConstraints();
        int row = 1;
        builder.addSeparator("Stack viewing", cc.xyw(1, row, 3));
        builder.add((Component)stackFormatLabel, cc.xy(1, row += 2));
        builder.add((Component)this.stackFormatChoice, cc.xy(3, row));
        builder.add((Component)stackOrderLabel, cc.xy(1, row += 2));
        builder.add((Component)this.stackOrderChoice, cc.xy(3, row));
        builder.addSeparator("Dataset organization", cc.xyw(1, row += 4, 3));
        builder.add((Component)this.groupFilesBox, this.xyw(cc, 1, row += 2, 3));
        builder.add((Component)this.ungroupFilesBox, this.xyw(cc, 1, row += 2, 3));
        builder.add((Component)this.swapDimsBox, this.xyw(cc, 1, row += 2, 3));
        builder.add((Component)this.openAllSeriesBox, this.xyw(cc, 1, row += 2, 3));
        builder.add((Component)this.concatenateBox, this.xyw(cc, 1, row += 2, 3));
        builder.addSeparator("Color options", cc.xyw(1, row += 2, 3));
        builder.add((Component)colorModeLabel, cc.xy(1, row += 2));
        builder.add((Component)this.colorModeChoice, cc.xy(3, row));
        builder.add((Component)this.autoscaleBox, this.xyw(cc, 1, row += 2, 3));
        row += 2;
        row = 1;
        builder.addSeparator("Metadata viewing", cc.xy(5, row));
        builder.add((Component)this.showMetadataBox, this.xyw(cc, 5, row += 2, 1));
        builder.add((Component)this.showOMEXMLBox, this.xyw(cc, 5, row += 2, 1));
        builder.add((Component)this.showROIsBox, this.xyw(cc, 5, row += 2, 1));
        builder.addSeparator("Memory management", cc.xy(5, row += 2));
        builder.add((Component)this.virtualBox, this.xyw(cc, 5, row += 2, 1));
        builder.add((Component)this.specifyRangesBox, this.xyw(cc, 5, row += 2, 1));
        builder.add((Component)this.cropBox, this.xyw(cc, 5, row += 2, 1));
        builder.addSeparator("Split into separate windows", cc.xy(5, row += 4));
        builder.add((Component)this.splitCBox, this.xyw(cc, 5, row += 2, 1));
        builder.add((Component)this.splitZBox, this.xyw(cc, 5, row += 2, 1));
        builder.add((Component)this.splitTBox, this.xyw(cc, 5, row += 2, 1));
        builder.addSeparator("Information", cc.xy(7, 1));
        this.infoPane = new JEditorPane();
        this.infoPane.setContentType("text/html");
        this.infoPane.setEditable(false);
        this.infoPane.setText("<html><i>Select an option for a detailed explanation. Documentation written by Glen MacDonald and Curtis Rueden.</i>");
        builder.add((Component)new JScrollPane(this.infoPane), cc.xywh(7, 3, 1, row));
        gd.removeAll();
        gd.add((Component)builder.getPanel());
        WindowTools.addScrollBars((Container)gd);
        gd.setBackground(Color.white);
    }

    private CellConstraints xyw(CellConstraints cc, int x, int y, int w) {
        return cc.xyw(x, y, w, CellConstraints.LEFT, CellConstraints.CENTER);
    }

    private void verifyOptions(Object src) {
        boolean splitEnabled;
        boolean autoscaleEnabled = this.autoscaleBox.isEnabled();
        boolean colorModeEnabled = this.colorModeChoice.isEnabled();
        boolean concatenateEnabled = this.concatenateBox.isEnabled();
        boolean cropEnabled = this.cropBox.isEnabled();
        boolean groupFilesEnabled = this.groupFilesBox.isEnabled();
        boolean ungroupFilesEnabled = this.ungroupFilesBox.isEnabled();
        boolean openAllSeriesEnabled = this.openAllSeriesBox.isEnabled();
        boolean showMetadataEnabled = this.showMetadataBox.isEnabled();
        boolean showOMEXMLEnabled = this.showOMEXMLBox.isEnabled();
        boolean specifyRangesEnabled = this.specifyRangesBox.isEnabled();
        boolean splitZEnabled = this.splitZBox.isEnabled();
        boolean splitTEnabled = this.splitTBox.isEnabled();
        boolean splitCEnabled = this.splitCBox.isEnabled();
        boolean stackOrderEnabled = this.stackOrderChoice.isEnabled();
        boolean swapDimsEnabled = this.swapDimsBox.isEnabled();
        boolean virtualEnabled = this.virtualBox.isEnabled();
        boolean isAutoscale = this.autoscaleBox.getState();
        String colorModeValue = this.colorModeChoice.getSelectedItem();
        boolean isConcatenate = this.concatenateBox.getState();
        boolean isCrop = this.cropBox.getState();
        boolean isGroupFiles = this.groupFilesBox.getState();
        boolean isUngroupFiles = this.ungroupFilesBox.getState();
        boolean isOpenAllSeries = this.openAllSeriesBox.getState();
        boolean isShowMetadata = this.showMetadataBox.getState();
        boolean isShowOMEXML = this.showOMEXMLBox.getState();
        boolean isSpecifyRanges = this.specifyRangesBox.getState();
        boolean isSplitZ = this.splitZBox.getState();
        boolean isSplitT = this.splitTBox.getState();
        boolean isSplitC = this.splitCBox.getState();
        String stackFormatValue = this.stackFormatChoice.getSelectedItem();
        boolean isStackNone = stackFormatValue.equals("Metadata only");
        boolean isStackStandard = stackFormatValue.equals("Standard ImageJ");
        boolean isStackHyperstack = stackFormatValue.equals("Hyperstack");
        boolean isStackBrowser = stackFormatValue.equals("Data Browser");
        boolean isStackImage5D = stackFormatValue.equals("Image5D");
        boolean isStackView5D = stackFormatValue.equals("View5D");
        String stackOrderValue = this.stackOrderChoice.getSelectedItem();
        boolean isSwap = this.swapDimsBox.getState();
        boolean isVirtual = this.virtualBox.getState();
        stackOrderEnabled = isStackStandard;
        if (src == this.stackFormatChoice) {
            stackOrderValue = isStackHyperstack || isStackBrowser || isStackImage5D ? "XYCZT" : (isStackView5D ? "XYZCT" : "Default");
        }
        boolean bl = showMetadataEnabled = !isStackNone;
        if (!showMetadataEnabled) {
            isShowMetadata = true;
        }
        if (src == this.stackFormatChoice && isStackBrowser) {
            isGroupFiles = true;
        }
        boolean bl2 = virtualEnabled = !isStackNone && !isStackImage5D && !isStackView5D;
        if (!virtualEnabled) {
            isVirtual = false;
        } else if (src == this.stackFormatChoice && isStackBrowser) {
            isVirtual = true;
        }
        boolean bl3 = specifyRangesEnabled = !isStackNone && !isVirtual;
        if (!specifyRangesEnabled) {
            isSpecifyRanges = false;
        }
        boolean bl4 = cropEnabled = !isStackNone && !isVirtual;
        if (!cropEnabled) {
            isCrop = false;
        }
        boolean bl5 = colorModeEnabled = !isStackImage5D && !isStackView5D && !isStackStandard;
        if (!colorModeEnabled) {
            colorModeValue = "Default";
        }
        boolean bl6 = autoscaleEnabled = !isVirtual;
        if (!autoscaleEnabled) {
            isAutoscale = false;
        }
        if (!(splitCEnabled = (splitEnabled = !isStackNone && !isStackBrowser && !isStackImage5D && !isStackView5D))) {
            isSplitC = false;
        }
        if (!(splitZEnabled = splitEnabled)) {
            isSplitZ = false;
        }
        if (!(splitTEnabled = splitEnabled)) {
            isSplitT = false;
        }
        this.autoscaleBox.setEnabled(autoscaleEnabled);
        this.colorModeChoice.setEnabled(colorModeEnabled);
        this.concatenateBox.setEnabled(concatenateEnabled);
        this.cropBox.setEnabled(cropEnabled);
        this.groupFilesBox.setEnabled(groupFilesEnabled);
        this.ungroupFilesBox.setEnabled(ungroupFilesEnabled);
        this.openAllSeriesBox.setEnabled(openAllSeriesEnabled);
        this.showMetadataBox.setEnabled(showMetadataEnabled);
        this.showOMEXMLBox.setEnabled(showOMEXMLEnabled);
        this.specifyRangesBox.setEnabled(specifyRangesEnabled);
        this.splitZBox.setEnabled(splitZEnabled);
        this.splitTBox.setEnabled(splitTEnabled);
        this.splitCBox.setEnabled(splitCEnabled);
        this.stackOrderChoice.setEnabled(stackOrderEnabled);
        this.swapDimsBox.setEnabled(swapDimsEnabled);
        this.virtualBox.setEnabled(virtualEnabled);
        this.autoscaleBox.setState(isAutoscale);
        this.colorModeChoice.select(colorModeValue);
        this.concatenateBox.setState(isConcatenate);
        this.cropBox.setState(isCrop);
        this.groupFilesBox.setState(isGroupFiles);
        this.ungroupFilesBox.setState(isUngroupFiles);
        this.openAllSeriesBox.setState(isOpenAllSeries);
        this.showMetadataBox.setState(isShowMetadata);
        this.showOMEXMLBox.setState(isShowOMEXML);
        this.specifyRangesBox.setState(isSpecifyRanges);
        this.splitZBox.setState(isSplitZ);
        this.splitTBox.setState(isSplitT);
        this.splitCBox.setState(isSplitC);
        this.stackOrderChoice.select(stackOrderValue);
        this.swapDimsBox.setState(isSwap);
        this.virtualBox.setState(isVirtual);
        if (IS_GLITCHED) {
            int i;
            Component[] c = new Component[]{this.autoscaleBox, this.colorModeChoice, this.concatenateBox, this.cropBox, this.groupFilesBox, this.ungroupFilesBox, this.openAllSeriesBox, this.showMetadataBox, this.showOMEXMLBox, this.specifyRangesBox, this.splitZBox, this.splitTBox, this.splitCBox, this.stackFormatChoice, this.stackOrderChoice, this.swapDimsBox, this.virtualBox};
            Component focused = null;
            for (i = 0; i < c.length; ++i) {
                if (!c[i].isFocusOwner()) continue;
                focused = c[i];
            }
            for (i = 0; i < c.length; ++i) {
                c[i].removeFocusListener(this);
            }
            for (i = 0; i < c.length; ++i) {
                c[i].requestFocusInWindow();
            }
            KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            kfm.clearGlobalFocusOwner();
            this.sleep(100L);
            if (focused != null) {
                focused.requestFocusInWindow();
            }
            for (int i2 = 0; i2 < c.length; ++i2) {
                c[i2].addFocusListener(this);
            }
        }
    }
}

