/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.meta;

import loci.common.DataTools;
import loci.formats.meta.MetadataStore;
import ome.xml.model.enums.AcquisitionMode;
import ome.xml.model.enums.ArcType;
import ome.xml.model.enums.Binning;
import ome.xml.model.enums.ContrastMethod;
import ome.xml.model.enums.Correction;
import ome.xml.model.enums.DetectorType;
import ome.xml.model.enums.DimensionOrder;
import ome.xml.model.enums.ExperimentType;
import ome.xml.model.enums.FilamentType;
import ome.xml.model.enums.FilterType;
import ome.xml.model.enums.IlluminationType;
import ome.xml.model.enums.Immersion;
import ome.xml.model.enums.LaserMedium;
import ome.xml.model.enums.LaserType;
import ome.xml.model.enums.Medium;
import ome.xml.model.enums.MicrobeamManipulationType;
import ome.xml.model.enums.MicroscopeType;
import ome.xml.model.enums.NamingConvention;
import ome.xml.model.enums.PixelType;
import ome.xml.model.enums.Pulse;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.NonNegativeLong;
import ome.xml.model.primitives.PercentFraction;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.PositiveInteger;

public class FilterMetadata
implements MetadataStore {
    private MetadataStore store;
    private boolean filter;

    public FilterMetadata(MetadataStore store, boolean filter) {
        this.store = store;
        this.filter = filter;
    }

    public void createRoot() {
        this.store.createRoot();
    }

    public Object getRoot() {
        return this.store.getRoot();
    }

    public void setRoot(Object root) {
        this.store.setRoot(root);
    }

    public void setUUID(String uuid) {
        this.store.setUUID(uuid);
    }

    public void setPixelsBinDataBigEndian(Boolean bigEndian, int imageIndex, int binDataIndex) {
        this.store.setPixelsBinDataBigEndian(bigEndian, imageIndex, binDataIndex);
    }

    public void setMaskBinData(byte[] binData, int ROIIndex, int shapeIndex) {
        this.store.setMaskBinData(binData, ROIIndex, shapeIndex);
    }

    public void setArcID(String id, int instrumentIndex, int lightSourceIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setArcID(id, instrumentIndex, lightSourceIndex);
    }

    public void setArcLotNumber(String lotNumber, int instrumentIndex, int lightSourceIndex) {
        lotNumber = this.filter ? DataTools.sanitize(lotNumber) : lotNumber;
        this.store.setArcLotNumber(lotNumber, instrumentIndex, lightSourceIndex);
    }

    public void setArcManufacturer(String manufacturer, int instrumentIndex, int lightSourceIndex) {
        manufacturer = this.filter ? DataTools.sanitize(manufacturer) : manufacturer;
        this.store.setArcManufacturer(manufacturer, instrumentIndex, lightSourceIndex);
    }

    public void setArcModel(String model, int instrumentIndex, int lightSourceIndex) {
        model = this.filter ? DataTools.sanitize(model) : model;
        this.store.setArcModel(model, instrumentIndex, lightSourceIndex);
    }

    public void setArcPower(Double power, int instrumentIndex, int lightSourceIndex) {
        this.store.setArcPower(power, instrumentIndex, lightSourceIndex);
    }

    public void setArcSerialNumber(String serialNumber, int instrumentIndex, int lightSourceIndex) {
        serialNumber = this.filter ? DataTools.sanitize(serialNumber) : serialNumber;
        this.store.setArcSerialNumber(serialNumber, instrumentIndex, lightSourceIndex);
    }

    public void setArcType(ArcType type, int instrumentIndex, int lightSourceIndex) {
        this.store.setArcType(type, instrumentIndex, lightSourceIndex);
    }

    public void setFileAnnotationBinaryFileFileName(String fileName, int fileAnnotationIndex) {
        fileName = this.filter ? DataTools.sanitize(fileName) : fileName;
        this.store.setFileAnnotationBinaryFileFileName(fileName, fileAnnotationIndex);
    }

    public void setOTFBinaryFileFileName(String fileName, int instrumentIndex, int OTFIndex) {
        fileName = this.filter ? DataTools.sanitize(fileName) : fileName;
        this.store.setOTFBinaryFileFileName(fileName, instrumentIndex, OTFIndex);
    }

    public void setFileAnnotationBinaryFileMIMEType(String mimetype, int fileAnnotationIndex) {
        mimetype = this.filter ? DataTools.sanitize(mimetype) : mimetype;
        this.store.setFileAnnotationBinaryFileMIMEType(mimetype, fileAnnotationIndex);
    }

    public void setOTFBinaryFileMIMEType(String mimetype, int instrumentIndex, int OTFIndex) {
        mimetype = this.filter ? DataTools.sanitize(mimetype) : mimetype;
        this.store.setOTFBinaryFileMIMEType(mimetype, instrumentIndex, OTFIndex);
    }

    public void setFileAnnotationBinaryFileSize(NonNegativeLong size, int fileAnnotationIndex) {
        this.store.setFileAnnotationBinaryFileSize(size, fileAnnotationIndex);
    }

    public void setOTFBinaryFileSize(NonNegativeLong size, int instrumentIndex, int OTFIndex) {
        this.store.setOTFBinaryFileSize(size, instrumentIndex, OTFIndex);
    }

    public void setBinaryOnlyMetadataFile(String metadataFile) {
        metadataFile = this.filter ? DataTools.sanitize(metadataFile) : metadataFile;
        this.store.setBinaryOnlyMetadataFile(metadataFile);
    }

    public void setBinaryOnlyUUID(String uuid) {
        uuid = this.filter ? DataTools.sanitize(uuid) : uuid;
        this.store.setBinaryOnlyUUID(uuid);
    }

    public void setBooleanAnnotationAnnotationRef(String annotation, int booleanAnnotationIndex, int annotationRefIndex) {
        this.store.setBooleanAnnotationAnnotationRef(annotation, booleanAnnotationIndex, annotationRefIndex);
    }

    public void setBooleanAnnotationDescription(String description, int booleanAnnotationIndex) {
        description = this.filter ? DataTools.sanitize(description) : description;
        this.store.setBooleanAnnotationDescription(description, booleanAnnotationIndex);
    }

    public void setBooleanAnnotationID(String id, int booleanAnnotationIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setBooleanAnnotationID(id, booleanAnnotationIndex);
    }

    public void setBooleanAnnotationNamespace(String namespace, int booleanAnnotationIndex) {
        namespace = this.filter ? DataTools.sanitize(namespace) : namespace;
        this.store.setBooleanAnnotationNamespace(namespace, booleanAnnotationIndex);
    }

    public void setBooleanAnnotationValue(Boolean value, int booleanAnnotationIndex) {
        this.store.setBooleanAnnotationValue(value, booleanAnnotationIndex);
    }

    public void setChannelAcquisitionMode(AcquisitionMode acquisitionMode, int imageIndex, int channelIndex) {
        this.store.setChannelAcquisitionMode(acquisitionMode, imageIndex, channelIndex);
    }

    public void setChannelAnnotationRef(String annotation, int imageIndex, int channelIndex, int annotationRefIndex) {
        this.store.setChannelAnnotationRef(annotation, imageIndex, channelIndex, annotationRefIndex);
    }

    public void setChannelColor(Integer color, int imageIndex, int channelIndex) {
        this.store.setChannelColor(color, imageIndex, channelIndex);
    }

    public void setChannelContrastMethod(ContrastMethod contrastMethod, int imageIndex, int channelIndex) {
        this.store.setChannelContrastMethod(contrastMethod, imageIndex, channelIndex);
    }

    public void setChannelEmissionWavelength(PositiveInteger emissionWavelength, int imageIndex, int channelIndex) {
        this.store.setChannelEmissionWavelength(emissionWavelength, imageIndex, channelIndex);
    }

    public void setChannelExcitationWavelength(PositiveInteger excitationWavelength, int imageIndex, int channelIndex) {
        this.store.setChannelExcitationWavelength(excitationWavelength, imageIndex, channelIndex);
    }

    public void setChannelFilterSetRef(String filterSet, int imageIndex, int channelIndex) {
        this.store.setChannelFilterSetRef(filterSet, imageIndex, channelIndex);
    }

    public void setChannelFluor(String fluor, int imageIndex, int channelIndex) {
        fluor = this.filter ? DataTools.sanitize(fluor) : fluor;
        this.store.setChannelFluor(fluor, imageIndex, channelIndex);
    }

    public void setChannelID(String id, int imageIndex, int channelIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setChannelID(id, imageIndex, channelIndex);
    }

    public void setChannelIlluminationType(IlluminationType illuminationType, int imageIndex, int channelIndex) {
        this.store.setChannelIlluminationType(illuminationType, imageIndex, channelIndex);
    }

    public void setChannelNDFilter(Double ndfilter, int imageIndex, int channelIndex) {
        this.store.setChannelNDFilter(ndfilter, imageIndex, channelIndex);
    }

    public void setChannelName(String name, int imageIndex, int channelIndex) {
        name = this.filter ? DataTools.sanitize(name) : name;
        this.store.setChannelName(name, imageIndex, channelIndex);
    }

    public void setChannelOTFRef(String otf, int imageIndex, int channelIndex) {
        this.store.setChannelOTFRef(otf, imageIndex, channelIndex);
    }

    public void setChannelPinholeSize(Double pinholeSize, int imageIndex, int channelIndex) {
        this.store.setChannelPinholeSize(pinholeSize, imageIndex, channelIndex);
    }

    public void setChannelPockelCellSetting(Integer pockelCellSetting, int imageIndex, int channelIndex) {
        this.store.setChannelPockelCellSetting(pockelCellSetting, imageIndex, channelIndex);
    }

    public void setChannelSamplesPerPixel(PositiveInteger samplesPerPixel, int imageIndex, int channelIndex) {
        this.store.setChannelSamplesPerPixel(samplesPerPixel, imageIndex, channelIndex);
    }

    public void setCommentAnnotationAnnotationRef(String annotation, int commentAnnotationIndex, int annotationRefIndex) {
        this.store.setCommentAnnotationAnnotationRef(annotation, commentAnnotationIndex, annotationRefIndex);
    }

    public void setCommentAnnotationDescription(String description, int commentAnnotationIndex) {
        description = this.filter ? DataTools.sanitize(description) : description;
        this.store.setCommentAnnotationDescription(description, commentAnnotationIndex);
    }

    public void setCommentAnnotationID(String id, int commentAnnotationIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setCommentAnnotationID(id, commentAnnotationIndex);
    }

    public void setCommentAnnotationNamespace(String namespace, int commentAnnotationIndex) {
        namespace = this.filter ? DataTools.sanitize(namespace) : namespace;
        this.store.setCommentAnnotationNamespace(namespace, commentAnnotationIndex);
    }

    public void setCommentAnnotationValue(String value, int commentAnnotationIndex) {
        value = this.filter ? DataTools.sanitize(value) : value;
        this.store.setCommentAnnotationValue(value, commentAnnotationIndex);
    }

    public void setDatasetAnnotationRef(String annotation, int datasetIndex, int annotationRefIndex) {
        this.store.setDatasetAnnotationRef(annotation, datasetIndex, annotationRefIndex);
    }

    public void setDatasetDescription(String description, int datasetIndex) {
        description = this.filter ? DataTools.sanitize(description) : description;
        this.store.setDatasetDescription(description, datasetIndex);
    }

    public void setDatasetExperimenterRef(String experimenter, int datasetIndex) {
        this.store.setDatasetExperimenterRef(experimenter, datasetIndex);
    }

    public void setDatasetGroupRef(String group, int datasetIndex) {
        this.store.setDatasetGroupRef(group, datasetIndex);
    }

    public void setDatasetID(String id, int datasetIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setDatasetID(id, datasetIndex);
    }

    public void setDatasetName(String name, int datasetIndex) {
        name = this.filter ? DataTools.sanitize(name) : name;
        this.store.setDatasetName(name, datasetIndex);
    }

    public void setDatasetProjectRef(String project, int datasetIndex, int projectRefIndex) {
        this.store.setDatasetProjectRef(project, datasetIndex, projectRefIndex);
    }

    public void setDetectorAmplificationGain(Double amplificationGain, int instrumentIndex, int detectorIndex) {
        this.store.setDetectorAmplificationGain(amplificationGain, instrumentIndex, detectorIndex);
    }

    public void setDetectorGain(Double gain, int instrumentIndex, int detectorIndex) {
        this.store.setDetectorGain(gain, instrumentIndex, detectorIndex);
    }

    public void setDetectorID(String id, int instrumentIndex, int detectorIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setDetectorID(id, instrumentIndex, detectorIndex);
    }

    public void setDetectorLotNumber(String lotNumber, int instrumentIndex, int detectorIndex) {
        lotNumber = this.filter ? DataTools.sanitize(lotNumber) : lotNumber;
        this.store.setDetectorLotNumber(lotNumber, instrumentIndex, detectorIndex);
    }

    public void setDetectorManufacturer(String manufacturer, int instrumentIndex, int detectorIndex) {
        manufacturer = this.filter ? DataTools.sanitize(manufacturer) : manufacturer;
        this.store.setDetectorManufacturer(manufacturer, instrumentIndex, detectorIndex);
    }

    public void setDetectorModel(String model, int instrumentIndex, int detectorIndex) {
        model = this.filter ? DataTools.sanitize(model) : model;
        this.store.setDetectorModel(model, instrumentIndex, detectorIndex);
    }

    public void setDetectorOffset(Double offset, int instrumentIndex, int detectorIndex) {
        this.store.setDetectorOffset(offset, instrumentIndex, detectorIndex);
    }

    public void setDetectorSerialNumber(String serialNumber, int instrumentIndex, int detectorIndex) {
        serialNumber = this.filter ? DataTools.sanitize(serialNumber) : serialNumber;
        this.store.setDetectorSerialNumber(serialNumber, instrumentIndex, detectorIndex);
    }

    public void setDetectorType(DetectorType type, int instrumentIndex, int detectorIndex) {
        this.store.setDetectorType(type, instrumentIndex, detectorIndex);
    }

    public void setDetectorVoltage(Double voltage, int instrumentIndex, int detectorIndex) {
        this.store.setDetectorVoltage(voltage, instrumentIndex, detectorIndex);
    }

    public void setDetectorZoom(Double zoom, int instrumentIndex, int detectorIndex) {
        this.store.setDetectorZoom(zoom, instrumentIndex, detectorIndex);
    }

    public void setDetectorSettingsBinning(Binning binning, int imageIndex, int channelIndex) {
        this.store.setDetectorSettingsBinning(binning, imageIndex, channelIndex);
    }

    public void setDetectorSettingsGain(Double gain, int imageIndex, int channelIndex) {
        this.store.setDetectorSettingsGain(gain, imageIndex, channelIndex);
    }

    public void setDetectorSettingsID(String id, int imageIndex, int channelIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setDetectorSettingsID(id, imageIndex, channelIndex);
    }

    public void setDetectorSettingsOffset(Double offset, int imageIndex, int channelIndex) {
        this.store.setDetectorSettingsOffset(offset, imageIndex, channelIndex);
    }

    public void setDetectorSettingsReadOutRate(Double readOutRate, int imageIndex, int channelIndex) {
        this.store.setDetectorSettingsReadOutRate(readOutRate, imageIndex, channelIndex);
    }

    public void setDetectorSettingsVoltage(Double voltage, int imageIndex, int channelIndex) {
        this.store.setDetectorSettingsVoltage(voltage, imageIndex, channelIndex);
    }

    public void setDichroicID(String id, int instrumentIndex, int dichroicIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setDichroicID(id, instrumentIndex, dichroicIndex);
    }

    public void setDichroicLotNumber(String lotNumber, int instrumentIndex, int dichroicIndex) {
        lotNumber = this.filter ? DataTools.sanitize(lotNumber) : lotNumber;
        this.store.setDichroicLotNumber(lotNumber, instrumentIndex, dichroicIndex);
    }

    public void setDichroicManufacturer(String manufacturer, int instrumentIndex, int dichroicIndex) {
        manufacturer = this.filter ? DataTools.sanitize(manufacturer) : manufacturer;
        this.store.setDichroicManufacturer(manufacturer, instrumentIndex, dichroicIndex);
    }

    public void setDichroicModel(String model, int instrumentIndex, int dichroicIndex) {
        model = this.filter ? DataTools.sanitize(model) : model;
        this.store.setDichroicModel(model, instrumentIndex, dichroicIndex);
    }

    public void setDichroicSerialNumber(String serialNumber, int instrumentIndex, int dichroicIndex) {
        serialNumber = this.filter ? DataTools.sanitize(serialNumber) : serialNumber;
        this.store.setDichroicSerialNumber(serialNumber, instrumentIndex, dichroicIndex);
    }

    public void setDoubleAnnotationAnnotationRef(String annotation, int doubleAnnotationIndex, int annotationRefIndex) {
        this.store.setDoubleAnnotationAnnotationRef(annotation, doubleAnnotationIndex, annotationRefIndex);
    }

    public void setDoubleAnnotationDescription(String description, int doubleAnnotationIndex) {
        description = this.filter ? DataTools.sanitize(description) : description;
        this.store.setDoubleAnnotationDescription(description, doubleAnnotationIndex);
    }

    public void setDoubleAnnotationID(String id, int doubleAnnotationIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setDoubleAnnotationID(id, doubleAnnotationIndex);
    }

    public void setDoubleAnnotationNamespace(String namespace, int doubleAnnotationIndex) {
        namespace = this.filter ? DataTools.sanitize(namespace) : namespace;
        this.store.setDoubleAnnotationNamespace(namespace, doubleAnnotationIndex);
    }

    public void setDoubleAnnotationValue(Double value, int doubleAnnotationIndex) {
        this.store.setDoubleAnnotationValue(value, doubleAnnotationIndex);
    }

    public void setEllipseDescription(String description, int ROIIndex, int shapeIndex) {
        description = this.filter ? DataTools.sanitize(description) : description;
        this.store.setEllipseDescription(description, ROIIndex, shapeIndex);
    }

    public void setEllipseFill(Integer fill, int ROIIndex, int shapeIndex) {
        this.store.setEllipseFill(fill, ROIIndex, shapeIndex);
    }

    public void setEllipseFontSize(NonNegativeInteger fontSize, int ROIIndex, int shapeIndex) {
        this.store.setEllipseFontSize(fontSize, ROIIndex, shapeIndex);
    }

    public void setEllipseID(String id, int ROIIndex, int shapeIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setEllipseID(id, ROIIndex, shapeIndex);
    }

    public void setEllipseLabel(String label, int ROIIndex, int shapeIndex) {
        label = this.filter ? DataTools.sanitize(label) : label;
        this.store.setEllipseLabel(label, ROIIndex, shapeIndex);
    }

    public void setEllipseName(String name, int ROIIndex, int shapeIndex) {
        name = this.filter ? DataTools.sanitize(name) : name;
        this.store.setEllipseName(name, ROIIndex, shapeIndex);
    }

    public void setEllipseStroke(Integer stroke, int ROIIndex, int shapeIndex) {
        this.store.setEllipseStroke(stroke, ROIIndex, shapeIndex);
    }

    public void setEllipseStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        strokeDashArray = this.filter ? DataTools.sanitize(strokeDashArray) : strokeDashArray;
        this.store.setEllipseStrokeDashArray(strokeDashArray, ROIIndex, shapeIndex);
    }

    public void setEllipseStrokeWidth(Double strokeWidth, int ROIIndex, int shapeIndex) {
        this.store.setEllipseStrokeWidth(strokeWidth, ROIIndex, shapeIndex);
    }

    public void setEllipseTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        this.store.setEllipseTheC(theC, ROIIndex, shapeIndex);
    }

    public void setEllipseTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        this.store.setEllipseTheT(theT, ROIIndex, shapeIndex);
    }

    public void setEllipseTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        this.store.setEllipseTheZ(theZ, ROIIndex, shapeIndex);
    }

    public void setEllipseTransform(String transform, int ROIIndex, int shapeIndex) {
        transform = this.filter ? DataTools.sanitize(transform) : transform;
        this.store.setEllipseTransform(transform, ROIIndex, shapeIndex);
    }

    public void setEllipseRadiusX(Double radiusX, int ROIIndex, int shapeIndex) {
        this.store.setEllipseRadiusX(radiusX, ROIIndex, shapeIndex);
    }

    public void setEllipseRadiusY(Double radiusY, int ROIIndex, int shapeIndex) {
        this.store.setEllipseRadiusY(radiusY, ROIIndex, shapeIndex);
    }

    public void setEllipseX(Double x, int ROIIndex, int shapeIndex) {
        this.store.setEllipseX(x, ROIIndex, shapeIndex);
    }

    public void setEllipseY(Double y, int ROIIndex, int shapeIndex) {
        this.store.setEllipseY(y, ROIIndex, shapeIndex);
    }

    public void setExperimentDescription(String description, int experimentIndex) {
        description = this.filter ? DataTools.sanitize(description) : description;
        this.store.setExperimentDescription(description, experimentIndex);
    }

    public void setExperimentExperimenterRef(String experimenter, int experimentIndex) {
        this.store.setExperimentExperimenterRef(experimenter, experimentIndex);
    }

    public void setExperimentID(String id, int experimentIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setExperimentID(id, experimentIndex);
    }

    public void setExperimentType(ExperimentType type, int experimentIndex) {
        this.store.setExperimentType(type, experimentIndex);
    }

    public void setExperimenterAnnotationRef(String annotation, int experimenterIndex, int annotationRefIndex) {
        this.store.setExperimenterAnnotationRef(annotation, experimenterIndex, annotationRefIndex);
    }

    public void setExperimenterDisplayName(String displayName, int experimenterIndex) {
        displayName = this.filter ? DataTools.sanitize(displayName) : displayName;
        this.store.setExperimenterDisplayName(displayName, experimenterIndex);
    }

    public void setExperimenterEmail(String email, int experimenterIndex) {
        email = this.filter ? DataTools.sanitize(email) : email;
        this.store.setExperimenterEmail(email, experimenterIndex);
    }

    public void setExperimenterFirstName(String firstName, int experimenterIndex) {
        firstName = this.filter ? DataTools.sanitize(firstName) : firstName;
        this.store.setExperimenterFirstName(firstName, experimenterIndex);
    }

    public void setExperimenterGroupRef(String group, int experimenterIndex, int groupRefIndex) {
        this.store.setExperimenterGroupRef(group, experimenterIndex, groupRefIndex);
    }

    public void setExperimenterID(String id, int experimenterIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setExperimenterID(id, experimenterIndex);
    }

    public void setExperimenterInstitution(String institution, int experimenterIndex) {
        institution = this.filter ? DataTools.sanitize(institution) : institution;
        this.store.setExperimenterInstitution(institution, experimenterIndex);
    }

    public void setExperimenterLastName(String lastName, int experimenterIndex) {
        lastName = this.filter ? DataTools.sanitize(lastName) : lastName;
        this.store.setExperimenterLastName(lastName, experimenterIndex);
    }

    public void setExperimenterMiddleName(String middleName, int experimenterIndex) {
        middleName = this.filter ? DataTools.sanitize(middleName) : middleName;
        this.store.setExperimenterMiddleName(middleName, experimenterIndex);
    }

    public void setExperimenterUserName(String userName, int experimenterIndex) {
        userName = this.filter ? DataTools.sanitize(userName) : userName;
        this.store.setExperimenterUserName(userName, experimenterIndex);
    }

    public void setFilamentID(String id, int instrumentIndex, int lightSourceIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setFilamentID(id, instrumentIndex, lightSourceIndex);
    }

    public void setFilamentLotNumber(String lotNumber, int instrumentIndex, int lightSourceIndex) {
        lotNumber = this.filter ? DataTools.sanitize(lotNumber) : lotNumber;
        this.store.setFilamentLotNumber(lotNumber, instrumentIndex, lightSourceIndex);
    }

    public void setFilamentManufacturer(String manufacturer, int instrumentIndex, int lightSourceIndex) {
        manufacturer = this.filter ? DataTools.sanitize(manufacturer) : manufacturer;
        this.store.setFilamentManufacturer(manufacturer, instrumentIndex, lightSourceIndex);
    }

    public void setFilamentModel(String model, int instrumentIndex, int lightSourceIndex) {
        model = this.filter ? DataTools.sanitize(model) : model;
        this.store.setFilamentModel(model, instrumentIndex, lightSourceIndex);
    }

    public void setFilamentPower(Double power, int instrumentIndex, int lightSourceIndex) {
        this.store.setFilamentPower(power, instrumentIndex, lightSourceIndex);
    }

    public void setFilamentSerialNumber(String serialNumber, int instrumentIndex, int lightSourceIndex) {
        serialNumber = this.filter ? DataTools.sanitize(serialNumber) : serialNumber;
        this.store.setFilamentSerialNumber(serialNumber, instrumentIndex, lightSourceIndex);
    }

    public void setFilamentType(FilamentType type, int instrumentIndex, int lightSourceIndex) {
        this.store.setFilamentType(type, instrumentIndex, lightSourceIndex);
    }

    public void setFileAnnotationAnnotationRef(String annotation, int fileAnnotationIndex, int annotationRefIndex) {
        this.store.setFileAnnotationAnnotationRef(annotation, fileAnnotationIndex, annotationRefIndex);
    }

    public void setFileAnnotationDescription(String description, int fileAnnotationIndex) {
        description = this.filter ? DataTools.sanitize(description) : description;
        this.store.setFileAnnotationDescription(description, fileAnnotationIndex);
    }

    public void setFileAnnotationID(String id, int fileAnnotationIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setFileAnnotationID(id, fileAnnotationIndex);
    }

    public void setFileAnnotationNamespace(String namespace, int fileAnnotationIndex) {
        namespace = this.filter ? DataTools.sanitize(namespace) : namespace;
        this.store.setFileAnnotationNamespace(namespace, fileAnnotationIndex);
    }

    public void setFilterFilterWheel(String filterWheel, int instrumentIndex, int filterIndex) {
        filterWheel = this.filter ? DataTools.sanitize(filterWheel) : filterWheel;
        this.store.setFilterFilterWheel(filterWheel, instrumentIndex, filterIndex);
    }

    public void setFilterID(String id, int instrumentIndex, int filterIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setFilterID(id, instrumentIndex, filterIndex);
    }

    public void setFilterLotNumber(String lotNumber, int instrumentIndex, int filterIndex) {
        lotNumber = this.filter ? DataTools.sanitize(lotNumber) : lotNumber;
        this.store.setFilterLotNumber(lotNumber, instrumentIndex, filterIndex);
    }

    public void setFilterManufacturer(String manufacturer, int instrumentIndex, int filterIndex) {
        manufacturer = this.filter ? DataTools.sanitize(manufacturer) : manufacturer;
        this.store.setFilterManufacturer(manufacturer, instrumentIndex, filterIndex);
    }

    public void setFilterModel(String model, int instrumentIndex, int filterIndex) {
        model = this.filter ? DataTools.sanitize(model) : model;
        this.store.setFilterModel(model, instrumentIndex, filterIndex);
    }

    public void setFilterSerialNumber(String serialNumber, int instrumentIndex, int filterIndex) {
        serialNumber = this.filter ? DataTools.sanitize(serialNumber) : serialNumber;
        this.store.setFilterSerialNumber(serialNumber, instrumentIndex, filterIndex);
    }

    public void setFilterType(FilterType type, int instrumentIndex, int filterIndex) {
        this.store.setFilterType(type, instrumentIndex, filterIndex);
    }

    public void setFilterSetDichroicRef(String dichroic, int instrumentIndex, int filterSetIndex) {
        this.store.setFilterSetDichroicRef(dichroic, instrumentIndex, filterSetIndex);
    }

    public void setFilterSetEmissionFilterRef(String emissionFilter, int instrumentIndex, int filterSetIndex, int emissionFilterRefIndex) {
        this.store.setFilterSetEmissionFilterRef(emissionFilter, instrumentIndex, filterSetIndex, emissionFilterRefIndex);
    }

    public void setFilterSetExcitationFilterRef(String excitationFilter, int instrumentIndex, int filterSetIndex, int excitationFilterRefIndex) {
        this.store.setFilterSetExcitationFilterRef(excitationFilter, instrumentIndex, filterSetIndex, excitationFilterRefIndex);
    }

    public void setFilterSetID(String id, int instrumentIndex, int filterSetIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setFilterSetID(id, instrumentIndex, filterSetIndex);
    }

    public void setFilterSetLotNumber(String lotNumber, int instrumentIndex, int filterSetIndex) {
        lotNumber = this.filter ? DataTools.sanitize(lotNumber) : lotNumber;
        this.store.setFilterSetLotNumber(lotNumber, instrumentIndex, filterSetIndex);
    }

    public void setFilterSetManufacturer(String manufacturer, int instrumentIndex, int filterSetIndex) {
        manufacturer = this.filter ? DataTools.sanitize(manufacturer) : manufacturer;
        this.store.setFilterSetManufacturer(manufacturer, instrumentIndex, filterSetIndex);
    }

    public void setFilterSetModel(String model, int instrumentIndex, int filterSetIndex) {
        model = this.filter ? DataTools.sanitize(model) : model;
        this.store.setFilterSetModel(model, instrumentIndex, filterSetIndex);
    }

    public void setFilterSetSerialNumber(String serialNumber, int instrumentIndex, int filterSetIndex) {
        serialNumber = this.filter ? DataTools.sanitize(serialNumber) : serialNumber;
        this.store.setFilterSetSerialNumber(serialNumber, instrumentIndex, filterSetIndex);
    }

    public void setGroupContact(String contact, int groupIndex) {
        this.store.setGroupContact(contact, groupIndex);
    }

    public void setGroupDescription(String description, int groupIndex) {
        description = this.filter ? DataTools.sanitize(description) : description;
        this.store.setGroupDescription(description, groupIndex);
    }

    public void setGroupID(String id, int groupIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setGroupID(id, groupIndex);
    }

    public void setGroupLeader(String leader, int groupIndex) {
        this.store.setGroupLeader(leader, groupIndex);
    }

    public void setGroupName(String name, int groupIndex) {
        name = this.filter ? DataTools.sanitize(name) : name;
        this.store.setGroupName(name, groupIndex);
    }

    public void setImageAcquiredDate(String acquiredDate, int imageIndex) {
        acquiredDate = this.filter ? DataTools.sanitize(acquiredDate) : acquiredDate;
        this.store.setImageAcquiredDate(acquiredDate, imageIndex);
    }

    public void setImageAnnotationRef(String annotation, int imageIndex, int annotationRefIndex) {
        this.store.setImageAnnotationRef(annotation, imageIndex, annotationRefIndex);
    }

    public void setImageDatasetRef(String dataset, int imageIndex, int datasetRefIndex) {
        this.store.setImageDatasetRef(dataset, imageIndex, datasetRefIndex);
    }

    public void setImageDescription(String description, int imageIndex) {
        description = this.filter ? DataTools.sanitize(description) : description;
        this.store.setImageDescription(description, imageIndex);
    }

    public void setImageExperimentRef(String experiment, int imageIndex) {
        this.store.setImageExperimentRef(experiment, imageIndex);
    }

    public void setImageExperimenterRef(String experimenter, int imageIndex) {
        this.store.setImageExperimenterRef(experimenter, imageIndex);
    }

    public void setImageGroupRef(String group, int imageIndex) {
        this.store.setImageGroupRef(group, imageIndex);
    }

    public void setImageID(String id, int imageIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setImageID(id, imageIndex);
    }

    public void setImageInstrumentRef(String instrument, int imageIndex) {
        this.store.setImageInstrumentRef(instrument, imageIndex);
    }

    public void setImageMicrobeamManipulationRef(String microbeamManipulation, int imageIndex, int microbeamManipulationRefIndex) {
        this.store.setImageMicrobeamManipulationRef(microbeamManipulation, imageIndex, microbeamManipulationRefIndex);
    }

    public void setImageName(String name, int imageIndex) {
        name = this.filter ? DataTools.sanitize(name) : name;
        this.store.setImageName(name, imageIndex);
    }

    public void setImageROIRef(String roi, int imageIndex, int ROIRefIndex) {
        this.store.setImageROIRef(roi, imageIndex, ROIRefIndex);
    }

    public void setImagingEnvironmentAirPressure(Double airPressure, int imageIndex) {
        this.store.setImagingEnvironmentAirPressure(airPressure, imageIndex);
    }

    public void setImagingEnvironmentCO2Percent(PercentFraction co2percent, int imageIndex) {
        this.store.setImagingEnvironmentCO2Percent(co2percent, imageIndex);
    }

    public void setImagingEnvironmentHumidity(PercentFraction humidity, int imageIndex) {
        this.store.setImagingEnvironmentHumidity(humidity, imageIndex);
    }

    public void setImagingEnvironmentTemperature(Double temperature, int imageIndex) {
        this.store.setImagingEnvironmentTemperature(temperature, imageIndex);
    }

    public void setInstrumentID(String id, int instrumentIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setInstrumentID(id, instrumentIndex);
    }

    public void setLaserID(String id, int instrumentIndex, int lightSourceIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setLaserID(id, instrumentIndex, lightSourceIndex);
    }

    public void setLaserLotNumber(String lotNumber, int instrumentIndex, int lightSourceIndex) {
        lotNumber = this.filter ? DataTools.sanitize(lotNumber) : lotNumber;
        this.store.setLaserLotNumber(lotNumber, instrumentIndex, lightSourceIndex);
    }

    public void setLaserManufacturer(String manufacturer, int instrumentIndex, int lightSourceIndex) {
        manufacturer = this.filter ? DataTools.sanitize(manufacturer) : manufacturer;
        this.store.setLaserManufacturer(manufacturer, instrumentIndex, lightSourceIndex);
    }

    public void setLaserModel(String model, int instrumentIndex, int lightSourceIndex) {
        model = this.filter ? DataTools.sanitize(model) : model;
        this.store.setLaserModel(model, instrumentIndex, lightSourceIndex);
    }

    public void setLaserPower(Double power, int instrumentIndex, int lightSourceIndex) {
        this.store.setLaserPower(power, instrumentIndex, lightSourceIndex);
    }

    public void setLaserSerialNumber(String serialNumber, int instrumentIndex, int lightSourceIndex) {
        serialNumber = this.filter ? DataTools.sanitize(serialNumber) : serialNumber;
        this.store.setLaserSerialNumber(serialNumber, instrumentIndex, lightSourceIndex);
    }

    public void setLaserFrequencyMultiplication(PositiveInteger frequencyMultiplication, int instrumentIndex, int lightSourceIndex) {
        this.store.setLaserFrequencyMultiplication(frequencyMultiplication, instrumentIndex, lightSourceIndex);
    }

    public void setLaserLaserMedium(LaserMedium laserMedium, int instrumentIndex, int lightSourceIndex) {
        this.store.setLaserLaserMedium(laserMedium, instrumentIndex, lightSourceIndex);
    }

    public void setLaserPockelCell(Boolean pockelCell, int instrumentIndex, int lightSourceIndex) {
        this.store.setLaserPockelCell(pockelCell, instrumentIndex, lightSourceIndex);
    }

    public void setLaserPulse(Pulse pulse, int instrumentIndex, int lightSourceIndex) {
        this.store.setLaserPulse(pulse, instrumentIndex, lightSourceIndex);
    }

    public void setLaserPump(String pump, int instrumentIndex, int lightSourceIndex) {
        this.store.setLaserPump(pump, instrumentIndex, lightSourceIndex);
    }

    public void setLaserRepetitionRate(Double repetitionRate, int instrumentIndex, int lightSourceIndex) {
        this.store.setLaserRepetitionRate(repetitionRate, instrumentIndex, lightSourceIndex);
    }

    public void setLaserTuneable(Boolean tuneable, int instrumentIndex, int lightSourceIndex) {
        this.store.setLaserTuneable(tuneable, instrumentIndex, lightSourceIndex);
    }

    public void setLaserType(LaserType type, int instrumentIndex, int lightSourceIndex) {
        this.store.setLaserType(type, instrumentIndex, lightSourceIndex);
    }

    public void setLaserWavelength(PositiveInteger wavelength, int instrumentIndex, int lightSourceIndex) {
        this.store.setLaserWavelength(wavelength, instrumentIndex, lightSourceIndex);
    }

    public void setLightEmittingDiodeID(String id, int instrumentIndex, int lightSourceIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setLightEmittingDiodeID(id, instrumentIndex, lightSourceIndex);
    }

    public void setLightEmittingDiodeLotNumber(String lotNumber, int instrumentIndex, int lightSourceIndex) {
        lotNumber = this.filter ? DataTools.sanitize(lotNumber) : lotNumber;
        this.store.setLightEmittingDiodeLotNumber(lotNumber, instrumentIndex, lightSourceIndex);
    }

    public void setLightEmittingDiodeManufacturer(String manufacturer, int instrumentIndex, int lightSourceIndex) {
        manufacturer = this.filter ? DataTools.sanitize(manufacturer) : manufacturer;
        this.store.setLightEmittingDiodeManufacturer(manufacturer, instrumentIndex, lightSourceIndex);
    }

    public void setLightEmittingDiodeModel(String model, int instrumentIndex, int lightSourceIndex) {
        model = this.filter ? DataTools.sanitize(model) : model;
        this.store.setLightEmittingDiodeModel(model, instrumentIndex, lightSourceIndex);
    }

    public void setLightEmittingDiodePower(Double power, int instrumentIndex, int lightSourceIndex) {
        this.store.setLightEmittingDiodePower(power, instrumentIndex, lightSourceIndex);
    }

    public void setLightEmittingDiodeSerialNumber(String serialNumber, int instrumentIndex, int lightSourceIndex) {
        serialNumber = this.filter ? DataTools.sanitize(serialNumber) : serialNumber;
        this.store.setLightEmittingDiodeSerialNumber(serialNumber, instrumentIndex, lightSourceIndex);
    }

    public void setLightPathDichroicRef(String dichroic, int imageIndex, int channelIndex) {
        this.store.setLightPathDichroicRef(dichroic, imageIndex, channelIndex);
    }

    public void setLightPathEmissionFilterRef(String emissionFilter, int imageIndex, int channelIndex, int emissionFilterRefIndex) {
        this.store.setLightPathEmissionFilterRef(emissionFilter, imageIndex, channelIndex, emissionFilterRefIndex);
    }

    public void setLightPathExcitationFilterRef(String excitationFilter, int imageIndex, int channelIndex, int excitationFilterRefIndex) {
        this.store.setLightPathExcitationFilterRef(excitationFilter, imageIndex, channelIndex, excitationFilterRefIndex);
    }

    public void setChannelLightSourceSettingsAttenuation(PercentFraction attenuation, int imageIndex, int channelIndex) {
        this.store.setChannelLightSourceSettingsAttenuation(attenuation, imageIndex, channelIndex);
    }

    public void setMicrobeamManipulationLightSourceSettingsAttenuation(PercentFraction attenuation, int experimentIndex, int microbeamManipulationIndex, int lightSourceSettingsIndex) {
        this.store.setMicrobeamManipulationLightSourceSettingsAttenuation(attenuation, experimentIndex, microbeamManipulationIndex, lightSourceSettingsIndex);
    }

    public void setChannelLightSourceSettingsID(String id, int imageIndex, int channelIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setChannelLightSourceSettingsID(id, imageIndex, channelIndex);
    }

    public void setMicrobeamManipulationLightSourceSettingsID(String id, int experimentIndex, int microbeamManipulationIndex, int lightSourceSettingsIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setMicrobeamManipulationLightSourceSettingsID(id, experimentIndex, microbeamManipulationIndex, lightSourceSettingsIndex);
    }

    public void setChannelLightSourceSettingsWavelength(PositiveInteger wavelength, int imageIndex, int channelIndex) {
        this.store.setChannelLightSourceSettingsWavelength(wavelength, imageIndex, channelIndex);
    }

    public void setMicrobeamManipulationLightSourceSettingsWavelength(PositiveInteger wavelength, int experimentIndex, int microbeamManipulationIndex, int lightSourceSettingsIndex) {
        this.store.setMicrobeamManipulationLightSourceSettingsWavelength(wavelength, experimentIndex, microbeamManipulationIndex, lightSourceSettingsIndex);
    }

    public void setLineDescription(String description, int ROIIndex, int shapeIndex) {
        description = this.filter ? DataTools.sanitize(description) : description;
        this.store.setLineDescription(description, ROIIndex, shapeIndex);
    }

    public void setLineFill(Integer fill, int ROIIndex, int shapeIndex) {
        this.store.setLineFill(fill, ROIIndex, shapeIndex);
    }

    public void setLineFontSize(NonNegativeInteger fontSize, int ROIIndex, int shapeIndex) {
        this.store.setLineFontSize(fontSize, ROIIndex, shapeIndex);
    }

    public void setLineID(String id, int ROIIndex, int shapeIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setLineID(id, ROIIndex, shapeIndex);
    }

    public void setLineLabel(String label, int ROIIndex, int shapeIndex) {
        label = this.filter ? DataTools.sanitize(label) : label;
        this.store.setLineLabel(label, ROIIndex, shapeIndex);
    }

    public void setLineName(String name, int ROIIndex, int shapeIndex) {
        name = this.filter ? DataTools.sanitize(name) : name;
        this.store.setLineName(name, ROIIndex, shapeIndex);
    }

    public void setLineStroke(Integer stroke, int ROIIndex, int shapeIndex) {
        this.store.setLineStroke(stroke, ROIIndex, shapeIndex);
    }

    public void setLineStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        strokeDashArray = this.filter ? DataTools.sanitize(strokeDashArray) : strokeDashArray;
        this.store.setLineStrokeDashArray(strokeDashArray, ROIIndex, shapeIndex);
    }

    public void setLineStrokeWidth(Double strokeWidth, int ROIIndex, int shapeIndex) {
        this.store.setLineStrokeWidth(strokeWidth, ROIIndex, shapeIndex);
    }

    public void setLineTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        this.store.setLineTheC(theC, ROIIndex, shapeIndex);
    }

    public void setLineTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        this.store.setLineTheT(theT, ROIIndex, shapeIndex);
    }

    public void setLineTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        this.store.setLineTheZ(theZ, ROIIndex, shapeIndex);
    }

    public void setLineTransform(String transform, int ROIIndex, int shapeIndex) {
        transform = this.filter ? DataTools.sanitize(transform) : transform;
        this.store.setLineTransform(transform, ROIIndex, shapeIndex);
    }

    public void setLineX1(Double x1, int ROIIndex, int shapeIndex) {
        this.store.setLineX1(x1, ROIIndex, shapeIndex);
    }

    public void setLineX2(Double x2, int ROIIndex, int shapeIndex) {
        this.store.setLineX2(x2, ROIIndex, shapeIndex);
    }

    public void setLineY1(Double y1, int ROIIndex, int shapeIndex) {
        this.store.setLineY1(y1, ROIIndex, shapeIndex);
    }

    public void setLineY2(Double y2, int ROIIndex, int shapeIndex) {
        this.store.setLineY2(y2, ROIIndex, shapeIndex);
    }

    public void setListAnnotationAnnotationRef(String annotation, int listAnnotationIndex, int annotationRefIndex) {
        this.store.setListAnnotationAnnotationRef(annotation, listAnnotationIndex, annotationRefIndex);
    }

    public void setListAnnotationDescription(String description, int listAnnotationIndex) {
        description = this.filter ? DataTools.sanitize(description) : description;
        this.store.setListAnnotationDescription(description, listAnnotationIndex);
    }

    public void setListAnnotationID(String id, int listAnnotationIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setListAnnotationID(id, listAnnotationIndex);
    }

    public void setListAnnotationNamespace(String namespace, int listAnnotationIndex) {
        namespace = this.filter ? DataTools.sanitize(namespace) : namespace;
        this.store.setListAnnotationNamespace(namespace, listAnnotationIndex);
    }

    public void setLongAnnotationAnnotationRef(String annotation, int longAnnotationIndex, int annotationRefIndex) {
        this.store.setLongAnnotationAnnotationRef(annotation, longAnnotationIndex, annotationRefIndex);
    }

    public void setLongAnnotationDescription(String description, int longAnnotationIndex) {
        description = this.filter ? DataTools.sanitize(description) : description;
        this.store.setLongAnnotationDescription(description, longAnnotationIndex);
    }

    public void setLongAnnotationID(String id, int longAnnotationIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setLongAnnotationID(id, longAnnotationIndex);
    }

    public void setLongAnnotationNamespace(String namespace, int longAnnotationIndex) {
        namespace = this.filter ? DataTools.sanitize(namespace) : namespace;
        this.store.setLongAnnotationNamespace(namespace, longAnnotationIndex);
    }

    public void setLongAnnotationValue(Long value, int longAnnotationIndex) {
        this.store.setLongAnnotationValue(value, longAnnotationIndex);
    }

    public void setMaskDescription(String description, int ROIIndex, int shapeIndex) {
        description = this.filter ? DataTools.sanitize(description) : description;
        this.store.setMaskDescription(description, ROIIndex, shapeIndex);
    }

    public void setMaskFill(Integer fill, int ROIIndex, int shapeIndex) {
        this.store.setMaskFill(fill, ROIIndex, shapeIndex);
    }

    public void setMaskFontSize(NonNegativeInteger fontSize, int ROIIndex, int shapeIndex) {
        this.store.setMaskFontSize(fontSize, ROIIndex, shapeIndex);
    }

    public void setMaskID(String id, int ROIIndex, int shapeIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setMaskID(id, ROIIndex, shapeIndex);
    }

    public void setMaskLabel(String label, int ROIIndex, int shapeIndex) {
        label = this.filter ? DataTools.sanitize(label) : label;
        this.store.setMaskLabel(label, ROIIndex, shapeIndex);
    }

    public void setMaskName(String name, int ROIIndex, int shapeIndex) {
        name = this.filter ? DataTools.sanitize(name) : name;
        this.store.setMaskName(name, ROIIndex, shapeIndex);
    }

    public void setMaskStroke(Integer stroke, int ROIIndex, int shapeIndex) {
        this.store.setMaskStroke(stroke, ROIIndex, shapeIndex);
    }

    public void setMaskStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        strokeDashArray = this.filter ? DataTools.sanitize(strokeDashArray) : strokeDashArray;
        this.store.setMaskStrokeDashArray(strokeDashArray, ROIIndex, shapeIndex);
    }

    public void setMaskStrokeWidth(Double strokeWidth, int ROIIndex, int shapeIndex) {
        this.store.setMaskStrokeWidth(strokeWidth, ROIIndex, shapeIndex);
    }

    public void setMaskTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        this.store.setMaskTheC(theC, ROIIndex, shapeIndex);
    }

    public void setMaskTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        this.store.setMaskTheT(theT, ROIIndex, shapeIndex);
    }

    public void setMaskTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        this.store.setMaskTheZ(theZ, ROIIndex, shapeIndex);
    }

    public void setMaskTransform(String transform, int ROIIndex, int shapeIndex) {
        transform = this.filter ? DataTools.sanitize(transform) : transform;
        this.store.setMaskTransform(transform, ROIIndex, shapeIndex);
    }

    public void setMaskHeight(Double height, int ROIIndex, int shapeIndex) {
        this.store.setMaskHeight(height, ROIIndex, shapeIndex);
    }

    public void setMaskWidth(Double width, int ROIIndex, int shapeIndex) {
        this.store.setMaskWidth(width, ROIIndex, shapeIndex);
    }

    public void setMaskX(Double x, int ROIIndex, int shapeIndex) {
        this.store.setMaskX(x, ROIIndex, shapeIndex);
    }

    public void setMaskY(Double y, int ROIIndex, int shapeIndex) {
        this.store.setMaskY(y, ROIIndex, shapeIndex);
    }

    public void setMicrobeamManipulationDescription(String description, int experimentIndex, int microbeamManipulationIndex) {
        description = this.filter ? DataTools.sanitize(description) : description;
        this.store.setMicrobeamManipulationDescription(description, experimentIndex, microbeamManipulationIndex);
    }

    public void setMicrobeamManipulationExperimenterRef(String experimenter, int experimentIndex, int microbeamManipulationIndex) {
        this.store.setMicrobeamManipulationExperimenterRef(experimenter, experimentIndex, microbeamManipulationIndex);
    }

    public void setMicrobeamManipulationID(String id, int experimentIndex, int microbeamManipulationIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setMicrobeamManipulationID(id, experimentIndex, microbeamManipulationIndex);
    }

    public void setMicrobeamManipulationROIRef(String roi, int experimentIndex, int microbeamManipulationIndex, int ROIRefIndex) {
        this.store.setMicrobeamManipulationROIRef(roi, experimentIndex, microbeamManipulationIndex, ROIRefIndex);
    }

    public void setMicrobeamManipulationType(MicrobeamManipulationType type, int experimentIndex, int microbeamManipulationIndex) {
        this.store.setMicrobeamManipulationType(type, experimentIndex, microbeamManipulationIndex);
    }

    public void setMicroscopeLotNumber(String lotNumber, int instrumentIndex) {
        lotNumber = this.filter ? DataTools.sanitize(lotNumber) : lotNumber;
        this.store.setMicroscopeLotNumber(lotNumber, instrumentIndex);
    }

    public void setMicroscopeManufacturer(String manufacturer, int instrumentIndex) {
        manufacturer = this.filter ? DataTools.sanitize(manufacturer) : manufacturer;
        this.store.setMicroscopeManufacturer(manufacturer, instrumentIndex);
    }

    public void setMicroscopeModel(String model, int instrumentIndex) {
        model = this.filter ? DataTools.sanitize(model) : model;
        this.store.setMicroscopeModel(model, instrumentIndex);
    }

    public void setMicroscopeSerialNumber(String serialNumber, int instrumentIndex) {
        serialNumber = this.filter ? DataTools.sanitize(serialNumber) : serialNumber;
        this.store.setMicroscopeSerialNumber(serialNumber, instrumentIndex);
    }

    public void setMicroscopeType(MicroscopeType type, int instrumentIndex) {
        this.store.setMicroscopeType(type, instrumentIndex);
    }

    public void setOTFFilterSetRef(String filterSet, int instrumentIndex, int OTFIndex) {
        this.store.setOTFFilterSetRef(filterSet, instrumentIndex, OTFIndex);
    }

    public void setOTFID(String id, int instrumentIndex, int OTFIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setOTFID(id, instrumentIndex, OTFIndex);
    }

    public void setOTFOpticalAxisAveraged(Boolean opticalAxisAveraged, int instrumentIndex, int OTFIndex) {
        this.store.setOTFOpticalAxisAveraged(opticalAxisAveraged, instrumentIndex, OTFIndex);
    }

    public void setOTFSizeX(PositiveInteger sizeX, int instrumentIndex, int OTFIndex) {
        this.store.setOTFSizeX(sizeX, instrumentIndex, OTFIndex);
    }

    public void setOTFSizeY(PositiveInteger sizeY, int instrumentIndex, int OTFIndex) {
        this.store.setOTFSizeY(sizeY, instrumentIndex, OTFIndex);
    }

    public void setOTFType(PixelType type, int instrumentIndex, int OTFIndex) {
        this.store.setOTFType(type, instrumentIndex, OTFIndex);
    }

    public void setObjectiveCalibratedMagnification(Double calibratedMagnification, int instrumentIndex, int objectiveIndex) {
        this.store.setObjectiveCalibratedMagnification(calibratedMagnification, instrumentIndex, objectiveIndex);
    }

    public void setObjectiveCorrection(Correction correction, int instrumentIndex, int objectiveIndex) {
        this.store.setObjectiveCorrection(correction, instrumentIndex, objectiveIndex);
    }

    public void setObjectiveID(String id, int instrumentIndex, int objectiveIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setObjectiveID(id, instrumentIndex, objectiveIndex);
    }

    public void setObjectiveImmersion(Immersion immersion, int instrumentIndex, int objectiveIndex) {
        this.store.setObjectiveImmersion(immersion, instrumentIndex, objectiveIndex);
    }

    public void setObjectiveIris(Boolean iris, int instrumentIndex, int objectiveIndex) {
        this.store.setObjectiveIris(iris, instrumentIndex, objectiveIndex);
    }

    public void setObjectiveLensNA(Double lensNA, int instrumentIndex, int objectiveIndex) {
        this.store.setObjectiveLensNA(lensNA, instrumentIndex, objectiveIndex);
    }

    public void setObjectiveLotNumber(String lotNumber, int instrumentIndex, int objectiveIndex) {
        lotNumber = this.filter ? DataTools.sanitize(lotNumber) : lotNumber;
        this.store.setObjectiveLotNumber(lotNumber, instrumentIndex, objectiveIndex);
    }

    public void setObjectiveManufacturer(String manufacturer, int instrumentIndex, int objectiveIndex) {
        manufacturer = this.filter ? DataTools.sanitize(manufacturer) : manufacturer;
        this.store.setObjectiveManufacturer(manufacturer, instrumentIndex, objectiveIndex);
    }

    public void setObjectiveModel(String model, int instrumentIndex, int objectiveIndex) {
        model = this.filter ? DataTools.sanitize(model) : model;
        this.store.setObjectiveModel(model, instrumentIndex, objectiveIndex);
    }

    public void setObjectiveNominalMagnification(PositiveInteger nominalMagnification, int instrumentIndex, int objectiveIndex) {
        this.store.setObjectiveNominalMagnification(nominalMagnification, instrumentIndex, objectiveIndex);
    }

    public void setObjectiveSerialNumber(String serialNumber, int instrumentIndex, int objectiveIndex) {
        serialNumber = this.filter ? DataTools.sanitize(serialNumber) : serialNumber;
        this.store.setObjectiveSerialNumber(serialNumber, instrumentIndex, objectiveIndex);
    }

    public void setObjectiveWorkingDistance(Double workingDistance, int instrumentIndex, int objectiveIndex) {
        this.store.setObjectiveWorkingDistance(workingDistance, instrumentIndex, objectiveIndex);
    }

    public void setImageObjectiveSettingsCorrectionCollar(Double correctionCollar, int imageIndex) {
        this.store.setImageObjectiveSettingsCorrectionCollar(correctionCollar, imageIndex);
    }

    public void setOTFObjectiveSettingsCorrectionCollar(Double correctionCollar, int instrumentIndex, int OTFIndex) {
        this.store.setOTFObjectiveSettingsCorrectionCollar(correctionCollar, instrumentIndex, OTFIndex);
    }

    public void setImageObjectiveSettingsID(String id, int imageIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setImageObjectiveSettingsID(id, imageIndex);
    }

    public void setOTFObjectiveSettingsID(String id, int instrumentIndex, int OTFIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setOTFObjectiveSettingsID(id, instrumentIndex, OTFIndex);
    }

    public void setImageObjectiveSettingsMedium(Medium medium, int imageIndex) {
        this.store.setImageObjectiveSettingsMedium(medium, imageIndex);
    }

    public void setOTFObjectiveSettingsMedium(Medium medium, int instrumentIndex, int OTFIndex) {
        this.store.setOTFObjectiveSettingsMedium(medium, instrumentIndex, OTFIndex);
    }

    public void setImageObjectiveSettingsRefractiveIndex(Double refractiveIndex, int imageIndex) {
        this.store.setImageObjectiveSettingsRefractiveIndex(refractiveIndex, imageIndex);
    }

    public void setOTFObjectiveSettingsRefractiveIndex(Double refractiveIndex, int instrumentIndex, int OTFIndex) {
        this.store.setOTFObjectiveSettingsRefractiveIndex(refractiveIndex, instrumentIndex, OTFIndex);
    }

    public void setPathDescription(String description, int ROIIndex, int shapeIndex) {
        description = this.filter ? DataTools.sanitize(description) : description;
        this.store.setPathDescription(description, ROIIndex, shapeIndex);
    }

    public void setPathFill(Integer fill, int ROIIndex, int shapeIndex) {
        this.store.setPathFill(fill, ROIIndex, shapeIndex);
    }

    public void setPathFontSize(NonNegativeInteger fontSize, int ROIIndex, int shapeIndex) {
        this.store.setPathFontSize(fontSize, ROIIndex, shapeIndex);
    }

    public void setPathID(String id, int ROIIndex, int shapeIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setPathID(id, ROIIndex, shapeIndex);
    }

    public void setPathLabel(String label, int ROIIndex, int shapeIndex) {
        label = this.filter ? DataTools.sanitize(label) : label;
        this.store.setPathLabel(label, ROIIndex, shapeIndex);
    }

    public void setPathName(String name, int ROIIndex, int shapeIndex) {
        name = this.filter ? DataTools.sanitize(name) : name;
        this.store.setPathName(name, ROIIndex, shapeIndex);
    }

    public void setPathStroke(Integer stroke, int ROIIndex, int shapeIndex) {
        this.store.setPathStroke(stroke, ROIIndex, shapeIndex);
    }

    public void setPathStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        strokeDashArray = this.filter ? DataTools.sanitize(strokeDashArray) : strokeDashArray;
        this.store.setPathStrokeDashArray(strokeDashArray, ROIIndex, shapeIndex);
    }

    public void setPathStrokeWidth(Double strokeWidth, int ROIIndex, int shapeIndex) {
        this.store.setPathStrokeWidth(strokeWidth, ROIIndex, shapeIndex);
    }

    public void setPathTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        this.store.setPathTheC(theC, ROIIndex, shapeIndex);
    }

    public void setPathTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        this.store.setPathTheT(theT, ROIIndex, shapeIndex);
    }

    public void setPathTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        this.store.setPathTheZ(theZ, ROIIndex, shapeIndex);
    }

    public void setPathTransform(String transform, int ROIIndex, int shapeIndex) {
        transform = this.filter ? DataTools.sanitize(transform) : transform;
        this.store.setPathTransform(transform, ROIIndex, shapeIndex);
    }

    public void setPathDefinition(String definition, int ROIIndex, int shapeIndex) {
        definition = this.filter ? DataTools.sanitize(definition) : definition;
        this.store.setPathDefinition(definition, ROIIndex, shapeIndex);
    }

    public void setPixelsAnnotationRef(String annotation, int imageIndex, int annotationRefIndex) {
        this.store.setPixelsAnnotationRef(annotation, imageIndex, annotationRefIndex);
    }

    public void setPixelsDimensionOrder(DimensionOrder dimensionOrder, int imageIndex) {
        this.store.setPixelsDimensionOrder(dimensionOrder, imageIndex);
    }

    public void setPixelsID(String id, int imageIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setPixelsID(id, imageIndex);
    }

    public void setPixelsPhysicalSizeX(PositiveFloat physicalSizeX, int imageIndex) {
        this.store.setPixelsPhysicalSizeX(physicalSizeX, imageIndex);
    }

    public void setPixelsPhysicalSizeY(PositiveFloat physicalSizeY, int imageIndex) {
        this.store.setPixelsPhysicalSizeY(physicalSizeY, imageIndex);
    }

    public void setPixelsPhysicalSizeZ(PositiveFloat physicalSizeZ, int imageIndex) {
        this.store.setPixelsPhysicalSizeZ(physicalSizeZ, imageIndex);
    }

    public void setPixelsSizeC(PositiveInteger sizeC, int imageIndex) {
        this.store.setPixelsSizeC(sizeC, imageIndex);
    }

    public void setPixelsSizeT(PositiveInteger sizeT, int imageIndex) {
        this.store.setPixelsSizeT(sizeT, imageIndex);
    }

    public void setPixelsSizeX(PositiveInteger sizeX, int imageIndex) {
        this.store.setPixelsSizeX(sizeX, imageIndex);
    }

    public void setPixelsSizeY(PositiveInteger sizeY, int imageIndex) {
        this.store.setPixelsSizeY(sizeY, imageIndex);
    }

    public void setPixelsSizeZ(PositiveInteger sizeZ, int imageIndex) {
        this.store.setPixelsSizeZ(sizeZ, imageIndex);
    }

    public void setPixelsTimeIncrement(Double timeIncrement, int imageIndex) {
        this.store.setPixelsTimeIncrement(timeIncrement, imageIndex);
    }

    public void setPixelsType(PixelType type, int imageIndex) {
        this.store.setPixelsType(type, imageIndex);
    }

    public void setPlaneAnnotationRef(String annotation, int imageIndex, int planeIndex, int annotationRefIndex) {
        this.store.setPlaneAnnotationRef(annotation, imageIndex, planeIndex, annotationRefIndex);
    }

    public void setPlaneDeltaT(Double deltaT, int imageIndex, int planeIndex) {
        this.store.setPlaneDeltaT(deltaT, imageIndex, planeIndex);
    }

    public void setPlaneExposureTime(Double exposureTime, int imageIndex, int planeIndex) {
        this.store.setPlaneExposureTime(exposureTime, imageIndex, planeIndex);
    }

    public void setPlaneHashSHA1(String hashSHA1, int imageIndex, int planeIndex) {
        hashSHA1 = this.filter ? DataTools.sanitize(hashSHA1) : hashSHA1;
        this.store.setPlaneHashSHA1(hashSHA1, imageIndex, planeIndex);
    }

    public void setPlanePositionX(Double positionX, int imageIndex, int planeIndex) {
        this.store.setPlanePositionX(positionX, imageIndex, planeIndex);
    }

    public void setPlanePositionY(Double positionY, int imageIndex, int planeIndex) {
        this.store.setPlanePositionY(positionY, imageIndex, planeIndex);
    }

    public void setPlanePositionZ(Double positionZ, int imageIndex, int planeIndex) {
        this.store.setPlanePositionZ(positionZ, imageIndex, planeIndex);
    }

    public void setPlaneTheC(NonNegativeInteger theC, int imageIndex, int planeIndex) {
        this.store.setPlaneTheC(theC, imageIndex, planeIndex);
    }

    public void setPlaneTheT(NonNegativeInteger theT, int imageIndex, int planeIndex) {
        this.store.setPlaneTheT(theT, imageIndex, planeIndex);
    }

    public void setPlaneTheZ(NonNegativeInteger theZ, int imageIndex, int planeIndex) {
        this.store.setPlaneTheZ(theZ, imageIndex, planeIndex);
    }

    public void setPlateAnnotationRef(String annotation, int plateIndex, int annotationRefIndex) {
        this.store.setPlateAnnotationRef(annotation, plateIndex, annotationRefIndex);
    }

    public void setPlateColumnNamingConvention(NamingConvention columnNamingConvention, int plateIndex) {
        this.store.setPlateColumnNamingConvention(columnNamingConvention, plateIndex);
    }

    public void setPlateColumns(PositiveInteger columns, int plateIndex) {
        this.store.setPlateColumns(columns, plateIndex);
    }

    public void setPlateDescription(String description, int plateIndex) {
        description = this.filter ? DataTools.sanitize(description) : description;
        this.store.setPlateDescription(description, plateIndex);
    }

    public void setPlateExternalIdentifier(String externalIdentifier, int plateIndex) {
        externalIdentifier = this.filter ? DataTools.sanitize(externalIdentifier) : externalIdentifier;
        this.store.setPlateExternalIdentifier(externalIdentifier, plateIndex);
    }

    public void setPlateID(String id, int plateIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setPlateID(id, plateIndex);
    }

    public void setPlateName(String name, int plateIndex) {
        name = this.filter ? DataTools.sanitize(name) : name;
        this.store.setPlateName(name, plateIndex);
    }

    public void setPlateRowNamingConvention(NamingConvention rowNamingConvention, int plateIndex) {
        this.store.setPlateRowNamingConvention(rowNamingConvention, plateIndex);
    }

    public void setPlateRows(PositiveInteger rows, int plateIndex) {
        this.store.setPlateRows(rows, plateIndex);
    }

    public void setPlateScreenRef(String screen, int plateIndex, int screenRefIndex) {
        this.store.setPlateScreenRef(screen, plateIndex, screenRefIndex);
    }

    public void setPlateStatus(String status, int plateIndex) {
        status = this.filter ? DataTools.sanitize(status) : status;
        this.store.setPlateStatus(status, plateIndex);
    }

    public void setPlateWellOriginX(Double wellOriginX, int plateIndex) {
        this.store.setPlateWellOriginX(wellOriginX, plateIndex);
    }

    public void setPlateWellOriginY(Double wellOriginY, int plateIndex) {
        this.store.setPlateWellOriginY(wellOriginY, plateIndex);
    }

    public void setPlateAcquisitionAnnotationRef(String annotation, int plateIndex, int plateAcquisitionIndex, int annotationRefIndex) {
        this.store.setPlateAcquisitionAnnotationRef(annotation, plateIndex, plateAcquisitionIndex, annotationRefIndex);
    }

    public void setPlateAcquisitionDescription(String description, int plateIndex, int plateAcquisitionIndex) {
        description = this.filter ? DataTools.sanitize(description) : description;
        this.store.setPlateAcquisitionDescription(description, plateIndex, plateAcquisitionIndex);
    }

    public void setPlateAcquisitionEndTime(String endTime, int plateIndex, int plateAcquisitionIndex) {
        endTime = this.filter ? DataTools.sanitize(endTime) : endTime;
        this.store.setPlateAcquisitionEndTime(endTime, plateIndex, plateAcquisitionIndex);
    }

    public void setPlateAcquisitionID(String id, int plateIndex, int plateAcquisitionIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setPlateAcquisitionID(id, plateIndex, plateAcquisitionIndex);
    }

    public void setPlateAcquisitionMaximumFieldCount(PositiveInteger maximumFieldCount, int plateIndex, int plateAcquisitionIndex) {
        this.store.setPlateAcquisitionMaximumFieldCount(maximumFieldCount, plateIndex, plateAcquisitionIndex);
    }

    public void setPlateAcquisitionName(String name, int plateIndex, int plateAcquisitionIndex) {
        name = this.filter ? DataTools.sanitize(name) : name;
        this.store.setPlateAcquisitionName(name, plateIndex, plateAcquisitionIndex);
    }

    public void setPlateAcquisitionStartTime(String startTime, int plateIndex, int plateAcquisitionIndex) {
        startTime = this.filter ? DataTools.sanitize(startTime) : startTime;
        this.store.setPlateAcquisitionStartTime(startTime, plateIndex, plateAcquisitionIndex);
    }

    public void setPlateAcquisitionWellSampleRef(String wellSample, int plateIndex, int plateAcquisitionIndex, int wellSampleRefIndex) {
        this.store.setPlateAcquisitionWellSampleRef(wellSample, plateIndex, plateAcquisitionIndex, wellSampleRefIndex);
    }

    public void setPointDescription(String description, int ROIIndex, int shapeIndex) {
        description = this.filter ? DataTools.sanitize(description) : description;
        this.store.setPointDescription(description, ROIIndex, shapeIndex);
    }

    public void setPointFill(Integer fill, int ROIIndex, int shapeIndex) {
        this.store.setPointFill(fill, ROIIndex, shapeIndex);
    }

    public void setPointFontSize(NonNegativeInteger fontSize, int ROIIndex, int shapeIndex) {
        this.store.setPointFontSize(fontSize, ROIIndex, shapeIndex);
    }

    public void setPointID(String id, int ROIIndex, int shapeIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setPointID(id, ROIIndex, shapeIndex);
    }

    public void setPointLabel(String label, int ROIIndex, int shapeIndex) {
        label = this.filter ? DataTools.sanitize(label) : label;
        this.store.setPointLabel(label, ROIIndex, shapeIndex);
    }

    public void setPointName(String name, int ROIIndex, int shapeIndex) {
        name = this.filter ? DataTools.sanitize(name) : name;
        this.store.setPointName(name, ROIIndex, shapeIndex);
    }

    public void setPointStroke(Integer stroke, int ROIIndex, int shapeIndex) {
        this.store.setPointStroke(stroke, ROIIndex, shapeIndex);
    }

    public void setPointStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        strokeDashArray = this.filter ? DataTools.sanitize(strokeDashArray) : strokeDashArray;
        this.store.setPointStrokeDashArray(strokeDashArray, ROIIndex, shapeIndex);
    }

    public void setPointStrokeWidth(Double strokeWidth, int ROIIndex, int shapeIndex) {
        this.store.setPointStrokeWidth(strokeWidth, ROIIndex, shapeIndex);
    }

    public void setPointTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        this.store.setPointTheC(theC, ROIIndex, shapeIndex);
    }

    public void setPointTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        this.store.setPointTheT(theT, ROIIndex, shapeIndex);
    }

    public void setPointTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        this.store.setPointTheZ(theZ, ROIIndex, shapeIndex);
    }

    public void setPointTransform(String transform, int ROIIndex, int shapeIndex) {
        transform = this.filter ? DataTools.sanitize(transform) : transform;
        this.store.setPointTransform(transform, ROIIndex, shapeIndex);
    }

    public void setPointX(Double x, int ROIIndex, int shapeIndex) {
        this.store.setPointX(x, ROIIndex, shapeIndex);
    }

    public void setPointY(Double y, int ROIIndex, int shapeIndex) {
        this.store.setPointY(y, ROIIndex, shapeIndex);
    }

    public void setPolylineDescription(String description, int ROIIndex, int shapeIndex) {
        description = this.filter ? DataTools.sanitize(description) : description;
        this.store.setPolylineDescription(description, ROIIndex, shapeIndex);
    }

    public void setPolylineFill(Integer fill, int ROIIndex, int shapeIndex) {
        this.store.setPolylineFill(fill, ROIIndex, shapeIndex);
    }

    public void setPolylineFontSize(NonNegativeInteger fontSize, int ROIIndex, int shapeIndex) {
        this.store.setPolylineFontSize(fontSize, ROIIndex, shapeIndex);
    }

    public void setPolylineID(String id, int ROIIndex, int shapeIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setPolylineID(id, ROIIndex, shapeIndex);
    }

    public void setPolylineLabel(String label, int ROIIndex, int shapeIndex) {
        label = this.filter ? DataTools.sanitize(label) : label;
        this.store.setPolylineLabel(label, ROIIndex, shapeIndex);
    }

    public void setPolylineName(String name, int ROIIndex, int shapeIndex) {
        name = this.filter ? DataTools.sanitize(name) : name;
        this.store.setPolylineName(name, ROIIndex, shapeIndex);
    }

    public void setPolylineStroke(Integer stroke, int ROIIndex, int shapeIndex) {
        this.store.setPolylineStroke(stroke, ROIIndex, shapeIndex);
    }

    public void setPolylineStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        strokeDashArray = this.filter ? DataTools.sanitize(strokeDashArray) : strokeDashArray;
        this.store.setPolylineStrokeDashArray(strokeDashArray, ROIIndex, shapeIndex);
    }

    public void setPolylineStrokeWidth(Double strokeWidth, int ROIIndex, int shapeIndex) {
        this.store.setPolylineStrokeWidth(strokeWidth, ROIIndex, shapeIndex);
    }

    public void setPolylineTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        this.store.setPolylineTheC(theC, ROIIndex, shapeIndex);
    }

    public void setPolylineTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        this.store.setPolylineTheT(theT, ROIIndex, shapeIndex);
    }

    public void setPolylineTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        this.store.setPolylineTheZ(theZ, ROIIndex, shapeIndex);
    }

    public void setPolylineTransform(String transform, int ROIIndex, int shapeIndex) {
        transform = this.filter ? DataTools.sanitize(transform) : transform;
        this.store.setPolylineTransform(transform, ROIIndex, shapeIndex);
    }

    public void setPolylineClosed(Boolean closed, int ROIIndex, int shapeIndex) {
        this.store.setPolylineClosed(closed, ROIIndex, shapeIndex);
    }

    public void setPolylinePoints(String points, int ROIIndex, int shapeIndex) {
        points = this.filter ? DataTools.sanitize(points) : points;
        this.store.setPolylinePoints(points, ROIIndex, shapeIndex);
    }

    public void setProjectAnnotationRef(String annotation, int projectIndex, int annotationRefIndex) {
        this.store.setProjectAnnotationRef(annotation, projectIndex, annotationRefIndex);
    }

    public void setProjectDescription(String description, int projectIndex) {
        description = this.filter ? DataTools.sanitize(description) : description;
        this.store.setProjectDescription(description, projectIndex);
    }

    public void setProjectExperimenterRef(String experimenter, int projectIndex) {
        this.store.setProjectExperimenterRef(experimenter, projectIndex);
    }

    public void setProjectGroupRef(String group, int projectIndex) {
        this.store.setProjectGroupRef(group, projectIndex);
    }

    public void setProjectID(String id, int projectIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setProjectID(id, projectIndex);
    }

    public void setProjectName(String name, int projectIndex) {
        name = this.filter ? DataTools.sanitize(name) : name;
        this.store.setProjectName(name, projectIndex);
    }

    public void setROIAnnotationRef(String annotation, int ROIIndex, int annotationRefIndex) {
        this.store.setROIAnnotationRef(annotation, ROIIndex, annotationRefIndex);
    }

    public void setROIDescription(String description, int ROIIndex) {
        description = this.filter ? DataTools.sanitize(description) : description;
        this.store.setROIDescription(description, ROIIndex);
    }

    public void setROIID(String id, int ROIIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setROIID(id, ROIIndex);
    }

    public void setROIName(String name, int ROIIndex) {
        name = this.filter ? DataTools.sanitize(name) : name;
        this.store.setROIName(name, ROIIndex);
    }

    public void setROINamespace(String namespace, int ROIIndex) {
        namespace = this.filter ? DataTools.sanitize(namespace) : namespace;
        this.store.setROINamespace(namespace, ROIIndex);
    }

    public void setReagentAnnotationRef(String annotation, int screenIndex, int reagentIndex, int annotationRefIndex) {
        this.store.setReagentAnnotationRef(annotation, screenIndex, reagentIndex, annotationRefIndex);
    }

    public void setReagentDescription(String description, int screenIndex, int reagentIndex) {
        description = this.filter ? DataTools.sanitize(description) : description;
        this.store.setReagentDescription(description, screenIndex, reagentIndex);
    }

    public void setReagentID(String id, int screenIndex, int reagentIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setReagentID(id, screenIndex, reagentIndex);
    }

    public void setReagentName(String name, int screenIndex, int reagentIndex) {
        name = this.filter ? DataTools.sanitize(name) : name;
        this.store.setReagentName(name, screenIndex, reagentIndex);
    }

    public void setReagentReagentIdentifier(String reagentIdentifier, int screenIndex, int reagentIndex) {
        reagentIdentifier = this.filter ? DataTools.sanitize(reagentIdentifier) : reagentIdentifier;
        this.store.setReagentReagentIdentifier(reagentIdentifier, screenIndex, reagentIndex);
    }

    public void setRectangleDescription(String description, int ROIIndex, int shapeIndex) {
        description = this.filter ? DataTools.sanitize(description) : description;
        this.store.setRectangleDescription(description, ROIIndex, shapeIndex);
    }

    public void setRectangleFill(Integer fill, int ROIIndex, int shapeIndex) {
        this.store.setRectangleFill(fill, ROIIndex, shapeIndex);
    }

    public void setRectangleFontSize(NonNegativeInteger fontSize, int ROIIndex, int shapeIndex) {
        this.store.setRectangleFontSize(fontSize, ROIIndex, shapeIndex);
    }

    public void setRectangleID(String id, int ROIIndex, int shapeIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setRectangleID(id, ROIIndex, shapeIndex);
    }

    public void setRectangleLabel(String label, int ROIIndex, int shapeIndex) {
        label = this.filter ? DataTools.sanitize(label) : label;
        this.store.setRectangleLabel(label, ROIIndex, shapeIndex);
    }

    public void setRectangleName(String name, int ROIIndex, int shapeIndex) {
        name = this.filter ? DataTools.sanitize(name) : name;
        this.store.setRectangleName(name, ROIIndex, shapeIndex);
    }

    public void setRectangleStroke(Integer stroke, int ROIIndex, int shapeIndex) {
        this.store.setRectangleStroke(stroke, ROIIndex, shapeIndex);
    }

    public void setRectangleStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        strokeDashArray = this.filter ? DataTools.sanitize(strokeDashArray) : strokeDashArray;
        this.store.setRectangleStrokeDashArray(strokeDashArray, ROIIndex, shapeIndex);
    }

    public void setRectangleStrokeWidth(Double strokeWidth, int ROIIndex, int shapeIndex) {
        this.store.setRectangleStrokeWidth(strokeWidth, ROIIndex, shapeIndex);
    }

    public void setRectangleTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        this.store.setRectangleTheC(theC, ROIIndex, shapeIndex);
    }

    public void setRectangleTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        this.store.setRectangleTheT(theT, ROIIndex, shapeIndex);
    }

    public void setRectangleTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        this.store.setRectangleTheZ(theZ, ROIIndex, shapeIndex);
    }

    public void setRectangleTransform(String transform, int ROIIndex, int shapeIndex) {
        transform = this.filter ? DataTools.sanitize(transform) : transform;
        this.store.setRectangleTransform(transform, ROIIndex, shapeIndex);
    }

    public void setRectangleHeight(Double height, int ROIIndex, int shapeIndex) {
        this.store.setRectangleHeight(height, ROIIndex, shapeIndex);
    }

    public void setRectangleWidth(Double width, int ROIIndex, int shapeIndex) {
        this.store.setRectangleWidth(width, ROIIndex, shapeIndex);
    }

    public void setRectangleX(Double x, int ROIIndex, int shapeIndex) {
        this.store.setRectangleX(x, ROIIndex, shapeIndex);
    }

    public void setRectangleY(Double y, int ROIIndex, int shapeIndex) {
        this.store.setRectangleY(y, ROIIndex, shapeIndex);
    }

    public void setScreenAnnotationRef(String annotation, int screenIndex, int annotationRefIndex) {
        this.store.setScreenAnnotationRef(annotation, screenIndex, annotationRefIndex);
    }

    public void setScreenDescription(String description, int screenIndex) {
        description = this.filter ? DataTools.sanitize(description) : description;
        this.store.setScreenDescription(description, screenIndex);
    }

    public void setScreenID(String id, int screenIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setScreenID(id, screenIndex);
    }

    public void setScreenName(String name, int screenIndex) {
        name = this.filter ? DataTools.sanitize(name) : name;
        this.store.setScreenName(name, screenIndex);
    }

    public void setScreenPlateRef(String plate, int screenIndex, int plateRefIndex) {
        this.store.setScreenPlateRef(plate, screenIndex, plateRefIndex);
    }

    public void setScreenProtocolDescription(String protocolDescription, int screenIndex) {
        protocolDescription = this.filter ? DataTools.sanitize(protocolDescription) : protocolDescription;
        this.store.setScreenProtocolDescription(protocolDescription, screenIndex);
    }

    public void setScreenProtocolIdentifier(String protocolIdentifier, int screenIndex) {
        protocolIdentifier = this.filter ? DataTools.sanitize(protocolIdentifier) : protocolIdentifier;
        this.store.setScreenProtocolIdentifier(protocolIdentifier, screenIndex);
    }

    public void setScreenReagentSetDescription(String reagentSetDescription, int screenIndex) {
        reagentSetDescription = this.filter ? DataTools.sanitize(reagentSetDescription) : reagentSetDescription;
        this.store.setScreenReagentSetDescription(reagentSetDescription, screenIndex);
    }

    public void setScreenReagentSetIdentifier(String reagentSetIdentifier, int screenIndex) {
        reagentSetIdentifier = this.filter ? DataTools.sanitize(reagentSetIdentifier) : reagentSetIdentifier;
        this.store.setScreenReagentSetIdentifier(reagentSetIdentifier, screenIndex);
    }

    public void setScreenType(String type, int screenIndex) {
        type = this.filter ? DataTools.sanitize(type) : type;
        this.store.setScreenType(type, screenIndex);
    }

    public void setStageLabelName(String name, int imageIndex) {
        name = this.filter ? DataTools.sanitize(name) : name;
        this.store.setStageLabelName(name, imageIndex);
    }

    public void setStageLabelX(Double x, int imageIndex) {
        this.store.setStageLabelX(x, imageIndex);
    }

    public void setStageLabelY(Double y, int imageIndex) {
        this.store.setStageLabelY(y, imageIndex);
    }

    public void setStageLabelZ(Double z, int imageIndex) {
        this.store.setStageLabelZ(z, imageIndex);
    }

    public void setTagAnnotationAnnotationRef(String annotation, int tagAnnotationIndex, int annotationRefIndex) {
        this.store.setTagAnnotationAnnotationRef(annotation, tagAnnotationIndex, annotationRefIndex);
    }

    public void setTagAnnotationDescription(String description, int tagAnnotationIndex) {
        description = this.filter ? DataTools.sanitize(description) : description;
        this.store.setTagAnnotationDescription(description, tagAnnotationIndex);
    }

    public void setTagAnnotationID(String id, int tagAnnotationIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setTagAnnotationID(id, tagAnnotationIndex);
    }

    public void setTagAnnotationNamespace(String namespace, int tagAnnotationIndex) {
        namespace = this.filter ? DataTools.sanitize(namespace) : namespace;
        this.store.setTagAnnotationNamespace(namespace, tagAnnotationIndex);
    }

    public void setTagAnnotationValue(String value, int tagAnnotationIndex) {
        value = this.filter ? DataTools.sanitize(value) : value;
        this.store.setTagAnnotationValue(value, tagAnnotationIndex);
    }

    public void setTermAnnotationAnnotationRef(String annotation, int termAnnotationIndex, int annotationRefIndex) {
        this.store.setTermAnnotationAnnotationRef(annotation, termAnnotationIndex, annotationRefIndex);
    }

    public void setTermAnnotationDescription(String description, int termAnnotationIndex) {
        description = this.filter ? DataTools.sanitize(description) : description;
        this.store.setTermAnnotationDescription(description, termAnnotationIndex);
    }

    public void setTermAnnotationID(String id, int termAnnotationIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setTermAnnotationID(id, termAnnotationIndex);
    }

    public void setTermAnnotationNamespace(String namespace, int termAnnotationIndex) {
        namespace = this.filter ? DataTools.sanitize(namespace) : namespace;
        this.store.setTermAnnotationNamespace(namespace, termAnnotationIndex);
    }

    public void setTermAnnotationValue(String value, int termAnnotationIndex) {
        value = this.filter ? DataTools.sanitize(value) : value;
        this.store.setTermAnnotationValue(value, termAnnotationIndex);
    }

    public void setTextDescription(String description, int ROIIndex, int shapeIndex) {
        description = this.filter ? DataTools.sanitize(description) : description;
        this.store.setTextDescription(description, ROIIndex, shapeIndex);
    }

    public void setTextFill(Integer fill, int ROIIndex, int shapeIndex) {
        this.store.setTextFill(fill, ROIIndex, shapeIndex);
    }

    public void setTextFontSize(NonNegativeInteger fontSize, int ROIIndex, int shapeIndex) {
        this.store.setTextFontSize(fontSize, ROIIndex, shapeIndex);
    }

    public void setTextID(String id, int ROIIndex, int shapeIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setTextID(id, ROIIndex, shapeIndex);
    }

    public void setTextLabel(String label, int ROIIndex, int shapeIndex) {
        label = this.filter ? DataTools.sanitize(label) : label;
        this.store.setTextLabel(label, ROIIndex, shapeIndex);
    }

    public void setTextName(String name, int ROIIndex, int shapeIndex) {
        name = this.filter ? DataTools.sanitize(name) : name;
        this.store.setTextName(name, ROIIndex, shapeIndex);
    }

    public void setTextStroke(Integer stroke, int ROIIndex, int shapeIndex) {
        this.store.setTextStroke(stroke, ROIIndex, shapeIndex);
    }

    public void setTextStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        strokeDashArray = this.filter ? DataTools.sanitize(strokeDashArray) : strokeDashArray;
        this.store.setTextStrokeDashArray(strokeDashArray, ROIIndex, shapeIndex);
    }

    public void setTextStrokeWidth(Double strokeWidth, int ROIIndex, int shapeIndex) {
        this.store.setTextStrokeWidth(strokeWidth, ROIIndex, shapeIndex);
    }

    public void setTextTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        this.store.setTextTheC(theC, ROIIndex, shapeIndex);
    }

    public void setTextTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        this.store.setTextTheT(theT, ROIIndex, shapeIndex);
    }

    public void setTextTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        this.store.setTextTheZ(theZ, ROIIndex, shapeIndex);
    }

    public void setTextTransform(String transform, int ROIIndex, int shapeIndex) {
        transform = this.filter ? DataTools.sanitize(transform) : transform;
        this.store.setTextTransform(transform, ROIIndex, shapeIndex);
    }

    public void setTextValue(String value, int ROIIndex, int shapeIndex) {
        value = this.filter ? DataTools.sanitize(value) : value;
        this.store.setTextValue(value, ROIIndex, shapeIndex);
    }

    public void setTextX(Double x, int ROIIndex, int shapeIndex) {
        this.store.setTextX(x, ROIIndex, shapeIndex);
    }

    public void setTextY(Double y, int ROIIndex, int shapeIndex) {
        this.store.setTextY(y, ROIIndex, shapeIndex);
    }

    public void setTiffDataFirstC(NonNegativeInteger firstC, int imageIndex, int tiffDataIndex) {
        this.store.setTiffDataFirstC(firstC, imageIndex, tiffDataIndex);
    }

    public void setTiffDataFirstT(NonNegativeInteger firstT, int imageIndex, int tiffDataIndex) {
        this.store.setTiffDataFirstT(firstT, imageIndex, tiffDataIndex);
    }

    public void setTiffDataFirstZ(NonNegativeInteger firstZ, int imageIndex, int tiffDataIndex) {
        this.store.setTiffDataFirstZ(firstZ, imageIndex, tiffDataIndex);
    }

    public void setTiffDataIFD(NonNegativeInteger ifd, int imageIndex, int tiffDataIndex) {
        this.store.setTiffDataIFD(ifd, imageIndex, tiffDataIndex);
    }

    public void setTiffDataPlaneCount(NonNegativeInteger planeCount, int imageIndex, int tiffDataIndex) {
        this.store.setTiffDataPlaneCount(planeCount, imageIndex, tiffDataIndex);
    }

    public void setTimestampAnnotationAnnotationRef(String annotation, int timestampAnnotationIndex, int annotationRefIndex) {
        this.store.setTimestampAnnotationAnnotationRef(annotation, timestampAnnotationIndex, annotationRefIndex);
    }

    public void setTimestampAnnotationDescription(String description, int timestampAnnotationIndex) {
        description = this.filter ? DataTools.sanitize(description) : description;
        this.store.setTimestampAnnotationDescription(description, timestampAnnotationIndex);
    }

    public void setTimestampAnnotationID(String id, int timestampAnnotationIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setTimestampAnnotationID(id, timestampAnnotationIndex);
    }

    public void setTimestampAnnotationNamespace(String namespace, int timestampAnnotationIndex) {
        namespace = this.filter ? DataTools.sanitize(namespace) : namespace;
        this.store.setTimestampAnnotationNamespace(namespace, timestampAnnotationIndex);
    }

    public void setTimestampAnnotationValue(String value, int timestampAnnotationIndex) {
        value = this.filter ? DataTools.sanitize(value) : value;
        this.store.setTimestampAnnotationValue(value, timestampAnnotationIndex);
    }

    public void setTransmittanceRangeCutIn(PositiveInteger cutIn, int instrumentIndex, int filterIndex) {
        this.store.setTransmittanceRangeCutIn(cutIn, instrumentIndex, filterIndex);
    }

    public void setTransmittanceRangeCutInTolerance(NonNegativeInteger cutInTolerance, int instrumentIndex, int filterIndex) {
        this.store.setTransmittanceRangeCutInTolerance(cutInTolerance, instrumentIndex, filterIndex);
    }

    public void setTransmittanceRangeCutOut(PositiveInteger cutOut, int instrumentIndex, int filterIndex) {
        this.store.setTransmittanceRangeCutOut(cutOut, instrumentIndex, filterIndex);
    }

    public void setTransmittanceRangeCutOutTolerance(NonNegativeInteger cutOutTolerance, int instrumentIndex, int filterIndex) {
        this.store.setTransmittanceRangeCutOutTolerance(cutOutTolerance, instrumentIndex, filterIndex);
    }

    public void setTransmittanceRangeTransmittance(PercentFraction transmittance, int instrumentIndex, int filterIndex) {
        this.store.setTransmittanceRangeTransmittance(transmittance, instrumentIndex, filterIndex);
    }

    public void setUUIDValue(String value, int imageIndex, int tiffDataIndex) {
        value = this.filter ? DataTools.sanitize(value) : value;
        this.store.setUUIDValue(value, imageIndex, tiffDataIndex);
    }

    public void setUUIDFileName(String fileName, int imageIndex, int tiffDataIndex) {
        fileName = this.filter ? DataTools.sanitize(fileName) : fileName;
        this.store.setUUIDFileName(fileName, imageIndex, tiffDataIndex);
    }

    public void setWellAnnotationRef(String annotation, int plateIndex, int wellIndex, int annotationRefIndex) {
        this.store.setWellAnnotationRef(annotation, plateIndex, wellIndex, annotationRefIndex);
    }

    public void setWellColor(Integer color, int plateIndex, int wellIndex) {
        this.store.setWellColor(color, plateIndex, wellIndex);
    }

    public void setWellColumn(NonNegativeInteger column, int plateIndex, int wellIndex) {
        this.store.setWellColumn(column, plateIndex, wellIndex);
    }

    public void setWellExternalDescription(String externalDescription, int plateIndex, int wellIndex) {
        externalDescription = this.filter ? DataTools.sanitize(externalDescription) : externalDescription;
        this.store.setWellExternalDescription(externalDescription, plateIndex, wellIndex);
    }

    public void setWellExternalIdentifier(String externalIdentifier, int plateIndex, int wellIndex) {
        externalIdentifier = this.filter ? DataTools.sanitize(externalIdentifier) : externalIdentifier;
        this.store.setWellExternalIdentifier(externalIdentifier, plateIndex, wellIndex);
    }

    public void setWellID(String id, int plateIndex, int wellIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setWellID(id, plateIndex, wellIndex);
    }

    public void setWellReagentRef(String reagent, int plateIndex, int wellIndex) {
        this.store.setWellReagentRef(reagent, plateIndex, wellIndex);
    }

    public void setWellRow(NonNegativeInteger row, int plateIndex, int wellIndex) {
        this.store.setWellRow(row, plateIndex, wellIndex);
    }

    public void setWellStatus(String status, int plateIndex, int wellIndex) {
        status = this.filter ? DataTools.sanitize(status) : status;
        this.store.setWellStatus(status, plateIndex, wellIndex);
    }

    public void setWellSampleAnnotationRef(String annotation, int plateIndex, int wellIndex, int wellSampleIndex, int annotationRefIndex) {
        this.store.setWellSampleAnnotationRef(annotation, plateIndex, wellIndex, wellSampleIndex, annotationRefIndex);
    }

    public void setWellSampleID(String id, int plateIndex, int wellIndex, int wellSampleIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setWellSampleID(id, plateIndex, wellIndex, wellSampleIndex);
    }

    public void setWellSampleImageRef(String image, int plateIndex, int wellIndex, int wellSampleIndex) {
        this.store.setWellSampleImageRef(image, plateIndex, wellIndex, wellSampleIndex);
    }

    public void setWellSampleIndex(NonNegativeInteger index, int plateIndex, int wellIndex, int wellSampleIndex) {
        this.store.setWellSampleIndex(index, plateIndex, wellIndex, wellSampleIndex);
    }

    public void setWellSamplePositionX(Double positionX, int plateIndex, int wellIndex, int wellSampleIndex) {
        this.store.setWellSamplePositionX(positionX, plateIndex, wellIndex, wellSampleIndex);
    }

    public void setWellSamplePositionY(Double positionY, int plateIndex, int wellIndex, int wellSampleIndex) {
        this.store.setWellSamplePositionY(positionY, plateIndex, wellIndex, wellSampleIndex);
    }

    public void setWellSampleTimepoint(String timepoint, int plateIndex, int wellIndex, int wellSampleIndex) {
        timepoint = this.filter ? DataTools.sanitize(timepoint) : timepoint;
        this.store.setWellSampleTimepoint(timepoint, plateIndex, wellIndex, wellSampleIndex);
    }

    public void setXMLAnnotationAnnotationRef(String annotation, int XMLAnnotationIndex, int annotationRefIndex) {
        this.store.setXMLAnnotationAnnotationRef(annotation, XMLAnnotationIndex, annotationRefIndex);
    }

    public void setXMLAnnotationDescription(String description, int XMLAnnotationIndex) {
        description = this.filter ? DataTools.sanitize(description) : description;
        this.store.setXMLAnnotationDescription(description, XMLAnnotationIndex);
    }

    public void setXMLAnnotationID(String id, int XMLAnnotationIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setXMLAnnotationID(id, XMLAnnotationIndex);
    }

    public void setXMLAnnotationNamespace(String namespace, int XMLAnnotationIndex) {
        namespace = this.filter ? DataTools.sanitize(namespace) : namespace;
        this.store.setXMLAnnotationNamespace(namespace, XMLAnnotationIndex);
    }

    public void setXMLAnnotationValue(String value, int XMLAnnotationIndex) {
        value = this.filter ? DataTools.sanitize(value) : value;
        this.store.setXMLAnnotationValue(value, XMLAnnotationIndex);
    }
}

