/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.util;

import ij.Prefs;
import ij.gui.GenericDialog;
import loci.formats.FormatException;

public final class LuraWave {
    private LuraWave() {
    }

    public static String initLicenseCode() {
        String code = Prefs.get((String)"lurawave.license", null);
        if (code != null) {
            System.setProperty("lurawave.license", code);
        }
        return code;
    }

    public static boolean isLicenseCodeException(FormatException exc) {
        String msg = exc == null ? null : exc.getMessage();
        return msg != null && (msg.equals("No LuraWave license code was specified.\r\nPlease set one in the lurawave.license system property (e.g., with -Dlurawave.license=XXXX from the command line).") || msg.startsWith("Invalid license code: "));
    }

    public static String promptLicenseCode(String code, boolean first) {
        GenericDialog gd = new GenericDialog("LuraWave License Code");
        if (!first) {
            gd.addMessage("Invalid license code; try again.");
        }
        gd.addStringField("LuraWave_License Code: ", code, 16);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return null;
        }
        code = gd.getNextString();
        if (code != null) {
            Prefs.set((String)"lurawave.license", (String)code);
        }
        return code;
    }
}

