/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.codec.ZlibCodec;
import loci.formats.meta.FilterMetadata;

public class CellomicsReader
extends FormatReader {
    public static final int C01_MAGIC_BYTES = 16;

    public CellomicsReader() {
        super("Cellomics C01", new String[]{"c01", "dib"});
        this.domains = new String[]{"Light Microscopy", "High-Content Screening (HCS)"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 4;
        if (!FormatTools.validStream(stream, 4, false)) {
            return false;
        }
        return stream.readInt() == 16;
    }

    public String[] getDomains() {
        FormatTools.assertId(this.currentId, true, 1);
        return new String[]{"Light Microscopy"};
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int planeSize = FormatTools.getPlaneSize(this);
        this.in.seek(52 + no * planeSize);
        this.readPlane(this.in, x, y, w, h, buf);
        return buf;
    }

    protected void initFile(String id) throws FormatException, IOException {
        this.debug("CellomicsReader.initFile(" + id + ")");
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        if (CellomicsReader.checkSuffix(id, "c01")) {
            this.status("Decompressing file");
            this.in.seek(4L);
            ZlibCodec codec = new ZlibCodec();
            byte[] file2 = codec.decompress(this.in, null);
            this.in.close();
            this.in = new RandomAccessInputStream(file2);
        }
        this.status("Reading header data");
        this.in.order(true);
        this.in.skipBytes(4);
        int x = this.in.readInt();
        int y = this.in.readInt();
        short nPlanes = this.in.readShort();
        short nBits = this.in.readShort();
        int compression = this.in.readInt();
        if ((long)(x * y * nPlanes * (nBits / 8) + 52) > this.in.length()) {
            throw new FormatException("Compressed pixel data is not yet supported.");
        }
        this.in.skipBytes(4);
        int pixelWidth = this.in.readInt();
        int pixelHeight = this.in.readInt();
        int colorUsed = this.in.readInt();
        int colorImportant = this.in.readInt();
        this.status("Populating metadata hashtable");
        this.addGlobalMeta("Image width", x);
        this.addGlobalMeta("Image height", y);
        this.addGlobalMeta("Number of planes", (int)nPlanes);
        this.addGlobalMeta("Bits per pixel", (int)nBits);
        this.addGlobalMeta("Compression", compression);
        this.addGlobalMeta("Pixels per meter (X)", pixelWidth);
        this.addGlobalMeta("Pixels per meter (Y)", pixelHeight);
        this.addGlobalMeta("Color used", colorUsed);
        this.addGlobalMeta("Color important", colorImportant);
        this.status("Populating core metadata");
        this.core[0].sizeX = x;
        this.core[0].sizeY = y;
        this.core[0].sizeZ = nPlanes;
        this.core[0].sizeT = 1;
        this.core[0].sizeC = 1;
        this.core[0].imageCount = this.getSizeZ();
        this.core[0].littleEndian = true;
        this.core[0].dimensionOrder = "XYCZT";
        switch (nBits) {
            case 8: {
                this.core[0].pixelType = 1;
                break;
            }
            case 16: {
                this.core[0].pixelType = 3;
                break;
            }
            default: {
                throw new FormatException("Unsupported bits per pixel: " + nBits);
            }
        }
        this.status("Populating metadata store");
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this);
        MetadataTools.setDefaultCreationDate(store, id, 0);
        float width = pixelWidth == 0 ? 0.0f : 1000000.0f / (float)pixelWidth;
        float height = pixelHeight == 0 ? 0.0f : 1000000.0f / (float)pixelHeight;
        store.setDimensionsPhysicalSizeX(new Float(width), 0, 0);
        store.setDimensionsPhysicalSizeY(new Float(height), 0, 0);
    }
}

