/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.io.IOException;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ImageTools;
import loci.formats.ReaderWrapper;

public class ChannelSeparator
extends ReaderWrapper {
    private byte[] lastImage;
    private int lastImageIndex = -1;
    private int lastImageSeries = -1;
    private int lastImageX = -1;
    private int lastImageY = -1;
    private int lastImageWidth = -1;
    private int lastImageHeight = -1;

    public static ChannelSeparator makeChannelSeparator(IFormatReader r) {
        if (r instanceof ChannelSeparator) {
            return (ChannelSeparator)r;
        }
        return new ChannelSeparator(r);
    }

    public ChannelSeparator() {
    }

    public ChannelSeparator(IFormatReader r) {
        super(r);
    }

    public int getOriginalIndex(int no) throws FormatException, IOException {
        int originalCount;
        int imageCount = this.getImageCount();
        if (imageCount == (originalCount = this.reader.getImageCount())) {
            return no;
        }
        int[] coords = this.getZCTCoords(no);
        coords[1] = coords[1] / this.reader.getRGBChannelCount();
        return this.reader.getIndex(coords[0], coords[1], coords[2]);
    }

    public int getImageCount() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return this.reader.isRGB() && !this.reader.isIndexed() ? this.reader.getRGBChannelCount() * this.reader.getImageCount() : this.reader.getImageCount();
    }

    public String getDimensionOrder() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        String order = super.getDimensionOrder();
        if (this.reader.isRGB() && !this.reader.isIndexed()) {
            String newOrder = "XYC";
            newOrder = order.indexOf("Z") > order.indexOf("T") ? newOrder + "TZ" : newOrder + "ZT";
            return newOrder;
        }
        return order;
    }

    public boolean isRGB() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return this.isIndexed() && !this.isFalseColor();
    }

    public byte[] openBytes(int no) throws FormatException, IOException {
        return this.openBytes(no, 0, 0, this.getSizeX(), this.getSizeY());
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        return this.openBytes(no, buf, 0, 0, this.getSizeX(), this.getSizeY());
    }

    public byte[] openBytes(int no, int x, int y, int w, int h) throws FormatException, IOException {
        byte[] buf = new byte[w * h * FormatTools.getBytesPerPixel(this.getPixelType())];
        return this.openBytes(no, buf, x, y, w, h);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        FormatTools.checkPlaneNumber(this, no);
        if (this.reader.isRGB() && !this.reader.isIndexed()) {
            int c = this.getSizeC() / this.reader.getEffectiveSizeC();
            int source = no / c;
            int channel = no % c;
            int series = this.getSeries();
            if (source != this.lastImageIndex || series != this.lastImageSeries || x != this.lastImageX || y != this.lastImageY || w != this.lastImageWidth || h != this.lastImageHeight) {
                this.lastImage = this.reader.openBytes(source, x, y, w, h);
                this.lastImageIndex = source;
                this.lastImageSeries = series;
                this.lastImageX = x;
                this.lastImageY = y;
                this.lastImageWidth = w;
                this.lastImageHeight = h;
            }
            ImageTools.splitChannels(this.lastImage, buf, channel, c, FormatTools.getBytesPerPixel(this.getPixelType()), false, this.isInterleaved());
            return buf;
        }
        return this.reader.openBytes(no, buf, x, y, w, h);
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.lastImage = null;
            this.lastImageIndex = -1;
            this.lastImageSeries = -1;
            this.lastImageX = -1;
            this.lastImageY = -1;
            this.lastImageWidth = -1;
            this.lastImageHeight = -1;
        }
    }

    public int getIndex(int z, int c, int t) {
        return FormatTools.getIndex(this, z, c, t);
    }

    public int[] getZCTCoords(int index) {
        return FormatTools.getZCTCoords(this, index);
    }

    public void setId(String id) throws FormatException, IOException {
        super.setId(id);
        this.lastImage = null;
        this.lastImageIndex = -1;
        this.lastImageSeries = -1;
        this.lastImageX = -1;
        this.lastImageY = -1;
        this.lastImageWidth = -1;
        this.lastImageHeight = -1;
    }
}

