/*
 * Decompiled with CFR 0.152.
 */
package bioformatsconverter;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.StringTokenizer;
import loci.formats.ChannelSeparator;
import loci.formats.ClassList;
import loci.formats.FormatException;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.MetadataTools;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.out.APNGWriter;
import loci.formats.out.OMETiffWriter;

public class Main {
    private static boolean imageopen = false;
    private static String filename = "";
    private static boolean collectmeta = true;
    private static boolean collectmetaorig = false;
    private static boolean filtermeta = true;
    private static int savemode = 0;
    private static int stackmode = 0;

    public static void progress(int i, int size) {
        float prog = (float)(i + 1) / (float)size * 100.0f;
        prog = Main.Round(prog, 2);
        System.out.print("\r\r      Progress = " + prog + " %");
        if ((double)prog == 100.0) {
            System.out.println("\n");
        }
    }

    public static float Round(float Rval, int Rpl) {
        float p = (float)Math.pow(10.0, Rpl);
        float tmp = Math.round(Rval *= p);
        return tmp / p;
    }

    public static void saveImageToOMETIFF(String in_fn, String out_dn) throws Exception {
        if (in_fn.length() == 0) {
            System.out.println("\nERROR: Input filename is NULL!\n");
            return;
        }
        if (out_dn.length() == 0) {
            System.out.println("\nERROR: Output dirname is NULL!\n");
            return;
        }
        IMetadata meta = MetadataTools.createOMEXMLMetadata();
        ClassList defaultClasses = new ClassList("readers.txt", IFormatReader.class);
        IFormatReader myimagereader = new ImageReader(defaultClasses);
        myimagereader.setMetadataCollected(collectmeta);
        myimagereader.setOriginalMetadataPopulated(collectmetaorig);
        myimagereader.setMetadataFiltered(filtermeta);
        myimagereader.setMetadataStore(meta);
        myimagereader = new ChannelSeparator(myimagereader);
        myimagereader.setId(in_fn);
        MetadataStore metarestore = myimagereader.getMetadataStore();
        MetadataRetrieve metaretrieve = (MetadataRetrieve)((Object)metarestore);
        int index = in_fn.lastIndexOf("/");
        String infilname = index != -1 ? in_fn.substring(index + 1, in_fn.length()) : in_fn;
        infilname = infilname.replace('.', '_');
        System.out.println("Number of Images in Current File: " + myimagereader.getSeriesCount() + "\n");
        int series = myimagereader.getSeriesCount();
        for (int s = 0; s < series; ++s) {
            boolean eofiles = false;
            int i = 0;
            myimagereader.setSeries(s);
            metarestore = myimagereader.getMetadataStore();
            metaretrieve = (MetadataRetrieve)((Object)metarestore);
            int sdigits = Integer.toString(s).length();
            String snumb = Integer.toString(s);
            if (sdigits == 1) {
                snumb = "S00" + snumb;
            } else if (sdigits == 2) {
                snumb = "S0" + snumb;
            }
            int numbimgs = myimagereader.getImageCount();
            int xres = metaretrieve.getPixelsSizeX(s, 0);
            int yres = metaretrieve.getPixelsSizeY(s, 0);
            int zres = metaretrieve.getPixelsSizeZ(s, 0);
            int cres = metaretrieve.getPixelsSizeC(s, 0);
            int tres = metaretrieve.getPixelsSizeT(s, 0);
            float zsize = 0.0f;
            float ysize = 0.0f;
            float xsize = 0.0f;
            if (metaretrieve.getDimensionsPhysicalSizeX(s, 0) != null) {
                xsize = metaretrieve.getDimensionsPhysicalSizeX(s, 0).floatValue();
            }
            ysize = metaretrieve.getDimensionsPhysicalSizeY(s, 0) != null ? metaretrieve.getDimensionsPhysicalSizeY(s, 0).floatValue() : xsize;
            if (metaretrieve.getDimensionsPhysicalSizeZ(s, 0) != null) {
                zsize = metaretrieve.getDimensionsPhysicalSizeZ(s, 0).floatValue();
            }
            String dimorder = myimagereader.getDimensionOrder();
            System.out.println("    Series: Image " + (s + 1) + " of " + series);
            System.out.println("    =============================================");
            System.out.println("    Image INFO:");
            System.out.println("    (" + xres + "," + yres + "," + zres + ") (" + cres + "," + tres + ")");
            System.out.println("    Number of images to save: " + numbimgs);
            System.out.println("    Dimensions Order: " + dimorder);
            System.out.println("    (voxel size) X: " + xsize + " Y: " + ysize + " Z: " + zsize);
            System.out.println("    TimeStart: (sec) " + metaretrieve.getImageCreationDate(s));
            System.out.println("    TimeStep: (sec) " + metaretrieve.getDimensionsTimeIncrement(s, 0));
            System.out.println("    =============================================");
            System.out.println("    Saving to OME-TIFF...");
            for (int t = 0; t < tres; ++t) {
                int tdigits = Integer.toString(t).length();
                String tnumb = Integer.toString(t);
                if (tdigits == 1) {
                    tnumb = "00" + tnumb;
                } else if (tdigits == 2) {
                    tnumb = "0" + tnumb;
                }
                String timeoutdirname = out_dn + snumb + "_T" + tnumb + "/";
                new File(timeoutdirname).mkdir();
                for (int z = 0; z < zres; ++z) {
                    int zdigits = Integer.toString(z).length();
                    String znumb = Integer.toString(z);
                    if (zdigits == 1) {
                        znumb = "00" + znumb;
                    } else if (zdigits == 2) {
                        znumb = "0" + znumb;
                    }
                    Main.progress(z, zres);
                    for (int c = 0; c < cres; ++c) {
                        int cdigits = Integer.toString(c).length();
                        String cnumb = Integer.toString(c);
                        if (cdigits == 1) {
                            cnumb = "00" + cnumb;
                        } else if (cdigits == 2) {
                            cnumb = "0" + cnumb;
                        }
                        String channeloutdirname = timeoutdirname + "C" + cnumb + "/";
                        new File(channeloutdirname).mkdir();
                        String savefilename = channeloutdirname + infilname + "_T" + tnumb + "_Z" + znumb + "_C" + cnumb + ".tif";
                        eofiles = false;
                        if (i == numbimgs - 1) {
                            eofiles = true;
                        }
                        byte[] imagebytes = myimagereader.openBytes(myimagereader.getIndex(z, c, t));
                        if (z == 0) {
                            FileWriter fstream = new FileWriter(channeloutdirname + "voxelscale.txt");
                            BufferedWriter out = new BufferedWriter(fstream);
                            out.write("x " + metaretrieve.getDimensionsPhysicalSizeX(s, 0));
                            out.newLine();
                            out.write("y " + metaretrieve.getDimensionsPhysicalSizeY(s, 0));
                            out.newLine();
                            out.write("z " + metaretrieve.getDimensionsPhysicalSizeZ(s, 0));
                            out.newLine();
                            out.close();
                            fstream = new FileWriter(channeloutdirname + "voxelspacing.txt");
                            out = new BufferedWriter(fstream);
                            out.write("x " + metaretrieve.getDimensionsPhysicalSizeX(s, 0));
                            out.newLine();
                            out.write("y " + metaretrieve.getDimensionsPhysicalSizeY(s, 0));
                            out.newLine();
                            out.write("z " + metaretrieve.getDimensionsPhysicalSizeZ(s, 0));
                            out.newLine();
                            out.close();
                        }
                        metarestore.setPixelsSizeX(xres, 0, 0);
                        metarestore.setPixelsSizeY(yres, 0, 0);
                        metarestore.setPixelsSizeZ(1, 0, 0);
                        metarestore.setPixelsSizeC(1, 0, 0);
                        metarestore.setPixelsSizeT(1, 0, 0);
                        metarestore.setDimensionsPhysicalSizeX(Double.valueOf(xsize), 0, 0);
                        metarestore.setDimensionsPhysicalSizeY(Double.valueOf(ysize), 0, 0);
                        metarestore.setDimensionsPhysicalSizeZ(Double.valueOf(zsize), 0, 0);
                        OMETiffWriter ometiffwriter = new OMETiffWriter();
                        ometiffwriter.setMetadataRetrieve((MetadataRetrieve)((Object)metarestore));
                        ometiffwriter.setId(savefilename);
                        ometiffwriter.saveBytes(imagebytes, true);
                        ++i;
                    }
                }
            }
        }
    }

    public static void saveImageToOMETIFF_Zstack(String in_fn, String out_dn) throws Exception {
        if (in_fn.length() == 0) {
            System.out.println("\nERROR: Input filename is NULL!\n");
            return;
        }
        if (out_dn.length() == 0) {
            System.out.println("\nERROR: Output dirname is NULL!\n");
            return;
        }
        IMetadata meta = MetadataTools.createOMEXMLMetadata();
        ClassList defaultClasses = new ClassList("readers.txt", IFormatReader.class);
        System.out.println("Loading file: " + in_fn);
        IFormatReader myimagereader = new ImageReader(defaultClasses);
        myimagereader.setMetadataCollected(collectmeta);
        myimagereader.setOriginalMetadataPopulated(collectmetaorig);
        myimagereader.setMetadataFiltered(filtermeta);
        myimagereader.setMetadataStore(meta);
        myimagereader = new ChannelSeparator(myimagereader);
        try {
            myimagereader.setId(in_fn);
        }
        catch (FormatException exc) {
            System.out.println(exc.toString());
            exc.printStackTrace();
        }
        catch (IOException exc) {
            System.out.println(exc.toString());
            exc.printStackTrace();
        }
        MetadataStore metarestore = myimagereader.getMetadataStore();
        MetadataRetrieve metaretrieve = (MetadataRetrieve)((Object)metarestore);
        int index = in_fn.lastIndexOf("/");
        String infilname = index != -1 ? in_fn.substring(index + 1, in_fn.length()) : in_fn;
        infilname = infilname.replace('.', '_');
        System.out.println("Number of Images in Current File: " + myimagereader.getSeriesCount() + "\n");
        int series = myimagereader.getSeriesCount();
        for (int s = 0; s < series; ++s) {
            boolean eostack = false;
            int i = 0;
            myimagereader.setSeries(s);
            metarestore = myimagereader.getMetadataStore();
            metaretrieve = (MetadataRetrieve)((Object)metarestore);
            int sdigits = Integer.toString(s).length();
            String snumb = Integer.toString(s);
            if (sdigits == 1) {
                snumb = "S00" + snumb;
            } else if (sdigits == 2) {
                snumb = "S0" + snumb;
            }
            int numbimgs = myimagereader.getImageCount();
            int xres = metaretrieve.getPixelsSizeX(s, 0);
            int yres = metaretrieve.getPixelsSizeY(s, 0);
            int zres = metaretrieve.getPixelsSizeZ(s, 0);
            int cres = metaretrieve.getPixelsSizeC(s, 0);
            int tres = metaretrieve.getPixelsSizeT(s, 0);
            float zsize = 0.0f;
            float ysize = 0.0f;
            float xsize = 0.0f;
            if (metaretrieve.getDimensionsPhysicalSizeX(s, 0).floatValue() != 0.0f) {
                xsize = metaretrieve.getDimensionsPhysicalSizeX(s, 0).floatValue();
            }
            ysize = metaretrieve.getDimensionsPhysicalSizeY(s, 0).floatValue() != 0.0f ? metaretrieve.getDimensionsPhysicalSizeY(s, 0).floatValue() : xsize;
            if (metaretrieve.getDimensionsPhysicalSizeZ(s, 0).floatValue() != 0.0f) {
                zsize = metaretrieve.getDimensionsPhysicalSizeZ(s, 0).floatValue();
            }
            String dimorder = myimagereader.getDimensionOrder();
            System.out.println("    Series: Image " + (s + 1) + " of " + series);
            System.out.println("    =============================================");
            System.out.println("    Image INFO:");
            System.out.println("    (" + xres + "," + yres + "," + zres + ") (" + cres + "," + tres + ")");
            System.out.println("    Number of images to save: " + numbimgs);
            System.out.println("    Dimensions Order: " + dimorder);
            System.out.println("    (voxel size) X: " + xsize + " Y: " + ysize + " Z: " + zsize);
            System.out.println("    TimeStart: (sec) " + metaretrieve.getImageCreationDate(0));
            System.out.println("    TimeStep: (sec) " + metaretrieve.getDimensionsTimeIncrement(s, 0));
            System.out.println("    =============================================");
            System.out.println("    Saving to OME-TIFF...");
            for (int t = 0; t < tres; ++t) {
                int tdigits = Integer.toString(t).length();
                String tnumb = Integer.toString(t);
                if (tdigits == 1) {
                    tnumb = "T00" + tnumb;
                } else if (tdigits == 2) {
                    tnumb = "T0" + tnumb;
                }
                for (int c = 0; c < cres; ++c) {
                    int cdigits = Integer.toString(c).length();
                    String cnumb = Integer.toString(c);
                    if (cdigits == 1) {
                        cnumb = "C00" + cnumb;
                    } else if (cdigits == 2) {
                        cnumb = "C0" + cnumb;
                    }
                    String savefilename = out_dn + snumb + "_" + tnumb + "_" + cnumb + "_" + infilname + ".tiff";
                    metarestore.setPixelsSizeX(xres, 0, 0);
                    metarestore.setPixelsSizeY(yres, 0, 0);
                    metarestore.setPixelsSizeZ(zres, 0, 0);
                    metarestore.setPixelsSizeC(1, 0, 0);
                    metarestore.setPixelsSizeT(1, 0, 0);
                    metarestore.setDimensionsPhysicalSizeX(Double.valueOf(xsize), 0, 0);
                    metarestore.setDimensionsPhysicalSizeY(Double.valueOf(ysize), 0, 0);
                    metarestore.setDimensionsPhysicalSizeZ(Double.valueOf(zsize), 0, 0);
                    OMETiffWriter ometiffwriter = new OMETiffWriter();
                    ometiffwriter.setMetadataRetrieve((MetadataRetrieve)((Object)metarestore));
                    ometiffwriter.setId(savefilename);
                    for (int z = 0; z < zres; ++z) {
                        Main.progress(i, numbimgs);
                        eostack = false;
                        if (z == zres - 1) {
                            eostack = true;
                        }
                        byte[] imagebytes = myimagereader.openBytes(myimagereader.getIndex(z, c, t));
                        ometiffwriter.saveBytes(imagebytes, eostack);
                        ++i;
                    }
                }
            }
        }
    }

    public static void saveImageToOMETIFF_ZCstack(String in_fn, String out_dn) throws Exception {
        if (in_fn.length() == 0) {
            System.out.println("\nERROR: Input filename is NULL!\n");
            return;
        }
        if (out_dn.length() == 0) {
            System.out.println("\nERROR: Output dirname is NULL!\n");
            return;
        }
        IMetadata meta = MetadataTools.createOMEXMLMetadata();
        ClassList defaultClasses = new ClassList("readers.txt", IFormatReader.class);
        IFormatReader myimagereader = new ImageReader(defaultClasses);
        myimagereader.setMetadataCollected(collectmeta);
        myimagereader.setOriginalMetadataPopulated(collectmetaorig);
        myimagereader.setMetadataFiltered(filtermeta);
        myimagereader.setMetadataStore(meta);
        myimagereader = new ChannelSeparator(myimagereader);
        try {
            myimagereader.setId(in_fn);
        }
        catch (FormatException exc) {
            exc.printStackTrace();
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
        MetadataStore metarestore = myimagereader.getMetadataStore();
        MetadataRetrieve metaretrieve = (MetadataRetrieve)((Object)metarestore);
        System.out.println("Number of Images in Current File: " + myimagereader.getSeriesCount() + "\n");
        int series = myimagereader.getSeriesCount();
        int index = in_fn.lastIndexOf("/");
        String infilname = index != -1 ? in_fn.substring(index + 1, in_fn.length()) : in_fn;
        infilname = infilname.replace('.', '_');
        for (int s = 0; s < series; ++s) {
            boolean eostack = false;
            int i = 0;
            myimagereader.setSeries(s);
            metarestore = myimagereader.getMetadataStore();
            metaretrieve = (MetadataRetrieve)((Object)metarestore);
            int sdigits = Integer.toString(s).length();
            String snumb = Integer.toString(s);
            if (sdigits == 1) {
                snumb = "S00" + snumb;
            } else if (sdigits == 2) {
                snumb = "S0" + snumb;
            }
            int numbimgs = myimagereader.getImageCount();
            int xres = metaretrieve.getPixelsSizeX(s, 0);
            int yres = metaretrieve.getPixelsSizeY(s, 0);
            int zres = metaretrieve.getPixelsSizeZ(s, 0);
            int cres = metaretrieve.getPixelsSizeC(s, 0);
            int tres = metaretrieve.getPixelsSizeT(s, 0);
            float zsize = 0.0f;
            float ysize = 0.0f;
            float xsize = 0.0f;
            if (metaretrieve.getDimensionsPhysicalSizeX(s, 0).floatValue() != 0.0f) {
                xsize = metaretrieve.getDimensionsPhysicalSizeX(s, 0).floatValue();
            }
            ysize = metaretrieve.getDimensionsPhysicalSizeY(s, 0).floatValue() != 0.0f ? metaretrieve.getDimensionsPhysicalSizeY(s, 0).floatValue() : xsize;
            if (metaretrieve.getDimensionsPhysicalSizeZ(0, 0).floatValue() != 0.0f) {
                zsize = metaretrieve.getDimensionsPhysicalSizeZ(0, 0).floatValue();
            }
            String dimorder = myimagereader.getDimensionOrder();
            System.out.println("    Series: Image " + (s + 1) + " of " + series);
            System.out.println("    =============================================");
            System.out.println("    Image INFO:");
            System.out.println("    (" + xres + "," + yres + "," + zres + ") (" + cres + "," + tres + ")");
            System.out.println("    Number of images to save: " + numbimgs);
            System.out.println("    Dimensions Order: " + dimorder);
            System.out.println("    (voxel size) X: " + xsize + " Y: " + ysize + " Z: " + zsize);
            System.out.println("    TimeStart: (sec) " + metaretrieve.getImageCreationDate(0));
            System.out.println("    TimeStep: (sec) " + metaretrieve.getDimensionsTimeIncrement(s, 0));
            System.out.println("    =============================================");
            System.out.println("    Saving to OME-TIFF...");
            FileWriter fstream = new FileWriter(out_dn + snumb + "_metadata.txt");
            BufferedWriter out = new BufferedWriter(fstream);
            out.write("Image Dimensions (XYZ)(CT): (" + xres + "," + yres + "," + zres + ") (" + cres + "," + tres + ")");
            out.newLine();
            out.write("Voxel Physical Size X: " + xsize + " Y: " + ysize + " Z: " + zsize);
            out.newLine();
            if (metaretrieve.getImageCreationDate(0) != null) {
                out.write("TimeStart: (sec) " + metaretrieve.getImageCreationDate(0));
            }
            out.newLine();
            if (metaretrieve.getDimensionsTimeIncrement(0, 0) != null) {
                out.write("TimeStepSize: (sec) " + metaretrieve.getDimensionsTimeIncrement(0, 0));
            }
            out.close();
            for (int t = 0; t < tres; ++t) {
                int tdigits = Integer.toString(t).length();
                String tnumb = Integer.toString(t);
                if (tdigits == 1) {
                    tnumb = "T00" + tnumb;
                } else if (tdigits == 2) {
                    tnumb = "T0" + tnumb;
                }
                String savefilename = out_dn + snumb + "_" + tnumb + "_" + infilname + ".tiff";
                metarestore.setPixelsSizeX(xres, 0, 0);
                metarestore.setPixelsSizeY(yres, 0, 0);
                metarestore.setPixelsSizeZ(zres, 0, 0);
                metarestore.setPixelsSizeC(cres, 0, 0);
                metarestore.setPixelsSizeT(1, 0, 0);
                metarestore.setDimensionsPhysicalSizeX(Double.valueOf(xsize), 0, 0);
                metarestore.setDimensionsPhysicalSizeY(Double.valueOf(ysize), 0, 0);
                metarestore.setDimensionsPhysicalSizeZ(Double.valueOf(zsize), 0, 0);
                metarestore.setLogicalChannelSamplesPerPixel(cres, 0, 0);
                OMETiffWriter ometiffwriter = new OMETiffWriter();
                ometiffwriter.setMetadataRetrieve((MetadataRetrieve)((Object)metarestore));
                ometiffwriter.setId(savefilename);
                for (int c = 0; c < cres; ++c) {
                    for (int z = 0; z < zres; ++z) {
                        Main.progress(i, numbimgs);
                        eostack = false;
                        if (c * (zres - 1) + z == cres * (zres - 1)) {
                            eostack = true;
                        }
                        byte[] imagebytes = myimagereader.openBytes(myimagereader.getIndex(z, c, t));
                        ometiffwriter.saveBytes(imagebytes, eostack);
                        ++i;
                    }
                }
            }
        }
    }

    public static void saveImageToOMETIFF_ZCTstack(String in_fn, String out_dn) throws Exception {
        if (in_fn.length() == 0) {
            System.out.println("\nERROR: Input filename is NULL!\n");
            return;
        }
        if (out_dn.length() == 0) {
            System.out.println("\nERROR: Output dirname is NULL!\n");
            return;
        }
        IMetadata meta = MetadataTools.createOMEXMLMetadata();
        ClassList defaultClasses = new ClassList("readers.txt", IFormatReader.class);
        IFormatReader myimagereader = new ImageReader(defaultClasses);
        myimagereader.setMetadataCollected(collectmeta);
        myimagereader.setOriginalMetadataPopulated(collectmetaorig);
        myimagereader.setMetadataFiltered(filtermeta);
        myimagereader.setMetadataStore(meta);
        myimagereader = new ChannelSeparator(myimagereader);
        try {
            myimagereader.setId(in_fn);
        }
        catch (FormatException exc) {
            exc.printStackTrace();
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
        MetadataStore metarestore = myimagereader.getMetadataStore();
        MetadataRetrieve metaretrieve = (MetadataRetrieve)((Object)metarestore);
        System.out.println("Number of Images in Current File: " + myimagereader.getSeriesCount() + "\n");
        int series = myimagereader.getSeriesCount();
        for (int s = 0; s < series; ++s) {
            boolean eostack = false;
            int i = 0;
            myimagereader.setSeries(s);
            metarestore = myimagereader.getMetadataStore();
            metaretrieve = (MetadataRetrieve)((Object)metarestore);
            int sdigits = Integer.toString(s).length();
            String snumb = Integer.toString(s);
            if (sdigits == 1) {
                snumb = "S00" + snumb;
            } else if (sdigits == 2) {
                snumb = "S0" + snumb;
            }
            int numbimgs = myimagereader.getImageCount();
            int xres = metaretrieve.getPixelsSizeX(s, 0);
            int yres = metaretrieve.getPixelsSizeY(s, 0);
            int zres = metaretrieve.getPixelsSizeZ(s, 0);
            int cres = metaretrieve.getPixelsSizeC(s, 0);
            int tres = metaretrieve.getPixelsSizeT(s, 0);
            float zsize = 0.0f;
            float ysize = 0.0f;
            float xsize = 0.0f;
            if (metaretrieve.getDimensionsPhysicalSizeX(s, 0).floatValue() != 0.0f) {
                xsize = metaretrieve.getDimensionsPhysicalSizeX(s, 0).floatValue();
            }
            ysize = metaretrieve.getDimensionsPhysicalSizeY(s, 0).floatValue() != 0.0f ? metaretrieve.getDimensionsPhysicalSizeY(s, 0).floatValue() : xsize;
            if (metaretrieve.getDimensionsPhysicalSizeZ(s, 0).floatValue() != 0.0f) {
                zsize = metaretrieve.getDimensionsPhysicalSizeZ(s, 0).floatValue();
            }
            String dimorder = myimagereader.getDimensionOrder();
            System.out.println("    Series: Image " + (s + 1) + " of " + series);
            System.out.println("    =============================================");
            System.out.println("    Image INFO:");
            System.out.println("    (" + xres + "," + yres + "," + zres + ") (" + cres + "," + tres + ")");
            System.out.println("    Number of images to save: " + numbimgs);
            System.out.println("    Dimensions Order: " + dimorder);
            System.out.println("    (voxel size) X: " + xsize + " Y: " + ysize + " Z: " + zsize);
            System.out.println("    TimeStart: (sec) " + metaretrieve.getImageCreationDate(0));
            System.out.println("    TimeStep: (sec) " + metaretrieve.getDimensionsTimeIncrement(s, 0));
            System.out.println("    =============================================");
            System.out.println("    Saving to OME-TIFF...");
            int index = in_fn.lastIndexOf("/");
            String infilname = index != -1 ? in_fn.substring(index + 1, in_fn.length()) : in_fn;
            infilname = infilname.replace('.', '_');
            String savefilename = out_dn + snumb + "_" + infilname + ".tiff";
            metarestore.setPixelsSizeX(xres, 0, 0);
            metarestore.setPixelsSizeY(yres, 0, 0);
            metarestore.setPixelsSizeZ(zres, 0, 0);
            metarestore.setPixelsSizeC(cres, 0, 0);
            metarestore.setPixelsSizeT(tres, 0, 0);
            metarestore.setDimensionsPhysicalSizeX(Double.valueOf(xsize), 0, 0);
            metarestore.setDimensionsPhysicalSizeY(Double.valueOf(ysize), 0, 0);
            metarestore.setDimensionsPhysicalSizeZ(Double.valueOf(zsize), 0, 0);
            OMETiffWriter ometiffwriter = new OMETiffWriter();
            ometiffwriter.setMetadataRetrieve((MetadataRetrieve)((Object)metarestore));
            ometiffwriter.setId(savefilename);
            for (int t = 0; t < tres; ++t) {
                for (int c = 0; c < cres; ++c) {
                    for (int z = 0; z < zres; ++z) {
                        Main.progress(i, numbimgs);
                        eostack = false;
                        if (i == t * c * z - 1) {
                            eostack = true;
                        }
                        byte[] imagebytes = myimagereader.openBytes(myimagereader.getIndex(z, c, t));
                        ometiffwriter.saveBytes(imagebytes, eostack);
                        ++i;
                    }
                }
            }
        }
    }

    public static void saveImageToPNG(String in_fn, String out_dn) throws Exception {
        if (in_fn.length() == 0) {
            System.out.println("\nERROR: Input filename is NULL!\n");
            return;
        }
        if (out_dn.length() == 0) {
            System.out.println("\nERROR: Output dirname is NULL!\n");
            return;
        }
        System.out.println("Loading file: " + in_fn);
        IMetadata meta = MetadataTools.createOMEXMLMetadata();
        ClassList defaultClasses = new ClassList("readers.txt", IFormatReader.class);
        IFormatReader myimagereader = new ImageReader(defaultClasses);
        myimagereader.setMetadataCollected(collectmeta);
        myimagereader.setOriginalMetadataPopulated(collectmetaorig);
        myimagereader.setMetadataFiltered(filtermeta);
        myimagereader.setMetadataStore(meta);
        myimagereader = new ChannelSeparator(myimagereader);
        myimagereader.setId(in_fn);
        MetadataRetrieve metaretrieve = (MetadataRetrieve)((Object)myimagereader.getMetadataStore());
        MetadataStore metarestore = myimagereader.getMetadataStore();
        OMEXMLMetadata omexmlmetadata = (OMEXMLMetadata)metaretrieve;
        int index = in_fn.lastIndexOf("/");
        String infilname = index != -1 ? in_fn.substring(index + 1, in_fn.length()) : in_fn;
        infilname = infilname.replace('.', '_');
        Object buffimage = null;
        boolean eofiles = false;
        System.out.println("Number of Images in Current File: " + myimagereader.getSeriesCount());
        int series = myimagereader.getSeriesCount();
        for (int s = 0; s < series; ++s) {
            myimagereader.setSeries(s);
            metarestore = myimagereader.getMetadataStore();
            metaretrieve = MetadataTools.asRetrieve(metarestore);
            int sdigits = Integer.toString(s).length();
            String snumb = Integer.toString(s);
            if (sdigits == 1) {
                snumb = "S00" + snumb;
            } else if (sdigits == 2) {
                snumb = "S0" + snumb;
            }
            int numbimgs = myimagereader.getImageCount();
            int xres = myimagereader.getSizeX();
            int yres = myimagereader.getSizeY();
            int zres = myimagereader.getSizeZ();
            int cres = myimagereader.getSizeC();
            int tres = myimagereader.getSizeT();
            float zsize = 0.0f;
            float ysize = 0.0f;
            float xsize = 0.0f;
            if ((double)metaretrieve.getDimensionsPhysicalSizeX(s, 0).floatValue() != 0.0) {
                xsize = metaretrieve.getDimensionsPhysicalSizeX(s, 0).floatValue();
            }
            ysize = (double)metaretrieve.getDimensionsPhysicalSizeY(s, 0).floatValue() != 0.0 ? metaretrieve.getDimensionsPhysicalSizeY(s, 0).floatValue() : xsize;
            if ((double)metaretrieve.getDimensionsPhysicalSizeZ(s, 0).floatValue() != 0.0) {
                zsize = metaretrieve.getDimensionsPhysicalSizeZ(s, 0).floatValue();
            }
            String dimorder = myimagereader.getDimensionOrder();
            System.out.println("    Series Image " + (s + 1) + " of " + series);
            System.out.println("    =============================================");
            System.out.println("    Image INFO:");
            System.out.println("    (" + xres + "," + yres + "," + zres + ") (" + cres + "," + tres + ")");
            System.out.println("    Number of images to save: " + numbimgs);
            System.out.println("    Dimensions Order: " + dimorder);
            System.out.println("    (voxel size) X: " + xsize + " Y: " + ysize + " Z: " + zsize);
            System.out.println("    TimeStart: (sec) " + metaretrieve.getImageCreationDate(0));
            System.out.println("    TimeStep: (sec) " + metaretrieve.getDimensionsTimeIncrement(0, 0));
            System.out.println("    =============================================");
            System.out.println("    Saving to OME-TIFF...");
            for (int t = 0; t < tres; ++t) {
                int tdigits = Integer.toString(t).length();
                String tnumb = Integer.toString(t);
                if (tdigits == 1) {
                    tnumb = "00" + tnumb;
                } else if (tdigits == 2) {
                    tnumb = "0" + tnumb;
                }
                String timeoutdirname = out_dn + infilname + "_T" + tnumb + "_";
                for (int z = 0; z < zres; ++z) {
                    int zdigits = Integer.toString(z).length();
                    String znumb = Integer.toString(z);
                    if (zdigits == 1) {
                        znumb = "00" + znumb;
                    } else if (zdigits == 2) {
                        znumb = "0" + znumb;
                    }
                    Main.progress(z, zres);
                    for (int c = 0; c < cres; ++c) {
                        int cdigits = Integer.toString(c).length();
                        String cnumb = Integer.toString(c);
                        if (cdigits == 1) {
                            cnumb = "00" + cnumb;
                        } else if (cdigits == 2) {
                            cnumb = "0" + cnumb;
                        }
                        String channeloutdirname = timeoutdirname + "C" + cnumb + "/";
                        new File(channeloutdirname).mkdir();
                        int i = myimagereader.getIndex(z, c, t);
                        eofiles = false;
                        if (i == numbimgs) {
                            eofiles = true;
                        }
                        byte[] imagebytes = myimagereader.openBytes(i);
                        String savefilename = channeloutdirname + infilname + "_" + snumb + "_T" + tnumb + "_Z" + znumb + "_C" + cnumb + ".png";
                        if (z == 0) {
                            FileWriter fstream = new FileWriter(channeloutdirname + "voxelscale.txt");
                            BufferedWriter out = new BufferedWriter(fstream);
                            out.write("x " + metaretrieve.getDimensionsPhysicalSizeX(s, 0));
                            out.newLine();
                            out.write("y " + metaretrieve.getDimensionsPhysicalSizeY(s, 0));
                            out.newLine();
                            out.write("z " + metaretrieve.getDimensionsPhysicalSizeZ(s, 0));
                            out.newLine();
                            out.close();
                            fstream = new FileWriter(channeloutdirname + "voxelspacing.txt");
                            out = new BufferedWriter(fstream);
                            out.write("x " + metaretrieve.getDimensionsPhysicalSizeX(s, 0));
                            out.newLine();
                            out.write("y " + metaretrieve.getDimensionsPhysicalSizeY(s, 0));
                            out.newLine();
                            out.write("z " + metaretrieve.getDimensionsPhysicalSizeZ(s, 0));
                            out.newLine();
                            out.close();
                        }
                        meta.setPixelsSizeX(xres, 0, 0);
                        meta.setPixelsSizeY(yres, 0, 0);
                        meta.setPixelsSizeC(1, 0, 0);
                        APNGWriter pngwriter = new APNGWriter();
                        pngwriter.setMetadataRetrieve(meta);
                        pngwriter.setId(savefilename);
                        pngwriter.saveBytes(imagebytes, true);
                        pngwriter.close();
                    }
                }
            }
        }
    }

    public static BufferedImage toBufferedImage(int w, int h, byte[] data) {
        DataBufferByte buffer = new DataBufferByte(data, w * h);
        int pixelStride = 1;
        int scanlineStride = pixelStride * w;
        int[] bandOffsets = new int[]{0};
        WritableRaster raster = Raster.createInterleavedRaster(buffer, w, h, scanlineStride, pixelStride, bandOffsets, null);
        ColorSpace colorSpace = ColorSpace.getInstance(1003);
        boolean hasAlpha = false;
        boolean isAlphaPremultiplied = false;
        int transparency = 3;
        int transferType = 0;
        ComponentColorModel colorModel = new ComponentColorModel(colorSpace, hasAlpha, isAlphaPremultiplied, transparency, transferType);
        return new BufferedImage(colorModel, raster, isAlphaPremultiplied, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readSettings(String fn) {
        File aFile = new File(fn);
        String filecontents = new String();
        filecontents = "";
        try {
            BufferedReader input = new BufferedReader(new FileReader(aFile));
            try {
                String line = null;
                while ((line = input.readLine()) != null) {
                    filecontents = filecontents + "\r\n" + line;
                }
            }
            finally {
                input.close();
            }
        }
        catch (IOException ex) {
            System.out.println("ERROR: Settings.txt file could not be found!");
        }
        StringTokenizer st = new StringTokenizer(filecontents);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals("savemode:")) {
                token = st.nextToken();
                if (token.equals("TIFF")) {
                    System.out.println("savemode: TIFF");
                    savemode = 1;
                    continue;
                }
                if (!token.equals("PNG")) continue;
                System.out.println("savemode: PNG");
                savemode = 2;
                continue;
            }
            if (!token.equals("stackmode:")) continue;
            token = st.nextToken();
            if (token.equals("SINGLE_TIFFS")) {
                System.out.println("tiffmode: single tiffs");
                stackmode = 1;
                continue;
            }
            if (token.equals("Z_STACK_TIFFS")) {
                System.out.println("tiffmode: Z_STACK tiffs");
                stackmode = 2;
                continue;
            }
            if (token.equals("ZC_STACK_TIFFS")) {
                System.out.println("tiffmode: ZC_STACK tiffs");
                stackmode = 3;
                continue;
            }
            if (!token.equals("ZCT_STACK_TIFFS")) continue;
            System.out.println("tiffmode: ZCT_STACK tiffs");
            stackmode = 4;
        }
    }

    public static void main(String[] args) throws Exception {
        System.out.println("=============================================");
        System.out.println("BIOFORMATS CONVERTER v2.0");
        System.out.println("author: Jerome Avondo.");
        System.out.println("");
        System.out.println("=============================================");
        Main.readSettings("settings.txt");
        if (savemode == 0 || stackmode == 0) {
            System.out.println("ERROR: Reading the Setting.txt file");
            return;
        }
        System.out.println("=============================================");
        System.out.println("");
        String inputdir = "IN/";
        File dir = new File(inputdir);
        String[] children = dir.list();
        if (children == null) {
            System.out.println("ERROR: Could not find the IN/ directory!");
            return;
        }
        for (int i = 0; i < children.length; ++i) {
            String current_file = inputdir + children[i];
            String outputsubdir = children[i];
            outputsubdir = outputsubdir.replace(".", "_");
            outputsubdir = outputsubdir + "/";
            boolean dircreate = new File("OUT/" + outputsubdir).mkdir();
            if (dircreate) {
                // empty if block
            }
            boolean fileexists = new File(current_file).exists();
            boolean isdirectory = new File(current_file).isDirectory();
            if (fileexists && !isdirectory) {
                System.out.println("=============================================");
                System.out.println("CURRENT FILE: " + current_file);
                System.out.println("File : " + (i + 1) + " of " + children.length);
                System.out.println("=============================================");
                if (savemode == 1) {
                    if (stackmode == 1) {
                        System.out.println("SAVEMODE: SINGLE_TIFFS");
                        Main.saveImageToOMETIFF(current_file, "OUT/" + outputsubdir);
                        continue;
                    }
                    if (stackmode == 2) {
                        System.out.println("SAVEMODE: Z_STACKS");
                        Main.saveImageToOMETIFF_Zstack(current_file, "OUT/" + outputsubdir);
                        continue;
                    }
                    if (stackmode == 3) {
                        System.out.println("SAVEMODE: ZC_STACKS");
                        Main.saveImageToOMETIFF_ZCstack(current_file, "OUT/" + outputsubdir);
                        continue;
                    }
                    if (stackmode != 4) continue;
                    System.out.println("SAVEMODE: ZCT_STACKS");
                    Main.saveImageToOMETIFF_ZCTstack(current_file, "OUT/" + outputsubdir);
                    continue;
                }
                if (savemode != 2) continue;
                Main.saveImageToPNG(current_file, "OUT/" + outputsubdir);
                continue;
            }
            System.out.println("ERROR: Could not find " + current_file + " !");
            return;
        }
        System.out.println("=============================================");
        System.out.println("Finished...");
    }
}

