/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.ProxyReader;
import ucar.nc2.Variable;
import ucar.nc2.util.CancelTask;

class SectionReader
implements ProxyReader {
    private static Logger log = LoggerFactory.getLogger(SectionReader.class);
    private Variable orgVar;
    private Section orgSection;

    SectionReader(Variable orgVar, Section section) throws InvalidRangeException {
        this.orgVar = orgVar;
        this.orgSection = section.isImmutable() ? section : new Section(section.getRanges());
    }

    public Array read(Variable mainv, CancelTask cancelTask) throws IOException {
        try {
            return this.orgVar._read(this.orgSection);
        }
        catch (InvalidRangeException e) {
            log.error("InvalidRangeException in SectionReader, var=" + this.orgVar.getName());
            throw new IllegalStateException(e.getMessage());
        }
    }

    public Array read(Variable mainv, Section section, CancelTask cancelTask) throws IOException, InvalidRangeException {
        Section want = this.orgSection.compose(section);
        return this.orgVar._read(want);
    }
}

