/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.r200706;

import java.io.File;
import java.util.Vector;
import ome.xml.DOMUtil;
import ome.xml.OMEXMLFactory;
import ome.xml.r200706.ome.ChannelSpecTypeNode;
import ome.xml.r200706.ome.DatasetNode;
import ome.xml.r200706.ome.DetectorNode;
import ome.xml.r200706.ome.DisplayOptionsNode;
import ome.xml.r200706.ome.ExperimentNode;
import ome.xml.r200706.ome.ExperimenterNode;
import ome.xml.r200706.ome.FilterNode;
import ome.xml.r200706.ome.FilterSetNode;
import ome.xml.r200706.ome.GreyChannelNode;
import ome.xml.r200706.ome.GroupNode;
import ome.xml.r200706.ome.ImageNode;
import ome.xml.r200706.ome.ImagingEnvironmentNode;
import ome.xml.r200706.ome.InstrumentNode;
import ome.xml.r200706.ome.LightSourceNode;
import ome.xml.r200706.ome.LogicalChannelNode;
import ome.xml.r200706.ome.MicroscopeNode;
import ome.xml.r200706.ome.OMENode;
import ome.xml.r200706.ome.OTFNode;
import ome.xml.r200706.ome.ObjectiveSettingsNode;
import ome.xml.r200706.ome.PixelsNode;
import ome.xml.r200706.ome.ProjectNode;
import ome.xml.r200706.ome.ProjectionNode;
import ome.xml.r200706.ome.StageLabelNode;
import ome.xml.r200706.ome.ThumbnailNode;
import ome.xml.r200706.ome.TimeNode;
import ome.xml.r200706.ome.TransmittanceRangeNode;

public final class SampleTest {
    private SampleTest() {
    }

    public static void testSample(OMENode ome) throws Exception {
        int projectCount = ome.getProjectCount();
        Vector projectList = ome.getProjectList();
        SampleTest.checkCount("Project", projectCount, projectList, 1);
        int datasetCount = ome.getDatasetCount();
        Vector datasetList = ome.getDatasetList();
        SampleTest.checkCount("Dataset", datasetCount, datasetList, 1);
        int experimentCount = ome.getExperimentCount();
        Vector experimentList = ome.getExperimentList();
        SampleTest.checkCount("Experiment", experimentCount, experimentList, 1);
        int plateCount = ome.getPlateCount();
        Vector plateList = ome.getPlateList();
        SampleTest.checkCount("Plate", plateCount, plateList, 1);
        int screenCount = ome.getScreenCount();
        Vector screenList = ome.getScreenList();
        SampleTest.checkCount("Screen", screenCount, screenList, 1);
        int experimenterCount = ome.getExperimenterCount();
        Vector experimenterList = ome.getExperimenterList();
        SampleTest.checkCount("Experimenter", experimenterCount, experimenterList, 1);
        int groupCount = ome.getGroupCount();
        Vector groupList = ome.getGroupList();
        SampleTest.checkCount("Group", groupCount, groupList, 1);
        int instrumentCount = ome.getInstrumentCount();
        Vector instrumentList = ome.getInstrumentList();
        SampleTest.checkCount("Instrument", instrumentCount, instrumentList, 1);
        int imageCount = ome.getImageCount();
        Vector imageList = ome.getImageList();
        SampleTest.checkCount("Image", imageCount, imageList, 1);
        ProjectNode project = (ProjectNode)projectList.get(0);
        ExperimenterNode projectExperimenter = project.getExperimenter();
        SampleTest.checkNotNull("Project Experimenter", projectExperimenter);
        String projectDescription = project.getDescription();
        SampleTest.checkNull("Project Description", projectDescription);
        GroupNode projectGroup = project.getGroup();
        SampleTest.checkNotNull("Project Group", projectGroup);
        String projectName = project.getName();
        SampleTest.checkValue("Project Name", projectName, "Stress Response Pathway");
        DatasetNode dataset = (DatasetNode)datasetList.get(0);
        Boolean datasetLocked = dataset.getLocked();
        String datasetDescription = dataset.getDescription();
        ExperimenterNode datasetExperimenter = dataset.getExperimenter();
        int datasetProjectCount = dataset.getProjectCount();
        Vector datasetProjectList = dataset.getProjectList();
        GroupNode datasetGroup = dataset.getGroup();
        String datasetCustomAttributes = dataset.getCustomAttributes();
        String datasetName = dataset.getName();
        ExperimentNode experiment = (ExperimentNode)experimentList.get(0);
        String experimentID = experiment.getNodeID();
        SampleTest.checkValue("Experiment ID", experimentID, "urn:lsid:foo.bar.com:Experiment:123456");
        String experimentDescription = experiment.getDescription();
        SampleTest.checkValue("Experiment Description", experimentDescription, "This was an experiment.");
        ExperimenterNode experimentExperimenter = experiment.getExperimenter();
        SampleTest.checkNotNull("Experiment Experimenter", experimentExperimenter);
        int experimentMicrobeamManipulationCount = experiment.getMicrobeamManipulationCount();
        Vector experimentMicrobeamManipulationList = experiment.getMicrobeamManipulationList();
        SampleTest.checkCount("Experiment MicrobeamManipulation", experimentMicrobeamManipulationCount, experimentMicrobeamManipulationList, 0);
        String experimentType = experiment.getType();
        SampleTest.checkValue("Experiment Type", experimentType, "TimeLapse");
        ExperimenterNode experimenter = (ExperimenterNode)experimenterList.get(0);
        String experimenterID = experimenter.getNodeID();
        SampleTest.checkValue("Experimenter ID", experimenterID, "urn:lsid:foo.bar.com:Experimenter:123456");
        String experimenterFirstName = experimenter.getFirstName();
        SampleTest.checkValue("Experimenter FirstName", experimenterFirstName, "Nicola");
        String experimenterLastName = experimenter.getLastName();
        SampleTest.checkValue("Experimenter LastName", experimenterLastName, "Sacco");
        String experimenterEmail = experimenter.getEmail();
        SampleTest.checkValue("Experimenter Email", experimenterEmail, "Nicola.Sacco@justice.net");
        String experimenterInstitution = experimenter.getInstitution();
        SampleTest.checkNull("Experimenter Institution", experimenterInstitution);
        String experimenterOMEName = experimenter.getOMEName();
        SampleTest.checkValue("Experimenter OMEName", experimenterOMEName, "nico");
        int experimenterGroupCount = experimenter.getGroupCount();
        Vector experimenterGroupList = experimenter.getGroupList();
        SampleTest.checkCount("Experimenter Group", experimenterGroupCount, experimenterGroupList, 2);
        InstrumentNode instrument = (InstrumentNode)instrumentList.get(0);
        SampleTest.checkNotNull("Instrument", instrument);
        MicroscopeNode instrumentMicroscope = instrument.getMicroscope();
        SampleTest.checkNotNull("Instrument Microscope", instrumentMicroscope);
        int instrumentLightSourceCount = instrument.getLightSourceCount();
        Vector instrumentLightSourceList = instrument.getLightSourceList();
        SampleTest.checkCount("Instrument LightSource", instrumentLightSourceCount, instrumentLightSourceList, 2);
        int instrumentDetectorCount = instrument.getDetectorCount();
        Vector instrumentDetectorList = instrument.getDetectorList();
        SampleTest.checkCount("Instrument Detector", instrumentDetectorCount, instrumentDetectorList, 1);
        int instrumentObjectiveCount = instrument.getObjectiveCount();
        Vector instrumentObjectiveList = instrument.getObjectiveList();
        SampleTest.checkCount("Instrument Objective", instrumentObjectiveCount, instrumentObjectiveList, 1);
        int instrumentFilterSetCount = instrument.getFilterSetCount();
        Vector instrumentFilterSetList = instrument.getFilterSetList();
        SampleTest.checkCount("Instrument FilterSet", instrumentFilterSetCount, instrumentFilterSetList, 1);
        int instrumentFilterCount = instrument.getFilterCount();
        Vector instrumentFilterList = instrument.getFilterList();
        SampleTest.checkCount("Instrument Filter", instrumentFilterCount, instrumentFilterList, 2);
        int instrumentDichroicCount = instrument.getDichroicCount();
        Vector instrumentDichroicList = instrument.getDichroicList();
        SampleTest.checkCount("Instrument Dichroic", instrumentDichroicCount, instrumentDichroicList, 0);
        int instrumentOTFCount = instrument.getOTFCount();
        Vector instrumentOTFList = instrument.getOTFList();
        SampleTest.checkCount("Instrument OTF", instrumentOTFCount, instrumentOTFList, 1);
        ImageNode image = (ImageNode)imageList.get(0);
        SampleTest.checkNotNull("Image", image);
        String imageID = image.getNodeID();
        SampleTest.checkValue("Image ID", imageID, "urn:lsid:foo.bar.com:Image:123456");
        String imageCreationDate = image.getCreationDate();
        SampleTest.checkValue("Image CreationDate", imageCreationDate, "1988-04-07T18:39:09");
        ExperimenterNode imageExperimenter = image.getExperimenter();
        SampleTest.checkNotNull("Image Experimenter", imageExperimenter);
        String imageDescription = image.getDescription();
        SampleTest.checkValue("Image Description", imageDescription, "This is an Image");
        ExperimentNode imageExperiment = image.getExperiment();
        SampleTest.checkNotNull("Image Experiment", imageExperiment);
        GroupNode imageGroup = image.getGroup();
        SampleTest.checkNotNull("Image Group", imageGroup);
        int imageDatasetCount = image.getDatasetCount();
        Vector imageDatasetList = image.getDatasetList();
        SampleTest.checkCount("Image Dataset", imageDatasetCount, imageDatasetList, 1);
        InstrumentNode imageInstrument = image.getInstrument();
        SampleTest.checkNotNull("Image Instrument", imageInstrument);
        ObjectiveSettingsNode imageObjectiveSettings = image.getObjectiveSettings();
        SampleTest.checkNull("Image ObjectiveSettings", imageObjectiveSettings);
        ImagingEnvironmentNode imageImagingEnvironment = image.getImagingEnvironment();
        SampleTest.checkNotNull("Image ImagingEnvironment", imageImagingEnvironment);
        ThumbnailNode imageThumbnail = image.getThumbnail();
        SampleTest.checkNotNull("Image Thumbnail", imageThumbnail);
        int imageLogicalChannelCount = image.getLogicalChannelCount();
        Vector imageLogicalChannelList = image.getLogicalChannelList();
        SampleTest.checkCount("Image LogicalChannel", imageLogicalChannelCount, imageLogicalChannelList, 1);
        DisplayOptionsNode imageDisplayOptions = image.getDisplayOptions();
        SampleTest.checkNotNull("Image DisplayOptions", imageDisplayOptions);
        StageLabelNode imageStageLabel = image.getStageLabel();
        SampleTest.checkNotNull("Image StageLabel", imageStageLabel);
        int imagePixelsCount = image.getPixelsCount();
        Vector imagePixelsList = image.getPixelsList();
        SampleTest.checkCount("Image Pixels", imagePixelsCount, imagePixelsList, 1);
        PixelsNode imageAcquiredPixels = image.getAcquiredPixels();
        SampleTest.checkNull("Image AcquiredPixels", imageAcquiredPixels);
        int imageRegionCount = image.getRegionCount();
        Vector imageRegionList = image.getRegionList();
        SampleTest.checkCount("Image Region", imageRegionCount, imageRegionList, 0);
        String imageCustomAttributes = image.getCustomAttributes();
        SampleTest.checkNull("Image CustomAttributes", imageCustomAttributes);
        int imageROICount = image.getROICount();
        Vector imageROIList = image.getROIList();
        SampleTest.checkCount("Image ROI", imageROICount, imageROIList, 0);
        int imageMicrobeamManipulationCount = image.getMicrobeamManipulationCount();
        Vector imageMicrobeamManipulationList = image.getMicrobeamManipulationList();
        SampleTest.checkCount("Image MicrobeamManipulation", imageMicrobeamManipulationCount, imageMicrobeamManipulationList, 0);
        String imageName = image.getName();
        SampleTest.checkValue("Image Name", imageName, "P1W1S1");
        FilterNode instrumentFilter1 = (FilterNode)instrumentFilterList.get(0);
        String instrumentFilter1ID = instrumentFilter1.getNodeID();
        SampleTest.checkValue("Instrument Filter-1 ID", instrumentFilter1ID, "urn:lsid:foo.bar.com:Filter:123456");
        String instrumentFilter1Manufacturer = instrumentFilter1.getManufacturer();
        SampleTest.checkValue("Instrument Filter-1 Manufacturer", instrumentFilter1Manufacturer, "Omega");
        String instrumentFilter1Model = instrumentFilter1.getModel();
        SampleTest.checkValue("Instrument Filter-1 Model", instrumentFilter1Model, "SuperGFP");
        String instrumentFilter1LotNumber = instrumentFilter1.getLotNumber();
        SampleTest.checkNull("Instrument Filter-1 LotNumber", instrumentFilter1LotNumber);
        TransmittanceRangeNode instrumentFilter1TransmittanceRange = instrumentFilter1.getTransmittanceRange();
        SampleTest.checkNotNull("Instrument Filter-1 TransmittanceRange", instrumentFilter1TransmittanceRange);
        String instrumentFilter1Type = instrumentFilter1.getType();
        SampleTest.checkNull("Instrument Filter-1 Type", instrumentFilter1Type);
        String instrumentFilter1FilterWheel = instrumentFilter1.getFilterWheel();
        SampleTest.checkNull("Instrument Filter-1 FilterWheel", instrumentFilter1FilterWheel);
        FilterNode instrumentFilter2 = (FilterNode)instrumentFilterList.get(1);
        String instrumentFilter2ID = instrumentFilter2.getNodeID();
        SampleTest.checkValue("Instrument Filter-2 ID", instrumentFilter2ID, "urn:lsid:foo.bar.com:Filter:1234567");
        String instrumentFilter2Manufacturer = instrumentFilter2.getManufacturer();
        SampleTest.checkValue("Instrument Filter-2 Manufacturer", instrumentFilter2Manufacturer, "Omega");
        String instrumentFilter2Model = instrumentFilter2.getModel();
        SampleTest.checkValue("Instrument Filter-2 Model", instrumentFilter2Model, "SuperGFP");
        String instrumentFilter2LotNumber = instrumentFilter2.getLotNumber();
        SampleTest.checkNull("Instrument Filter-2 LotNumber", instrumentFilter2LotNumber);
        TransmittanceRangeNode instrumentFilter2TransmittanceRange = instrumentFilter2.getTransmittanceRange();
        SampleTest.checkNotNull("Instrument Filter-2 TransmittanceRange", instrumentFilter2TransmittanceRange);
        String instrumentFilter2Type = instrumentFilter2.getType();
        SampleTest.checkNull("Instrument Filter-2 Type", instrumentFilter2Type);
        String instrumentFilter2FilterWheel = instrumentFilter2.getFilterWheel();
        SampleTest.checkNull("Instrument Filter-2 FilterWheel", instrumentFilter2FilterWheel);
        LogicalChannelNode imageLogicalChannel = (LogicalChannelNode)imageLogicalChannelList.get(0);
        SampleTest.checkNotNull("Image LogicalChannel", imageLogicalChannel);
        String imageLogicalChannelID = imageLogicalChannel.getNodeID();
        SampleTest.checkValue("Image LogicalChannel ID", imageLogicalChannelID, "urn:lsid:foo.bar.com:LogicalChannel:123456");
        LightSourceNode imageLogicalChannelLightSource = imageLogicalChannel.getLightSource();
        SampleTest.checkNotNull("Image LogicalChannel LightSource", imageLogicalChannelLightSource);
        OTFNode imageLogicalChannelOTF = imageLogicalChannel.getOTF();
        SampleTest.checkNotNull("Image LogicalChannel OTF", imageLogicalChannelOTF);
        DetectorNode imageLogicalChannelDetector = imageLogicalChannel.getDetector();
        SampleTest.checkNotNull("Image LogicalChannel Detector", imageLogicalChannelDetector);
        FilterSetNode imageLogicalChannelFilterSet = imageLogicalChannel.getFilterSet();
        SampleTest.checkNotNull("Image LogicalChannel FilterSet", imageLogicalChannelFilterSet);
        int imageLogicalChannelChannelComponentCount = imageLogicalChannel.getChannelComponentCount();
        Vector imageLogicalChannelChannelComponentList = imageLogicalChannel.getChannelComponentList();
        SampleTest.checkCount("Image LogicalChannel ChannelComponent", imageLogicalChannelChannelComponentCount, imageLogicalChannelChannelComponentList, 1);
        String imageLogicalChannelName = imageLogicalChannel.getName();
        SampleTest.checkValue("Image LogicalChannel Name", imageLogicalChannelName, "Ch 1");
        Integer imageLogicalChannelSamplesPerPixel = imageLogicalChannel.getSamplesPerPixel();
        SampleTest.checkNull("Image LogicalChannel SamplesPerPixel", imageLogicalChannelSamplesPerPixel);
        FilterNode imageLogicalChannelSecondaryEmissionFilter = imageLogicalChannel.getSecondaryEmissionFilterNode();
        SampleTest.checkNull("Image LogicalChannel SecondaryEmissionFilter", imageLogicalChannelSecondaryEmissionFilter);
        FilterNode imageLogicalChannelSecondaryExcitationFilter = imageLogicalChannel.getSecondaryExcitationFilterNode();
        SampleTest.checkNull("Image LogicalChannel SecondaryExcitationFilter", imageLogicalChannelSecondaryExcitationFilter);
        String imageLogicalChannelIlluminationType = imageLogicalChannel.getIlluminationType();
        SampleTest.checkValue("Image LogicalChannel IlluminationType", imageLogicalChannelIlluminationType, "Epifluorescence");
        Integer imageLogicalChannelPinholeSize = imageLogicalChannel.getPinholeSize();
        SampleTest.checkNull("Image LogicalChannel PinholeSize", imageLogicalChannelPinholeSize);
        String imageLogicalChannelPhotometricInterpretation = imageLogicalChannel.getPhotometricInterpretation();
        SampleTest.checkNull("Image LogicalChannel PhotometricInterpretation", imageLogicalChannelPhotometricInterpretation);
        String imageLogicalChannelMode = imageLogicalChannel.getMode();
        SampleTest.checkNull("Image LogicalChannel Mode", imageLogicalChannelMode);
        String imageLogicalChannelContrastMethod = imageLogicalChannel.getContrastMethod();
        SampleTest.checkNull("Image LogicalChannel ContrastMethod", imageLogicalChannelContrastMethod);
        Integer imageLogicalChannelExWave = imageLogicalChannel.getExWave();
        SampleTest.checkValue("Image LogicalChannel ExWave", imageLogicalChannelExWave, new Integer(490));
        Integer imageLogicalChannelEmWave = imageLogicalChannel.getEmWave();
        SampleTest.checkValue("Image LogicalChannel EmWave", imageLogicalChannelEmWave, new Integer(528));
        String imageLogicalChannelFluor = imageLogicalChannel.getFluor();
        SampleTest.checkValue("Image LogicalChannel Fluor", imageLogicalChannelFluor, "GFP");
        Double imageLogicalChannelNdFilter = imageLogicalChannel.getNdFilter();
        SampleTest.checkValue("Image LogicalChannel NdFilter", imageLogicalChannelNdFilter, new Double(0.0));
        Integer imageLogicalChannelPockelCellSetting = imageLogicalChannel.getPockelCellSetting();
        SampleTest.checkNull("Image LogicalChannel PockelCellSetting", imageLogicalChannelPockelCellSetting);
        String imageDisplayOptionsID = imageDisplayOptions.getNodeID();
        SampleTest.checkValue("Image DisplayOptions ID", imageDisplayOptionsID, "urn:lsid:foo.bar.com:DisplayOptions:123456");
        ChannelSpecTypeNode imageDisplayOptionsRedChannel = imageDisplayOptions.getRedChannel();
        SampleTest.checkNotNull("Image DisplayOptions RedChannel", imageDisplayOptionsRedChannel);
        ChannelSpecTypeNode imageDisplayOptionsGreenChannel = imageDisplayOptions.getGreenChannel();
        SampleTest.checkNotNull("Image DisplayOptions GreenChannel", imageDisplayOptionsGreenChannel);
        ChannelSpecTypeNode imageDisplayOptionsBlueChannel = imageDisplayOptions.getBlueChannel();
        SampleTest.checkNotNull("Image DisplayOptions BlueChannel", imageDisplayOptionsBlueChannel);
        GreyChannelNode imageDisplayOptionsGreyChannel = imageDisplayOptions.getGreyChannel();
        SampleTest.checkNotNull("Image DisplayOptions GreyChannel", imageDisplayOptionsGreyChannel);
        ProjectionNode imageDisplayOptionsProjection = imageDisplayOptions.getProjection();
        SampleTest.checkNotNull("Image DisplayOptions Projection", imageDisplayOptionsProjection);
        TimeNode imageDisplayOptionsTime = imageDisplayOptions.getTime();
        SampleTest.checkNotNull("Image DisplayOptions Time", imageDisplayOptionsTime);
        int imageDisplayOptionsROICount = imageDisplayOptions.getROICount();
        Vector imageDisplayOptionsROIList = imageDisplayOptions.getROIList();
        SampleTest.checkCount("Image DisplayOptions ROI", imageDisplayOptionsROICount, imageDisplayOptionsROIList, 1);
        Double imageDisplayOptionsZoom = imageDisplayOptions.getZoom();
        SampleTest.checkValue("Image DisplayOptions Zoom", imageDisplayOptionsZoom, new Double(1.0));
        String imageDisplayOptionsDisplay = imageDisplayOptions.getDisplay();
        SampleTest.checkValue("Image DisplayOptions Display", imageDisplayOptionsDisplay, "RGB");
        String imageStageLabelName = imageStageLabel.getName();
        SampleTest.checkValue("Image StageLabel Name", imageStageLabelName, "Zulu");
        Double imageStageLabelX = imageStageLabel.getX();
        SampleTest.checkValue("Image StageLabel X", imageStageLabelX, new Double(123.0));
        Double imageStageLabelY = imageStageLabel.getY();
        SampleTest.checkValue("Image StageLabel Y", imageStageLabelY, new Double(456.0));
        Double imageStageLabelZ = imageStageLabel.getZ();
        SampleTest.checkValue("Image StageLabel Z", imageStageLabelZ, new Double(789.0));
        PixelsNode imagePixels = (PixelsNode)imagePixelsList.get(0);
        SampleTest.checkNotNull("Image Pixels", imagePixels);
        int imagePixelsTiffDataCount = imagePixels.getTiffDataCount();
        Vector imagePixelsTiffDataList = imagePixels.getTiffDataList();
        SampleTest.checkCount("Image Pixels TiffData", imagePixelsTiffDataCount, imagePixelsTiffDataList, 0);
        int imagePixelsPlaneCount = imagePixels.getPlaneCount();
        Vector imagePixelsPlaneList = imagePixels.getPlaneList();
        SampleTest.checkCount("Image Pixels Plane", imagePixelsPlaneCount, imagePixelsPlaneList, 0);
        String imagePixelsDimensionOrder = imagePixels.getDimensionOrder();
        SampleTest.checkValue("Image Pixels DimensionOrder", imagePixelsDimensionOrder, "XYZCT");
        String imagePixelsPixelType = imagePixels.getPixelType();
        SampleTest.checkValue("Image Pixels PixelType", imagePixelsPixelType, "int16");
        Boolean imagePixelsBigEndian = imagePixels.getBigEndian();
        SampleTest.checkValue("Image Pixels BigEndian", imagePixelsBigEndian, Boolean.TRUE);
        Integer imagePixelsSizeX = imagePixels.getSizeX();
        SampleTest.checkValue("Image Pixels SizeX", imagePixelsSizeX, new Integer(20));
        Integer imagePixelsSizeY = imagePixels.getSizeY();
        SampleTest.checkValue("Image Pixels SizeY", imagePixelsSizeY, new Integer(20));
        Integer imagePixelsSizeZ = imagePixels.getSizeZ();
        SampleTest.checkValue("Image Pixels SizeZ", imagePixelsSizeZ, new Integer(5));
        Integer imagePixelsSizeC = imagePixels.getSizeC();
        SampleTest.checkValue("Image Pixels SizeC", imagePixelsSizeC, new Integer(1));
        Integer imagePixelsSizeT = imagePixels.getSizeT();
        SampleTest.checkValue("Image Pixels SizeT", imagePixelsSizeT, new Integer(6));
        Double imagePixelsPhysicalSizeX = imagePixels.getPhysicalSizeX();
        SampleTest.checkValue("Image Pixels PhysicalSizeX", imagePixelsPhysicalSizeX, new Double(0.2));
        Double imagePixelsPhysicalSizeY = imagePixels.getPhysicalSizeY();
        SampleTest.checkValue("Image Pixels PhysicalSizeY", imagePixelsPhysicalSizeY, new Double(0.2));
        Double imagePixelsPhysicalSizeZ = imagePixels.getPhysicalSizeZ();
        SampleTest.checkValue("Image Pixels PhysicalSizeZ", imagePixelsPhysicalSizeZ, new Double(0.2));
        Double imagePixelsTimeIncrement = imagePixels.getTimeIncrement();
        SampleTest.checkNull("Image Pixels TimeIncrement", imagePixelsTimeIncrement);
        Integer imagePixelsWaveStart = imagePixels.getWaveStart();
        SampleTest.checkNull("Image Pixels WaveStart", imagePixelsWaveStart);
        Integer imagePixelsWaveIncrement = imagePixels.getWaveIncrement();
        SampleTest.checkNull("Image Pixels WaveIncrement", imagePixelsWaveIncrement);
        Integer instrumentFilter1TransmittanceRangeCutIn = instrumentFilter1TransmittanceRange.getCutIn();
        SampleTest.checkValue("Instrument Filter-1 TransmittanceRange CutIn", instrumentFilter1TransmittanceRangeCutIn, new Integer(432));
        Integer instrumentFilter1TransmittanceRangeTransmittance = instrumentFilter1TransmittanceRange.getTransmittance();
        SampleTest.checkValue("Instrument Filter-1 TransmittanceRange Transmittance", instrumentFilter1TransmittanceRangeTransmittance, new Integer(20));
        Integer instrumentFilter1TransmittanceRangeCutOut = instrumentFilter1TransmittanceRange.getCutOut();
        SampleTest.checkValue("Instrument Filter-1 TransmittanceRange CutOut", instrumentFilter1TransmittanceRangeCutOut, new Integer(543));
        Integer instrumentFilter1TransmittanceRangeCutInTolerance = instrumentFilter1TransmittanceRange.getCutInTolerance();
        SampleTest.checkNull("Instrument Filter-1 TransmittanceRange CutInTolerance", instrumentFilter1TransmittanceRangeCutInTolerance);
        Integer instrumentFilter1TransmittanceRangeCutOutTolerance = instrumentFilter1TransmittanceRange.getCutOutTolerance();
        SampleTest.checkNull("Instrument Filter-1 TransmittanceRange CutOutTolerance", instrumentFilter1TransmittanceRangeCutOutTolerance);
        Integer instrumentFilter2TransmittanceRangeCutIn = instrumentFilter2TransmittanceRange.getCutIn();
        SampleTest.checkValue("Instrument Filter-2 TransmittanceRange CutIn", instrumentFilter2TransmittanceRangeCutIn, new Integer(432));
        Integer instrumentFilter2TransmittanceRangeTransmittance = instrumentFilter2TransmittanceRange.getTransmittance();
        SampleTest.checkValue("Instrument Filter-2 TransmittanceRange Transmittance", instrumentFilter2TransmittanceRangeTransmittance, new Integer(20));
        Integer instrumentFilter2TransmittanceRangeCutOut = instrumentFilter2TransmittanceRange.getCutOut();
        SampleTest.checkValue("Instrument Filter-2 TransmittanceRange CutOut", instrumentFilter2TransmittanceRangeCutOut, new Integer(543));
        Integer instrumentFilter2TransmittanceRangeCutInTolerance = instrumentFilter2TransmittanceRange.getCutInTolerance();
        SampleTest.checkNull("Instrument Filter-2 TransmittanceRange CutInTolerance", instrumentFilter2TransmittanceRangeCutInTolerance);
        Integer instrumentFilter2TransmittanceRangeCutOutTolerance = instrumentFilter2TransmittanceRange.getCutOutTolerance();
        SampleTest.checkNull("Instrument Filter-2 TransmittanceRange CutOutTolerance", instrumentFilter2TransmittanceRangeCutOutTolerance);
        Integer imageDisplayOptionsRedChannelChannelNumber = imageDisplayOptionsRedChannel.getChannelNumber();
        SampleTest.checkValue("Image DisplayOptions RedChannel ChannelNumber", imageDisplayOptionsRedChannelChannelNumber, new Integer(0));
        Double imageDisplayOptionsRedChannelBlackLevel = imageDisplayOptionsRedChannel.getBlackLevel();
        SampleTest.checkValue("Image DisplayOptions RedChannel BlackLevel", imageDisplayOptionsRedChannelBlackLevel, new Double(144.0));
        Double imageDisplayOptionsRedChannelWhiteLevel = imageDisplayOptionsRedChannel.getWhiteLevel();
        SampleTest.checkValue("Image DisplayOptions RedChannel WhiteLevel", imageDisplayOptionsRedChannelWhiteLevel, new Double(338.0));
        Double imageDisplayOptionsRedChannelGamma = imageDisplayOptionsRedChannel.getGamma();
        SampleTest.checkNull("Image DisplayOptions RedChannel Gamma", imageDisplayOptionsRedChannelGamma);
        Boolean imageDisplayOptionsRedChannelisOn = imageDisplayOptionsRedChannel.getisOn();
        SampleTest.checkValue("Image DisplayOptions RedChannel isOn", imageDisplayOptionsRedChannelisOn, Boolean.TRUE);
        Integer imageDisplayOptionsGreenChannelChannelNumber = imageDisplayOptionsGreenChannel.getChannelNumber();
        SampleTest.checkValue("Image DisplayOptions GreenChannel ChannelNumber", imageDisplayOptionsGreenChannelChannelNumber, new Integer(0));
        Double imageDisplayOptionsGreenChannelBlackLevel = imageDisplayOptionsGreenChannel.getBlackLevel();
        SampleTest.checkValue("Image DisplayOptions GreenChannel BlackLevel", imageDisplayOptionsGreenChannelBlackLevel, new Double(144.0));
        Double imageDisplayOptionsGreenChannelWhiteLevel = imageDisplayOptionsGreenChannel.getWhiteLevel();
        SampleTest.checkValue("Image DisplayOptions GreenChannel WhiteLevel", imageDisplayOptionsGreenChannelWhiteLevel, new Double(338.0));
        Double imageDisplayOptionsGreenChannelGamma = imageDisplayOptionsGreenChannel.getGamma();
        SampleTest.checkNull("Image DisplayOptions GreenChannel Gamma", imageDisplayOptionsGreenChannelGamma);
        Boolean imageDisplayOptionsGreenChannelisOn = imageDisplayOptionsGreenChannel.getisOn();
        SampleTest.checkValue("Image DisplayOptions GreenChannel isOn", imageDisplayOptionsGreenChannelisOn, Boolean.TRUE);
        Integer imageDisplayOptionsBlueChannelChannelNumber = imageDisplayOptionsBlueChannel.getChannelNumber();
        SampleTest.checkValue("Image DisplayOptions BlueChannel ChannelNumber", imageDisplayOptionsBlueChannelChannelNumber, new Integer(0));
        Double imageDisplayOptionsBlueChannelBlackLevel = imageDisplayOptionsBlueChannel.getBlackLevel();
        SampleTest.checkValue("Image DisplayOptions BlueChannel BlackLevel", imageDisplayOptionsBlueChannelBlackLevel, new Double(144.0));
        Double imageDisplayOptionsBlueChannelWhiteLevel = imageDisplayOptionsBlueChannel.getWhiteLevel();
        SampleTest.checkValue("Image DisplayOptions BlueChannel WhiteLevel", imageDisplayOptionsBlueChannelWhiteLevel, new Double(338.0));
        Double imageDisplayOptionsBlueChannelGamma = imageDisplayOptionsBlueChannel.getGamma();
        SampleTest.checkNull("Image DisplayOptions BlueChannel Gamma", imageDisplayOptionsBlueChannelGamma);
        Boolean imageDisplayOptionsBlueChannelisOn = imageDisplayOptionsBlueChannel.getisOn();
        SampleTest.checkValue("Image DisplayOptions BlueChannel isOn", imageDisplayOptionsBlueChannelisOn, Boolean.TRUE);
        String imageDisplayOptionsGreyChannelColorMap = imageDisplayOptionsGreyChannel.getColorMap();
        SampleTest.checkNull("Image DisplayOptions GreyChannel ColorMap", imageDisplayOptionsGreyChannelColorMap);
        Integer imageDisplayOptionsGreyChannelChannelNumber = imageDisplayOptionsGreyChannel.getChannelNumber();
        SampleTest.checkValue("Image DisplayOptions GreyChannel ChannelNumber", imageDisplayOptionsGreyChannelChannelNumber, new Integer(0));
        Double imageDisplayOptionsGreyChannelBlackLevel = imageDisplayOptionsGreyChannel.getBlackLevel();
        SampleTest.checkValue("Image DisplayOptions GreyChannel BlackLevel", imageDisplayOptionsGreyChannelBlackLevel, new Double(144.0));
        Double imageDisplayOptionsGreyChannelWhiteLevel = imageDisplayOptionsGreyChannel.getWhiteLevel();
        SampleTest.checkValue("Image DisplayOptions GreyChannel WhiteLevel", imageDisplayOptionsGreyChannelWhiteLevel, new Double(338.0));
        Double imageDisplayOptionsGreyChannelGamma = imageDisplayOptionsGreyChannel.getGamma();
        SampleTest.checkNull("Image DisplayOptions GreyChannel Gamma", imageDisplayOptionsGreyChannelGamma);
        Boolean imageDisplayOptionsGreyChannelisOn = imageDisplayOptionsGreyChannel.getisOn();
        SampleTest.checkNull("Image DisplayOptions GreyChannel isOn", imageDisplayOptionsGreyChannelisOn);
        Integer imageDisplayOptionsProjectionZStart = imageDisplayOptionsProjection.getZStart();
        SampleTest.checkValue("Image DisplayOptions Projection ZStart", imageDisplayOptionsProjectionZStart, new Integer(3));
        Integer imageDisplayOptionsProjectionZStop = imageDisplayOptionsProjection.getZStop();
        SampleTest.checkValue("Image DisplayOptions Projection ZStop", imageDisplayOptionsProjectionZStop, new Integer(3));
        Integer imageDisplayOptionsTimeTStart = imageDisplayOptionsTime.getTStart();
        SampleTest.checkValue("Image DisplayOptions Time TStart", imageDisplayOptionsTimeTStart, new Integer(3));
        Integer imageDisplayOptionsTimeTStop = imageDisplayOptionsTime.getTStop();
        SampleTest.checkValue("Image DisplayOptions Time TStop", imageDisplayOptionsTimeTStop, new Integer(3));
    }

    public static OMENode createNode() throws Exception {
        OMENode ome = null;
        return ome;
    }

    private static void checkCount(String field, int count, Vector list, int expected) {
        if (count != expected || list.size() != expected) {
            char[] c = field.toCharArray();
            int i = 0;
            while (i < c.length && c[i] >= 'A' && c[i] <= 'Z') {
                int n = i++;
                c[n] = (char)(c[n] + 32);
            }
            String var = new String(c).replaceAll("[- ]", "");
            System.out.println("Error: Incorrect " + field + " count" + " (" + var + "Count=" + count + ", " + var + "List.size()=" + list.size() + ")");
        }
    }

    private static void checkNull(String field, Object value) {
        if (value != null) {
            System.out.println("Error: " + field + " is not null as expected (" + value + ")");
        }
    }

    private static void checkNotNull(String field, Object value) {
        if (value == null) {
            System.out.println("Error: " + field + " should not be null");
        }
    }

    private static void checkValue(String field, Object value, Object expected) {
        if (value == null && expected == null) {
            return;
        }
        if (value == null || !value.equals(expected)) {
            System.out.println("Error: Incorrect " + field + " (" + value + ")");
        }
    }

    public static void main(String[] args) throws Exception {
        String path = null;
        boolean build = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            if (args[i].equalsIgnoreCase("-build")) {
                build = true;
                continue;
            }
            path = args[i];
        }
        if (path == null && !build) {
            System.out.println("Usage: java " + SampleTest.class.getName() + " [-build || /path/to/Sample-2007_06.ome]");
            return;
        }
        System.out.println("Creating OME node...");
        OMENode ome = null;
        ome = build ? SampleTest.createNode() : (OMENode)OMEXMLFactory.newOMENodeFromSource(new File(path));
        System.out.println();
        System.out.println("Performing API tests...");
        SampleTest.testSample(ome);
        System.out.println();
        System.out.println("Writing OME-XML to String...");
        DOMUtil.writeXML(System.out, ome.getDOMElement().getOwnerDocument());
    }
}

