/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.shortcut;

import ij.IJ;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import loci.plugins.shortcut.ShortcutPanel;

public class ShortcutTransferHandler
extends TransferHandler {
    protected ShortcutPanel shortcutPanel;

    public ShortcutTransferHandler(ShortcutPanel shortcutPanel) {
        this.shortcutPanel = shortcutPanel;
    }

    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        return true;
    }

    public boolean importData(JComponent comp, Transferable t) {
        try {
            DataFlavor[] flavors = t.getTransferDataFlavors();
            int fileIndex = -1;
            int stringIndex = -1;
            int listIndex = -1;
            for (int i = 0; i < flavors.length && (fileIndex < 0 || stringIndex < 0 || listIndex < 0); ++i) {
                Class<?> c = flavors[i].getRepresentationClass();
                if (fileIndex < 0 && c == File.class) {
                    fileIndex = i;
                }
                if (stringIndex < 0 && c == String.class) {
                    stringIndex = i;
                }
                if (listIndex >= 0 || c != List.class) continue;
                listIndex = i;
            }
            Vector<Object> list = null;
            if (listIndex >= 0) {
                list = (Vector<Object>)t.getTransferData(flavors[listIndex]);
            } else if (fileIndex >= 0) {
                File f = (File)t.getTransferData(flavors[fileIndex]);
                list = new Vector<Object>();
                list.add(f);
            } else if (stringIndex >= 0) {
                String s = (String)t.getTransferData(flavors[stringIndex]);
                list = new Vector();
                StringTokenizer st = new StringTokenizer(s);
                while (st.hasMoreTokens()) {
                    list.add(st.nextToken());
                }
            }
            if (list == null) {
                return false;
            }
            final String[] ids = new String[list.size()];
            for (int i = 0; i < ids.length; ++i) {
                Object item = list.get(i);
                String id = null;
                if (item instanceof File) {
                    File f = (File)item;
                    id = f.getAbsolutePath();
                } else if (item instanceof String) {
                    id = (String)item;
                }
                if (id == null) {
                    System.err.println("Warning: ignoring item #" + i + ": " + item);
                    continue;
                }
                ids[i] = id.replaceAll("^file:/*", "/");
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    for (int i = 0; i < ids.length; ++i) {
                        ShortcutTransferHandler.this.shortcutPanel.open(ids[i]);
                    }
                }
            });
        }
        catch (UnsupportedFlavorException e) {
            e.printStackTrace();
            DataFlavor[] df = t.getTransferDataFlavors();
            System.err.println("Supported flavors:");
            for (int i = 0; i < df.length; ++i) {
                System.err.println("\t#" + i + ": " + df[i]);
            }
            IJ.error((String)e.toString());
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            IJ.error((String)e.toString());
            return false;
        }
        return true;
    }
}

