/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.out;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import loci.common.DataTools;
import loci.common.RandomAccessOutputStream;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.FormatWriter;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataRetrieve;

public class JavaWriter
extends FormatWriter {
    protected PrintWriter out;
    protected int no = 0;

    public JavaWriter() {
        super("Java source code", "java");
    }

    public void saveBytes(byte[] buf, int series, boolean lastInSeries, boolean last) throws FormatException, IOException {
        if (buf == null) {
            throw new FormatException("Byte array is null");
        }
        MetadataRetrieve meta = this.getMetadataRetrieve();
        MetadataTools.verifyMinimumPopulated(meta, series);
        String pixelType = meta.getPixelsPixelType(series, 0);
        int type = FormatTools.pixelTypeFromString(pixelType);
        if (!DataTools.containsValue(this.getPixelTypes(), type)) {
            throw new FormatException("Unsupported image type '" + pixelType + "'.");
        }
        int bpp = FormatTools.getBytesPerPixel(type);
        boolean fp = FormatTools.isFloatingPoint(type);
        boolean little = Boolean.FALSE.equals(meta.getPixelsBigEndian(series, 0));
        if (!this.initialized) {
            this.writeHeader();
            this.initialized = true;
        }
        String varName = "series" + series + "Plane" + this.no;
        Object array = DataTools.makeDataArray(buf, bpp, fp, little);
        int w = meta.getPixelsSizeX(series, 0);
        int h = meta.getPixelsSizeY(series, 0);
        if (array instanceof byte[]) {
            this.writePlane(varName, (byte[])array, w, h);
        } else if (array instanceof short[]) {
            this.writePlane(varName, (short[])array, w, h);
        } else if (array instanceof int[]) {
            this.writePlane(varName, (int[])array, w, h);
        } else if (array instanceof long[]) {
            this.writePlane(varName, (long[])array, w, h);
        } else if (array instanceof float[]) {
            this.writePlane(varName, (float[])array, w, h);
        } else if (array instanceof double[]) {
            this.writePlane(varName, (double[])array, w, h);
        }
        ++this.no;
        if (lastInSeries) {
            this.no = 0;
        }
        if (last) {
            this.writeFooter();
        }
    }

    public boolean canDoStacks() {
        return true;
    }

    public int[] getPixelTypes() {
        return new int[]{0, 1, 3, 5, 4, 6, 7};
    }

    public void close() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
        this.out = null;
        this.currentId = null;
        this.initialized = false;
    }

    protected void writeHeader() throws IOException {
        this.out = new PrintWriter(new RandomAccessOutputStream(this.currentId));
        String className = this.currentId.substring(0, this.currentId.length() - 5);
        className = className.substring(className.lastIndexOf(File.separator) + 1);
        this.out.println("//");
        this.out.println("// " + className + ".java");
        this.out.println("//");
        this.out.println();
        this.out.println("// Generated by Bio-Formats v4.2-DEV");
        this.out.println("// Generated on " + new Date());
        this.out.println();
        this.out.println("public class " + className + " {");
        this.out.println();
    }

    protected void writePlane(String varName, byte[] array, int w, int h) {
        int i = 0;
        this.out.println("  public byte[][] " + varName + " = {");
        for (int y = 0; y < h; ++y) {
            this.out.print("    {");
            for (int x = 0; x < w; ++x) {
                this.out.print(array[i++]);
                if (x < w - 1) {
                    this.out.print(", ");
                    continue;
                }
                this.out.print("}");
            }
            if (y < h - 1) {
                this.out.println(",");
                continue;
            }
            this.out.println();
        }
        this.out.println("  };");
        this.out.println();
    }

    protected void writePlane(String varName, short[] array, int w, int h) {
        int i = 0;
        this.out.println("  public short[][] " + varName + " = {");
        for (int y = 0; y < h; ++y) {
            this.out.print("    {");
            for (int x = 0; x < w; ++x) {
                this.out.print(array[i++]);
                if (x < w - 1) {
                    this.out.print(", ");
                    continue;
                }
                this.out.print("}");
            }
            if (y < h - 1) {
                this.out.println(",");
                continue;
            }
            this.out.println();
        }
        this.out.println("  };");
        this.out.println();
    }

    protected void writePlane(String varName, int[] array, int w, int h) {
        int i = 0;
        this.out.println("  public int[][] " + varName + " = {");
        for (int y = 0; y < h; ++y) {
            this.out.print("    {");
            for (int x = 0; x < w; ++x) {
                this.out.print(array[i++]);
                if (x < w - 1) {
                    this.out.print(", ");
                    continue;
                }
                this.out.print("}");
            }
            if (y < h - 1) {
                this.out.println(",");
                continue;
            }
            this.out.println();
        }
        this.out.println("  };");
        this.out.println();
    }

    protected void writePlane(String varName, long[] array, int w, int h) {
        int i = 0;
        this.out.println("  public long[][] " + varName + " = {");
        for (int y = 0; y < h; ++y) {
            this.out.print("    {");
            for (int x = 0; x < w; ++x) {
                this.out.print(array[i++]);
                if (x < w - 1) {
                    this.out.print(", ");
                    continue;
                }
                this.out.print("}");
            }
            if (y < h - 1) {
                this.out.println(",");
                continue;
            }
            this.out.println();
        }
        this.out.println("  };");
        this.out.println();
    }

    protected void writePlane(String varName, float[] array, int w, int h) {
        int i = 0;
        this.out.println("  public float[][] " + varName + " = {");
        for (int y = 0; y < h; ++y) {
            this.out.print("    {");
            for (int x = 0; x < w; ++x) {
                this.out.print(array[i++]);
                if (x < w - 1) {
                    this.out.print(", ");
                    continue;
                }
                this.out.print("}");
            }
            if (y < h - 1) {
                this.out.println(",");
                continue;
            }
            this.out.println();
        }
        this.out.println("  };");
        this.out.println();
    }

    protected void writePlane(String varName, double[] array, int w, int h) {
        int i = 0;
        this.out.println("  public double[][] " + varName + " = {");
        for (int y = 0; y < h; ++y) {
            this.out.print("    {");
            for (int x = 0; x < w; ++x) {
                this.out.print(array[i++]);
                if (x < w - 1) {
                    this.out.print(", ");
                    continue;
                }
                this.out.print("}");
            }
            if (y < h - 1) {
                this.out.println(",");
                continue;
            }
            this.out.println();
        }
        this.out.println("  };");
        this.out.println();
    }

    protected void writeFooter() {
        this.out.println("}");
    }
}

