/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.DateTools;
import loci.formats.FormatException;
import loci.formats.in.BaseTiffReader;
import loci.formats.meta.FilterMetadata;
import loci.formats.tiff.IFD;

public class LEOReader
extends BaseTiffReader {
    public static final int LEO_TAG = 34118;
    private double xSize;
    private String date;
    private double workingDistance;

    public LEOReader() {
        super("LEO", "sxm");
        this.domains = new String[]{"Electron Microscopy (EM)"};
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        super.initStandardMetadata();
        String tag = ((IFD)this.ifds.get(0)).getIFDTextValue(34118);
        String[] lines = tag.split("\n");
        this.xSize = Double.parseDouble(lines[3]) * 1000000.0;
        double eht = Double.parseDouble(lines[6]);
        double filament = Double.parseDouble(lines[7]);
        this.workingDistance = Double.parseDouble(lines[9]);
        this.date = "";
        for (int line = 10; line < lines.length; ++line) {
            if (lines[line].equals("clock")) {
                this.date = this.date + lines[++line];
                continue;
            }
            if (!lines[line].equals("date")) continue;
            this.date = this.date + " " + lines[++line];
        }
        this.addGlobalMeta("Acquisition date", this.date);
        this.addGlobalMeta("EHT", eht);
        this.addGlobalMeta("Filament", filament);
        this.addGlobalMeta("Working Distance", this.workingDistance);
        this.addGlobalMeta("Physical pixel size", this.xSize + " um");
    }

    protected void initMetadataStore() throws FormatException {
        super.initMetadataStore();
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        store.setDimensionsPhysicalSizeX(new Double(this.xSize), 0, 0);
        store.setDimensionsPhysicalSizeY(new Double(this.xSize), 0, 0);
        store.setObjectiveWorkingDistance(new Double(this.workingDistance), 0, 0);
        this.date = DateTools.formatDate(this.date, "HH:mm dd-MMM-yyyy");
        store.setImageCreationDate(this.date, 0);
    }
}

