/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.DateTools;
import loci.common.XMLTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.MetadataTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.meta.FilterMetadata;
import loci.formats.tiff.IFD;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class ImaconReader
extends BaseTiffReader {
    private static final int CREATOR_TAG = 34377;
    private static final int XML_TAG = 50457;
    private String experimenterName;
    private String creationDate;
    private String imageName;

    public ImaconReader() {
        super("Imacon", new String[]{"fff"});
        this.domains = new String[]{"Graphics"};
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.experimenterName = null;
            this.creationDate = null;
            this.imageName = null;
        }
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        super.initStandardMetadata();
        this.ifds = this.tiffParser.getIFDs(false);
        this.core = new CoreMetadata[this.ifds.size()];
        for (int i = 0; i < this.core.length; ++i) {
            this.core[i] = new CoreMetadata();
            this.core[i].imageCount = 1;
            IFD ifd = (IFD)this.ifds.get(i);
            int photo = ifd.getPhotometricInterpretation();
            int samples = ifd.getSamplesPerPixel();
            boolean bl = this.core[i].rgb = samples > 1 || photo == 2 || photo == 32803;
            if (photo == 32803) {
                samples = 3;
            }
            this.core[i].sizeX = (int)ifd.getImageWidth();
            this.core[i].sizeY = (int)ifd.getImageLength();
            this.core[i].sizeZ = 1;
            this.core[i].sizeC = this.isRGB() ? samples : 1;
            this.core[i].sizeT = 1;
            this.core[i].pixelType = ifd.getPixelType();
            this.core[i].indexed = photo == 3;
            this.core[i].dimensionOrder = "XYCZT";
            this.core[i].interleaved = ifd.getPlanarConfiguration() == 2;
        }
        IFD firstIFD = (IFD)this.ifds.get(0);
        String xml = firstIFD.getIFDTextValue(50457).trim();
        xml = xml.substring(xml.indexOf("<"));
        XMLTools.parseXML(xml, (DefaultHandler)new ImaconHandler());
        String[] creationInfo = firstIFD.getIFDTextValue(34377).split("\n");
        int lineNumber = 0;
        for (String s : creationInfo) {
            if (s.trim().length() == 0) continue;
            switch (lineNumber) {
                case 4: {
                    this.experimenterName = s.trim();
                    break;
                }
                case 6: {
                    this.imageName = s.trim();
                    break;
                }
                case 8: {
                    this.creationDate = s.trim();
                    break;
                }
                case 10: {
                    this.creationDate = this.creationDate + " " + s.trim();
                }
            }
            ++lineNumber;
        }
    }

    protected void initMetadataStore() throws FormatException {
        int nameSpace;
        super.initMetadataStore();
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        if (this.experimenterName == null) {
            this.experimenterName = "";
        }
        String firstName = (nameSpace = this.experimenterName.indexOf(" ")) == -1 ? "" : this.experimenterName.substring(0, nameSpace);
        String lastName = nameSpace == -1 ? this.experimenterName : this.experimenterName.substring(nameSpace + 1);
        String experimenter = MetadataTools.createLSID("Experimenter", 0);
        store.setExperimenterID(experimenter, 0);
        store.setExperimenterFirstName(firstName, 0);
        store.setExperimenterLastName(lastName, 0);
        if (this.creationDate != null) {
            this.creationDate = DateTools.formatDate(this.creationDate, "yyyyMMdd HHmmSSZ");
        }
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            store.setImageExperimenterRef(experimenter, i);
            store.setImageName(this.imageName + " #" + (i + 1), i);
            if (this.creationDate != null) {
                store.setImageCreationDate(this.creationDate, i);
                continue;
            }
            MetadataTools.setDefaultCreationDate(store, this.currentId, i);
        }
    }

    class ImaconHandler
    extends DefaultHandler {
        private String key;
        private String value;
        private String qName;

        ImaconHandler() {
        }

        public void characters(char[] data, int start, int len) {
            if (this.qName.equals("key")) {
                this.key = new String(data, start, len);
                this.value = null;
            } else {
                this.value = new String(data, start, len);
            }
            if (this.key != null && this.value != null) {
                ImaconReader.this.addGlobalMeta(this.key, this.value);
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            this.qName = qName;
        }
    }
}

