/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.enums.handler;

import java.util.Hashtable;
import loci.formats.enums.Enumeration;
import loci.formats.enums.EnumerationException;
import loci.formats.enums.MicrobeamManipulationType;
import loci.formats.enums.handler.IEnumerationHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MicrobeamManipulationTypeEnumHandler
implements IEnumerationHandler {
    private static final Hashtable<String, String> patterns = MicrobeamManipulationTypeEnumHandler.makePatterns();

    private static Hashtable<String, String> makePatterns() {
        Hashtable<String, String> p = new Hashtable<String, String>();
        p.put("^\\s*FRAP\\s*", "FRAP");
        p.put("^\\s*Photoablation\\s*", "Photoablation");
        p.put("^\\s*Photoactivation\\s*", "Photoactivation");
        p.put("^\\s*Uncaging\\s*", "Uncaging");
        p.put("^\\s*OpticalTrapping\\s*", "OpticalTrapping");
        p.put("^\\s*Other\\s*", "Other");
        return p;
    }

    @Override
    public Enumeration getEnumeration(String value) throws EnumerationException {
        for (String pattern : patterns.keySet()) {
            if (!value.toLowerCase().matches(pattern.toLowerCase())) continue;
            String v = patterns.get(pattern);
            return MicrobeamManipulationType.fromString(v);
        }
        throw new EnumerationException(this.getClass().getName() + " could not find enumeration for " + value);
    }

    @Override
    public Class<? extends Enumeration> getEntity() {
        return MicrobeamManipulationType.class;
    }
}

