/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.enums.handler;

import java.util.Hashtable;
import loci.formats.enums.DetectorType;
import loci.formats.enums.Enumeration;
import loci.formats.enums.EnumerationException;
import loci.formats.enums.handler.IEnumerationHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DetectorTypeEnumHandler
implements IEnumerationHandler {
    private static final Hashtable<String, String> patterns = DetectorTypeEnumHandler.makePatterns();

    private static Hashtable<String, String> makePatterns() {
        Hashtable<String, String> p = new Hashtable<String, String>();
        p.put("^\\s*CCD\\s*", "CCD");
        p.put("^\\s*IntensifiedCCD\\s*", "IntensifiedCCD");
        p.put("^\\s*AnalogVideo\\s*", "AnalogVideo");
        p.put("^\\s*PMT\\s*", "PMT");
        p.put("^\\s*Photodiode\\s*", "Photodiode");
        p.put("^\\s*Spectroscopy\\s*", "Spectroscopy");
        p.put("^\\s*LifetimeImaging\\s*", "LifetimeImaging");
        p.put("^\\s*CorrelationSpectroscopy\\s*", "CorrelationSpectroscopy");
        p.put("^\\s*FTIR\\s*", "FTIR");
        p.put("^\\s*EMCCD\\s*", "EMCCD");
        p.put("^\\s*APD\\s*", "APD");
        p.put("^\\s*CMOS\\s*", "CMOS");
        p.put("^\\s*Other\\s*", "Other");
        return p;
    }

    @Override
    public Enumeration getEnumeration(String value) throws EnumerationException {
        for (String pattern : patterns.keySet()) {
            if (!value.toLowerCase().matches(pattern.toLowerCase())) continue;
            String v = patterns.get(pattern);
            return DetectorType.fromString(v);
        }
        throw new EnumerationException(this.getClass().getName() + " could not find enumeration for " + value);
    }

    @Override
    public Class<? extends Enumeration> getEntity() {
        return DetectorType.class;
    }
}

