/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.enums;

import loci.formats.enums.Enumeration;
import loci.formats.enums.EnumerationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum MicrobeamManipulationType implements Enumeration
{
    FRAP("FRAP"),
    PHOTOABLATION("Photoablation"),
    PHOTOACTIVATION("Photoactivation"),
    UNCAGING("Uncaging"),
    OPTICALTRAPPING("OpticalTrapping"),
    OTHER("Other");

    private final String value;

    private MicrobeamManipulationType(String value) {
        this.value = value;
    }

    public static MicrobeamManipulationType fromString(String value) throws EnumerationException {
        if ("FRAP".equals(value)) {
            return FRAP;
        }
        if ("Photoablation".equals(value)) {
            return PHOTOABLATION;
        }
        if ("Photoactivation".equals(value)) {
            return PHOTOACTIVATION;
        }
        if ("Uncaging".equals(value)) {
            return UNCAGING;
        }
        if ("OpticalTrapping".equals(value)) {
            return OPTICALTRAPPING;
        }
        if ("Other".equals(value)) {
            return OTHER;
        }
        String s = String.format("%s not a supported value of %s", value, MicrobeamManipulationType.class);
        throw new EnumerationException(s);
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }
}

