/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.enums;

import loci.formats.enums.Enumeration;
import loci.formats.enums.EnumerationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Medium implements Enumeration
{
    AIR("Air"),
    OIL("Oil"),
    WATER("Water"),
    GLYCEROL("Glycerol"),
    OTHER("Other");

    private final String value;

    private Medium(String value) {
        this.value = value;
    }

    public static Medium fromString(String value) throws EnumerationException {
        if ("Air".equals(value)) {
            return AIR;
        }
        if ("Oil".equals(value)) {
            return OIL;
        }
        if ("Water".equals(value)) {
            return WATER;
        }
        if ("Glycerol".equals(value)) {
            return GLYCEROL;
        }
        if ("Other".equals(value)) {
            return OTHER;
        }
        String s = String.format("%s not a supported value of %s", value, Medium.class);
        throw new EnumerationException(s);
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }
}

