/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.enums;

import loci.formats.enums.Enumeration;
import loci.formats.enums.EnumerationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Marker implements Enumeration
{
    ARROW("Arrow"),
    CIRCLE("Circle"),
    SQUARE("Square");

    private final String value;

    private Marker(String value) {
        this.value = value;
    }

    public static Marker fromString(String value) throws EnumerationException {
        if ("Arrow".equals(value)) {
            return ARROW;
        }
        if ("Circle".equals(value)) {
            return CIRCLE;
        }
        if ("Square".equals(value)) {
            return SQUARE;
        }
        String s = String.format("%s not a supported value of %s", value, Marker.class);
        throw new EnumerationException(s);
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }
}

