/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.enums;

import loci.formats.enums.Enumeration;
import loci.formats.enums.EnumerationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FilterType implements Enumeration
{
    LONGPASS("LongPass"),
    SHORTPASS("ShortPass"),
    BANDPASS("BandPass"),
    MULTIPASS("MultiPass"),
    OTHER("Other");

    private final String value;

    private FilterType(String value) {
        this.value = value;
    }

    public static FilterType fromString(String value) throws EnumerationException {
        if ("LongPass".equals(value)) {
            return LONGPASS;
        }
        if ("ShortPass".equals(value)) {
            return SHORTPASS;
        }
        if ("BandPass".equals(value)) {
            return BANDPASS;
        }
        if ("MultiPass".equals(value)) {
            return MULTIPASS;
        }
        if ("Other".equals(value)) {
            return OTHER;
        }
        String s = String.format("%s not a supported value of %s", value, FilterType.class);
        throw new EnumerationException(s);
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }
}

