/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.enums;

import loci.formats.enums.Enumeration;
import loci.formats.enums.EnumerationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DetectorType implements Enumeration
{
    CCD("CCD"),
    INTENSIFIEDCCD("IntensifiedCCD"),
    ANALOGVIDEO("AnalogVideo"),
    PMT("PMT"),
    PHOTODIODE("Photodiode"),
    SPECTROSCOPY("Spectroscopy"),
    LIFETIMEIMAGING("LifetimeImaging"),
    CORRELATIONSPECTROSCOPY("CorrelationSpectroscopy"),
    FTIR("FTIR"),
    EMCCD("EMCCD"),
    APD("APD"),
    CMOS("CMOS"),
    OTHER("Other");

    private final String value;

    private DetectorType(String value) {
        this.value = value;
    }

    public static DetectorType fromString(String value) throws EnumerationException {
        if ("CCD".equals(value)) {
            return CCD;
        }
        if ("IntensifiedCCD".equals(value)) {
            return INTENSIFIEDCCD;
        }
        if ("AnalogVideo".equals(value)) {
            return ANALOGVIDEO;
        }
        if ("PMT".equals(value)) {
            return PMT;
        }
        if ("Photodiode".equals(value)) {
            return PHOTODIODE;
        }
        if ("Spectroscopy".equals(value)) {
            return SPECTROSCOPY;
        }
        if ("LifetimeImaging".equals(value)) {
            return LIFETIMEIMAGING;
        }
        if ("CorrelationSpectroscopy".equals(value)) {
            return CORRELATIONSPECTROSCOPY;
        }
        if ("FTIR".equals(value)) {
            return FTIR;
        }
        if ("EMCCD".equals(value)) {
            return EMCCD;
        }
        if ("APD".equals(value)) {
            return APD;
        }
        if ("CMOS".equals(value)) {
            return CMOS;
        }
        if ("Other".equals(value)) {
            return OTHER;
        }
        String s = String.format("%s not a supported value of %s", value, DetectorType.class);
        throw new EnumerationException(s);
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }
}

