/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.enums;

import loci.formats.enums.Enumeration;
import loci.formats.enums.EnumerationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum AcquisitionMode implements Enumeration
{
    WIDEFIELD("WideField"),
    LASERSCANNINGMICROSCOPY("LaserScanningMicroscopy"),
    LASERSCANNINGCONFOCAL("LaserScanningConfocal"),
    SPINNINGDISKCONFOCAL("SpinningDiskConfocal"),
    SLITSCANCONFOCAL("SlitScanConfocal"),
    MULTIPHOTONMICROSCOPY("MultiPhotonMicroscopy"),
    STRUCTUREDILLUMINATION("StructuredIllumination"),
    SINGLEMOLECULEIMAGING("SingleMoleculeImaging"),
    TOTALINTERNALREFLECTION("TotalInternalReflection"),
    FLUORESCENCELIFETIME("FluorescenceLifetime"),
    SPECTRALIMAGING("SpectralImaging"),
    FLUORESCENCECORRELATIONSPECTROSCOPY("FluorescenceCorrelationSpectroscopy"),
    NEARFIELDSCANNINGOPTICALMICROSCOPY("NearFieldScanningOpticalMicroscopy"),
    SECONDHARMONICGENERATIONIMAGING("SecondHarmonicGenerationImaging"),
    OTHER("Other");

    private final String value;

    private AcquisitionMode(String value) {
        this.value = value;
    }

    public static AcquisitionMode fromString(String value) throws EnumerationException {
        if ("WideField".equals(value)) {
            return WIDEFIELD;
        }
        if ("LaserScanningMicroscopy".equals(value)) {
            return LASERSCANNINGMICROSCOPY;
        }
        if ("LaserScanningConfocal".equals(value)) {
            return LASERSCANNINGCONFOCAL;
        }
        if ("SpinningDiskConfocal".equals(value)) {
            return SPINNINGDISKCONFOCAL;
        }
        if ("SlitScanConfocal".equals(value)) {
            return SLITSCANCONFOCAL;
        }
        if ("MultiPhotonMicroscopy".equals(value)) {
            return MULTIPHOTONMICROSCOPY;
        }
        if ("StructuredIllumination".equals(value)) {
            return STRUCTUREDILLUMINATION;
        }
        if ("SingleMoleculeImaging".equals(value)) {
            return SINGLEMOLECULEIMAGING;
        }
        if ("TotalInternalReflection".equals(value)) {
            return TOTALINTERNALREFLECTION;
        }
        if ("FluorescenceLifetime".equals(value)) {
            return FLUORESCENCELIFETIME;
        }
        if ("SpectralImaging".equals(value)) {
            return SPECTRALIMAGING;
        }
        if ("FluorescenceCorrelationSpectroscopy".equals(value)) {
            return FLUORESCENCECORRELATIONSPECTROSCOPY;
        }
        if ("NearFieldScanningOpticalMicroscopy".equals(value)) {
            return NEARFIELDSCANNINGOPTICALMICROSCOPY;
        }
        if ("SecondHarmonicGenerationImaging".equals(value)) {
            return SECONDHARMONICGENERATIONIMAGING;
        }
        if ("Other".equals(value)) {
            return OTHER;
        }
        String s = String.format("%s not a supported value of %s", value, AcquisitionMode.class);
        throw new EnumerationException(s);
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }
}

