/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.awt.image.ColorModel;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import loci.formats.FormatException;
import loci.formats.IFormatWriter;
import loci.formats.ImageWriter;
import loci.formats.StatusListener;
import loci.formats.meta.MetadataRetrieve;

public abstract class WriterWrapper
implements IFormatWriter {
    protected IFormatWriter writer;

    public WriterWrapper() {
        this(new ImageWriter());
    }

    public WriterWrapper(IFormatWriter w) {
        if (w == null) {
            throw new IllegalArgumentException("Format writer cannot be null");
        }
        this.writer = w;
    }

    public IFormatWriter getWriter() {
        return this.writer;
    }

    public IFormatWriter unwrap() throws FormatException, IOException {
        return this.unwrap(null, null);
    }

    public IFormatWriter unwrap(String id) throws FormatException, IOException {
        return this.unwrap(null, id);
    }

    public IFormatWriter unwrap(Class writerClass, String id) throws FormatException, IOException {
        IFormatWriter w = this;
        while (!(!(w instanceof WriterWrapper) && !(w instanceof ImageWriter) || writerClass != null && writerClass.isInstance(w))) {
            if (w instanceof ImageWriter) {
                ImageWriter iw = (ImageWriter)w;
                w = id == null ? iw.getWriter() : iw.getWriter(id);
                continue;
            }
            w = w.getWriter();
        }
        if (writerClass != null && !writerClass.isInstance(w)) {
            return null;
        }
        return w;
    }

    public WriterWrapper duplicate(Class imageWriterClass) throws FormatException {
        WriterWrapper wrapperCopy = this.duplicateRecurse(imageWriterClass);
        boolean interleaved = this.isInterleaved();
        ColorModel cm = this.getColorModel();
        int rate = this.getFramesPerSecond();
        String compress = this.getCompression();
        StatusListener[] statusListeners = this.getStatusListeners();
        wrapperCopy.setInterleaved(interleaved);
        wrapperCopy.setColorModel(cm);
        wrapperCopy.setFramesPerSecond(rate);
        wrapperCopy.setCompression(compress);
        for (int k = 0; k < statusListeners.length; ++k) {
            wrapperCopy.addStatusListener(statusListeners[k]);
        }
        return wrapperCopy;
    }

    public void saveBytes(byte[] bytes, boolean last) throws FormatException, IOException {
        this.writer.saveBytes(bytes, last);
    }

    public void saveBytes(byte[] bytes, int series, boolean lastInSeries, boolean last) throws FormatException, IOException {
        this.writer.saveBytes(bytes, series, lastInSeries, last);
    }

    public void savePlane(Object plane, boolean last) throws FormatException, IOException {
        this.writer.savePlane(plane, last);
    }

    public void savePlane(Object plane, int series, boolean lastInSeries, boolean last) throws FormatException, IOException {
        this.writer.savePlane(plane, series, lastInSeries, last);
    }

    public void setInterleaved(boolean interleaved) {
        this.writer.setInterleaved(interleaved);
    }

    public boolean isInterleaved() {
        return this.writer.isInterleaved();
    }

    public boolean canDoStacks() {
        return this.writer.canDoStacks();
    }

    public void setMetadataRetrieve(MetadataRetrieve r) {
        this.writer.setMetadataRetrieve(r);
    }

    public MetadataRetrieve getMetadataRetrieve() {
        return this.writer.getMetadataRetrieve();
    }

    public void setColorModel(ColorModel cm) {
        this.writer.setColorModel(cm);
    }

    public ColorModel getColorModel() {
        return this.writer.getColorModel();
    }

    public void setFramesPerSecond(int rate) {
        this.writer.setFramesPerSecond(rate);
    }

    public int getFramesPerSecond() {
        return this.writer.getFramesPerSecond();
    }

    public String[] getCompressionTypes() {
        return this.writer.getCompressionTypes();
    }

    public int[] getPixelTypes() {
        return this.writer.getPixelTypes();
    }

    public int[] getPixelTypes(String codec) {
        return this.writer.getPixelTypes(codec);
    }

    public boolean isSupportedType(int type) {
        return this.writer.isSupportedType(type);
    }

    public void setCompression(String compress) throws FormatException {
        this.writer.setCompression(compress);
    }

    public String getCompression() {
        return this.writer.getCompression();
    }

    public boolean isThisType(String name) {
        return this.writer.isThisType(name);
    }

    public String getFormat() {
        return this.writer.getFormat();
    }

    public String[] getSuffixes() {
        return this.writer.getSuffixes();
    }

    public Class getNativeDataType() {
        return this.writer.getNativeDataType();
    }

    public void setId(String id) throws FormatException, IOException {
        this.writer.setId(id);
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public void addStatusListener(StatusListener l) {
        this.writer.addStatusListener(l);
    }

    public void removeStatusListener(StatusListener l) {
        this.writer.removeStatusListener(l);
    }

    public StatusListener[] getStatusListeners() {
        return this.writer.getStatusListeners();
    }

    private WriterWrapper duplicateRecurse(Class imageWriterClass) throws FormatException {
        IFormatWriter childCopy = null;
        if (this.writer instanceof WriterWrapper) {
            childCopy = ((WriterWrapper)this.writer).duplicateRecurse(imageWriterClass);
        } else {
            Class<?> c = null;
            c = this.writer instanceof ImageWriter ? (imageWriterClass == null ? ImageWriter.class : imageWriterClass) : this.writer.getClass();
            try {
                childCopy = (IFormatWriter)c.newInstance();
            }
            catch (IllegalAccessException exc) {
                throw new FormatException(exc);
            }
            catch (InstantiationException exc) {
                throw new FormatException(exc);
            }
        }
        Class<?> wrapperClass = this.getClass();
        WriterWrapper wrapperCopy = null;
        try {
            wrapperCopy = (WriterWrapper)wrapperClass.getConstructor(IFormatWriter.class).newInstance(childCopy);
        }
        catch (InstantiationException exc) {
            throw new FormatException(exc);
        }
        catch (IllegalAccessException exc) {
            throw new FormatException(exc);
        }
        catch (NoSuchMethodException exc) {
            throw new FormatException(exc);
        }
        catch (InvocationTargetException exc) {
            throw new FormatException(exc);
        }
        return wrapperCopy;
    }
}

