/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.tiff;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.tiff.TiffParser;

public final class TiffTools {
    private TiffTools() {
    }

    public static boolean isValidHeader(byte[] block) {
        return TiffTools.checkHeader(block) != null;
    }

    public static Boolean checkHeader(byte[] block) {
        try {
            RandomAccessInputStream in = new RandomAccessInputStream(block);
            TiffParser tiffParser = new TiffParser(in);
            Boolean result = tiffParser.checkHeader();
            in.close();
            return result;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String getComment(String id) throws IOException {
        RandomAccessInputStream in = new RandomAccessInputStream(id);
        TiffParser tiffParser = new TiffParser(in);
        String comment = tiffParser.getComment();
        in.close();
        return comment;
    }
}

