/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.awt.image.ColorModel;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Vector;
import loci.common.LogTools;
import loci.formats.ClassList;
import loci.formats.FormatException;
import loci.formats.IFormatWriter;
import loci.formats.StatusListener;
import loci.formats.UnknownFormatException;
import loci.formats.meta.MetadataRetrieve;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageWriter
implements IFormatWriter {
    private static ClassList defaultClasses;
    protected IFormatWriter[] writers;
    private String[] suffixes;
    protected String[] compressionTypes;
    protected String currentId;
    protected int current;

    private static ClassList getDefaultWriterClasses() {
        if (defaultClasses == null) {
            try {
                defaultClasses = new ClassList("writers.txt", IFormatWriter.class);
            }
            catch (IOException exc) {
                defaultClasses = new ClassList(IFormatWriter.class);
                LogTools.trace(exc);
            }
        }
        return defaultClasses;
    }

    public ImageWriter() {
        this(ImageWriter.getDefaultWriterClasses());
    }

    public ImageWriter(ClassList classList) {
        Vector<IFormatWriter> v = new Vector<IFormatWriter>();
        Class[] c = classList.getClasses();
        for (int i = 0; i < c.length; ++i) {
            IFormatWriter writer = null;
            try {
                writer = (IFormatWriter)c[i].newInstance();
            }
            catch (IllegalAccessException exc) {
            }
            catch (InstantiationException exc) {
                // empty catch block
            }
            if (writer == null) {
                LogTools.println("Error: " + c[i].getName() + " cannot be instantiated.");
                continue;
            }
            v.add(writer);
        }
        this.writers = new IFormatWriter[v.size()];
        v.copyInto(this.writers);
    }

    public String getFormat(String id) throws FormatException, IOException {
        return this.getWriter(id).getFormat();
    }

    public IFormatWriter getWriter(String id) throws FormatException {
        if (!id.equals(this.currentId)) {
            boolean success = false;
            for (int i = 0; i < this.writers.length; ++i) {
                if (!this.writers[i].isThisType(id)) continue;
                this.current = i;
                this.currentId = id;
                success = true;
                break;
            }
            if (!success) {
                throw new UnknownFormatException("Unknown file format: " + id);
            }
        }
        return this.writers[this.current];
    }

    public IFormatWriter getWriter() {
        return this.writers[this.current];
    }

    public IFormatWriter getWriter(Class<IFormatWriter> c) {
        for (int i = 0; i < this.writers.length; ++i) {
            if (!this.writers[i].getClass().equals(c)) continue;
            return this.writers[i];
        }
        return null;
    }

    public IFormatWriter[] getWriters() {
        IFormatWriter[] w = new IFormatWriter[this.writers.length];
        System.arraycopy(this.writers, 0, w, 0, this.writers.length);
        return w;
    }

    @Override
    public void saveBytes(byte[] bytes, boolean last) throws FormatException, IOException {
        this.getWriter().saveBytes(bytes, last);
    }

    @Override
    public void saveBytes(byte[] bytes, int series, boolean lastInSeries, boolean last) throws FormatException, IOException {
        this.getWriter().saveBytes(bytes, series, lastInSeries, last);
    }

    @Override
    public void savePlane(Object plane, boolean last) throws FormatException, IOException {
        this.getWriter().savePlane(plane, last);
    }

    @Override
    public void savePlane(Object plane, int series, boolean lastInSeries, boolean last) throws FormatException, IOException {
        this.getWriter().savePlane(plane, series, lastInSeries, last);
    }

    @Override
    public void setInterleaved(boolean interleaved) {
        for (int i = 0; i < this.writers.length; ++i) {
            this.writers[i].setInterleaved(interleaved);
        }
    }

    @Override
    public boolean isInterleaved() {
        return this.writers[0].isInterleaved();
    }

    @Override
    public boolean canDoStacks() {
        return this.getWriter().canDoStacks();
    }

    @Override
    public void setMetadataRetrieve(MetadataRetrieve r) {
        for (int i = 0; i < this.writers.length; ++i) {
            this.writers[i].setMetadataRetrieve(r);
        }
    }

    @Override
    public MetadataRetrieve getMetadataRetrieve() {
        return this.getWriter().getMetadataRetrieve();
    }

    @Override
    public void setColorModel(ColorModel cm) {
        for (int i = 0; i < this.writers.length; ++i) {
            this.writers[i].setColorModel(cm);
        }
    }

    @Override
    public ColorModel getColorModel() {
        return this.writers[0].getColorModel();
    }

    @Override
    public void setFramesPerSecond(int rate) {
        for (int i = 0; i < this.writers.length; ++i) {
            this.writers[i].setFramesPerSecond(rate);
        }
    }

    @Override
    public int getFramesPerSecond() {
        return this.writers[0].getFramesPerSecond();
    }

    @Override
    public String[] getCompressionTypes() {
        if (this.compressionTypes == null) {
            HashSet<String> set = new HashSet<String>();
            for (int i = 0; i < this.writers.length; ++i) {
                String[] s = this.writers[i].getCompressionTypes();
                if (s == null) continue;
                for (int j = 0; j < s.length; ++j) {
                    set.add(s[j]);
                }
            }
            this.compressionTypes = new String[set.size()];
            set.toArray(this.compressionTypes);
            Arrays.sort(this.compressionTypes);
        }
        return this.compressionTypes;
    }

    @Override
    public int[] getPixelTypes() {
        return this.getWriter().getPixelTypes();
    }

    @Override
    public int[] getPixelTypes(String codec) {
        return this.getWriter().getPixelTypes(codec);
    }

    @Override
    public boolean isSupportedType(int type) {
        return this.getWriter().isSupportedType(type);
    }

    @Override
    public void setCompression(String compress) throws FormatException {
        boolean ok = false;
        for (int i = 0; i < this.writers.length; ++i) {
            String[] s = this.writers[i].getCompressionTypes();
            if (s == null) continue;
            for (int j = 0; j < s.length; ++j) {
                if (!s[j].equals(compress)) continue;
                this.writers[i].setCompression(compress);
                ok = true;
            }
        }
        if (!ok) {
            throw new FormatException("Invalid compression type: " + compress);
        }
    }

    @Override
    public String getCompression() {
        return this.getWriter().getCompression();
    }

    @Override
    public boolean isThisType(String name) {
        for (int i = 0; i < this.writers.length; ++i) {
            if (!this.writers[i].isThisType(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getFormat() {
        return this.getWriter().getFormat();
    }

    @Override
    public String[] getSuffixes() {
        if (this.suffixes == null) {
            HashSet<String> suffixSet = new HashSet<String>();
            for (int i = 0; i < this.writers.length; ++i) {
                String[] suf = this.writers[i].getSuffixes();
                for (int j = 0; j < suf.length; ++j) {
                    suffixSet.add(suf[j]);
                }
            }
            this.suffixes = new String[suffixSet.size()];
            suffixSet.toArray(this.suffixes);
            Arrays.sort(this.suffixes);
        }
        return this.suffixes;
    }

    @Override
    public Class getNativeDataType() {
        return this.getWriter().getNativeDataType();
    }

    @Override
    public void setId(String id) throws FormatException, IOException {
        this.getWriter(id).setId(id);
    }

    @Override
    public void close() throws IOException {
        this.getWriter().close();
    }

    @Override
    public void addStatusListener(StatusListener l) {
        for (int i = 0; i < this.writers.length; ++i) {
            this.writers[i].addStatusListener(l);
        }
    }

    @Override
    public void removeStatusListener(StatusListener l) {
        for (int i = 0; i < this.writers.length; ++i) {
            this.writers[i].removeStatusListener(l);
        }
    }

    @Override
    public StatusListener[] getStatusListeners() {
        return this.writers[0].getStatusListeners();
    }
}

