/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import ucar.unidata.geoloc.Earth;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.geoloc.projection.LatLonProjection;
import ucar.unidata.util.Format;
import ucar.unidata.util.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProjectionImpl
implements Projection,
Cloneable,
Serializable {
    public static final String ATTR_NAME = "Projection_Name";
    public static final double EARTH_RADIUS = Earth.getRadius() * 0.001;
    public static final int INDEX_LAT = 0;
    public static final int INDEX_LON = 1;
    public static final int INDEX_X = 0;
    public static final int INDEX_Y = 1;
    protected static final double TOLERANCE = 1.0E-6;
    public static final double PI = Math.PI;
    public static final double PI_OVER_2 = 1.5707963267948966;
    public static final double PI_OVER_4 = 0.7853981633974483;
    protected String name = "";
    protected boolean isLatLon = false;
    protected List<Parameter> atts = new ArrayList<Parameter>();
    protected ProjectionRect defaultMapArea = new ProjectionRect();
    private static String header = null;
    protected ProjectionPointImpl workP = new ProjectionPointImpl();
    protected LatLonPointImpl workL = new LatLonPointImpl();

    public abstract ProjectionImpl constructCopy();

    @Override
    public String getClassName() {
        String className = this.getClass().getName();
        int index = className.lastIndexOf(".");
        if (index >= 0) {
            className = className.substring(index + 1);
        }
        return className;
    }

    @Override
    public abstract String paramsToString();

    public String getProjectionTypeLabel() {
        return this.getClassName();
    }

    @Override
    public abstract ProjectionPoint latLonToProj(LatLonPoint var1, ProjectionPointImpl var2);

    @Override
    public abstract LatLonPoint projToLatLon(ProjectionPoint var1, LatLonPointImpl var2);

    public ProjectionPoint latLonToProj(LatLonPoint latLon) {
        return this.latLonToProj(latLon, this.workP);
    }

    public LatLonPoint projToLatLon(ProjectionPoint ppt) {
        return this.projToLatLon(ppt, this.workL);
    }

    @Override
    public abstract boolean crossSeam(ProjectionPoint var1, ProjectionPoint var2);

    @Override
    public abstract boolean equals(Object var1);

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public List<Parameter> getProjectionParameters() {
        return this.atts;
    }

    protected void addParameter(String name, String value) {
        this.atts.add(new Parameter(name, value));
    }

    protected void addParameter(String name, double value) {
        this.atts.add(new Parameter(name, value));
    }

    protected void addParameter(Parameter p) {
        this.atts.add(p);
    }

    public boolean isLatLon() {
        return this.isLatLon;
    }

    public static String getHeader() {
        if (header == null) {
            StringBuffer headerB = new StringBuffer(60);
            headerB.append("Name");
            Format.tab(headerB, 20, true);
            headerB.append("Class");
            Format.tab(headerB, 40, true);
            headerB.append("Parameters");
            header = headerB.toString();
        }
        return header;
    }

    public String toString() {
        return this.getName();
    }

    public Object clone() {
        ProjectionImpl p;
        try {
            p = (ProjectionImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        p.name = this.name;
        this.workP = new ProjectionPointImpl();
        this.workL = new LatLonPointImpl();
        p.defaultMapArea = new ProjectionRect(this.defaultMapArea);
        return p;
    }

    @Override
    public ProjectionRect getDefaultMapArea() {
        return this.defaultMapArea;
    }

    public LatLonRect getDefaultMapAreaLL() {
        return this.projToLatLonBB(this.defaultMapArea);
    }

    public void setDefaultMapArea(ProjectionRect bb) {
        if (bb == null) {
            return;
        }
        this.defaultMapArea = (ProjectionRect)bb.clone();
    }

    public ProjectionPointImpl latLonToProj(double lat, double lon) {
        this.workL.setLatitude(lat);
        this.workL.setLongitude(lon);
        return (ProjectionPointImpl)this.latLonToProj(this.workL);
    }

    public LatLonPointImpl projToLatLon(double x, double y) {
        this.workP.setLocation(x, y);
        return (LatLonPointImpl)this.projToLatLon(this.workP);
    }

    public double[][] projToLatLon(double[][] from) {
        return this.projToLatLon(from, new double[2][from[0].length]);
    }

    public double[][] projToLatLon(double[][] from, double[][] to) {
        if (from == null || from.length != 2) {
            throw new IllegalArgumentException("ProjectionImpl.projToLatLon:null array argument or wrong dimension (from)");
        }
        if (to == null || to.length != 2) {
            throw new IllegalArgumentException("ProjectionImpl.projToLatLon:null array argument or wrong dimension (to)");
        }
        if (from[0].length != to[0].length) {
            throw new IllegalArgumentException("ProjectionImpl.projToLatLon:from array not same length as to array");
        }
        for (int i = 0; i < from[0].length; ++i) {
            LatLonPointImpl endL = this.projToLatLon(from[0][i], from[1][i]);
            to[0][i] = endL.getLatitude();
            to[1][i] = endL.getLongitude();
        }
        return to;
    }

    public float[][] projToLatLon(float[][] from) {
        return this.projToLatLon(from, new float[2][from[0].length]);
    }

    public float[][] projToLatLon(float[][] from, float[][] to) {
        if (from == null || from.length != 2) {
            throw new IllegalArgumentException("ProjectionImpl.projToLatLon:null array argument or wrong dimension (from)");
        }
        if (to == null || to.length != 2) {
            throw new IllegalArgumentException("ProjectionImpl.projToLatLon:null array argument or wrong dimension (to)");
        }
        if (from[0].length != to[0].length) {
            throw new IllegalArgumentException("ProjectionImpl.projToLatLon:from array not same length as to array");
        }
        ProjectionPointImpl ppi = new ProjectionPointImpl();
        LatLonPointImpl llpi = new LatLonPointImpl();
        for (int i = 0; i < from[0].length; ++i) {
            ppi.setLocation(from[0][i], from[1][i]);
            this.projToLatLon(ppi, llpi);
            to[0][i] = (float)llpi.getLatitude();
            to[1][i] = (float)llpi.getLongitude();
        }
        return to;
    }

    public double[][] latLonToProj(double[][] from) {
        return this.latLonToProj(from, new double[2][from[0].length]);
    }

    public double[][] latLonToProj(double[][] from, double[][] to) {
        return this.latLonToProj(from, to, 0, 1);
    }

    public double[][] latLonToProj(double[][] from, int latIndex, int lonIndex) {
        return this.latLonToProj(from, new double[2][from[0].length], latIndex, lonIndex);
    }

    public double[][] latLonToProj(double[][] from, double[][] to, int latIndex, int lonIndex) {
        if (from == null || from.length != 2) {
            throw new IllegalArgumentException("ProjectionImpl.latLonToProj:null array argument or wrong dimension (from)");
        }
        if (to == null || to.length != 2) {
            throw new IllegalArgumentException("ProjectionImpl.latLonToProj:null array argument or wrong dimension (to)");
        }
        if (from[0].length != to[0].length) {
            throw new IllegalArgumentException("ProjectionImpl.latLonToProj:from array not same length as to array");
        }
        ProjectionPointImpl ppi = new ProjectionPointImpl();
        LatLonPointImpl llpi = new LatLonPointImpl();
        for (int i = 0; i < from[0].length; ++i) {
            llpi.setLatitude(from[latIndex][i]);
            llpi.setLongitude(from[lonIndex][i]);
            this.latLonToProj(llpi, ppi);
            to[0][i] = ppi.getX();
            to[1][i] = ppi.getY();
        }
        return to;
    }

    public float[][] latLonToProj(float[][] from) {
        return this.latLonToProj(from, new float[2][from[0].length]);
    }

    public float[][] latLonToProj(float[][] from, float[][] to) {
        return this.latLonToProj(from, to, 0, 1);
    }

    public float[][] latLonToProj(float[][] from, int latIndex, int lonIndex) {
        return this.latLonToProj(from, new float[2][from[0].length], latIndex, lonIndex);
    }

    public float[][] latLonToProj(float[][] from, float[][] to, int latIndex, int lonIndex) {
        if (from == null || from.length != 2) {
            throw new IllegalArgumentException("ProjectionImpl.latLonToProj:null array argument or wrong dimension (from)");
        }
        if (to == null || to.length != 2) {
            throw new IllegalArgumentException("ProjectionImpl.latLonToProj:null array argument or wrong dimension (to)");
        }
        if (from[0].length != to[0].length) {
            throw new IllegalArgumentException("ProjectionImpl.latLonToProj:from array not same length as to array");
        }
        ProjectionPointImpl ppi = new ProjectionPointImpl();
        LatLonPointImpl llpi = new LatLonPointImpl();
        for (int i = 0; i < from[0].length; ++i) {
            llpi.setLatitude(from[latIndex][i]);
            llpi.setLongitude(from[lonIndex][i]);
            this.latLonToProj(llpi, ppi);
            to[0][i] = (float)ppi.getX();
            to[1][i] = (float)ppi.getY();
        }
        return to;
    }

    ProjectionRect latLonToProjBB2(LatLonRect latlonRect) {
        double maxy;
        double maxx;
        double miny;
        double minx;
        LatLonPointImpl llpt = latlonRect.getLowerLeftPoint();
        LatLonPointImpl urpt = latlonRect.getUpperRightPoint();
        LatLonPointImpl lrpt = latlonRect.getLowerRightPoint();
        LatLonPointImpl ulpt = latlonRect.getUpperLeftPoint();
        if (this.isLatLon()) {
            minx = this.getMinOrMaxLon(llpt.getLongitude(), ulpt.getLongitude(), true);
            miny = Math.min(llpt.getLatitude(), lrpt.getLatitude());
            maxx = this.getMinOrMaxLon(urpt.getLongitude(), lrpt.getLongitude(), false);
            maxy = Math.min(ulpt.getLatitude(), urpt.getLatitude());
        } else {
            ProjectionPoint ll = this.latLonToProj(llpt, new ProjectionPointImpl());
            ProjectionPoint ur = this.latLonToProj(urpt, new ProjectionPointImpl());
            ProjectionPoint lr = this.latLonToProj(lrpt, new ProjectionPointImpl());
            ProjectionPoint ul = this.latLonToProj(ulpt, new ProjectionPointImpl());
            minx = Math.min(ll.getX(), ul.getX());
            miny = Math.min(ll.getY(), lr.getY());
            maxx = Math.max(ur.getX(), lr.getX());
            maxy = Math.max(ul.getY(), ur.getY());
        }
        return new ProjectionRect(minx, miny, maxx, maxy);
    }

    private double getMinOrMaxLon(double lon1, double lon2, boolean wantMin) {
        double midpoint = (lon1 + lon2) / 2.0;
        lon1 = LatLonPointImpl.lonNormal(lon1, midpoint);
        lon2 = LatLonPointImpl.lonNormal(lon2, midpoint);
        return wantMin ? Math.min(lon1, lon2) : Math.max(lon1, lon2);
    }

    public ProjectionRect latLonToProjBB(LatLonRect latlonRect) {
        if (this.isLatLon) {
            LatLonProjection llp = (LatLonProjection)this;
            llp.setCenterLon(latlonRect.getCenterLon());
        }
        ProjectionPointImpl w1 = new ProjectionPointImpl();
        ProjectionPointImpl w2 = new ProjectionPointImpl();
        LatLonPointImpl ll = latlonRect.getLowerLeftPoint();
        LatLonPointImpl ur = latlonRect.getUpperRightPoint();
        this.latLonToProj(ll, w1);
        this.latLonToProj(ur, w2);
        if (!this.isLatLon && this.crossSeam(w1, w2)) {
            System.out.println("CROSS SEAM !" + w1 + " " + w2);
        }
        ProjectionRect world = new ProjectionRect(w1.getX(), w1.getY(), w2.getX(), w2.getY());
        LatLonPointImpl la = new LatLonPointImpl();
        LatLonPointImpl lb = new LatLonPointImpl();
        la.setLatitude(ur.getLatitude());
        la.setLongitude(ll.getLongitude());
        this.latLonToProj(la, w1);
        world.add(w1);
        lb.setLatitude(ll.getLatitude());
        lb.setLongitude(ur.getLongitude());
        this.latLonToProj(lb, w2);
        world.add(w2);
        return world;
    }

    public LatLonRect projToLatLonBB(ProjectionRect world) {
        ProjectionPoint min = world.getMinPoint();
        ProjectionPoint max = world.getMaxPoint();
        LatLonPointImpl llmin = new LatLonPointImpl();
        LatLonPointImpl llmax = new LatLonPointImpl();
        this.projToLatLon(min, llmin);
        this.projToLatLon(max, llmax);
        LatLonRect llbb = new LatLonRect(llmin, llmax);
        ProjectionPointImpl w1 = new ProjectionPointImpl();
        ProjectionPointImpl w2 = new ProjectionPointImpl();
        w1.setLocation(min.getX(), max.getY());
        this.projToLatLon(w1, llmin);
        llbb.extend(llmin);
        w2.setLocation(max.getX(), min.getY());
        this.projToLatLon(w2, llmax);
        llbb.extend(llmax);
        return llbb;
    }
}

