/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dataset.AxisType;
import ucar.nc2.dataset.CoordSysBuilderIF;
import ucar.nc2.dataset.CoordTransBuilder;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.NetcdfDatasetInfo;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.dataset.conv.ADASConvention;
import ucar.nc2.dataset.conv.ATDRadarConvention;
import ucar.nc2.dataset.conv.AWIPSConvention;
import ucar.nc2.dataset.conv.AWIPSsatConvention;
import ucar.nc2.dataset.conv.CF1Convention;
import ucar.nc2.dataset.conv.COARDSConvention;
import ucar.nc2.dataset.conv.CSMConvention;
import ucar.nc2.dataset.conv.EpicInsitu;
import ucar.nc2.dataset.conv.GDVConvention;
import ucar.nc2.dataset.conv.GIEFConvention;
import ucar.nc2.dataset.conv.IFPSConvention;
import ucar.nc2.dataset.conv.IridlConvention;
import ucar.nc2.dataset.conv.M3IOConvention;
import ucar.nc2.dataset.conv.M3IOVGGridConvention;
import ucar.nc2.dataset.conv.MADISStation;
import ucar.nc2.dataset.conv.NUWGConvention;
import ucar.nc2.dataset.conv.NsslRadarMosaicConvention;
import ucar.nc2.dataset.conv.UnidataObsConvention;
import ucar.nc2.dataset.conv.WRFConvention;
import ucar.nc2.dataset.conv.ZebraConvention;
import ucar.nc2.ncml4.NcMLReader;
import ucar.nc2.util.CancelTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoordSysBuilder
implements CoordSysBuilderIF {
    public static final String resourcesDir = "resources/nj22/coords/";
    protected static Logger log = LoggerFactory.getLogger(CoordSysBuilder.class);
    private static Map<String, Class> conventionHash = new HashMap<String, Class>();
    private static List<Convention> conventionList = new ArrayList<Convention>();
    private static Map<String, String> ncmlHash = new HashMap<String, String>();
    private static boolean useMaximalCoordSys = true;
    private static boolean userMode = false;
    protected String conventionName = "_Coordinates";
    protected List<VarProcess> varList = new ArrayList<VarProcess>();
    protected Map<Dimension, List<VarProcess>> coordVarMap = new HashMap<Dimension, List<VarProcess>>();
    protected StringBuffer parseInfo = new StringBuffer();
    protected StringBuffer userAdvice = new StringBuffer();
    protected boolean debug = false;
    protected boolean showRejects = false;

    public static void registerNcML(String conventionName, String ncmlLocation) {
        ncmlHash.put(conventionName, ncmlLocation);
    }

    public static void registerConvention(String conventionName, Class c) {
        if (!CoordSysBuilderIF.class.isAssignableFrom(c)) {
            throw new IllegalArgumentException("CoordSysBuilderIF Class " + c.getName() + " must implement CoordSysBuilderIF");
        }
        try {
            c.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("CoordSysBuilderIF Class " + c.getName() + " cannot instantiate, probably need default Constructor");
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("CoordSysBuilderIF Class " + c.getName() + " is not accessible");
        }
        if (userMode) {
            conventionList.add(0, new Convention(conventionName, c));
        } else {
            conventionList.add(new Convention(conventionName, c));
        }
        conventionHash.put(conventionName, c);
    }

    public static void registerConvention(String conventionName, String className) throws ClassNotFoundException {
        Class<?> c = Class.forName(className);
        CoordSysBuilder.registerConvention(conventionName, c);
    }

    public static void setUseMaximalCoordSys(boolean b) {
        useMaximalCoordSys = b;
    }

    public static boolean getUseMaximalCoordSys() {
        return useMaximalCoordSys;
    }

    public static void addCoordinateSystems(NetcdfDataset ds, CancelTask cancelTask) throws IOException {
        CoordSysBuilderIF builder;
        boolean usingDefault;
        String convNcML;
        String convName = ds.findAttValueIgnoreCase(null, "Conventions", null);
        if (convName == null) {
            convName = ds.findAttValueIgnoreCase(null, "Convention", null);
        }
        if (convName != null) {
            convName = convName.trim();
        }
        if (convName != null && (convNcML = ncmlHash.get(convName)) != null) {
            CoordSysBuilder csb = new CoordSysBuilder();
            NcMLReader.wrapNcML(ds, convNcML, cancelTask);
            csb.buildCoordinateSystems(ds);
            return;
        }
        Class convClass = null;
        if (convName != null && (convClass = conventionHash.get(convName)) == null) {
            String name;
            StringTokenizer stoke;
            ArrayList<String> names = new ArrayList<String>();
            if (convName.indexOf(44) > 0 || convName.indexOf(59) > 0) {
                stoke = new StringTokenizer(convName, ",;");
                while (stoke.hasMoreTokens()) {
                    name = stoke.nextToken();
                    names.add(name.trim());
                }
            } else if (convName.indexOf(47) > 0) {
                stoke = new StringTokenizer(convName, "/");
                while (stoke.hasMoreTokens()) {
                    name = stoke.nextToken();
                    names.add(name.trim());
                }
            }
            if (names.size() > 0) {
                for (Convention conv : conventionList) {
                    for (String name2 : names) {
                        if (!name2.equalsIgnoreCase(conv.convName)) continue;
                        convClass = conv.convClass;
                        convName = name2;
                    }
                    if (convClass == null) continue;
                    break;
                }
            }
        }
        if (convClass == null) {
            convName = null;
            for (Convention conv : conventionList) {
                Method m;
                Class c = conv.convClass;
                try {
                    m = c.getMethod("isMine", NetcdfFile.class);
                }
                catch (NoSuchMethodException ex) {
                    continue;
                }
                try {
                    Boolean result = (Boolean)m.invoke(null, ds);
                    if (!result.booleanValue()) continue;
                    convClass = c;
                    break;
                }
                catch (Exception ex) {
                    System.out.println("ERROR: Class " + c.getName() + " Exception invoking isMine method\n" + ex);
                }
            }
        }
        boolean bl = usingDefault = convClass == null;
        if (usingDefault) {
            convClass = GDVConvention.class;
        }
        try {
            builder = (CoordSysBuilderIF)convClass.newInstance();
            if (builder == null) {
                return;
            }
        }
        catch (InstantiationException e) {
            return;
        }
        catch (IllegalAccessException e) {
            return;
        }
        if (usingDefault) {
            builder.addUserAdvice("No CoordSysBuilder found - using default (GDV).\n");
        }
        if (convName != null) {
            builder.setConventionUsed(convName);
        } else {
            builder.addUserAdvice("No 'Convention' global attribute.\n");
        }
        builder.augmentDataset(ds, cancelTask);
        builder.buildCoordinateSystems(ds);
    }

    @Override
    public void setConventionUsed(String convName) {
        this.conventionName = convName;
    }

    @Override
    public String getConventionUsed() {
        return this.conventionName;
    }

    @Override
    public void addUserAdvice(String advice) {
        this.userAdvice.append(advice);
    }

    @Override
    public void augmentDataset(NetcdfDataset ncDataset, CancelTask cancelTask) throws IOException {
    }

    protected AxisType getAxisType(NetcdfDataset ncDataset, VariableEnhanced v) {
        return null;
    }

    @Override
    public void buildCoordinateSystems(NetcdfDataset ncDataset) {
        this.parseInfo.append("Parsing with Convention = ").append(this.conventionName).append("\n");
        this.addVariables(ncDataset, ncDataset.getVariables(), this.varList);
        this.findCoordinateAxes(ncDataset);
        this.findCoordinateSystems(ncDataset);
        this.findCoordinateTransforms(ncDataset);
        this.makeCoordinateAxes(ncDataset);
        this.makeCoordinateSystems(ncDataset);
        this.assignExplicitCoordinateSystems(ncDataset);
        this.makeCoordinateSystemsImplicit(ncDataset);
        if (useMaximalCoordSys) {
            this.makeCoordinateSystemsMaximal(ncDataset);
        }
        this.makeCoordinateTransforms(ncDataset);
        this.assignCoordinateTransforms(ncDataset);
        NetcdfDatasetInfo info = ncDataset.getInfo();
        info.setCoordSysBuilderName(this.conventionName);
        info.addParseInfo(this.parseInfo.toString());
        info.addUserAdvice(this.userAdvice.toString());
        if (this.debug) {
            System.out.println("parseInfo = \n" + this.parseInfo.toString());
        }
    }

    private void addVariables(NetcdfDataset ncDataset, List<Variable> varList, List<VarProcess> varProcessList) {
        for (Variable v : varList) {
            varProcessList.add(new VarProcess(ncDataset, v));
            if (!(v instanceof Structure)) continue;
            List<Variable> nested = ((Structure)v).getVariables();
            this.addVariables(ncDataset, nested, varProcessList);
        }
    }

    protected void findCoordinateAxes(NetcdfDataset ncDataset) {
        for (VarProcess vp : this.varList) {
            if (vp.coordAxes != null) {
                this.findCoordinateAxes(vp, vp.coordAxes);
            }
            if (vp.coordinates == null) continue;
            this.findCoordinateAxes(vp, vp.coordinates);
        }
    }

    private void findCoordinateAxes(VarProcess vp, String coordinates) {
        StringTokenizer stoker = new StringTokenizer(coordinates);
        while (stoker.hasMoreTokens()) {
            String vname = stoker.nextToken();
            VarProcess ap = this.findVarProcess(vname);
            if (ap != null) {
                if (!ap.isCoordinateAxis) {
                    this.parseInfo.append(" CoordinateAxis = ").append(vname).append(" added; referenced from var= ").append(vp.v.getName()).append("\n");
                }
                ap.isCoordinateAxis = true;
                continue;
            }
            this.parseInfo.append("***Cant find coordAxis ").append(vname).append(" referenced from var= ").append(vp.v.getName()).append("\n");
            this.userAdvice.append("***Cant find coordAxis ").append(vname).append(" referenced from var= ").append(vp.v.getName()).append("\n");
        }
    }

    protected void findCoordinateSystems(NetcdfDataset ncDataset) {
        for (VarProcess vp : this.varList) {
            if (vp.coordSys == null) continue;
            StringTokenizer stoker = new StringTokenizer(vp.coordSys);
            while (stoker.hasMoreTokens()) {
                String vname = stoker.nextToken();
                VarProcess ap = this.findVarProcess(vname);
                if (ap != null) {
                    if (!ap.isCoordinateSystem) {
                        this.parseInfo.append(" CoordinateSystem = ").append(vname).append(" added; referenced from var= ").append(vp.v.getName()).append("\n");
                    }
                    ap.isCoordinateSystem = true;
                    continue;
                }
                this.parseInfo.append("***Cant find coordSystem ").append(vname).append(" referenced from var= ").append(vp.v.getName()).append("\n");
                this.userAdvice.append("***Cant find coordSystem ").append(vname).append(" referenced from var= ").append(vp.v.getName()).append("\n");
            }
        }
    }

    protected void findCoordinateTransforms(NetcdfDataset ncDataset) {
        for (VarProcess vp : this.varList) {
            if (vp.coordTransforms == null) continue;
            StringTokenizer stoker = new StringTokenizer(vp.coordTransforms);
            while (stoker.hasMoreTokens()) {
                String vname = stoker.nextToken();
                VarProcess ap = this.findVarProcess(vname);
                if (ap != null) {
                    if (!ap.isCoordinateTransform) {
                        this.parseInfo.append(" Coordinate Transform = ").append(vname).append(" added; referenced from var= ").append(vp.v.getName()).append("\n");
                    }
                    ap.isCoordinateTransform = true;
                    continue;
                }
                this.parseInfo.append("***Cant find coord Transform ").append(vname).append(" referenced from var= ").append(vp.v.getName()).append("\n");
                this.userAdvice.append("***Cant find coord Transform ").append(vname).append(" referenced from var= ").append(vp.v.getName()).append("\n");
            }
        }
    }

    protected void makeCoordinateAxes(NetcdfDataset ncDataset) {
        for (VarProcess vp : this.varList) {
            if (!vp.isCoordinateAxis && !vp.isCoordinateVariable) continue;
            if (vp.axisType == null) {
                vp.axisType = this.getAxisType(ncDataset, (VariableEnhanced)((Object)vp.v));
            }
            if (vp.axisType == null) {
                this.userAdvice.append("Coordinate Axis ").append(vp.v.getName()).append(" does not have an assigned AxisType\n");
            }
            vp.makeIntoCoordinateAxis();
        }
    }

    protected void makeCoordinateSystems(NetcdfDataset ncDataset) {
        for (VarProcess vp : this.varList) {
            if (!vp.isCoordinateSystem) continue;
            vp.makeCoordinateSystem();
        }
    }

    protected void assignExplicitCoordinateSystems(NetcdfDataset ncDataset) {
        for (VarProcess vp : this.varList) {
            if (vp.coordSys == null || vp.isCoordinateTransform) continue;
            StringTokenizer stoker = new StringTokenizer(vp.coordSys);
            while (stoker.hasMoreTokens()) {
                String vname = stoker.nextToken();
                VarProcess ap = this.findVarProcess(vname);
                if (ap == null) {
                    this.parseInfo.append("***Cant find Coordinate System variable ").append(vname).append(" referenced from var= ").append(vp.v.getName()).append("\n");
                    this.userAdvice.append("***Cant find Coordinate System variable ").append(vname).append(" referenced from var= ").append(vp.v.getName()).append("\n");
                    continue;
                }
                if (ap.cs == null) {
                    this.parseInfo.append("***Not a Coordinate System variable =").append(vname).append(" referenced from var= ").append(vp.v.getName()).append("\n");
                    this.userAdvice.append("***Not a Coordinate System variable =").append(vname).append(" referenced from var= ").append(vp.v.getName()).append("\n");
                    continue;
                }
                VariableEnhanced ve = (VariableEnhanced)((Object)vp.v);
                ve.addCoordinateSystem(ap.cs);
            }
        }
        for (VarProcess vp : this.varList) {
            List<CoordinateAxis> dataAxesList;
            VariableEnhanced ve = (VariableEnhanced)((Object)vp.v);
            if (vp.hasCoordinateSystem() || vp.coordAxes == null || !vp.isData() || (dataAxesList = this.getAxes(vp.coordAxes, vp.v.getName())).size() <= 1) continue;
            String coordSysName = CoordinateSystem.makeName(dataAxesList);
            CoordinateSystem cs = ncDataset.findCoordinateSystem(coordSysName);
            if (cs != null) {
                ve.addCoordinateSystem(cs);
                this.parseInfo.append(" assigned explicit CoordSystem '").append(cs.getName()).append("' for var= ").append(vp.v.getName()).append("\n");
                continue;
            }
            CoordinateSystem csnew = new CoordinateSystem(ncDataset, dataAxesList, null);
            ve.addCoordinateSystem(csnew);
            ncDataset.addCoordinateSystem(csnew);
            this.parseInfo.append(" created explicit CoordSystem '").append(csnew.getName()).append("' for var= ").append(vp.v.getName()).append("\n");
        }
    }

    private List<CoordinateAxis> getAxes(String names, String varName) {
        ArrayList<CoordinateAxis> axesList = new ArrayList<CoordinateAxis>();
        StringTokenizer stoker = new StringTokenizer(names);
        while (stoker.hasMoreTokens()) {
            String vname = stoker.nextToken();
            VarProcess ap = this.findVarProcess(vname);
            if (ap != null) {
                CoordinateAxis axis = ap.makeIntoCoordinateAxis();
                if (axesList.contains(axis)) continue;
                axesList.add(axis);
                continue;
            }
            this.parseInfo.append("***Cant find Coordinate Axis ").append(vname).append(" referenced from var= ").append(varName).append("\n");
            this.userAdvice.append("***Cant find Coordinate Axis ").append(vname).append(" referenced from var= ").append(varName).append("\n");
        }
        return axesList;
    }

    protected void makeCoordinateSystemsImplicit(NetcdfDataset ncDataset) {
        for (VarProcess vp : this.varList) {
            List<CoordinateAxis> dataAxesList;
            if (vp.hasCoordinateSystem() || !vp.isData() || (dataAxesList = vp.findCoordinateAxes(true)).size() < 2) continue;
            VariableEnhanced ve = (VariableEnhanced)((Object)vp.v);
            String csName = CoordinateSystem.makeName(dataAxesList);
            CoordinateSystem cs = ncDataset.findCoordinateSystem(csName);
            if (cs != null) {
                ve.addCoordinateSystem(cs);
                this.parseInfo.append(" assigned implicit coord System '").append(cs.getName()).append("' for var= ").append(vp.v.getName()).append("\n");
                continue;
            }
            CoordinateSystem csnew = new CoordinateSystem(ncDataset, dataAxesList, null);
            csnew.setImplicit(true);
            ve.addCoordinateSystem(csnew);
            ncDataset.addCoordinateSystem(csnew);
            this.parseInfo.append(" created implicit coord System '").append(csnew.getName()).append("' for var= ").append(vp.v.getName()).append("\n");
        }
    }

    protected void makeCoordinateSystemsMaximal(NetcdfDataset ncDataset) {
        for (VarProcess vp : this.varList) {
            VariableEnhanced ve = (VariableEnhanced)((Object)vp.v);
            CoordinateSystem implicit = null;
            if (vp.hasCoordinateSystem() || !vp.isData()) continue;
            CoordinateSystem existing = null;
            if (ve.getCoordinateSystems().size() == 1) {
                existing = ve.getCoordinateSystems().get(0);
                if (!existing.isImplicit() || existing.getRankRange() >= ve.getRank()) continue;
                implicit = existing;
            }
            ArrayList<CoordinateAxis> axisList = new ArrayList<CoordinateAxis>();
            List<CoordinateAxis> axes = ncDataset.getCoordinateAxes();
            for (CoordinateAxis axis : axes) {
                if (!this.isCoordinateAxisForVariable(axis, ve)) continue;
                axisList.add(axis);
            }
            if (existing != null && axisList.size() <= existing.getRankRange() || axisList.size() < 2) continue;
            String csName = CoordinateSystem.makeName(axisList);
            CoordinateSystem cs = ncDataset.findCoordinateSystem(csName);
            if (cs != null) {
                if (null != implicit) {
                    ve.removeCoordinateSystem(implicit);
                }
                ve.addCoordinateSystem(cs);
                this.parseInfo.append(" assigned maximal coord System '").append(cs.getName()).append("' for var= ").append(ve.getName()).append("\n");
                continue;
            }
            CoordinateSystem csnew = new CoordinateSystem(ncDataset, axisList, null);
            csnew.setImplicit(true);
            if (null != implicit) {
                ve.removeCoordinateSystem(implicit);
            }
            ve.addCoordinateSystem(csnew);
            ncDataset.addCoordinateSystem(csnew);
            this.parseInfo.append(" created maximal coord System '").append(csnew.getName()).append("' for var= ").append(ve.getName()).append("\n");
        }
    }

    protected boolean isCoordinateAxisForVariable(Variable axis, VariableEnhanced v) {
        List<Dimension> varDims = v.getDimensionsAll();
        int checkDims = axis.getRank();
        if (axis.getDataType() == DataType.CHAR) {
            --checkDims;
        }
        for (int i = 0; i < checkDims; ++i) {
            Dimension axisDim = axis.getDimension(i);
            if (varDims.contains(axisDim)) continue;
            return false;
        }
        return true;
    }

    protected boolean hasXY(List<CoordinateAxis> coordAxes) {
        boolean hasX = false;
        boolean hasY = false;
        boolean hasLat = false;
        boolean hasLon = false;
        for (CoordinateAxis axis : coordAxes) {
            AxisType axisType = axis.getAxisType();
            if (axisType == AxisType.GeoX) {
                hasX = true;
            }
            if (axisType == AxisType.GeoY) {
                hasY = true;
            }
            if (axisType == AxisType.Lat) {
                hasLat = true;
            }
            if (axisType != AxisType.Lon) continue;
            hasLon = true;
        }
        return hasLat && hasLon || hasX && hasY;
    }

    protected void makeCoordinateTransforms(NetcdfDataset ncDataset) {
        for (VarProcess vp : this.varList) {
            if (!vp.isCoordinateTransform || vp.ct != null) continue;
            vp.ct = CoordTransBuilder.makeCoordinateTransform(vp.ds, vp.v, this.parseInfo, this.userAdvice);
        }
    }

    protected CoordinateTransform makeCoordinateTransform(NetcdfDataset ds, Variable ctv) {
        return CoordTransBuilder.makeCoordinateTransform(ds, ctv, this.parseInfo, this.userAdvice);
    }

    protected void assignCoordinateTransforms(NetcdfDataset ncDataset) {
        String vname;
        StringTokenizer stoker;
        for (VarProcess vp : this.varList) {
            if (!vp.isCoordinateSystem || vp.coordTransforms == null) continue;
            stoker = new StringTokenizer(vp.coordTransforms);
            while (stoker.hasMoreTokens()) {
                vname = stoker.nextToken();
                VarProcess ap = this.findVarProcess(vname);
                if (ap != null) {
                    if (ap.ct != null) {
                        vp.cs.addCoordinateTransform(ap.ct);
                        this.parseInfo.append(" assign explicit coordTransform ").append(ap.ct).append(" to CoordSys= ").append(vp.cs).append("\n");
                        continue;
                    }
                    this.parseInfo.append("***Cant find coordTransform in ").append(vname).append(" referenced from var= ").append(vp.v.getName()).append("\n");
                    this.userAdvice.append("***Cant find coordTransform in ").append(vname).append(" referenced from var= ").append(vp.v.getName()).append("\n");
                    continue;
                }
                this.parseInfo.append("***Cant find coordTransform variable=").append(vname).append(" referenced from var= ").append(vp.v.getName()).append("\n");
                this.userAdvice.append("***Cant find coordTransform variable=").append(vname).append(" referenced from var= ").append(vp.v.getName()).append("\n");
            }
        }
        for (VarProcess vp : this.varList) {
            if (!vp.isCoordinateTransform || vp.ct == null || vp.coordSys == null) continue;
            stoker = new StringTokenizer(vp.coordSys);
            while (stoker.hasMoreTokens()) {
                vname = stoker.nextToken();
                VarProcess vcs = this.findVarProcess(vname);
                if (vcs == null) {
                    this.parseInfo.append("***Cant find coordSystem variable ").append(vname).append(" referenced from var= ").append(vp.v.getName()).append("\n");
                    this.userAdvice.append("***Cant find coordSystem variable ").append(vname).append(" referenced from var= ").append(vp.v.getName()).append("\n");
                    continue;
                }
                vcs.cs.addCoordinateTransform(vp.ct);
                this.parseInfo.append(" assign explicit coordTransform ").append(vp.ct).append(" to CoordSys= ").append(vp.cs).append("\n");
            }
        }
        for (VarProcess vp : this.varList) {
            List<CoordinateAxis> dataAxesList;
            if (!vp.isCoordinateTransform || vp.ct == null || vp.coordAxes == null || (dataAxesList = vp.findCoordinateAxes(false)).size() <= 0) continue;
            for (CoordinateSystem cs : ncDataset.getCoordinateSystems()) {
                if (!cs.containsAxes(dataAxesList)) continue;
                cs.addCoordinateTransform(vp.ct);
                this.parseInfo.append(" assign (implicit coordAxes) coordTransform ").append(vp.ct).append(" to CoordSys= ").append(cs).append("\n");
            }
        }
        for (VarProcess vp : this.varList) {
            if (!vp.isCoordinateTransform || vp.ct == null || vp.coordAxisTypes == null) continue;
            ArrayList<AxisType> axisTypesList = new ArrayList<AxisType>();
            StringTokenizer stoker2 = new StringTokenizer(vp.coordAxisTypes);
            while (stoker2.hasMoreTokens()) {
                String name = stoker2.nextToken();
                AxisType atype = AxisType.getType(name);
                if (null == atype) continue;
                axisTypesList.add(atype);
            }
            if (axisTypesList.size() <= 0) continue;
            for (CoordinateSystem cs : ncDataset.getCoordinateSystems()) {
                if (!cs.containsAxisTypes(axisTypesList)) continue;
                cs.addCoordinateTransform(vp.ct);
                this.parseInfo.append(" assign (implicit coordAxisType) coordTransform ").append(vp.ct).append(" to CoordSys= ").append(cs).append("\n");
            }
        }
    }

    protected VarProcess findVarProcess(String name) {
        if (name == null) {
            return null;
        }
        for (VarProcess vp : this.varList) {
            if (!name.equals(vp.v.getName())) continue;
            return vp;
        }
        return null;
    }

    protected VarProcess findCoordinateAxis(String name) {
        if (name == null) {
            return null;
        }
        for (VarProcess vp : this.varList) {
            if (!name.equals(vp.v.getName()) || !vp.isCoordinateVariable && !vp.isCoordinateAxis) continue;
            return vp;
        }
        return null;
    }

    protected void addCoordinateVariable(Dimension dim, VarProcess vp) {
        List<VarProcess> list = this.coordVarMap.get(dim);
        if (list == null) {
            list = new ArrayList<VarProcess>();
            this.coordVarMap.put(dim, list);
        }
        if (!list.contains(vp)) {
            list.add(vp);
        }
    }

    protected VariableDS makeCoordinateTransformVariable(NetcdfDataset ds, CoordinateTransform ct) {
        VariableDS v = CoordTransBuilder.makeDummyTransformVariable(ds, ct);
        this.parseInfo.append("  made CoordinateTransformVariable:").append(ct.getName()).append("\n");
        return v;
    }

    public static VariableDS makeDummyTransformVariable(NetcdfDataset ds, CoordinateTransform ct) {
        return CoordTransBuilder.makeDummyTransformVariable(ds, ct);
    }

    static {
        CoordSysBuilder.registerConvention("_Coordinates", CoordSysBuilder.class);
        CoordSysBuilder.registerConvention("CF-1.0", CF1Convention.class);
        CoordSysBuilder.registerConvention("COARDS", COARDSConvention.class);
        CoordSysBuilder.registerConvention("NCAR-CSM", CSMConvention.class);
        CoordSysBuilder.registerConvention("Unidata Observation Dataset v1.0", UnidataObsConvention.class);
        CoordSysBuilder.registerConvention("GDV", GDVConvention.class);
        CoordSysBuilder.registerConvention("ATDRadar", ATDRadarConvention.class);
        CoordSysBuilder.registerConvention("Zebra", ZebraConvention.class);
        CoordSysBuilder.registerConvention("GIEF/GIEF-F", GIEFConvention.class);
        CoordSysBuilder.registerConvention("IRIDL", IridlConvention.class);
        CoordSysBuilder.registerConvention("NUWG", NUWGConvention.class);
        CoordSysBuilder.registerConvention("AWIPS", AWIPSConvention.class);
        CoordSysBuilder.registerConvention("AWIPS-Sat", AWIPSsatConvention.class);
        CoordSysBuilder.registerConvention("WRF", WRFConvention.class);
        CoordSysBuilder.registerConvention("M3IOVGGrid", M3IOVGGridConvention.class);
        CoordSysBuilder.registerConvention("M3IO", M3IOConvention.class);
        CoordSysBuilder.registerConvention("IFPS", IFPSConvention.class);
        CoordSysBuilder.registerConvention("ARPS/ADAS", ADASConvention.class);
        CoordSysBuilder.registerConvention("MADIS surface observations, v1.0", MADISStation.class);
        CoordSysBuilder.registerConvention("epic-insitu-1.0", EpicInsitu.class);
        CoordSysBuilder.registerConvention("NSSL National Reflectivity Mosaic", NsslRadarMosaicConvention.class);
        userMode = true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class VarProcess {
        public NetcdfDataset ds;
        public Variable v;
        public boolean isCoordinateVariable;
        public boolean isCoordinateAxis;
        public AxisType axisType;
        public String coordAxes;
        public String coordSys;
        public String coordVarAlias;
        public String positive;
        public String coordAxisTypes;
        public String coordinates;
        public CoordinateAxis axis;
        public boolean isCoordinateSystem;
        public String coordTransforms;
        public CoordinateSystem cs;
        public boolean isCoordinateTransform;
        public String coordTransformType;
        public CoordinateTransform ct;

        private VarProcess(NetcdfDataset ds, Variable v) {
            Attribute att;
            this.ds = ds;
            this.v = v;
            VariableEnhanced ve = (VariableEnhanced)((Object)v);
            this.isCoordinateVariable = v.isCoordinateVariable();
            if (this.isCoordinateVariable) {
                CoordSysBuilder.this.addCoordinateVariable(v.getDimension(0), this);
                CoordSysBuilder.this.parseInfo.append(" Coordinate Variable added = ").append(v.getName()).append(" for dimension ").append(v.getDimension(0)).append("\n");
            }
            if ((att = v.findAttributeIgnoreCase("_CoordinateAxisType")) != null) {
                String axisName = att.getStringValue();
                this.axisType = AxisType.getType(axisName);
                this.isCoordinateAxis = true;
                CoordSysBuilder.this.parseInfo.append(" Coordinate Axis added = ").append(v.getName()).append(" type= ").append(axisName).append("\n");
            }
            this.coordVarAlias = ds.findAttValueIgnoreCase(v, "_CoordinateAliasForDimension", null);
            if (this.coordVarAlias != null) {
                this.coordVarAlias = this.coordVarAlias.trim();
                if (v.getRank() != 1) {
                    CoordSysBuilder.this.parseInfo.append("**ERROR Coordinate Variable Alias ").append(v.getName()).append(" has rank ").append(v.getRank()).append("\n");
                    CoordSysBuilder.this.userAdvice.append("**ERROR Coordinate Variable Alias ").append(v.getName()).append(" has rank ").append(v.getRank()).append("\n");
                } else {
                    Dimension vDim;
                    Dimension coordDim = ds.findDimension(this.coordVarAlias);
                    if (!coordDim.equals(vDim = v.getDimension(0))) {
                        CoordSysBuilder.this.parseInfo.append("**ERROR Coordinate Variable Alias ").append(v.getName()).append(" names wrong dimension ").append(this.coordVarAlias).append("\n");
                        CoordSysBuilder.this.userAdvice.append("**ERROR Coordinate Variable Alias ").append(v.getName()).append(" names wrong dimension ").append(this.coordVarAlias).append("\n");
                    } else {
                        this.isCoordinateAxis = true;
                        CoordSysBuilder.this.addCoordinateVariable(coordDim, this);
                        CoordSysBuilder.this.parseInfo.append(" Coordinate Variable Alias added = ").append(v.getName()).append(" for dimension ").append(this.coordVarAlias).append("\n");
                    }
                }
            }
            this.positive = ds.findAttValueIgnoreCase(v, "_CoordinateZisPositive", null);
            if (this.positive == null) {
                this.positive = ds.findAttValueIgnoreCase(v, "positive", null);
            } else {
                this.isCoordinateAxis = true;
                this.positive = this.positive.trim();
            }
            this.coordAxes = ds.findAttValueIgnoreCase(v, "_CoordinateAxes", null);
            this.coordSys = ds.findAttValueIgnoreCase(v, "_CoordinateSystems", null);
            this.coordTransforms = ds.findAttValueIgnoreCase(v, "_CoordinateTransforms", null);
            this.isCoordinateSystem = this.coordTransforms != null;
            this.coordAxisTypes = ds.findAttValueIgnoreCase(v, "_CoordinateAxisTypes", null);
            this.coordTransformType = ds.findAttValueIgnoreCase(v, "_CoordinateTransformType", null);
            boolean bl = this.isCoordinateTransform = this.coordTransformType != null || this.coordAxisTypes != null;
            if (!(this.isCoordinateSystem || this.isCoordinateTransform || this.isCoordinateAxis || this.coordAxes == null)) {
                StringTokenizer stoker = new StringTokenizer(this.coordAxes);
                while (stoker.hasMoreTokens()) {
                    String vname = stoker.nextToken();
                    Variable axis = ds.findVariable(vname);
                    if (axis == null || CoordSysBuilder.this.isCoordinateAxisForVariable(axis, ve)) continue;
                    this.isCoordinateSystem = true;
                }
            }
        }

        public VarProcess(NetcdfDataset ds) {
            this.ds = ds;
        }

        public boolean isData() {
            return !this.isCoordinateVariable && !this.isCoordinateAxis && !this.isCoordinateSystem && !this.isCoordinateTransform;
        }

        public boolean hasCoordinateSystem() {
            return ((VariableEnhanced)((Object)this.v)).getCoordinateSystems().size() > 0;
        }

        public CoordinateAxis makeIntoCoordinateAxis() {
            if (this.axis != null) {
                return this.axis;
            }
            if (this.v instanceof CoordinateAxis) {
                this.axis = (CoordinateAxis)this.v;
            } else {
                this.axis = this.ds.addCoordinateAxis((VariableDS)this.v);
                this.v = this.axis;
            }
            if (this.axisType != null) {
                this.axis.setAxisType(this.axisType);
                this.axis.addAttribute(new Attribute("_CoordinateAxisType", this.axisType.toString()));
                if ((this.axisType == AxisType.Height || this.axisType == AxisType.Pressure || this.axisType == AxisType.GeoZ) && this.positive != null) {
                    this.axis.setPositive(this.positive);
                    this.axis.addAttribute(new Attribute("_CoordinateZisPositive", this.positive));
                }
            }
            return this.axis;
        }

        public void makeCoordinateSystem() {
            ArrayList<CoordinateAxis> axesList = new ArrayList<CoordinateAxis>();
            StringTokenizer stoker = new StringTokenizer(this.coordAxes);
            while (stoker.hasMoreTokens()) {
                String vname = stoker.nextToken();
                VarProcess ap = CoordSysBuilder.this.findVarProcess(vname);
                if (ap != null) {
                    CoordinateAxis axis = ap.makeIntoCoordinateAxis();
                    if (axesList.contains(axis)) continue;
                    axesList.add(axis);
                    continue;
                }
                CoordSysBuilder.this.parseInfo.append(" Cant find axes ").append(vname).append(" for Coordinate System ").append(this.v.getName()).append("\n");
                CoordSysBuilder.this.userAdvice.append("Cant find axes ").append(vname).append(" for Coordinate System ").append(this.v.getName()).append("\n");
            }
            if (axesList.size() == 0) {
                CoordSysBuilder.this.parseInfo.append(" No axes found for Coordinate System ").append(this.v.getName()).append("\n");
                CoordSysBuilder.this.userAdvice.append("No axes found for Coordinate System ").append(this.v.getName()).append("\n");
                return;
            }
            this.cs = new CoordinateSystem(this.ds, axesList, null);
            this.ds.addCoordinateSystem(this.cs);
            CoordSysBuilder.this.parseInfo.append(" Made Coordinate System ").append(this.cs.getName()).append("\n");
        }

        public List<CoordinateAxis> findCoordinateAxes(boolean addCoordVariables) {
            CoordinateAxis axis;
            VarProcess ap;
            String vname;
            StringTokenizer stoker;
            ArrayList<CoordinateAxis> axesList = new ArrayList<CoordinateAxis>();
            if (this.coordAxes != null) {
                stoker = new StringTokenizer(this.coordAxes);
                while (stoker.hasMoreTokens()) {
                    vname = stoker.nextToken();
                    ap = CoordSysBuilder.this.findVarProcess(vname);
                    if (ap == null || axesList.contains(axis = ap.makeIntoCoordinateAxis())) continue;
                    axesList.add(axis);
                }
            } else if (this.coordinates != null) {
                stoker = new StringTokenizer(this.coordinates);
                while (stoker.hasMoreTokens()) {
                    vname = stoker.nextToken();
                    ap = CoordSysBuilder.this.findVarProcess(vname);
                    if (ap == null || axesList.contains(axis = ap.makeIntoCoordinateAxis())) continue;
                    axesList.add(axis);
                }
            }
            if (addCoordVariables) {
                for (Dimension d : this.v.getDimensions()) {
                    List<VarProcess> coordVars = CoordSysBuilder.this.coordVarMap.get(d);
                    if (coordVars == null) continue;
                    for (VarProcess vp : coordVars) {
                        CoordinateAxis axis2 = vp.makeIntoCoordinateAxis();
                        if (axesList.contains(axis2)) continue;
                        axesList.add(axis2);
                    }
                }
            }
            return axesList;
        }
    }

    private static class Convention {
        String convName;
        Class convClass;

        Convention(String convName, Class convClass) {
            this.convName = convName;
            this.convClass = convClass;
        }
    }
}

