/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Vector;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.XMLTools;
import loci.formats.AxisGuesser;
import loci.formats.CoreMetadata;
import loci.formats.FilePattern;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.LeicaHandler;
import loci.formats.in.TiffReader;
import loci.formats.meta.FilterMetadata;
import loci.formats.tiff.IFD;
import loci.formats.tiff.IFDList;
import loci.formats.tiff.TiffParser;
import org.xml.sax.helpers.DefaultHandler;

public class TCSReader
extends FormatReader {
    public static final String DATE_FORMAT = "yyyy:MM:dd HH:mm:ss.SSS";
    public static final String PREFIX = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><LEICA>";
    public static final String SUFFIX = "</LEICA>";
    public static final String[] XML_SUFFIX = new String[]{"xml"};
    private Vector<String> tiffs;
    private TiffReader[] tiffReaders;
    private TiffParser tiffParser;
    private long datestamp;
    private String xmlFile;

    public TCSReader() {
        super("Leica TCS TIFF", new String[]{"tif", "tiff", "xml"});
    }

    public boolean isThisType(String name, boolean open) {
        Location lei;
        if (!open) {
            return false;
        }
        String prefix = name;
        if (prefix.indexOf(".") != -1) {
            prefix = prefix.substring(0, prefix.lastIndexOf("."));
        }
        if (!(lei = new Location(prefix + ".lei")).exists()) {
            lei = new Location(prefix + ".LEI");
            while (!lei.exists() && prefix.indexOf("_") != -1) {
                lei = new Location((prefix = prefix.substring(0, prefix.lastIndexOf("_"))) + ".lei");
                if (lei.exists()) continue;
                lei = new Location(prefix + ".LEI");
            }
        }
        if (lei.exists()) {
            return false;
        }
        try {
            RandomAccessInputStream s = new RandomAccessInputStream(name);
            boolean isThisType = this.isThisType(s);
            s.close();
            return isThisType;
        }
        catch (IOException e) {
            this.traceDebug(e);
            return false;
        }
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        String[] ss;
        TiffParser tp = new TiffParser(stream);
        IFD ifd = tp.getFirstIFD();
        if (ifd == null) {
            return false;
        }
        String document = (String)ifd.get(new Integer(269));
        if (document == null) {
            document = "";
        }
        Object s = ifd.get(new Integer(305));
        String software = null;
        if (s instanceof String) {
            software = (String)s;
        } else if (s instanceof String[] && (ss = (String[])s).length > 0) {
            software = ss[0];
        }
        if (software == null) {
            software = "";
        }
        software = software.trim();
        return document.startsWith("CHANNEL") || software.startsWith("TCS");
    }

    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        return this.tiffReaders[0].get8BitLookupTable();
    }

    public short[][] get16BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        return this.tiffReaders[0].get16BitLookupTable();
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int n = no;
        for (int i = 0; i < this.series; ++i) {
            n += this.core[i].imageCount;
        }
        if (this.tiffReaders.length == 1) {
            return this.tiffReaders[0].openBytes(n, buf, x, y, w, h);
        }
        return this.tiffReaders[n].openBytes(0, buf, x, y, w, h);
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        if (noPixels) {
            String name = this.currentId.toLowerCase();
            if (TCSReader.checkSuffix(name, TiffReader.TIFF_SUFFIXES)) {
                return null;
            }
            return new String[]{this.currentId};
        }
        Vector<String> v = new Vector<String>();
        v.addAll(this.tiffs);
        String absoluteId = new Location(this.currentId).getAbsolutePath();
        if (!v.contains(absoluteId)) {
            v.add(absoluteId);
        }
        return v.toArray(new String[v.size()]);
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.tiffs = null;
            this.tiffReaders = null;
            this.tiffParser = null;
            this.datestamp = 0L;
            this.xmlFile = null;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        int i;
        this.debug("TCSReader.initFile(" + id + ")");
        Location l = new Location(id).getAbsoluteFile();
        Location parent = l.getParentFile();
        String[] list = parent.list();
        boolean isXML = TCSReader.checkSuffix(id, XML_SUFFIX);
        if (list != null) {
            for (String file2 : list) {
                if (TCSReader.checkSuffix(file2, XML_SUFFIX) && !isXML) {
                    this.xmlFile = new Location(parent, file2).getAbsolutePath();
                    break;
                }
                if (!TCSReader.checkSuffix(file2, TiffReader.TIFF_SUFFIXES) || !isXML) continue;
                this.initFile(new Location(parent, file2).getAbsolutePath());
                return;
            }
        }
        super.initFile(id);
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        this.in = new RandomAccessInputStream(id);
        this.tiffParser = new TiffParser(this.in);
        this.tiffs = new Vector();
        IFDList ifds = this.tiffParser.getIFDs();
        String date = ((IFD)ifds.get(0)).getIFDStringValue(306, false);
        this.datestamp = DateTools.getTime(date, "yyyy:MM:dd HH:mm:ss");
        this.groupFiles();
        this.tiffReaders = new TiffReader[this.tiffs.size()];
        for (int i2 = 0; i2 < this.tiffReaders.length; ++i2) {
            this.tiffReaders[i2] = new TiffReader();
            this.tiffReaders[i2].setId(this.tiffs.get(i2));
        }
        int[] ch = new int[ifds.size()];
        int[] idx = new int[ifds.size()];
        long[] stamp = new long[ifds.size()];
        int channelCount = 0;
        FilePattern fp = new FilePattern(new Location(this.currentId).getAbsoluteFile());
        AxisGuesser guesser = new AxisGuesser(fp, "XYTZC", 1, ifds.size(), 1, true);
        BigInteger[] first = fp.getFirst();
        BigInteger[] last = fp.getLast();
        BigInteger[] step = fp.getStep();
        int[] axisTypes = guesser.getAxisTypes();
        this.core[0].sizeZ = 1;
        this.core[0].sizeC = this.tiffReaders[0].getSizeC();
        this.core[0].dimensionOrder = this.isRGB() ? "XYC" : "XY";
        for (i = axisTypes.length - 1; i >= 0; --i) {
            int size = last[i].subtract(first[i]).divide(step[i]).intValue() + 1;
            if (axisTypes[i] == 1) {
                if (this.getDimensionOrder().indexOf("Z") == -1) {
                    this.core[0].dimensionOrder = this.core[0].dimensionOrder + "Z";
                }
                this.core[0].sizeZ *= size;
                continue;
            }
            if (axisTypes[i] != 3) continue;
            if (this.getDimensionOrder().indexOf("C") == -1) {
                this.core[0].dimensionOrder = this.core[0].dimensionOrder + "C";
            }
            this.core[0].sizeC *= size;
        }
        for (i = 0; i < ifds.size(); ++i) {
            String document = ((IFD)ifds.get(i)).getIFDStringValue(269, false);
            if (document == null) continue;
            int index = document.indexOf("INDEX");
            String s = document.substring(8, index).trim();
            ch[i] = Integer.parseInt(s);
            if (ch[i] > channelCount) {
                channelCount = ch[i];
            }
            String n = document.substring(index + 6, document.indexOf(" ", index + 6)).trim();
            idx[i] = Integer.parseInt(n);
            date = document.substring(document.indexOf(" ", index + 6), document.indexOf("FORMAT")).trim();
            stamp[i] = DateTools.getTime(date, DATE_FORMAT);
        }
        this.core[0].sizeT = 0;
        boolean unique = true;
        for (int i3 = 0; i3 < stamp.length; ++i3) {
            for (int j = i3 + 1; j < stamp.length; ++j) {
                if (stamp[j] != stamp[i3]) continue;
                unique = false;
                break;
            }
            if (unique) {
                ++this.core[0].sizeT;
                if (this.getDimensionOrder().indexOf("T") < 0) {
                    this.core[0].dimensionOrder = this.core[0].dimensionOrder + "T";
                }
            } else if (i3 > 0) {
                if (ch[i3] != ch[i3 - 1] && this.getDimensionOrder().indexOf("C") < 0) {
                    this.core[0].dimensionOrder = this.core[0].dimensionOrder + "C";
                } else if (this.getDimensionOrder().indexOf("Z") < 0) {
                    this.core[0].dimensionOrder = this.core[0].dimensionOrder + "Z";
                }
            }
            unique = true;
        }
        if (this.getDimensionOrder().indexOf("Z") < 0) {
            this.core[0].dimensionOrder = this.core[0].dimensionOrder + "Z";
        }
        if (this.getDimensionOrder().indexOf("C") < 0) {
            this.core[0].dimensionOrder = this.core[0].dimensionOrder + "C";
        }
        if (this.getDimensionOrder().indexOf("T") < 0) {
            this.core[0].dimensionOrder = this.core[0].dimensionOrder + "T";
        }
        if (this.getSizeT() == 0) {
            this.core[0].sizeT = 1;
        }
        if (channelCount == 0) {
            channelCount = 1;
        }
        if (this.getSizeZ() <= 1) {
            this.core[0].sizeZ = ifds.size() / (this.getSizeT() * channelCount);
        }
        this.core[0].sizeC *= channelCount;
        this.core[0].imageCount = this.getSizeZ() * this.getSizeT() * this.getSizeC();
        String comment = ((IFD)ifds.get(0)).getComment();
        if (comment != null && comment.startsWith("[")) {
            String[] lines;
            for (String line : lines = comment.split("\n")) {
                if (line.startsWith("[")) continue;
                int eq = line.indexOf("=");
                String key = line.substring(0, eq).trim();
                String value = line.substring(eq + 1).trim();
                this.addGlobalMeta(key, value);
            }
            this.metadata.remove("Comment");
        }
        this.core[0].sizeX = this.tiffReaders[0].getSizeX();
        this.core[0].sizeY = this.tiffReaders[0].getSizeY();
        this.core[0].rgb = this.tiffReaders[0].isRGB();
        this.core[0].pixelType = this.tiffReaders[0].getPixelType();
        this.core[0].littleEndian = this.tiffReaders[0].isLittleEndian();
        this.core[0].interleaved = this.tiffReaders[0].isInterleaved();
        this.core[0].falseColor = true;
        if (this.isRGB()) {
            this.core[0].imageCount /= this.getSizeC() / channelCount;
        }
        MetadataTools.populatePixels(store, this, true);
        if (this.xmlFile != null) {
            int i4;
            RandomAccessInputStream xmlStream = new RandomAccessInputStream(this.xmlFile);
            String xml = xmlStream.readString((int)xmlStream.length());
            xmlStream.close();
            xml = XMLTools.sanitizeXML(PREFIX + xml + SUFFIX);
            LeicaHandler handler = new LeicaHandler(store);
            XMLTools.parseXML(xml, (DefaultHandler)handler);
            this.metadata = handler.getGlobalMetadata();
            this.core = handler.getCoreMetadata().toArray(new CoreMetadata[0]);
            for (i4 = 0; i4 < this.getSeriesCount(); ++i4) {
                if (this.tiffs.size() < this.core[i4].imageCount) {
                    int div = this.core[i4].imageCount / this.core[i4].sizeC;
                    this.core[i4].imageCount = this.tiffs.size();
                    if (div >= this.core[i4].sizeZ) {
                        this.core[i4].sizeZ /= div;
                    } else if (div >= this.core[i4].sizeT) {
                        this.core[i4].sizeT /= div;
                    }
                }
                this.core[i4].dimensionOrder = this.getSizeZ() > this.getSizeT() ? "XYCZT" : "XYCTZ";
                this.core[i4].rgb = false;
                this.core[i4].interleaved = false;
                this.core[i4].indexed = this.tiffReaders[0].isIndexed();
            }
            MetadataTools.populatePixels(store, this, true);
            for (i4 = 0; i4 < this.getSeriesCount(); ++i4) {
                MetadataTools.setDefaultCreationDate(store, id, i4);
            }
        }
    }

    private void groupFiles() throws FormatException, IOException {
        Location current = new Location(this.currentId).getAbsoluteFile();
        Location parent = current.getParentFile();
        Object[] list = parent.list();
        Arrays.sort(list);
        HashMap<Object, Long> timestamps = new HashMap<Object, Long>();
        for (Object file2 : list) {
            RandomAccessInputStream rais;
            if (!TCSReader.checkSuffix((String)file2, TiffReader.TIFF_SUFFIXES) || ((String)(file2 = new Location(parent, (String)file2).getAbsolutePath())).length() != current.getAbsolutePath().length() || Math.abs((rais = new RandomAccessInputStream((String)file2)).length() - this.in.length()) > 16L) continue;
            TiffParser tp = new TiffParser(rais);
            IFD ifd = (IFD)tp.getIFDs().get(0);
            String date = ifd.getIFDStringValue(306, false);
            long stamp = DateTools.getTime(date, "yyyy:MM:dd HH:mm:ss");
            rais.close();
            String software = ifd.getIFDStringValue(305, false);
            if (software == null || !software.trim().startsWith("TCS")) continue;
            timestamps.put(file2, new Long(stamp));
        }
        Object[] files = timestamps.keySet().toArray(new String[timestamps.size()]);
        Arrays.sort(files);
        if (TCSReader.checkSuffix(this.currentId, TiffReader.TIFF_SUFFIXES)) {
            this.tiffs.add(current.getAbsolutePath());
        }
        for (Object file3 : files) {
            long thisStamp = (Long)timestamps.get(file3);
            boolean match = false;
            for (String tiff : this.tiffs) {
                RandomAccessInputStream s = new RandomAccessInputStream(tiff);
                TiffParser parser = new TiffParser(s);
                IFD ifd = (IFD)parser.getIFDs().get(0);
                s.close();
                String date = ifd.getIFDStringValue(306, false);
                long nextStamp = DateTools.getTime(date, "yyyy:MM:dd HH:mm:ss");
                if (Math.abs(thisStamp - nextStamp) >= 60000L) continue;
                match = true;
                break;
            }
            if (!match || this.tiffs.contains(file3)) continue;
            this.tiffs.add((String)file3);
        }
    }
}

