/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.importer;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.io.FileInfo;
import ij.plugin.filter.PlugInFilterRunner;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Rectangle;
import java.awt.image.IndexColorModel;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import loci.common.Location;
import loci.common.ReflectException;
import loci.common.ReflectedUniverse;
import loci.formats.ChannelMerger;
import loci.formats.ChannelSeparator;
import loci.formats.DimensionSwapper;
import loci.formats.FilePattern;
import loci.formats.FileStitcher;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.MetadataTools;
import loci.formats.StatusEvent;
import loci.formats.StatusListener;
import loci.formats.gui.XMLWindow;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataRetrieve;
import loci.plugins.Colorizer;
import loci.plugins.LociImporter;
import loci.plugins.importer.CropDialog;
import loci.plugins.importer.FilePatternDialog;
import loci.plugins.importer.IdDialog;
import loci.plugins.importer.ImporterDialog;
import loci.plugins.importer.ImporterOptions;
import loci.plugins.importer.LocationDialog;
import loci.plugins.importer.RangeDialog;
import loci.plugins.importer.SeriesDialog;
import loci.plugins.importer.SwapDialog;
import loci.plugins.importer.UpgradeDialog;
import loci.plugins.util.BFVirtualStack;
import loci.plugins.util.DataBrowser;
import loci.plugins.util.ImagePlusReader;
import loci.plugins.util.ImagePlusTools;
import loci.plugins.util.LociPrefs;
import loci.plugins.util.ROIHandler;
import loci.plugins.util.SearchableWindow;
import loci.plugins.util.VirtualImagePlus;
import loci.plugins.util.WindowTools;
import org.xml.sax.SAXException;

public class Importer {
    private LociImporter plugin;
    private Vector imps = new Vector();
    private String stackOrder = null;
    private IndexColorModel[] colorModels;

    public Importer(LociImporter plugin) {
        this.plugin = plugin;
    }

    public void run(String arg) {
        boolean windowless;
        ReflectedUniverse ru;
        this.debug("parse core options");
        ImporterOptions options = null;
        try {
            options = new ImporterOptions();
        }
        catch (IOException exc) {
            WindowTools.reportException(exc);
        }
        options.loadOptions();
        options.parseArg(arg);
        this.debug("check if new version is available");
        UpgradeDialog upgradeDialog = new UpgradeDialog(options);
        int status = upgradeDialog.showDialog();
        if (!this.statusOk(status)) {
            return;
        }
        this.debug("construct reader and check id");
        LocationDialog locationDialog = new LocationDialog(options);
        status = locationDialog.showDialog();
        if (!this.statusOk(status)) {
            return;
        }
        IdDialog idDialog = new IdDialog(options);
        status = idDialog.showDialog();
        if (!this.statusOk(status)) {
            return;
        }
        String id = options.getId();
        boolean quiet = options.isQuiet();
        Location idLoc = null;
        String idName = id;
        if (options.isLocal()) {
            idLoc = new Location(id);
            idName = idLoc.getName();
        } else if (options.isOME() || options.isOMERO()) {
            StringTokenizer st = new StringTokenizer(id, "?&");
            StringBuffer idBuf = new StringBuffer();
            int tokenCount = 0;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.startsWith("username=") || token.startsWith("password=")) continue;
                if (tokenCount == 1) {
                    idBuf.append("?");
                } else if (tokenCount > 1) {
                    idBuf.append("&");
                }
                idBuf.append(token);
                ++tokenCount;
            }
            idName = idBuf.toString();
        }
        IFormatReader base = null;
        if (options.isLocal() || options.isHTTP()) {
            IJ.showStatus((String)("Identifying " + idName));
            ImageReader reader = ImagePlusReader.makeImageReader();
            try {
                base = reader.getReader(id);
            }
            catch (FormatException exc) {
                WindowTools.reportException(exc, quiet, "Sorry, there was an error reading the file.");
                return;
            }
            catch (IOException exc) {
                WindowTools.reportException(exc, quiet, "Sorry, there was a I/O problem reading the file.");
                return;
            }
        } else if (options.isOMERO()) {
            try {
                ru = new ReflectedUniverse();
                ru.exec("import loci.ome.io.OMEROReader");
                base = (IFormatReader)ru.exec("new OMEROReader()");
            }
            catch (ReflectException exc) {
                WindowTools.reportException(exc, options.isQuiet(), "Sorry, there was a problem constructing the OMERO I/O engine");
                return;
            }
        } else if (options.isOME()) {
            try {
                ru = new ReflectedUniverse();
                ru.exec("import loci.ome.io.OMEReader");
                base = (IFormatReader)ru.exec("new OMEReader()");
            }
            catch (ReflectException exc) {
                WindowTools.reportException(exc, options.isQuiet(), "Sorry, there was a problem constructing the OME I/O engine");
                return;
            }
        } else {
            WindowTools.reportException(null, options.isQuiet(), "Sorry, there has been an internal error: unknown data source");
        }
        IMetadata omexmlMeta = MetadataTools.createOMEXMLMetadata();
        base.setMetadataStore(omexmlMeta);
        IJ.showStatus((String)"");
        base.addStatusListener(new StatusEchoer());
        this.debug("get parameter values");
        boolean bl = windowless = options.isWindowless() || LociPrefs.isWindowless(base);
        if (!windowless) {
            ImporterDialog importerDialog = new ImporterDialog(options);
            status = importerDialog.showDialog();
        }
        if (!this.statusOk(status)) {
            return;
        }
        boolean mergeChannels = options.isMergeChannels();
        boolean colorize = options.isColorize();
        boolean showMetadata = options.isShowMetadata();
        boolean showOMEXML = options.isShowOMEXML();
        boolean groupFiles = options.isGroupFiles();
        boolean concatenate = options.isConcatenate();
        boolean specifyRanges = options.isSpecifyRanges();
        boolean cropOnImport = options.doCrop();
        boolean swapDimensions = options.isSwapDimensions();
        quiet = options.isQuiet();
        if (!quiet) {
            options.setFirstTime(false);
        }
        options.saveOptions();
        this.debug("analyze and read from data source");
        IJ.showStatus((String)("Analyzing " + idName));
        try {
            CropDialog cropDialog;
            base.setMetadataFiltered(true);
            base.setNormalized(true);
            base.setOriginalMetadataPopulated(true);
            base.setId(id);
            int pixelType = base.getPixelType();
            String currentFile = base.getCurrentFile();
            if (groupFiles) {
                this.debug("prompt for the file pattern");
                FilePatternDialog filePatternDialog = new FilePatternDialog(options);
                status = filePatternDialog.showDialog();
                if (!this.statusOk(status)) {
                    return;
                }
                id = options.getId();
                if (id == null) {
                    id = currentFile;
                }
            } else {
                this.debug("no need to prompt for file pattern");
            }
            if (groupFiles) {
                base = new FileStitcher(base, true);
            }
            VirtualReader virtualReader = new VirtualReader(new ChannelSeparator(base));
            ImagePlusReader r = new ImagePlusReader(virtualReader);
            r.setId(id);
            int seriesCount = r.getSeriesCount();
            int[] num = new int[seriesCount];
            int[] sizeC = new int[seriesCount];
            int[] sizeZ = new int[seriesCount];
            int[] sizeT = new int[seriesCount];
            boolean[] certain = new boolean[seriesCount];
            int[] cBegin = new int[seriesCount];
            int[] cEnd = new int[seriesCount];
            int[] cStep = new int[seriesCount];
            int[] zBegin = new int[seriesCount];
            int[] zEnd = new int[seriesCount];
            int[] zStep = new int[seriesCount];
            int[] tBegin = new int[seriesCount];
            int[] tEnd = new int[seriesCount];
            int[] tStep = new int[seriesCount];
            boolean[] series = new boolean[seriesCount];
            for (int i = 0; i < seriesCount; ++i) {
                r.setSeries(i);
                num[i] = r.getImageCount();
                sizeC[i] = r.getEffectiveSizeC();
                sizeZ[i] = r.getSizeZ();
                sizeT[i] = r.getSizeT();
                certain[i] = r.isOrderCertain();
                tBegin[i] = 0;
                zBegin[i] = 0;
                cBegin[i] = 0;
                cEnd[i] = sizeC[i] - 1;
                zEnd[i] = sizeZ[i] - 1;
                tEnd[i] = sizeT[i] - 1;
                tStep[i] = 1;
                zStep[i] = 1;
                cStep[i] = 1;
            }
            series[0] = true;
            String[] seriesLabels = new String[seriesCount];
            for (int i = 0; i < seriesCount; ++i) {
                r.setSeries(i);
                StringBuffer sb = new StringBuffer();
                sb.append("Series_");
                sb.append(i + 1);
                sb.append(": ");
                String name = omexmlMeta.getImageName(i);
                if (name != null && name.length() > 0) {
                    sb.append(name);
                    sb.append(": ");
                }
                sb.append(r.getSizeX());
                sb.append(" x ");
                sb.append(r.getSizeY());
                sb.append("; ");
                sb.append(num[i]);
                sb.append(" plane");
                if (num[i] > 1) {
                    sb.append("s");
                    if (certain[i]) {
                        sb.append(" (");
                        boolean first = true;
                        if (sizeC[i] > 1) {
                            sb.append(sizeC[i]);
                            sb.append("C");
                            first = false;
                        }
                        if (sizeZ[i] > 1) {
                            if (!first) {
                                sb.append(" x ");
                            }
                            sb.append(sizeZ[i]);
                            sb.append("Z");
                            first = false;
                        }
                        if (sizeT[i] > 1) {
                            if (!first) {
                                sb.append(" x ");
                            }
                            sb.append(sizeT[i]);
                            sb.append("T");
                            first = false;
                        }
                        sb.append(")");
                    }
                }
                seriesLabels[i] = sb.toString();
            }
            if (seriesCount > 1 && !options.openAllSeries() && !options.isViewNone()) {
                this.debug("prompt for which series to import");
                SeriesDialog seriesDialog = new SeriesDialog(options, r, seriesLabels, series);
                status = seriesDialog.showDialog();
                if (!this.statusOk(status)) {
                    return;
                }
            } else {
                this.debug("no need to prompt for series");
            }
            if (options.openAllSeries() || options.isViewNone()) {
                Arrays.fill(series, true);
            }
            if (swapDimensions) {
                this.debug("prompt for dimension swapping parameters");
                SwapDialog swapDialog = new SwapDialog(options, virtualReader, series);
                status = swapDialog.showDialog();
                if (!this.statusOk(status)) {
                    return;
                }
                for (int i = 0; i < seriesCount; ++i) {
                    r.setSeries(i);
                    num[i] = r.getImageCount();
                    sizeC[i] = r.getEffectiveSizeC();
                    sizeZ[i] = r.getSizeZ();
                    sizeT[i] = r.getSizeT();
                    certain[i] = r.isOrderCertain();
                    tBegin[i] = 0;
                    zBegin[i] = 0;
                    cBegin[i] = 0;
                    cEnd[i] = sizeC[i] - 1;
                    zEnd[i] = sizeZ[i] - 1;
                    tEnd[i] = sizeT[i] - 1;
                    tStep[i] = 1;
                    zStep[i] = 1;
                    cStep[i] = 1;
                }
            } else {
                this.debug("no need to prompt for dimension swapping");
            }
            if (specifyRanges) {
                boolean needRange = false;
                for (int i = 0; i < seriesCount; ++i) {
                    if (!series[i] || num[i] <= 1) continue;
                    needRange = true;
                }
                if (needRange) {
                    this.debug("prompt for planar ranges");
                    IJ.showStatus((String)"");
                    RangeDialog rangeDialog = new RangeDialog(options, r, series, seriesLabels, cBegin, cEnd, cStep, zBegin, zEnd, zStep, tBegin, tEnd, tStep);
                    status = rangeDialog.showDialog();
                    if (!this.statusOk(status)) {
                        return;
                    }
                } else {
                    this.debug("no need to prompt for planar ranges");
                }
            } else {
                this.debug("open all planes");
            }
            int[] cCount = new int[seriesCount];
            int[] zCount = new int[seriesCount];
            int[] tCount = new int[seriesCount];
            for (int i = 0; i < seriesCount; ++i) {
                if (!series[i]) continue;
                cCount[i] = (cEnd[i] - cBegin[i] + cStep[i]) / cStep[i];
                zCount[i] = (zEnd[i] - zBegin[i] + zStep[i]) / zStep[i];
                tCount[i] = (tEnd[i] - tBegin[i] + tStep[i]) / tStep[i];
            }
            Rectangle[] cropOptions = new Rectangle[seriesCount];
            for (int i = 0; i < cropOptions.length; ++i) {
                if (!series[i] || !cropOnImport) continue;
                cropOptions[i] = new Rectangle();
            }
            if (cropOnImport && !this.statusOk(status = (cropDialog = new CropDialog(options, r, seriesLabels, series, cropOptions)).showDialog())) {
                return;
            }
            if (showMetadata) {
                this.debug("display metadata");
                IJ.showStatus((String)"Populating metadata");
                Hashtable meta = r.getMetadata();
                meta.put(options.getLocation(), currentFile);
                int digits = this.digits(seriesCount);
                for (int i = 0; i < seriesCount; ++i) {
                    if (!series[i]) continue;
                    r.setSeries(i);
                    String s = omexmlMeta.getImageName(i);
                    if ((s == null || s.trim().length() == 0) && seriesCount > 1) {
                        StringBuffer sb = new StringBuffer();
                        sb.append("Series ");
                        int zeroes = digits - this.digits(i + 1);
                        for (int j = 0; j < zeroes; ++j) {
                            sb.append(0);
                        }
                        sb.append(i + 1);
                        sb.append(" ");
                        s = sb.toString();
                    } else {
                        s = s + " ";
                    }
                    String pad = " ";
                    meta.put(" " + s + "SizeX", new Integer(r.getSizeX()));
                    meta.put(" " + s + "SizeY", new Integer(r.getSizeY()));
                    meta.put(" " + s + "SizeZ", new Integer(r.getSizeZ()));
                    meta.put(" " + s + "SizeT", new Integer(r.getSizeT()));
                    meta.put(" " + s + "SizeC", new Integer(r.getSizeC()));
                    meta.put(" " + s + "IsRGB", new Boolean(r.isRGB()));
                    meta.put(" " + s + "PixelType", FormatTools.getPixelTypeString(r.getPixelType()));
                    meta.put(" " + s + "LittleEndian", new Boolean(r.isLittleEndian()));
                    meta.put(" " + s + "DimensionOrder", r.getDimensionOrder());
                    meta.put(" " + s + "IsInterleaved", new Boolean(r.isInterleaved()));
                }
                String metaString = this.getMetadataString(meta, "\t");
                SearchableWindow w = new SearchableWindow("Original Metadata - " + id, "Key\tValue", metaString, 400, 400);
                w.setVisible(true);
            } else {
                this.debug("skip metadata");
            }
            if (showOMEXML) {
                this.debug("show OME-XML");
                if (!options.isViewBrowser()) {
                    XMLWindow metaWindow = new XMLWindow("OME Metadata - " + id);
                    try {
                        metaWindow.setXML(MetadataTools.getOMEXML(omexmlMeta));
                        WindowTools.placeWindow(metaWindow);
                        metaWindow.setVisible(true);
                    }
                    catch (ParserConfigurationException exc) {
                        WindowTools.reportException(exc, options.isQuiet(), "Sorry, there was a problem displaying the OME metadata");
                    }
                    catch (SAXException exc) {
                        WindowTools.reportException(exc, options.isQuiet(), "Sorry, there was a problem displaying the OME metadata");
                    }
                }
            } else {
                this.debug("skip OME-XML");
            }
            if (options.isViewNone()) {
                return;
            }
            this.debug("read pixel data");
            IJ.showStatus((String)("Reading " + currentFile));
            if (options.isVirtual()) {
                int totalSeries = 0;
                for (int i = 0; i < seriesCount; ++i) {
                    if (!series[i]) continue;
                    ++totalSeries;
                }
                virtualReader.setRefCount(totalSeries);
            }
            for (int i = 0; i < seriesCount; ++i) {
                long startTime;
                String idDir;
                if (!series[i]) continue;
                r.setSeries(i);
                boolean[] load = new boolean[num[i]];
                for (int c = cBegin[i]; c <= cEnd[i]; c += cStep[i]) {
                    for (int z = zBegin[i]; z <= zEnd[i]; z += zStep[i]) {
                        for (int t = tBegin[i]; t <= tEnd[i]; t += tStep[i]) {
                            int index = r.getIndex(z, c, t);
                            load[index] = true;
                        }
                    }
                }
                int total = 0;
                for (int j = 0; j < num[i]; ++j) {
                    if (!load[j]) continue;
                    ++total;
                }
                FileInfo fi = new FileInfo();
                String string = idDir = idLoc == null ? null : idLoc.getParent();
                if (idDir != null && !idDir.endsWith(File.separator)) {
                    idDir = idDir + File.separator;
                }
                fi.fileName = idName;
                fi.directory = idDir;
                String metadata = this.getMetadataString(r.getMetadata(), " = ");
                long time = startTime = System.currentTimeMillis();
                BFVirtualStack stackB = null;
                ImageStack stackS = null;
                ImageStack stackF = null;
                ImageStack stackO = null;
                int w = cropOnImport ? cropOptions[i].width : r.getSizeX();
                int h = cropOnImport ? cropOptions[i].height : r.getSizeY();
                int c = r.getRGBChannelCount();
                int type = r.getPixelType();
                int q = 0;
                this.stackOrder = options.getStackOrder();
                if (this.stackOrder.equals("Default")) {
                    this.stackOrder = r.getDimensionOrder();
                }
                virtualReader.setOutputOrder(this.stackOrder);
                omexmlMeta.setPixelsDimensionOrder(this.stackOrder, i, 0);
                fi.description = MetadataTools.getOMEXML(omexmlMeta);
                if (options.isVirtual()) {
                    int j;
                    BFVirtualStack virtualStackB;
                    int cSize = r.getSizeC();
                    int pt = r.getPixelType();
                    boolean doMerge = options.isMergeChannels();
                    boolean eight = pt != 1 && pt != 0;
                    boolean needComposite = doMerge && (cSize > 3 || eight);
                    int merge = needComposite || !doMerge ? 1 : cSize;
                    stackB = virtualStackB = new BFVirtualStack(id, r, colorize, doMerge, options.isRecord());
                    if (doMerge) {
                        cCount[i] = 1;
                        for (j = 0; j < num[i]; ++j) {
                            int[] pos = r.getZCTCoords(j);
                            if (pos[1] > 0) continue;
                            String label = this.constructSliceLabel(new ChannelMerger(r).getIndex(pos[0], pos[1], pos[2]), new ChannelMerger(r), omexmlMeta, i, zCount, cCount, tCount);
                            virtualStackB.addSlice(label);
                        }
                    } else {
                        for (j = 0; j < num[i]; ++j) {
                            String label = this.constructSliceLabel(j, r, omexmlMeta, i, zCount, cCount, tCount);
                            virtualStackB.addSlice(label);
                        }
                    }
                } else {
                    if (r.isIndexed()) {
                        this.colorModels = new IndexColorModel[r.getSizeC()];
                    }
                    for (int j = 0; j < num[i]; ++j) {
                        if (!load[j]) continue;
                        long clock = System.currentTimeMillis();
                        if (clock - time >= 100L) {
                            IJ.showStatus((String)("Reading " + (seriesCount > 1 ? "series " + (i + 1) + ", " : "") + "plane " + (j + 1) + "/" + num[i]));
                            time = clock;
                        }
                        IJ.showProgress((double)((double)q++ / (double)total));
                        int ndx = j;
                        String label = this.constructSliceLabel(ndx, r, omexmlMeta, i, zCount, cCount, tCount);
                        ImageProcessor ip = r.openProcessors(ndx, cropOptions[i])[0];
                        if (ip == null) {
                            this.plugin.canceled = true;
                            return;
                        }
                        int channel = r.getZCTCoords(ndx)[1];
                        if (this.colorModels != null) {
                            this.colorModels[channel] = (IndexColorModel)ip.getColorModel();
                        }
                        if (ip instanceof ByteProcessor) {
                            if (stackB == null) {
                                stackB = new ImageStack(w, h);
                            }
                            stackB.addSlice(label, ip);
                            continue;
                        }
                        if (ip instanceof ShortProcessor) {
                            if (stackS == null) {
                                stackS = new ImageStack(w, h);
                            }
                            stackS.addSlice(label, ip);
                            continue;
                        }
                        if (ip instanceof FloatProcessor) {
                            if (stackB != null) {
                                ip = ip.convertToByte(true);
                                stackB.addSlice(label, ip);
                                continue;
                            }
                            if (stackS != null) {
                                ip = ip.convertToShort(true);
                                stackS.addSlice(label, ip);
                                continue;
                            }
                            if (stackF == null) {
                                stackF = new ImageStack(w, h);
                            }
                            stackF.addSlice(label, ip);
                            continue;
                        }
                        if (!(ip instanceof ColorProcessor)) continue;
                        if (stackO == null) {
                            stackO = new ImageStack(w, h);
                        }
                        stackO.addSlice(label, ip);
                    }
                }
                IJ.showStatus((String)"Creating image");
                IJ.showProgress((double)1.0);
                String seriesName = omexmlMeta.getImageName(i);
                this.showStack((ImageStack)stackB, currentFile, seriesName, omexmlMeta, cCount[i], zCount[i], tCount[i], sizeZ[i], sizeC[i], sizeT[i], fi, r, options, metadata, windowless);
                this.showStack(stackS, currentFile, seriesName, omexmlMeta, cCount[i], zCount[i], tCount[i], sizeZ[i], sizeC[i], sizeT[i], fi, r, options, metadata, windowless);
                this.showStack(stackF, currentFile, seriesName, omexmlMeta, cCount[i], zCount[i], tCount[i], sizeZ[i], sizeC[i], sizeT[i], fi, r, options, metadata, windowless);
                this.showStack(stackO, currentFile, seriesName, omexmlMeta, cCount[i], zCount[i], tCount[i], sizeZ[i], sizeC[i], sizeT[i], fi, r, options, metadata, windowless);
                long endTime = System.currentTimeMillis();
                double elapsed = (double)(endTime - startTime) / 1000.0;
                if (num[i] == 1) {
                    IJ.showStatus((String)("Bio-Formats: " + elapsed + " seconds"));
                    continue;
                }
                long average = (endTime - startTime) / (long)num[i];
                IJ.showStatus((String)("Bio-Formats: " + elapsed + " seconds (" + average + " ms per plane)"));
            }
            if (concatenate) {
                Vector<Integer> widths = new Vector<Integer>();
                Vector<Integer> heights = new Vector<Integer>();
                Vector<Integer> types = new Vector<Integer>();
                Vector<ImagePlus> newImps = new Vector<ImagePlus>();
                for (int j = 0; j < this.imps.size(); ++j) {
                    ImagePlus imp = (ImagePlus)this.imps.get(j);
                    int wj = imp.getWidth();
                    int hj = imp.getHeight();
                    int tj = imp.getBitDepth();
                    boolean append = false;
                    for (int k = 0; k < widths.size(); ++k) {
                        int wk = (Integer)widths.get(k);
                        int hk = (Integer)heights.get(k);
                        int tk = (Integer)types.get(k);
                        if (wj != wk || hj != hk || tj != tk) continue;
                        ImagePlus oldImp = (ImagePlus)newImps.get(k);
                        ImageStack is = oldImp.getStack();
                        ImageStack newStack = imp.getStack();
                        for (int s = 0; s < newStack.getSize(); ++s) {
                            is.addSlice(newStack.getSliceLabel(s + 1), newStack.getProcessor(s + 1));
                        }
                        oldImp.setStack(oldImp.getTitle(), is);
                        newImps.setElementAt(oldImp, k);
                        append = true;
                        k = widths.size();
                    }
                    if (append) continue;
                    widths.add(new Integer(wj));
                    heights.add(new Integer(hj));
                    types.add(new Integer(tj));
                    newImps.add(imp);
                }
                boolean splitC = options.isSplitChannels();
                boolean splitZ = options.isSplitFocalPlanes();
                boolean splitT = options.isSplitTimepoints();
                for (int j = 0; j < newImps.size(); ++j) {
                    ImagePlus imp = (ImagePlus)newImps.get(j);
                    imp.show();
                    if (splitC || splitZ || splitT) {
                        IJ.runPlugIn((String)"loci.plugins.Slicer", (String)("slice_z=" + splitZ + " slice_c=" + splitC + " slice_t=" + splitT + " stack_order=" + this.stackOrder + " keep_original=false " + "hyper_stack=" + options.isViewHyperstack() + " "));
                        imp.close();
                    }
                    if (mergeChannels && windowless) {
                        IJ.runPlugIn((String)"loci.plugins.Colorizer", (String)("stack_order=" + this.stackOrder + " merge=true merge_option=[" + options.getMergeOption() + "] " + "series=" + r.getSeries() + " hyper_stack=" + options.isViewHyperstack() + " "));
                        imp.close();
                        continue;
                    }
                    if (!mergeChannels) continue;
                    IJ.runPlugIn((String)"loci.plugins.Colorizer", (String)("stack_order=" + this.stackOrder + " merge=true series=" + r.getSeries() + " hyper_stack=" + options.isViewHyperstack() + " "));
                    imp.close();
                }
            }
            if (options.showROIs()) {
                this.debug("display ROIs");
                ROIHandler.openROIs(omexmlMeta, this.imps.toArray(new ImagePlus[0]));
            } else {
                this.debug("skip ROIs");
            }
            this.debug("finish up");
            try {
                if (!options.isVirtual()) {
                    r.close();
                }
            }
            catch (IOException exc) {
                WindowTools.reportException(exc, options.isQuiet(), "Sorry, there was a problem closing the file");
            }
            this.plugin.success = true;
        }
        catch (FormatException exc) {
            WindowTools.reportException(exc, quiet, "Sorry, there was a problem reading the data.");
        }
        catch (IOException exc) {
            WindowTools.reportException(exc, quiet, "Sorry, there was an I/O problem reading the data.");
        }
    }

    private void showStack(ImageStack stack, String file2, String series, MetadataRetrieve retrieve, int cCount, int zCount, int tCount, int sizeZ, int sizeC, int sizeT, FileInfo fi, IFormatReader r, ImporterOptions options, String metadata, boolean windowless) throws FormatException, IOException {
        if (stack == null) {
            return;
        }
        String title = this.getTitle(r, file2, series, options.isGroupFiles());
        VirtualImagePlus imp = null;
        if (options.isVirtual()) {
            imp = new VirtualImagePlus(title, stack);
            imp.setReader(r);
        } else {
            imp = new ImagePlus(title, stack);
        }
        imp.setProperty("Info", metadata);
        ImagePlusTools.applyCalibration(retrieve, imp, r.getSeries());
        imp.setFileInfo(fi);
        imp.setDimensions(cCount, zCount, tCount);
        this.displayStack(imp, r, options, windowless);
    }

    private void displayStack(ImagePlus imp, IFormatReader r, ImporterOptions options, boolean windowless) {
        ReflectedUniverse ru;
        boolean mergeChannels = options.isMergeChannels();
        boolean concatenate = options.isConcatenate();
        int nSlices = imp.getNSlices();
        int nFrames = imp.getNFrames();
        if (options.isAutoscale() && !options.isVirtual()) {
            ImagePlusTools.adjustColorRange(imp);
        } else {
            imp.setDisplayRange(0.0, Math.pow(2.0, imp.getBitDepth()) - 1.0);
        }
        boolean splitC = options.isSplitChannels();
        boolean splitZ = options.isSplitFocalPlanes();
        boolean splitT = options.isSplitTimepoints();
        int z = r.getSizeZ();
        int c = r.getSizeC();
        int t = r.getSizeT();
        if (!concatenate && mergeChannels) {
            imp.show();
        }
        if (imp.isVisible() && !options.isVirtual()) {
            String arg = "stack_order=" + this.stackOrder + " merge=true series=" + r.getSeries() + " hyper_stack=" + options.isViewHyperstack();
            if (windowless) {
                arg = arg + " merge_option=[" + options.getMergeOption() + "]";
            }
            arg = arg + " ";
            IJ.runPlugIn((String)"loci.plugins.Colorizer", (String)arg);
        }
        imp.setDimensions(imp.getStackSize() / (nSlices * nFrames), nSlices, nFrames);
        if (options.isViewVisBio()) {
            ru = new ReflectedUniverse();
            try {
                ru.exec("import loci.visbio.data.Dataset");
                ru.exec("dataset = new Dataset(name, pattern)");
            }
            catch (ReflectException exc) {
                WindowTools.reportException(exc, options.isQuiet(), "Sorry, there was a problem interfacing with VisBio");
                return;
            }
        } else if (options.isViewImage5D()) {
            ru = new ReflectedUniverse();
            try {
                ru.exec("import i5d.Image5D");
                ru.setVar("title", imp.getTitle());
                ru.setVar("stack", imp.getStack());
                ru.setVar("sizeC", c);
                ru.setVar("sizeZ", z);
                ru.setVar("sizeT", t);
                ru.exec("i5d = new Image5D(title, stack, sizeC, sizeZ, sizeT)");
                ru.setVar("cal", imp.getCalibration());
                ru.setVar("fi", imp.getOriginalFileInfo());
                ru.exec("i5d.setCalibration(cal)");
                ru.exec("i5d.setFileInfo(fi)");
                ru.exec("i5d.show()");
            }
            catch (ReflectException exc) {
                WindowTools.reportException(exc, options.isQuiet(), "Sorry, there was a problem interfacing with Image5D");
                return;
            }
        } else if (options.isViewView5D()) {
            WindowManager.setTempCurrentImage((ImagePlus)imp);
            IJ.run((String)"start viewer", (String)"");
        } else {
            boolean hyper = options.isViewHyperstack() || options.isViewBrowser();
            imp.setOpenAsHyperStack(hyper);
            if (!concatenate) {
                if (options.isViewBrowser()) {
                    DataBrowser dataBrowser = new DataBrowser(imp, null, r.getChannelDimTypes(), r.getChannelDimLengths());
                    if (options.isShowOMEXML()) {
                        dataBrowser.showMetadataWindow();
                    }
                } else {
                    imp.show();
                }
                boolean colorize = options.isColorize();
                boolean customColorize = options.isCustomColorize();
                boolean browser = options.isViewBrowser();
                boolean virtual = options.isVirtual();
                if (colorize || customColorize) {
                    IJ.runPlugIn((String)"loci.plugins.Colorizer", (String)("stack_order=" + this.stackOrder + " merge=false colorize=true ndx=" + (customColorize ? "-1" : "0") + " series=" + r.getSeries() + " hyper_stack=" + options.isViewHyperstack() + " "));
                    imp.close();
                } else if (this.colorModels != null && !browser && !virtual) {
                    Colorizer colorizer = new Colorizer();
                    String arg = "stack_order=" + this.stackOrder + " merge=false " + "colorize=true series=" + r.getSeries() + " hyper_stack=" + hyper + " ";
                    colorizer.setup(arg, imp);
                    for (int channel = 0; channel < this.colorModels.length; ++channel) {
                        byte[][] lut = new byte[3][256];
                        this.colorModels[channel].getReds(lut[0]);
                        this.colorModels[channel].getGreens(lut[1]);
                        this.colorModels[channel].getBlues(lut[2]);
                        colorizer.setLookupTable(lut, channel);
                    }
                    new PlugInFilterRunner((Object)colorizer, "", arg);
                    imp.close();
                }
                if (splitC || splitZ || splitT) {
                    IJ.runPlugIn((String)"loci.plugins.Slicer", (String)("slice_z=" + splitZ + " slice_c=" + splitC + " slice_t=" + splitT + " stack_order=" + this.stackOrder + " keep_original=false " + "hyper_stack=" + hyper + " "));
                    imp.close();
                }
            }
            this.imps.add(imp);
        }
    }

    private int digits(int value) {
        int digits = 0;
        while (value > 0) {
            value /= 10;
            ++digits;
        }
        return digits;
    }

    private String getTitle(IFormatReader r, String file2, String series, boolean groupFiles) {
        FilePattern fp;
        String[] used = r.getUsedFiles();
        String title = file2.substring(file2.lastIndexOf(File.separator) + 1);
        if (used.length > 1 && groupFiles && (fp = new FilePattern(new Location(file2))) != null) {
            title = fp.getPattern();
            if (title == null && (title = file2).indexOf(".") != -1) {
                title = title.substring(0, title.lastIndexOf("."));
            }
            title = title.substring(title.lastIndexOf(File.separator) + 1);
        }
        if (series != null && !file2.endsWith(series) && r.getSeriesCount() > 1) {
            title = title + " - " + series;
        }
        if (title.length() > 128) {
            String a = title.substring(0, 62);
            String b = title.substring(title.length() - 62);
            title = a + "..." + b;
        }
        return title;
    }

    private String constructSliceLabel(int ndx, IFormatReader r, MetadataRetrieve retrieve, int series, int[] zCount, int[] cCount, int[] tCount) {
        String imageName;
        r.setSeries(series);
        int[] zct = r.getZCTCoords(ndx);
        int[] subC = r.getChannelDimLengths();
        String[] subCTypes = r.getChannelDimTypes();
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        if (cCount[series] > 1) {
            if (first) {
                first = false;
            } else {
                sb.append("; ");
            }
            int[] subCPos = FormatTools.rasterToPosition(subC, zct[1]);
            for (int i = 0; i < subC.length; ++i) {
                boolean ch = subCTypes[i].equals("Channel");
                sb.append(ch ? "c" : subCTypes[i]);
                sb.append(":");
                sb.append(subCPos[i] + 1);
                sb.append("/");
                sb.append(subC[i]);
                if (i >= subC.length - 1) continue;
                sb.append(", ");
            }
        }
        if (zCount[series] > 1) {
            if (first) {
                first = false;
            } else {
                sb.append("; ");
            }
            sb.append("z:");
            sb.append(zct[0] + 1);
            sb.append("/");
            sb.append(r.getSizeZ());
        }
        if (tCount[series] > 1) {
            if (first) {
                first = false;
            } else {
                sb.append("; ");
            }
            sb.append("t:");
            sb.append(zct[2] + 1);
            sb.append("/");
            sb.append(r.getSizeT());
        }
        if ((imageName = retrieve.getImageName(series)) != null && !imageName.trim().equals("")) {
            sb.append(" - ");
            sb.append(imageName);
        }
        return sb.toString();
    }

    private boolean statusOk(int status) {
        if (status == 1) {
            this.plugin.canceled = true;
        }
        return status == 0;
    }

    private String getMetadataString(Hashtable meta, String separator) {
        Enumeration e = meta.keys();
        Vector v = new Vector();
        while (e.hasMoreElements()) {
            v.add(e.nextElement());
        }
        Object[] keys = new String[v.size()];
        v.copyInto(keys);
        Arrays.sort(keys);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < keys.length; ++i) {
            sb.append((String)keys[i]);
            sb.append(separator);
            sb.append(meta.get(keys[i]));
            sb.append("\n");
        }
        return sb.toString();
    }

    private void debug(String msg) {
        if (IJ.debugMode) {
            IJ.log((String)("Bio-Formats Importer: " + msg));
        }
    }

    public static void main(String[] args) {
        new ImageJ(null);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(args[i]);
        }
        new LociImporter().run(sb.toString());
    }

    private class VirtualReader
    extends DimensionSwapper {
        private int refCount;

        public VirtualReader(IFormatReader r) {
            super(r);
            this.refCount = 0;
        }

        public void setRefCount(int refCount) {
            this.refCount = refCount;
        }

        public void close() throws IOException {
            if (this.refCount > 0) {
                --this.refCount;
            }
            if (this.refCount == 0) {
                super.close();
            }
        }
    }

    private static class StatusEchoer
    implements StatusListener {
        private StatusEchoer() {
        }

        public void statusUpdated(StatusEvent e) {
            IJ.showStatus((String)e.getStatusMessage());
        }
    }
}

