/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.thredds;

import java.io.IOException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.DataFormatType;
import thredds.catalog.DataType;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.ThreddsMetadata;
import thredds.datatype.DateRange;
import ucar.nc2.Attribute;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.PointObsDataset;
import ucar.nc2.dt.StationObsDataset;
import ucar.nc2.thredds.ThreddsDataFactory;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.LatLonRect;

public class MetadataExtractor {
    private static Logger logger = LoggerFactory.getLogger(MetadataExtractor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThreddsMetadata.GeospatialCoverage extractGeospatial(InvDatasetImpl threddsDataset) throws IOException {
        ThreddsDataFactory.Result result = null;
        try {
            StationObsDataset sobsDataset;
            LatLonRect llbb;
            result = new ThreddsDataFactory().openDatatype(threddsDataset, null);
            if (result.fatalError) {
                System.out.println(" openDatatype errs=" + result.errLog);
                ThreddsMetadata.GeospatialCoverage geospatialCoverage = null;
                return geospatialCoverage;
            }
            if (result.dataType == DataType.GRID) {
                System.out.println(" GRID=" + result.location);
                GridDataset gridDataset = (GridDataset)result.tds;
                ThreddsMetadata.GeospatialCoverage ioe = MetadataExtractor.extractGeospatial(gridDataset);
                return ioe;
            }
            if (result.dataType == DataType.POINT) {
                PointObsDataset pobsDataset = (PointObsDataset)result.tds;
                LatLonRect llbb2 = pobsDataset.getBoundingBox();
                if (null != llbb2) {
                    ThreddsMetadata.GeospatialCoverage gc = new ThreddsMetadata.GeospatialCoverage();
                    gc.setBoundingBox(llbb2);
                    ThreddsMetadata.GeospatialCoverage geospatialCoverage = gc;
                    return geospatialCoverage;
                }
            } else if (result.dataType == DataType.STATION && null != (llbb = (sobsDataset = (StationObsDataset)result.tds).getBoundingBox())) {
                ThreddsMetadata.GeospatialCoverage gc = new ThreddsMetadata.GeospatialCoverage();
                gc.setBoundingBox(llbb);
                ThreddsMetadata.GeospatialCoverage geospatialCoverage = gc;
                return geospatialCoverage;
            }
        }
        finally {
            try {
                if (result != null && result.tds != null) {
                    result.tds.close();
                }
            }
            catch (IOException ioe) {
                logger.error("Closing dataset " + result.tds, ioe);
            }
        }
        return null;
    }

    public static ThreddsMetadata.GeospatialCoverage extractGeospatial(GridDataset gridDataset) {
        ThreddsMetadata.GeospatialCoverage gc = new ThreddsMetadata.GeospatialCoverage();
        LatLonRect llbb = null;
        CoordinateAxis1D vaxis = null;
        for (GridDataset.Gridset gridset : gridDataset.getGridsets()) {
            GridCoordSystem gsys = gridset.getGeoCoordSystem();
            if (llbb == null) {
                llbb = gsys.getLatLonBoundingBox();
            }
            CoordinateAxis1D vaxis2 = gsys.getVerticalAxis();
            if (vaxis == null) {
                vaxis = vaxis2;
                continue;
            }
            if (vaxis2 == null || vaxis2.getSize() <= vaxis.getSize()) continue;
            vaxis = vaxis2;
        }
        gc.setBoundingBox(llbb);
        if (vaxis != null) {
            gc.setVertical(vaxis);
        }
        return gc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThreddsMetadata.Variables extractVariables(InvDatasetImpl threddsDataset) throws IOException {
        ThreddsDataFactory.Result result = null;
        try {
            result = new ThreddsDataFactory().openDatatype(threddsDataset, null);
            if (result.fatalError) {
                System.out.println(" openDatatype errs=" + result.errLog);
                ThreddsMetadata.Variables variables = null;
                return variables;
            }
            if (result.dataType == DataType.GRID) {
                GridDataset gridDataset = (GridDataset)result.tds;
                ThreddsMetadata.Variables ioe = MetadataExtractor.extractVariables(threddsDataset, gridDataset);
                return ioe;
            }
            if (result.dataType == DataType.STATION || result.dataType == DataType.POINT) {
                PointObsDataset pobsDataset = (PointObsDataset)result.tds;
                ThreddsMetadata.Variables vars = new ThreddsMetadata.Variables("CF-1.0");
                for (VariableSimpleIF vs : pobsDataset.getDataVariables()) {
                    ThreddsMetadata.Variable v = new ThreddsMetadata.Variable();
                    vars.addVariable(v);
                    v.setName(vs.getName());
                    v.setDescription(vs.getDescription());
                    v.setUnits(vs.getUnitsString());
                    Attribute att = vs.findAttributeIgnoreCase("standard_name");
                    v.setVocabularyName(att != null ? att.getStringValue() : "N/A");
                }
                vars.sort();
                ThreddsMetadata.Variables variables = vars;
                return variables;
            }
        }
        finally {
            try {
                if (result != null && result.tds != null) {
                    result.tds.close();
                }
            }
            catch (IOException ioe) {
                logger.error("Closing dataset " + result.tds, ioe);
            }
        }
        return null;
    }

    public static ThreddsMetadata.Variables extractVariables(InvDatasetImpl threddsDataset, GridDataset gridDataset) {
        DataFormatType fileFormat = threddsDataset.getDataFormatType();
        if (fileFormat != null && (fileFormat.equals(DataFormatType.GRIB1) || fileFormat.equals(DataFormatType.GRIB2))) {
            boolean isGrib1 = fileFormat.equals(DataFormatType.GRIB1);
            ThreddsMetadata.Variables vars = new ThreddsMetadata.Variables(fileFormat.toString());
            for (GridDatatype grid : gridDataset.getGrids()) {
                ThreddsMetadata.Variable v = new ThreddsMetadata.Variable();
                v.setName(grid.getName());
                v.setDescription(grid.getDescription());
                v.setUnits(grid.getUnitsString());
                if (isGrib1) {
                    v.setVocabularyName(grid.findAttValueIgnoreCase("GRIB_param_name", "ERROR"));
                    v.setVocabularyId(grid.findAttributeIgnoreCase("GRIB_param_id"));
                } else {
                    String paramDisc = grid.findAttValueIgnoreCase("GRIB_param_discipline", "");
                    String paramCategory = grid.findAttValueIgnoreCase("GRIB_param_category", "");
                    String paramName = grid.findAttValueIgnoreCase("GRIB_param_name", "");
                    v.setVocabularyName(paramDisc + " / " + paramCategory + " / " + paramName);
                    v.setVocabularyId(grid.findAttributeIgnoreCase("GRIB_param_id"));
                }
                vars.addVariable(v);
            }
            vars.sort();
            return vars;
        }
        ThreddsMetadata.Variables vars = new ThreddsMetadata.Variables("CF-1.0");
        for (GridDatatype grid : gridDataset.getGrids()) {
            ThreddsMetadata.Variable v = new ThreddsMetadata.Variable();
            vars.addVariable(v);
            v.setName(grid.getName());
            v.setDescription(grid.getDescription());
            v.setUnits(grid.getUnitsString());
            Attribute att = grid.findAttributeIgnoreCase("standard_name");
            v.setVocabularyName(att != null ? att.getStringValue() : "N/A");
        }
        vars.sort();
        return vars;
    }

    public static DateRange extractDateRange(GridDataset gridDataset) {
        DateRange maxDateRange = null;
        for (GridDataset.Gridset gridset : gridDataset.getGridsets()) {
            DateRange dateRange;
            GridCoordSystem gsys = gridset.getGeoCoordSystem();
            CoordinateAxis1DTime time1D = gsys.getTimeAxis1D();
            if (time1D != null) {
                dateRange = time1D.getDateRange();
            } else {
                CoordinateAxis time = gsys.getTimeAxis();
                try {
                    DateUnit du = new DateUnit(time.getUnitsString());
                    Date minDate = du.makeDate(time.getMinValue());
                    Date maxDate = du.makeDate(time.getMaxValue());
                    dateRange = new DateRange(minDate, maxDate);
                }
                catch (Exception e) {
                    logger.warn("Illegal Date Unit " + time.getUnitsString());
                    continue;
                }
            }
            if (maxDateRange == null) {
                maxDateRange = dateRange;
                continue;
            }
            maxDateRange.extend(dateRange);
        }
        return maxDateRange;
    }
}

