/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.grid;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import thredds.datatype.DateRange;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.nc2.Dimension;
import ucar.nc2.dataset.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dataset.CoordinateAxis2D;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.dataset.VerticalCT;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.units.DateUnit;
import ucar.nc2.units.SimpleUnit;
import ucar.nc2.units.TimeUnit;
import ucar.nc2.util.NamedObject;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.geoloc.projection.RotatedPole;
import ucar.unidata.geoloc.projection.VerticalPerspectiveView;
import ucar.unidata.geoloc.vertical.VerticalTransform;
import ucar.units.ConversionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridCoordSys
extends CoordinateSystem
implements GridCoordSystem {
    private static SimpleUnit kmUnit = SimpleUnit.factory("km");
    private ProjectionImpl proj;
    private CoordinateAxis horizXaxis;
    private CoordinateAxis horizYaxis;
    private CoordinateAxis1D vertZaxis;
    private CoordinateAxis1D ensembleAxis;
    private CoordinateAxis1DTime timeTaxis;
    private CoordinateAxis1DTime runTimeAxis;
    private VerticalCT vCT;
    private Dimension timeDim;
    private boolean isDate;
    private boolean isLatLon;
    private List<NamedObject> levels;
    private List<NamedObject> times;
    private Date[] timeDates;
    private CoordinateAxis1DTime[] timeAxisForRun;
    private ProjectionRect mapArea;
    private LatLonRect llbb;

    public static boolean isGridCoordSys(StringBuffer sbuff, CoordinateSystem cs) {
        CoordinateAxis yaxis;
        CoordinateAxis xaxis;
        if (cs.getRankDomain() < 2) {
            if (sbuff != null) {
                sbuff.append(cs.getName()).append(": domain rank < 2\n");
            }
            return false;
        }
        if (!cs.isLatLon()) {
            if (cs.getXaxis() == null || cs.getYaxis() == null) {
                if (sbuff != null) {
                    sbuff.append(cs.getName()).append(": NO Lat,Lon or X,Y axis\n");
                }
                return false;
            }
            if (null == cs.getProjection()) {
                if (sbuff != null) {
                    sbuff.append(cs.getName()).append(": NO projection found\n");
                }
                return false;
            }
        }
        if (cs.isGeoXY()) {
            xaxis = cs.getXaxis();
            yaxis = cs.getYaxis();
            ProjectionImpl p = cs.getProjection();
            if (!(p instanceof RotatedPole)) {
                if (!kmUnit.isCompatible(xaxis.getUnitsString())) {
                    if (sbuff != null) {
                        sbuff.append(cs.getName()).append(": X axis units must be convertible to km\n");
                    }
                    return false;
                }
                if (!kmUnit.isCompatible(yaxis.getUnitsString())) {
                    if (sbuff != null) {
                        sbuff.append(cs.getName()).append(": Y axis units must be convertible to km\n");
                    }
                    return false;
                }
            }
        } else {
            xaxis = cs.getLonAxis();
            yaxis = cs.getLatAxis();
        }
        if (xaxis.getRank() > 2 || yaxis.getRank() > 2) {
            if (sbuff != null) {
                sbuff.append(cs.getName()).append(": X or Y axis rank must be <= 2\n");
            }
            return false;
        }
        CoordinateAxis z = cs.getHeightAxis();
        if (z == null || !(z instanceof CoordinateAxis1D)) {
            z = cs.getPressureAxis();
        }
        if (z == null || !(z instanceof CoordinateAxis1D)) {
            z = cs.getZaxis();
        }
        if (z != null && !(z instanceof CoordinateAxis1D)) {
            if (sbuff != null) {
                sbuff.append(cs.getName()).append(": Z axis must be 1D\n");
            }
            return false;
        }
        CoordinateAxis t = cs.getTaxis();
        if (t != null && !(t instanceof CoordinateAxis1D)) {
            Dimension tdim;
            CoordinateAxis rt = cs.findAxis(AxisType.RunTime);
            if (rt == null) {
                if (sbuff != null) {
                    sbuff.append(cs.getName()).append(": T axis must be 1D\n");
                }
                return false;
            }
            if (!(rt instanceof CoordinateAxis1D)) {
                if (sbuff != null) {
                    sbuff.append(cs.getName()).append(": RunTime axis must be 1D\n");
                }
                return false;
            }
            if (t.getRank() != 2) {
                if (sbuff != null) {
                    sbuff.append(cs.getName()).append(": Time axis must be 2D when used with RunTime dimension\n");
                }
                return false;
            }
            CoordinateAxis1D rt1D = (CoordinateAxis1D)rt;
            Dimension rtdim = rt1D.getDimension(0);
            if (!rtdim.equals(tdim = t.getDimension(0))) {
                if (sbuff != null) {
                    sbuff.append(cs.getName()).append(": Time axis must use RunTime dimension\n");
                }
                return false;
            }
        }
        return true;
    }

    public static GridCoordSys makeGridCoordSys(StringBuffer sbuff, CoordinateSystem cs, VariableEnhanced v) {
        if (sbuff != null) {
            sbuff.append(" ");
            v.getNameAndDimensions(sbuff, true, false);
            sbuff.append(" check CS ").append(cs.getName()).append(": ");
        }
        if (GridCoordSys.isGridCoordSys(sbuff, cs)) {
            GridCoordSys gcs = new GridCoordSys(cs, sbuff);
            if (gcs.isComplete(v)) {
                if (sbuff != null) {
                    sbuff.append(" OK\n");
                }
                return gcs;
            }
            if (sbuff != null) {
                sbuff.append(" NOT complete\n");
            }
        }
        return null;
    }

    public GridCoordSys(CoordinateSystem cs, StringBuffer sbuff) {
        block24: {
            CoordinateAxis1D rtAxis;
            CoordinateAxis z;
            this.isDate = false;
            this.isLatLon = false;
            this.levels = null;
            this.times = null;
            this.timeDates = null;
            this.mapArea = null;
            this.llbb = null;
            this.ds = cs.getNetcdfDataset();
            if (cs.isGeoXY()) {
                this.horizXaxis = this.xAxis = cs.getXaxis();
                this.horizYaxis = this.yAxis = cs.getYaxis();
                ProjectionImpl p = cs.getProjection();
                if (!(p instanceof RotatedPole)) {
                    this.convertUnits(this.horizXaxis);
                    this.convertUnits(this.horizYaxis);
                }
            } else if (cs.isLatLon()) {
                this.horizXaxis = this.lonAxis = cs.getLonAxis();
                this.horizYaxis = this.latAxis = cs.getLatAxis();
                this.isLatLon = true;
            } else {
                throw new IllegalArgumentException("CoordinateSystem is not geoReferencing");
            }
            this.coordAxes.add(this.horizXaxis);
            this.coordAxes.add(this.horizYaxis);
            ProjectionImpl projOrig = cs.getProjection();
            if (projOrig != null) {
                this.proj = projOrig.constructCopy();
                this.proj.setDefaultMapArea(this.getBoundingBox());
            }
            if ((z = (this.hAxis = cs.getHeightAxis())) == null || !(z instanceof CoordinateAxis1D)) {
                z = this.pAxis = cs.getPressureAxis();
            }
            if (z == null || !(z instanceof CoordinateAxis1D)) {
                z = this.zAxis = cs.getZaxis();
            }
            if (z != null && !(z instanceof CoordinateAxis1D)) {
                z = null;
            }
            if (z != null) {
                this.vertZaxis = (CoordinateAxis1D)z;
                this.coordAxes.add(this.vertZaxis);
            } else {
                this.zAxis = null;
                this.pAxis = null;
                this.hAxis = null;
            }
            CoordinateAxis t = cs.getTaxis();
            if (t != null) {
                if (t instanceof CoordinateAxis1D) {
                    try {
                        this.timeTaxis = t instanceof CoordinateAxis1DTime ? (CoordinateAxis1DTime)t : CoordinateAxis1DTime.factory(this.ds, t, sbuff);
                        this.tAxis = this.timeTaxis;
                        this.coordAxes.add(this.timeTaxis);
                        this.timeDim = t.getDimension(0);
                    }
                    catch (Exception e) {
                        if (sbuff != null) {
                            sbuff.append("Error reading time coord= ").append(t.getName()).append(" ").append(e.getMessage());
                        }
                    }
                } else {
                    this.tAxis = t;
                    this.timeTaxis = null;
                    this.coordAxes.add(t);
                }
            }
            this.ensembleAxis = (CoordinateAxis1D)cs.findAxis(AxisType.Ensemble);
            if (null != this.ensembleAxis) {
                this.coordAxes.add(this.ensembleAxis);
            }
            if (null != (rtAxis = (CoordinateAxis1D)cs.findAxis(AxisType.RunTime))) {
                try {
                    this.runTimeAxis = rtAxis instanceof CoordinateAxis1DTime ? (CoordinateAxis1DTime)rtAxis : CoordinateAxis1DTime.factory(this.ds, rtAxis, sbuff);
                    this.coordAxes.add(this.runTimeAxis);
                }
                catch (IOException e) {
                    if (sbuff == null) break block24;
                    sbuff.append("Error reading runtime coord= ").append(t.getName()).append(" ").append(e.getMessage());
                }
            }
        }
        List<CoordinateTransform> list = cs.getCoordinateTransforms();
        for (CoordinateTransform ct : list) {
            if (!(ct instanceof VerticalCT)) continue;
            this.vCT = (VerticalCT)ct;
            break;
        }
        Collections.sort(this.coordAxes, new CoordinateAxis.AxisComparator());
        this.name = GridCoordSys.makeName(this.coordAxes);
        this.coordTrans = new ArrayList<CoordinateTransform>(cs.getCoordinateTransforms());
        for (CoordinateAxis axis : this.coordAxes) {
            List<Dimension> dims = axis.getDimensions();
            for (Dimension dim : dims) {
                if (this.domain.contains(dim)) continue;
                this.domain.add(dim);
            }
        }
        this.makeLevels();
        this.makeTimes();
    }

    public GridCoordSys(GridCoordSys from, Range t_range, Range z_range, Range y_range, Range x_range) throws InvalidRangeException {
        CoordinateAxis taxis;
        CoordinateAxis1D zaxis;
        this.isDate = false;
        this.isLatLon = false;
        this.levels = null;
        this.times = null;
        this.timeDates = null;
        this.mapArea = null;
        this.llbb = null;
        CoordinateAxis xaxis = from.getXHorizAxis();
        CoordinateAxis yaxis = from.getYHorizAxis();
        if (xaxis instanceof CoordinateAxis1D && yaxis instanceof CoordinateAxis1D) {
            CoordinateAxis1D xaxis1 = (CoordinateAxis1D)xaxis;
            CoordinateAxis1D yaxis1 = (CoordinateAxis1D)yaxis;
            this.horizXaxis = x_range == null ? xaxis1 : xaxis1.section(x_range);
            this.horizYaxis = y_range == null ? yaxis : yaxis1.section(y_range);
        } else if (xaxis instanceof CoordinateAxis2D && yaxis instanceof CoordinateAxis2D && from.isLatLon()) {
            CoordinateAxis2D lon_axis = (CoordinateAxis2D)xaxis;
            CoordinateAxis2D lat_axis = (CoordinateAxis2D)yaxis;
            this.horizXaxis = lon_axis.section(y_range, x_range);
            this.horizYaxis = lat_axis.section(y_range, x_range);
        } else {
            throw new IllegalArgumentException("must be 1D or 2D/LatLon ");
        }
        if (from.isGeoXY()) {
            this.xAxis = this.horizXaxis;
            this.yAxis = this.horizYaxis;
        } else {
            this.lonAxis = this.horizXaxis;
            this.latAxis = this.horizYaxis;
            this.isLatLon = true;
        }
        this.coordAxes.add(this.horizXaxis);
        this.coordAxes.add(this.horizYaxis);
        ProjectionImpl projOrig = from.getProjection();
        if (projOrig != null) {
            this.proj = projOrig.constructCopy();
            this.proj.setDefaultMapArea(this.getBoundingBox());
        }
        if ((zaxis = from.getVerticalAxis()) != null) {
            this.vertZaxis = z_range == null ? zaxis : zaxis.section(z_range);
            this.coordAxes.add(this.vertZaxis);
        }
        if (from.getVerticalCT() != null) {
            VerticalTransform vt = from.getVerticalTransform();
            if (vt != null) {
                vt = vt.subset(t_range, z_range, y_range, x_range);
            }
            this.vCT = new VerticalCT(from.getVerticalCT());
            this.vCT.setVerticalTransform(vt);
        }
        if ((taxis = from.getTimeAxis()) != null) {
            CoordinateAxis1DTime taxis1D = (CoordinateAxis1DTime)taxis;
            this.timeTaxis = t_range == null ? taxis1D : (CoordinateAxis1DTime)taxis1D.section(t_range);
            this.tAxis = this.timeTaxis;
            this.coordAxes.add(this.timeTaxis);
            this.timeDim = this.timeTaxis.getDimension(0);
        }
        Collections.sort(this.coordAxes, new CoordinateAxis.AxisComparator());
        this.name = GridCoordSys.makeName(this.coordAxes);
        this.coordTrans = new ArrayList<CoordinateTransform>(from.getCoordinateTransforms());
        for (CoordinateAxis axis : this.coordAxes) {
            List<Dimension> dims = axis.getDimensions();
            for (Dimension dim : dims) {
                dim.setShared(true);
                if (this.domain.contains(dim)) continue;
                this.domain.add(dim);
            }
        }
        this.makeLevels();
        this.makeTimes();
    }

    private void convertUnits(CoordinateAxis axis) {
        Array data;
        double factor;
        String units = axis.getUnitsString();
        SimpleUnit axisUnit = SimpleUnit.factory(units);
        try {
            factor = axisUnit.convertTo(1.0, kmUnit);
        }
        catch (ConversionException e) {
            e.printStackTrace();
            return;
        }
        if (factor == 1.0) {
            return;
        }
        try {
            data = axis.read();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        IndexIterator ii = data.getIndexIterator();
        while (ii.hasNext()) {
            ii.setDoubleCurrent(factor * ii.getDoubleNext());
        }
        axis.setCachedData(data, false);
        axis.setUnitsString("km");
    }

    @Override
    public VerticalTransform getVerticalTransform() {
        return this.vCT == null ? null : this.vCT.getVerticalTransform();
    }

    @Override
    public VerticalCT getVerticalCT() {
        return this.vCT;
    }

    void makeVerticalTransform(GridDataset gds, StringBuffer parseInfo) {
        if (this.vCT == null) {
            return;
        }
        if (this.vCT.getVerticalTransform() != null) {
            return;
        }
        this.vCT.makeVerticalTransform(gds.getNetcdfDataset(), this.timeDim);
        if (this.vCT.getVerticalTransform() == null) {
            parseInfo.append("  - CAN'T make VerticalTransform = ").append(this.vCT.getVerticalTransformType()).append("\n");
        } else {
            parseInfo.append("  - makeVerticalTransform = ").append(this.vCT.getVerticalTransformType()).append("\n");
        }
    }

    @Override
    public CoordinateAxis getXHorizAxis() {
        return this.horizXaxis;
    }

    @Override
    public CoordinateAxis getYHorizAxis() {
        return this.horizYaxis;
    }

    @Override
    public CoordinateAxis1D getVerticalAxis() {
        return this.vertZaxis;
    }

    @Override
    public CoordinateAxis getTimeAxis() {
        return this.tAxis;
    }

    @Override
    public CoordinateAxis1DTime getTimeAxis1D() {
        return this.timeTaxis;
    }

    @Override
    public CoordinateAxis1DTime getRunTimeAxis() {
        return this.runTimeAxis;
    }

    @Override
    public CoordinateAxis1D getEnsembleAxis() {
        return this.ensembleAxis;
    }

    @Override
    public ProjectionImpl getProjection() {
        return this.proj;
    }

    public List<NamedObject> getLevels() {
        return this.levels;
    }

    public List<NamedObject> getTimes() {
        return this.times;
    }

    public Date[] getTimeDates() {
        return this.timeDates;
    }

    @Override
    public boolean isLatLon() {
        return this.isLatLon;
    }

    public boolean isDate() {
        return this.isDate;
    }

    @Override
    public boolean isZPositive() {
        if (this.vertZaxis == null) {
            return false;
        }
        if (this.vertZaxis.getPositive() != null) {
            return this.vertZaxis.getPositive().equalsIgnoreCase("up");
        }
        if (this.vertZaxis.getAxisType() == AxisType.Height) {
            return true;
        }
        return this.vertZaxis.getAxisType() != AxisType.Pressure;
    }

    @Override
    public boolean isRegularSpatial() {
        if (!this.isRegularSpatial(this.getXHorizAxis())) {
            return false;
        }
        return this.isRegularSpatial(this.getYHorizAxis());
    }

    private boolean isRegularSpatial(CoordinateAxis axis) {
        if (axis == null) {
            return true;
        }
        if (!(axis instanceof CoordinateAxis1D)) {
            return false;
        }
        return ((CoordinateAxis1D)axis).isRegular();
    }

    @Override
    public int[] findXYindexFromCoord(double x_coord, double y_coord, int[] result) {
        if (result == null) {
            result = new int[2];
        }
        if (this.horizXaxis instanceof CoordinateAxis1D && this.horizYaxis instanceof CoordinateAxis1D) {
            result[0] = ((CoordinateAxis1D)this.horizXaxis).findCoordElement(x_coord);
            result[1] = ((CoordinateAxis1D)this.horizYaxis).findCoordElement(y_coord);
            return result;
        }
        if (this.horizXaxis instanceof CoordinateAxis2D && this.horizYaxis instanceof CoordinateAxis2D) {
            result[0] = -1;
            result[1] = -1;
            return result;
        }
        throw new IllegalStateException("GridCoordSystem.findXYindexFromCoord");
    }

    @Override
    public int[] findXYindexFromLatLon(double lat, double lon, int[] result) {
        ProjectionImpl dataProjection = this.getProjection();
        ProjectionPoint pp = dataProjection.latLonToProj(new LatLonPointImpl(lat, lon), new ProjectionPointImpl());
        return this.findXYindexFromCoord(pp.getX(), pp.getY(), result);
    }

    public int[] findXYCoordElement(double x_coord, double y_coord, int[] result) {
        return this.findXYindexFromCoord(x_coord, y_coord, result);
    }

    public int findTimeIndexFromDate(Date d) {
        int index;
        if (this.timeTaxis == null || !this.isDate()) {
            throw new UnsupportedOperationException("GridCoordSys: ti");
        }
        int n = (int)this.timeTaxis.getSize();
        long m = d.getTime();
        for (index = 0; index < n && m >= this.timeDates[index].getTime(); ++index) {
        }
        return index - 1;
    }

    public String getLevelName(int index) {
        if (this.vertZaxis == null || index < 0 || (long)index >= this.vertZaxis.getSize()) {
            throw new IllegalArgumentException("getLevelName = " + index);
        }
        NamedAnything name = (NamedAnything)this.levels.get(index);
        return name.getName();
    }

    public int getLevelIndex(String name) {
        if (this.vertZaxis == null || name == null) {
            return -1;
        }
        for (int i = 0; i < this.levels.size(); ++i) {
            NamedAnything level = (NamedAnything)this.levels.get(i);
            if (!level.getName().trim().equals(name)) continue;
            return i;
        }
        return -1;
    }

    public String getTimeName(int index) {
        if (this.timeTaxis == null || index < 0 || (long)index >= this.timeTaxis.getSize()) {
            throw new IllegalArgumentException("getTimeName = " + index);
        }
        NamedAnything name = (NamedAnything)this.times.get(index);
        return name.getName();
    }

    public int getTimeIndex(String name) {
        if (this.timeTaxis == null || name == null) {
            return -1;
        }
        for (int i = 0; i < this.times.size(); ++i) {
            NamedAnything time = (NamedAnything)this.times.get(i);
            if (!time.getName().trim().equals(name)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public DateRange getDateRange() {
        if (this.isDate()) {
            Date[] dates = this.getTimeDates();
            return new DateRange(dates[0], dates[dates.length - 1]);
        }
        return null;
    }

    @Override
    public boolean hasTimeAxis() {
        return this.tAxis != null;
    }

    @Override
    public boolean hasTimeAxis1D() {
        return this.timeTaxis != null;
    }

    @Override
    public CoordinateAxis1DTime getTimeAxisForRun(int run_index) {
        if (!this.hasTimeAxis() || this.hasTimeAxis1D()) {
            return null;
        }
        int nruns = (int)this.runTimeAxis.getSize();
        if (run_index < 0 || run_index >= nruns) {
            throw new IllegalArgumentException("getTimeAxisForRun index out of bounds= " + run_index);
        }
        if (this.timeAxisForRun == null) {
            this.timeAxisForRun = new CoordinateAxis1DTime[nruns];
        }
        if (this.timeAxisForRun[run_index] == null) {
            this.timeAxisForRun[run_index] = this.makeTimeAxisForRun(run_index);
        }
        return this.timeAxisForRun[run_index];
    }

    private CoordinateAxis1DTime makeTimeAxisForRun(int run_index) {
        try {
            VariableDS section = (VariableDS)this.tAxis.slice(0, run_index);
            return CoordinateAxis1DTime.factory(this.ds, section, null);
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public DateUnit getDateUnit() throws Exception {
        String tUnits = this.getTimeAxis().getUnitsString();
        return (DateUnit)SimpleUnit.factory(tUnits);
    }

    public TimeUnit getTimeResolution() throws Exception {
        if (!this.isRegular()) {
            return null;
        }
        CoordinateAxis1DTime taxis = (CoordinateAxis1DTime)this.getTimeAxis();
        String tUnits = taxis.getUnitsString();
        StringTokenizer stoker = new StringTokenizer(tUnits);
        double tResolution = taxis.getIncrement();
        return new TimeUnit(tResolution, stoker.nextToken());
    }

    @Override
    public ProjectionRect getBoundingBox() {
        if (this.mapArea == null) {
            if (this.horizXaxis == null || !this.horizXaxis.isNumeric() || this.horizYaxis == null || !this.horizYaxis.isNumeric()) {
                return null;
            }
            if (!(this.horizXaxis instanceof CoordinateAxis1D) || !(this.horizYaxis instanceof CoordinateAxis1D)) {
                this.mapArea = new ProjectionRect(this.horizXaxis.getMinValue(), this.horizYaxis.getMinValue(), this.horizXaxis.getMaxValue(), this.horizYaxis.getMaxValue());
            } else {
                CoordinateAxis1D xaxis1 = (CoordinateAxis1D)this.horizXaxis;
                CoordinateAxis1D yaxis1 = (CoordinateAxis1D)this.horizYaxis;
                this.mapArea = new ProjectionRect(xaxis1.getCoordEdge(0), yaxis1.getCoordEdge(0), xaxis1.getCoordEdge((int)xaxis1.getSize()), yaxis1.getCoordEdge((int)yaxis1.getSize()));
            }
        }
        return this.mapArea;
    }

    @Override
    public LatLonPoint getLatLon(int xindex, int yindex) {
        double y;
        CoordinateAxis2D horiz2D;
        double x;
        CoordinateAxis1D horiz1D;
        if (this.horizXaxis instanceof CoordinateAxis1D) {
            horiz1D = (CoordinateAxis1D)this.horizXaxis;
            x = horiz1D.getCoordValue(xindex);
        } else {
            horiz2D = (CoordinateAxis2D)this.horizXaxis;
            x = horiz2D.getCoordValue(xindex, yindex);
        }
        if (this.horizYaxis instanceof CoordinateAxis1D) {
            horiz1D = (CoordinateAxis1D)this.horizYaxis;
            y = horiz1D.getCoordValue(yindex);
        } else {
            horiz2D = (CoordinateAxis2D)this.horizYaxis;
            y = horiz2D.getCoordValue(xindex, yindex);
        }
        return this.isLatLon() ? new LatLonPointImpl(y, x) : this.getLatLon(x, y);
    }

    public LatLonPoint getLatLon(double xcoord, double ycoord) {
        ProjectionImpl dataProjection = this.getProjection();
        return dataProjection.projToLatLon(new ProjectionPointImpl(xcoord, ycoord), new LatLonPointImpl());
    }

    @Override
    public LatLonRect getLatLonBoundingBox() {
        if (this.llbb == null) {
            if (this.isLatLon()) {
                double startLat = this.horizYaxis.getMinValue();
                double startLon = this.horizXaxis.getMinValue();
                double deltaLat = this.horizYaxis.getMaxValue() - startLat;
                double deltaLon = this.horizXaxis.getMaxValue() - startLon;
                LatLonPointImpl llpt = new LatLonPointImpl(startLat, startLon);
                this.llbb = new LatLonRect(llpt, deltaLat, deltaLon);
            } else {
                ProjectionImpl dataProjection = this.getProjection();
                ProjectionRect bb = this.getBoundingBox();
                LatLonPointImpl llpt = (LatLonPointImpl)dataProjection.projToLatLon(bb.getLowerLeftPoint(), new LatLonPointImpl());
                LatLonPointImpl urpt = (LatLonPointImpl)dataProjection.projToLatLon(bb.getUpperRightPoint(), new LatLonPointImpl());
                LatLonPointImpl ulpt = (LatLonPointImpl)dataProjection.projToLatLon(bb.getUpperLeftPoint(), new LatLonPointImpl());
                LatLonPointImpl lrpt = (LatLonPointImpl)dataProjection.projToLatLon(bb.getLowerRightPoint(), new LatLonPointImpl());
                double latMin = Math.min(llpt.getLatitude(), lrpt.getLatitude());
                double latMax = Math.max(ulpt.getLatitude(), urpt.getLatitude());
                double lonMin = this.getMinOrMaxLon(llpt.getLongitude(), ulpt.getLongitude(), true);
                double lonMax = this.getMinOrMaxLon(lrpt.getLongitude(), urpt.getLongitude(), false);
                llpt.set(latMin, lonMin);
                urpt.set(latMax, lonMax);
                this.llbb = new LatLonRect(llpt, urpt);
            }
        }
        return this.llbb;
    }

    private double getMinOrMaxLon(double lon1, double lon2, boolean wantMin) {
        double midpoint = (lon1 + lon2) / 2.0;
        lon1 = LatLonPointImpl.lonNormal(lon1, midpoint);
        lon2 = LatLonPointImpl.lonNormal(lon2, midpoint);
        return wantMin ? Math.min(lon1, lon2) : Math.max(lon1, lon2);
    }

    public List<Range> getLatLonBoundingBox(LatLonRect rect) throws InvalidRangeException {
        return this.getRangesFromLatLonRect(rect);
    }

    @Override
    public List<Range> getRangesFromLatLonRect(LatLonRect rect) throws InvalidRangeException {
        double maxy;
        double maxx;
        double miny;
        double minx;
        LatLonRect bb;
        ProjectionImpl proj = this.getProjection();
        if (proj != null && !(proj instanceof VerticalPerspectiveView) && null == (rect = (bb = this.getLatLonBoundingBox()).intersect(rect))) {
            throw new InvalidRangeException("Request Bounding box does not intersect Grid");
        }
        if (this.isLatLon()) {
            LatLonPointImpl llpt = rect.getLowerLeftPoint();
            LatLonPointImpl urpt = rect.getUpperRightPoint();
            LatLonPointImpl lrpt = rect.getLowerRightPoint();
            LatLonPointImpl ulpt = rect.getUpperLeftPoint();
            minx = this.getMinOrMaxLon(llpt.getLongitude(), ulpt.getLongitude(), true);
            miny = Math.min(llpt.getLatitude(), lrpt.getLatitude());
            maxx = this.getMinOrMaxLon(urpt.getLongitude(), lrpt.getLongitude(), false);
            maxy = Math.min(ulpt.getLatitude(), urpt.getLatitude());
        } else {
            ProjectionRect prect = this.getProjection().latLonToProjBB(rect);
            minx = prect.getMinPoint().getX();
            miny = prect.getMinPoint().getY();
            maxx = prect.getMaxPoint().getX();
            maxy = prect.getMaxPoint().getY();
        }
        CoordinateAxis xaxis = this.getXHorizAxis();
        CoordinateAxis yaxis = this.getYHorizAxis();
        if (xaxis instanceof CoordinateAxis1D && yaxis instanceof CoordinateAxis1D) {
            CoordinateAxis1D xaxis1 = (CoordinateAxis1D)xaxis;
            CoordinateAxis1D yaxis1 = (CoordinateAxis1D)yaxis;
            int minxIndex = xaxis1.findCoordElementBounded(minx);
            int minyIndex = yaxis1.findCoordElementBounded(miny);
            int maxxIndex = xaxis1.findCoordElementBounded(maxx);
            int maxyIndex = yaxis1.findCoordElementBounded(maxy);
            ArrayList<Range> list = new ArrayList<Range>();
            list.add(new Range(Math.min(minyIndex, maxyIndex), Math.max(minyIndex, maxyIndex)));
            list.add(new Range(Math.min(minxIndex, maxxIndex), Math.max(minxIndex, maxxIndex)));
            return list;
        }
        if (xaxis instanceof CoordinateAxis2D && yaxis instanceof CoordinateAxis2D && this.isLatLon()) {
            CoordinateAxis2D lon_axis = (CoordinateAxis2D)xaxis;
            CoordinateAxis2D lat_axis = (CoordinateAxis2D)yaxis;
            int[] shape = lon_axis.getShape();
            int nj = shape[0];
            int ni = shape[1];
            int mini = Integer.MAX_VALUE;
            int minj = Integer.MAX_VALUE;
            int maxi = -1;
            int maxj = -1;
            for (int j = 0; j < nj; ++j) {
                for (int i = 0; i < ni; ++i) {
                    double lat = lat_axis.getCoordValue(j, i);
                    double lon = lon_axis.getCoordValue(j, i);
                    if (!(lat >= miny) || !(lat <= maxy) || !(lon >= minx) || !(lon <= maxx)) continue;
                    if (i > maxi) {
                        maxi = i;
                    }
                    if (i < mini) {
                        mini = i;
                    }
                    if (j > maxj) {
                        maxj = j;
                    }
                    if (j >= minj) continue;
                    minj = j;
                }
            }
            if (mini > maxi || minj > maxj) {
                mini = 0;
                minj = 0;
                maxi = -1;
                maxj = -1;
            }
            ArrayList<Range> list = new ArrayList<Range>();
            list.add(new Range(minj, maxj));
            list.add(new Range(mini, maxi));
            return list;
        }
        throw new IllegalArgumentException("must be 1D or 2D/LatLon ");
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer(200);
        buff.setLength(0);
        buff.append("(").append(this.getName()).append(") ");
        return buff.toString();
    }

    private void makeLevels() {
        this.levels = new ArrayList<NamedObject>();
        if (this.vertZaxis == null) {
            return;
        }
        int n = (int)this.vertZaxis.getSize();
        for (int i = 0; i < n; ++i) {
            this.levels.add(new NamedAnything(this.vertZaxis.getCoordName(i), this.vertZaxis.getUnitsString()));
        }
    }

    private void makeTimes() {
        this.times = new ArrayList<NamedObject>();
        if (this.timeTaxis == null || this.timeTaxis.getSize() == 0L) {
            return;
        }
        int n = (int)this.timeTaxis.getSize();
        this.timeDates = new Date[n];
        SimpleUnit su = null;
        String units = this.timeTaxis.getUnitsString();
        if (units != null) {
            su = SimpleUnit.factory(units);
        }
        if (su != null && su instanceof DateUnit) {
            DateFormatter formatter = new DateFormatter();
            DateUnit du = (DateUnit)su;
            for (int i = 0; i < n; ++i) {
                Date d = du.makeDate(this.timeTaxis.getCoordValue(i));
                String name = formatter.toDateTimeString(d);
                if (name == null) {
                    name = Double.toString(this.timeTaxis.getCoordValue(i));
                }
                this.times.add(new NamedAnything(name, "date/time"));
                this.timeDates[i] = d;
            }
            this.isDate = true;
            return;
        }
        if (this.timeTaxis.getDataType() == DataType.STRING || this.timeTaxis.getDataType() == DataType.CHAR) {
            this.isDate = true;
            DateFormatter formatter = new DateFormatter();
            for (int i = 0; i < n; ++i) {
                String coordValue = this.timeTaxis.getCoordName(i);
                Date d = formatter.getISODate(coordValue);
                if (d == null) {
                    this.isDate = false;
                    this.times.add(new NamedAnything(coordValue, this.timeTaxis.getUnitsString()));
                    continue;
                }
                this.times.add(new NamedAnything(formatter.toDateTimeString(d), "date/time"));
                this.timeDates[i] = d;
            }
            return;
        }
        for (int i = 0; i < n; ++i) {
            this.times.add(new NamedAnything(this.timeTaxis.getCoordName(i), this.timeTaxis.getUnitsString()));
        }
    }

    private static class NamedAnything
    implements NamedObject {
        private String name;
        private String desc;

        NamedAnything(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.desc;
        }

        public String toString() {
            return this.name;
        }
    }
}

