/*
 * Decompiled with CFR 0.152.
 */
package thredds.wcs.v1_0_0_Plus;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.wcs.v1_0_0_Plus.WcsException;
import thredds.wcs.v1_0_0_Plus.WcsRequest;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.grid.NetcdfCFWriter;
import ucar.nc2.util.DiskCache2;

public class GetCoverage
extends WcsRequest {
    private static Logger log = LoggerFactory.getLogger(GetCoverage.class);
    private String coverageId;
    private static DiskCache2 diskCache = null;

    public GetCoverage(WcsRequest.Operation operation, String version, String datasetPath, GridDataset dataset, String coverageId) {
        super(operation, version, datasetPath, dataset);
        this.coverageId = coverageId;
        if (this.coverageId == null) {
            throw new IllegalArgumentException("Non-null coverage identifier required.");
        }
    }

    public static void setDiskCache(DiskCache2 _diskCache) {
        diskCache = _diskCache;
    }

    private static DiskCache2 getDiskCache() {
        if (diskCache == null) {
            log.error("getDiskCache(): Disk cache has not been set.");
            throw new IllegalStateException("Disk cache must be set before calling GetCoverage.getDiskCache().");
        }
        return diskCache;
    }

    public File writeCoverageDataToFile() throws WcsException {
        File ncFile = GetCoverage.getDiskCache().getCacheFile(this.getDatasetPath() + "-" + this.coverageId + ".nc");
        NetcdfCFWriter writer = new NetcdfCFWriter();
        try {
            writer.makeFile(ncFile.getPath(), this.getDataset(), Collections.singletonList(this.coverageId), null, null, true, 1, 1, 1);
        }
        catch (InvalidRangeException e) {
            log.error("writeCoverageDataToFile(): Failed to subset coverage <" + this.coverageId + ">: " + e.getMessage());
            throw new WcsException(WcsException.Code.CoverageNotDefined, "", "Failed to subset coverage <" + this.coverageId + ">.");
        }
        catch (IOException e) {
            log.error("writeCoverageDataToFile(): Failed to write file for requested coverage <" + this.coverageId + ">: " + e.getMessage());
            throw new WcsException(WcsException.Code.UNKNOWN, "", "Problem creating coverage <" + this.coverageId + ">.");
        }
        return ncFile;
    }
}

