/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.importer;

import ij.IJ;
import ij.gui.GenericDialog;
import java.awt.Container;
import loci.formats.DimensionSwapper;
import loci.plugins.importer.ImporterOptions;
import loci.plugins.prefs.OptionsDialog;
import loci.plugins.util.WindowTools;

public class SwapDialog
extends OptionsDialog {
    protected ImporterOptions options;
    protected DimensionSwapper r;
    protected boolean[] series;

    public SwapDialog(ImporterOptions options, DimensionSwapper r, boolean[] series) {
        super(options);
        this.options = options;
        this.r = r;
        this.series = series;
    }

    public int showDialog() {
        int n;
        boolean valid = false;
        GenericDialog gd = new GenericDialog("Dimension swapping options");
        int oldSeries = this.r.getSeries();
        String[] labels = new String[]{"Z", "C", "T"};
        int[] sizes = new int[]{this.r.getSizeZ(), this.r.getSizeC(), this.r.getSizeT()};
        for (n = 0; n < this.r.getSeriesCount(); ++n) {
            if (!this.series[n]) continue;
            this.r.setSeries(n);
            gd.addMessage("Series " + (n + 1) + ":\n");
            for (int i = 0; i < labels.length; ++i) {
                gd.addChoice(sizes[i] + "_planes", labels, labels[i]);
            }
        }
        WindowTools.addScrollBars((Container)gd);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return 1;
        }
        for (n = 0; n < this.r.getSeriesCount(); ++n) {
            if (!this.series[n]) continue;
            this.r.setSeries(n);
            String z = gd.getNextChoice();
            String c = gd.getNextChoice();
            String t = gd.getNextChoice();
            if (z.equals(t) || z.equals(c) || c.equals(t)) {
                IJ.error((String)"Invalid swapping options - each axis can be used only once.");
                return this.showDialog();
            }
            String originalOrder = this.r.getDimensionOrder();
            StringBuffer sb = new StringBuffer();
            sb.append("XY");
            for (int i = 2; i < originalOrder.length(); ++i) {
                if (originalOrder.charAt(i) == 'Z') {
                    sb.append(z);
                    continue;
                }
                if (originalOrder.charAt(i) == 'C') {
                    sb.append(c);
                    continue;
                }
                if (originalOrder.charAt(i) != 'T') continue;
                sb.append(t);
            }
            this.r.swapDimensions(sb.toString());
        }
        this.r.setSeries(oldSeries);
        return 0;
    }
}

