/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins;

import ij.IJ;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import loci.common.RandomAccessInputStream;

public class Updater
implements PlugIn {
    public static final String TRUNK_BUILD = "http://hudson.openmicroscopy.org.uk/job/LOCI/lastSuccessfulBuild/artifact/trunk/artifacts/loci_tools.jar";
    public static final String TODAYS_BUILD = "http://loci.wisc.edu/software/daily/loci_tools.jar";
    public static final String YESTERDAYS_BUILD = "http://loci.wisc.edu/software/daily.old/loci_tools.jar";
    public static final String STABLE_BUILD = "http://loci.wisc.edu/software/loci_tools.jar";
    public static final String STABLE_VERSION = "4.0.1";
    public static final String REGISTRY = "http://upgrade.openmicroscopy.org.uk";
    public static final String[] REGISTRY_PROPERTIES = new String[]{"version", "os.name", "os.version", "os.arch", "java.runtime.version", "java.vm.vendor"};
    public boolean canceled;
    private String arg;

    public void run(String arg) {
        GenericDialog upgradeDialog = new GenericDialog("Update LOCI Plugins");
        String[] options = new String[]{"Trunk build", "Daily build (today)", "Daily build (yesterday)", "Stable build (4.0.1)"};
        upgradeDialog.addChoice("Release", options, options[0]);
        upgradeDialog.showDialog();
        if (upgradeDialog.wasCanceled()) {
            this.canceled = true;
            return;
        }
        String release = upgradeDialog.getNextChoice();
        if (release.equals(options[0])) {
            Updater.install(TRUNK_BUILD);
        } else if (release.equals(options[1])) {
            Updater.install(TODAYS_BUILD);
        } else if (release.equals(options[2])) {
            Updater.install(YESTERDAYS_BUILD);
        } else {
            Updater.install(STABLE_BUILD);
        }
    }

    public static boolean newVersionAvailable() {
        StringBuffer query = new StringBuffer(REGISTRY);
        for (int i = 0; i < REGISTRY_PROPERTIES.length; ++i) {
            if (i == 0) {
                query.append("?");
            } else {
                query.append(";");
            }
            query.append(REGISTRY_PROPERTIES[i]);
            query.append("=");
            if (i == 0) {
                query.append(STABLE_VERSION);
                continue;
            }
            try {
                query.append(URLEncoder.encode(System.getProperty(REGISTRY_PROPERTIES[i]), "UTF-8"));
                continue;
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        try {
            int data;
            URLConnection conn = new URL(query.toString()).openConnection();
            conn.setUseCaches(false);
            conn.addRequestProperty("User-Agent", "OMERO.imagej");
            conn.connect();
            InputStream in = conn.getInputStream();
            StringBuffer latestVersion = new StringBuffer();
            while ((data = in.read()) != -1) {
                latestVersion.append((char)data);
            }
            in.close();
            String[] version = latestVersion.toString().split("\\.");
            String[] thisVersion = STABLE_VERSION.split("\\.");
            for (int i = 0; i < thisVersion.length; ++i) {
                int subVersion = Integer.parseInt(thisVersion[i]);
                try {
                    int registrySubVersion = Integer.parseInt(version[i]);
                    if (registrySubVersion > subVersion) {
                        return true;
                    }
                    if (registrySubVersion >= subVersion) continue;
                    return false;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static void install(String url) {
        String pluginsDirectory = IJ.getDirectory((String)"plugins");
        String jarPath = pluginsDirectory + File.separator + "loci_tools.jar";
        String downloadPath = jarPath + ".tmp";
        File plugin = new File(downloadPath);
        if (plugin.exists()) {
            plugin.delete();
        }
        IJ.showStatus((String)"Downloading loci_tools.jar...");
        try {
            RandomAccessInputStream in = new RandomAccessInputStream(url);
            byte[] buf = new byte[(int)in.length()];
            in.read(buf);
            in.close();
            FileOutputStream out = new FileOutputStream(plugin);
            out.write(buf);
            out.close();
            plugin.renameTo(new File(jarPath));
        }
        catch (IOException e) {
            IJ.showMessage((String)"An error occurred while downloading the LOCI plugins");
            e.printStackTrace();
            return;
        }
        IJ.showStatus((String)"");
        IJ.showMessage((String)"The LOCI plugins have been downloaded.\nPlease restart ImageJ to complete the upgrade process.");
    }
}

