/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.out;

import java.awt.image.IndexColorModel;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.RandomAccessOutputStream;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.FormatWriter;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataRetrieve;

public class AVIWriter
extends FormatWriter {
    private RandomAccessOutputStream out;
    private int planesWritten = 0;
    private int bytesPerPixel;
    private File file;
    private int xDim;
    private int yDim;
    private int zDim;
    private int tDim;
    private int xPad;
    private int microSecPerFrame;
    private long saveFileSize;
    private long saveLIST1Size;
    private long saveLIST1subSize;
    private long savestrfSize;
    private long savestrnPos;
    private long saveJUNKsignature;
    private int paddingBytes;
    private long saveLIST2Size;
    private byte[] dataSignature;
    private Vector savedbLength;
    private long idx1Pos;
    private long endPos;
    private long saveidx1Length;
    private int z;
    private long savemovi;
    private int xMod;
    private long frameOffset;
    private long frameOffset2;

    public AVIWriter() {
        super("Audio Video Interleave", "avi");
    }

    public void saveBytes(byte[] buf, int series, boolean lastInSeries, boolean last) throws FormatException, IOException {
        if (buf == null) {
            throw new FormatException("Byte array is null");
        }
        MetadataRetrieve meta = this.getMetadataRetrieve();
        MetadataTools.verifyMinimumPopulated(meta, series);
        int type = FormatTools.pixelTypeFromString(meta.getPixelsPixelType(series, 0));
        if (!DataTools.containsValue(this.getPixelTypes(), type)) {
            throw new FormatException("Unsupported image type '" + FormatTools.getPixelTypeString(type) + "'.");
        }
        int nChannels = meta.getLogicalChannelSamplesPerPixel(series, 0);
        byte[][] lut = null;
        if (this.getColorModel() instanceof IndexColorModel) {
            lut = new byte[4][256];
            IndexColorModel model = (IndexColorModel)this.getColorModel();
            model.getReds(lut[0]);
            model.getGreens(lut[1]);
            model.getBlues(lut[2]);
            model.getAlphas(lut[3]);
        }
        if (!this.initialized) {
            this.initialized = true;
            this.planesWritten = 0;
            this.bytesPerPixel = nChannels == 2 ? 3 : nChannels;
            this.out = new RandomAccessOutputStream(this.currentId);
            this.out.seek(this.out.length());
            this.saveFileSize = 4L;
            this.saveLIST1Size = 16L;
            this.saveLIST1subSize = 92L;
            this.frameOffset = 48L;
            this.frameOffset2 = 140L;
            this.savestrfSize = 168L;
            this.savestrnPos = this.savestrfSize + 44L + (long)(this.bytesPerPixel == 1 ? 1024 : 0);
            this.saveJUNKsignature = this.savestrnPos + 24L;
            this.saveLIST2Size = 4088L;
            this.savemovi = 4092L;
            this.savedbLength = new Vector();
            this.dataSignature = new byte[4];
            this.dataSignature[0] = 48;
            this.dataSignature[1] = 48;
            this.dataSignature[2] = 100;
            this.dataSignature[3] = 98;
            this.tDim = 1;
            this.zDim = 1;
            this.yDim = meta.getPixelsSizeY(series, 0);
            this.xDim = meta.getPixelsSizeX(series, 0);
            this.xPad = 0;
            this.xMod = this.xDim % 4;
            if (this.xMod != 0) {
                this.xPad = 4 - this.xMod;
                this.xDim += this.xPad;
            }
            if (this.out.length() == 0L) {
                int i;
                DataTools.writeString(this.out, "RIFF");
                DataTools.writeInt(this.out, 0, true);
                DataTools.writeString(this.out, "AVI ");
                DataTools.writeString(this.out, "LIST");
                DataTools.writeInt(this.out, this.bytesPerPixel == 1 ? 1240 : 216, true);
                DataTools.writeString(this.out, "hdrl");
                DataTools.writeString(this.out, "avih");
                DataTools.writeInt(this.out, 56, true);
                this.microSecPerFrame = (int)(1.0 / (double)this.fps * 1000000.0);
                DataTools.writeInt(this.out, this.microSecPerFrame, true);
                DataTools.writeInt(this.out, 0, true);
                DataTools.writeInt(this.out, 0, true);
                DataTools.writeInt(this.out, 16, true);
                DataTools.writeInt(this.out, this.zDim * this.tDim, true);
                DataTools.writeInt(this.out, 0, true);
                DataTools.writeInt(this.out, 1, true);
                DataTools.writeInt(this.out, 0, true);
                DataTools.writeInt(this.out, this.xDim - this.xPad, true);
                DataTools.writeInt(this.out, this.yDim, true);
                DataTools.writeInt(this.out, 0, true);
                DataTools.writeInt(this.out, 0, true);
                DataTools.writeInt(this.out, 0, true);
                DataTools.writeInt(this.out, 0, true);
                DataTools.writeString(this.out, "LIST");
                DataTools.writeInt(this.out, this.bytesPerPixel == 1 ? 1164 : 140, true);
                DataTools.writeString(this.out, "strl");
                DataTools.writeString(this.out, "strh");
                DataTools.writeInt(this.out, 56, true);
                DataTools.writeString(this.out, "vids");
                DataTools.writeString(this.out, "DIB ");
                DataTools.writeInt(this.out, 0, true);
                DataTools.writeInt(this.out, 0, true);
                DataTools.writeInt(this.out, 0, true);
                DataTools.writeInt(this.out, 1, true);
                DataTools.writeInt(this.out, this.fps, true);
                DataTools.writeInt(this.out, 0, true);
                DataTools.writeInt(this.out, this.tDim * this.zDim, true);
                DataTools.writeInt(this.out, 0, true);
                DataTools.writeInt(this.out, -1, true);
                DataTools.writeInt(this.out, 0, true);
                DataTools.writeShort(this.out, 0, true);
                DataTools.writeShort(this.out, 0, true);
                DataTools.writeShort(this.out, 0, true);
                DataTools.writeShort(this.out, 0, true);
                DataTools.writeString(this.out, "strf");
                DataTools.writeInt(this.out, this.bytesPerPixel == 1 ? 1068 : 44, true);
                DataTools.writeInt(this.out, 40, true);
                DataTools.writeInt(this.out, this.xDim, true);
                DataTools.writeInt(this.out, this.yDim, true);
                DataTools.writeShort(this.out, 1, true);
                int bitsPerPixel = this.bytesPerPixel == 3 ? 24 : 8;
                DataTools.writeShort(this.out, (short)bitsPerPixel, true);
                DataTools.writeInt(this.out, 0, true);
                DataTools.writeInt(this.out, 0, true);
                DataTools.writeInt(this.out, 0, true);
                DataTools.writeInt(this.out, 0, true);
                int nColors = lut == null ? 0 : 256;
                DataTools.writeInt(this.out, nColors, true);
                DataTools.writeInt(this.out, 0, true);
                if (this.bytesPerPixel == 1) {
                    if (lut != null) {
                        for (i = 0; i < 256; ++i) {
                            this.out.write(lut[2][i]);
                            this.out.write(lut[1][i]);
                            this.out.write(lut[0][i]);
                            this.out.write(lut[3][i]);
                        }
                    } else {
                        byte[] lutWrite = new byte[1024];
                        for (int i2 = 0; i2 < 256; ++i2) {
                            lutWrite[4 * i2] = (byte)i2;
                            lutWrite[4 * i2 + 1] = (byte)i2;
                            lutWrite[4 * i2 + 2] = (byte)i2;
                            lutWrite[4 * i2 + 3] = 0;
                        }
                        this.out.write(lutWrite);
                    }
                }
                this.out.seek(this.savestrfSize);
                DataTools.writeInt(this.out, (int)(this.savestrnPos - (this.savestrfSize + 4L)), true);
                this.out.seek(this.savestrnPos);
                DataTools.writeString(this.out, "strn");
                DataTools.writeInt(this.out, 16, true);
                DataTools.writeString(this.out, "FileAVI write  ");
                this.out.seek(this.saveLIST1Size);
                DataTools.writeInt(this.out, (int)(this.saveJUNKsignature - (this.saveLIST1Size + 4L)), true);
                this.out.seek(this.saveLIST1subSize);
                DataTools.writeInt(this.out, (int)(this.saveJUNKsignature - (this.saveLIST1subSize + 4L)), true);
                this.out.seek(this.saveJUNKsignature);
                DataTools.writeString(this.out, "JUNK");
                this.paddingBytes = (int)(4084L - (this.saveJUNKsignature + 8L));
                DataTools.writeInt(this.out, this.paddingBytes, true);
                for (i = 0; i < this.paddingBytes / 2; ++i) {
                    DataTools.writeShort(this.out, 0, true);
                }
                DataTools.writeString(this.out, "LIST");
                this.saveLIST2Size = this.out.getFilePointer();
                DataTools.writeInt(this.out, 0, true);
                DataTools.writeString(this.out, "movi");
            }
        }
        int width = this.xDim - this.xPad;
        int height = buf.length / (width * this.bytesPerPixel);
        this.out.write(this.dataSignature);
        this.savedbLength.add(new Long(this.out.getFilePointer()));
        DataTools.writeInt(this.out, this.bytesPerPixel * this.xDim * this.yDim, true);
        int rowPad = this.xPad * this.bytesPerPixel;
        byte[] rowBuffer = new byte[width * this.bytesPerPixel + rowPad];
        for (int row = height - 1; row >= 0; --row) {
            for (int col = 0; col < width; ++col) {
                int offset = row * width + col;
                if (this.interleaved) {
                    offset *= nChannels;
                }
                byte r = buf[offset];
                if (nChannels > 1) {
                    byte g = buf[offset + (this.interleaved ? 1 : width * height)];
                    byte b = 0;
                    if (nChannels > 2) {
                        b = buf[offset + (this.interleaved ? 2 : 2 * width * height)];
                    }
                    rowBuffer[col * this.bytesPerPixel] = b;
                    rowBuffer[col * this.bytesPerPixel + 1] = g;
                }
                rowBuffer[col * this.bytesPerPixel + this.bytesPerPixel - 1] = r;
            }
            this.out.write(rowBuffer);
        }
        ++this.planesWritten;
        if (last) {
            this.idx1Pos = this.out.getFilePointer();
            this.out.seek(this.saveLIST2Size);
            DataTools.writeInt(this.out, (int)(this.idx1Pos - (this.saveLIST2Size + 4L)), true);
            this.out.seek(this.idx1Pos);
            DataTools.writeString(this.out, "idx1");
            this.saveidx1Length = this.out.getFilePointer();
            DataTools.writeInt(this.out, 4 + this.planesWritten * 16, true);
            this.z = 0;
            while (this.z < this.planesWritten) {
                this.out.write(this.dataSignature);
                if (this.z == 0) {
                    DataTools.writeInt(this.out, 16, true);
                } else {
                    DataTools.writeInt(this.out, 0, true);
                }
                DataTools.writeInt(this.out, (int)((Long)this.savedbLength.get(this.z) - 4L - this.savemovi), true);
                DataTools.writeInt(this.out, this.bytesPerPixel * this.xDim * this.yDim, true);
                ++this.z;
            }
            this.endPos = this.out.getFilePointer();
            this.out.seek(this.saveFileSize);
            DataTools.writeInt(this.out, (int)(this.endPos - (this.saveFileSize + 4L)), true);
            this.out.seek(this.saveidx1Length);
            DataTools.writeInt(this.out, (int)(this.endPos - (this.saveidx1Length + 4L)), true);
            this.out.seek(this.frameOffset);
            DataTools.writeInt(this.out, this.planesWritten, true);
            this.out.seek(this.frameOffset2);
            DataTools.writeInt(this.out, this.planesWritten, true);
            this.out.close();
        }
    }

    public boolean canDoStacks() {
        return true;
    }

    public int[] getPixelTypes() {
        return new int[]{1};
    }

    public void close() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
        this.out = null;
        this.currentId = null;
        this.initialized = false;
    }
}

