/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.POITools;
import loci.formats.meta.FilterMetadata;

public class TillVisionReader
extends FormatReader {
    private static final byte[] MARKER_0 = new byte[]{37, -128, 3, 0};
    private static final byte[] MARKER_1 = new byte[]{-106, -127, 3, 0};
    private RandomAccessInputStream[] pixelsStream;
    private Hashtable exposureTimes;
    private boolean embeddedImages;
    private int embeddedOffset;

    public TillVisionReader() {
        super("TillVision", "vws");
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        return false;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int plane = FormatTools.getPlaneSize(this);
        if (this.embeddedImages) {
            this.in.seek(this.embeddedOffset + no * plane);
            this.readPlane(this.in, x, y, w, h, buf);
        } else {
            this.pixelsStream[this.series].seek(no * plane);
            this.readPlane(this.pixelsStream[this.series], x, y, w, h, buf);
        }
        return buf;
    }

    public void close() throws IOException {
        super.close();
        if (this.pixelsStream != null) {
            for (int i = 0; i < this.pixelsStream.length; ++i) {
                if (this.pixelsStream[i] == null) continue;
                this.pixelsStream[i].close();
            }
        }
        this.pixelsStream = null;
        this.embeddedOffset = 0;
    }

    protected void initFile(String id) throws FormatException, IOException {
        int i;
        this.debug("TillVisionReader.initFile(" + id + ")");
        super.initFile(id);
        this.exposureTimes = new Hashtable();
        POITools poi = new POITools(id);
        Vector documents = poi.getDocumentList();
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        Vector<String> imageNames = new Vector<String>();
        Vector<String> waves = new Vector<String>();
        Vector<String> types = new Vector<String>();
        Vector<String> dates = new Vector<String>();
        int nImages = 0;
        Hashtable tmpSeriesMetadata = new Hashtable();
        block2: for (int i2 = 0; i2 < documents.size(); ++i2) {
            String name = (String)documents.get(i2);
            if (!name.equals("Root Entry/Contents")) continue;
            RandomAccessInputStream s = poi.getDocumentStream(name);
            byte[] b = new byte[(int)s.length()];
            s.read(b);
            boolean pos = false;
            boolean nFound = false;
            boolean bl = this.embeddedImages = b[0] == 1;
            if (this.embeddedImages) {
                int len = DataTools.bytesToShort(b, 13, 2, true);
                String type = new String(b, 15, len);
                if (!type.equals("CImage")) {
                    this.embeddedImages = false;
                    continue;
                }
                int offset = 27;
                len = b[offset++] & 0xFF;
                while (len != 0) {
                    offset += len;
                    len = b[offset++] & 0xFF;
                }
                this.core[0].sizeX = DataTools.bytesToInt(b, offset += 1243, 4, true);
                this.core[0].sizeY = DataTools.bytesToInt(b, offset += 4, 4, true);
                this.core[0].sizeZ = DataTools.bytesToInt(b, offset += 4, 4, true);
                this.core[0].sizeC = DataTools.bytesToInt(b, offset += 4, 4, true);
                this.core[0].sizeT = DataTools.bytesToInt(b, offset += 4, 4, true);
                this.core[0].pixelType = this.convertPixelType(DataTools.bytesToInt(b, offset += 4, 4, true));
                this.embeddedOffset = offset + 32;
                this.in = poi.getDocumentStream(name);
            }
            byte[] marker = this.getMarker(b);
            byte[] check = new byte[]{4, 0, 0, 4};
            s.seek(0L);
            while (s.getFilePointer() < s.length() - 2L) {
                s.order(false);
                s.seek(this.findNextOffset(b, marker, (int)s.getFilePointer()));
                if (s.getFilePointer() < 0L) continue block2;
                s.skipBytes(3);
                short len = s.readShort();
                if (len <= 0) continue;
                imageNames.add(s.readString(len));
                s.skipBytes(6);
                s.order(true);
                len = s.readShort();
                if (len < 0 || len > 4096) continue;
                String description = s.readString(len);
                String dateTime = "";
                String[] lines = description.split("\n");
                for (int q = 0; q < lines.length; ++q) {
                    lines[q] = lines[q].trim();
                    if (lines[q].indexOf(":") == -1 || lines[q].startsWith(";")) continue;
                    String key = lines[q].substring(0, lines[q].indexOf(":")).trim();
                    String value = lines[q].substring(lines[q].indexOf(":") + 1).trim();
                    String metaKey = "Series " + nImages + " " + key;
                    this.addMeta(metaKey, value, tmpSeriesMetadata);
                    if (key.equals("Start time of experiment")) {
                        dateTime = dateTime + " " + value;
                        continue;
                    }
                    if (key.equals("Date")) {
                        dateTime = value + " " + dateTime;
                        continue;
                    }
                    if (key.equals("Exposure time [ms]")) {
                        float exp = Float.parseFloat(value) / 1000.0f;
                        this.exposureTimes.put(new Integer(nImages), new Float(exp));
                        continue;
                    }
                    if (key.equals("Image type")) {
                        types.add(value);
                        continue;
                    }
                    if (key.equals("Monochromator wavelength [nm]") || !key.equals("Monochromator wavelength increment[nm]")) continue;
                    waves.add(value);
                }
                if (!(dateTime = dateTime.trim()).equals("")) {
                    String[] formats = new String[]{"mm/dd/yy HH:mm:ss aa", "mm/dd/yy HH:mm:ss.SSS aa", "mm/dd/yy", "HH:mm:ss aa", "HH:mm:ss.SSS aa"};
                    boolean success = false;
                    for (int q = 0; q < formats.length; ++q) {
                        try {
                            dateTime = DataTools.formatDate(dateTime, formats[q]);
                            success = true;
                            continue;
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                    }
                    dates.add(success ? dateTime : "");
                }
                ++nImages;
            }
        }
        String directory = new Location(this.currentId).getAbsoluteFile().getParent();
        Object[] pixelsFile = new String[nImages];
        if (!this.embeddedImages) {
            if (nImages == 0) {
                throw new FormatException("No images found.");
            }
            this.core = new CoreMetadata[nImages];
            Location dir = new Location(directory);
            String[] files = dir.list();
            int nextFile = 0;
            for (int i3 = 0; i3 < files.length; ++i3) {
                if (!files[i3].endsWith(".pst")) continue;
                Location pst = new Location(directory + File.separator + files[i3]);
                if (pst.isDirectory()) {
                    String[] subfiles = pst.list();
                    for (int q = 0; q < subfiles.length; ++q) {
                        if (!subfiles[q].endsWith(".pst") || nextFile >= nImages) continue;
                        pixelsFile[nextFile++] = files[i3] + File.separator + subfiles[q];
                    }
                    continue;
                }
                if (nextFile >= nImages) continue;
                pixelsFile[nextFile++] = files[i3];
            }
            if (nextFile == 0) {
                throw new FormatException("No image files found.");
            }
        }
        Arrays.sort(pixelsFile);
        this.pixelsStream = new RandomAccessInputStream[this.getSeriesCount()];
        Object[] metadataKeys = tmpSeriesMetadata.keySet().toArray();
        for (i = 0; i < this.getSeriesCount(); ++i) {
            if (!this.embeddedImages) {
                this.core[i] = new CoreMetadata();
                Object file2 = pixelsFile[i];
                file2 = ((String)file2).replaceAll("/", File.separator);
                Object oldFile = file2 = ((String)file2).replace('\\', File.separatorChar);
                file2 = directory + File.separator + (String)oldFile;
                if (!new Location((String)file2).exists()) {
                    oldFile = ((String)oldFile).substring(((String)oldFile).lastIndexOf(File.separator) + 1);
                    file2 = directory + File.separator + (String)oldFile;
                    if (!new Location((String)file2).exists()) {
                        throw new FormatException("Could not find pixels file '" + (String)file2);
                    }
                }
                this.pixelsStream[i] = new RandomAccessInputStream((String)file2);
                int dot = ((String)file2).lastIndexOf(".");
                String infFile = ((String)file2).substring(0, dot) + ".inf";
                this.in = new RandomAccessInputStream(infFile);
                String data = this.in.readString((int)this.in.length());
                StringTokenizer lines = new StringTokenizer(data);
                while (lines.hasMoreTokens()) {
                    String line = lines.nextToken().trim();
                    if (line.startsWith("[") || line.indexOf("=") == -1) continue;
                    int equal = line.indexOf("=");
                    String key = line.substring(0, equal).trim();
                    String value = line.substring(equal + 1).trim();
                    this.addGlobalMeta(key, value);
                    if (key.equals("Width")) {
                        this.core[i].sizeX = Integer.parseInt(value);
                        continue;
                    }
                    if (key.equals("Height")) {
                        this.core[i].sizeY = Integer.parseInt(value);
                        continue;
                    }
                    if (key.equals("Bands")) {
                        this.core[i].sizeC = Integer.parseInt(value);
                        continue;
                    }
                    if (key.equals("Slices")) {
                        this.core[i].sizeZ = Integer.parseInt(value);
                        continue;
                    }
                    if (key.equals("Frames")) {
                        this.core[i].sizeT = Integer.parseInt(value);
                        continue;
                    }
                    if (!key.equals("Datatype")) continue;
                    this.core[i].pixelType = this.convertPixelType(Integer.parseInt(value));
                }
                this.in.close();
            }
            this.core[i].imageCount = this.core[i].sizeZ * this.core[i].sizeC * this.core[i].sizeT;
            this.core[i].rgb = false;
            this.core[i].littleEndian = true;
            this.core[i].dimensionOrder = "XYCZT";
            this.core[i].seriesMetadata = new Hashtable();
            for (Object key : metadataKeys) {
                String keyName = key.toString();
                if (!keyName.startsWith("Series " + i + " ")) continue;
                keyName = keyName.replaceAll("Series " + i + " ", "");
                this.core[i].seriesMetadata.put(keyName, tmpSeriesMetadata.get(key));
            }
        }
        tmpSeriesMetadata = null;
        MetadataTools.populatePixels(store, this, true);
        for (i = 0; i < this.getSeriesCount(); ++i) {
            int waveIncrement;
            String date;
            if (i < imageNames.size()) {
                store.setImageName((String)imageNames.get(i), i);
            }
            String string = date = i < dates.size() ? (String)dates.get(i) : "";
            if (date != null && !date.equals("")) {
                store.setImageCreationDate(date, i);
            } else {
                MetadataTools.setDefaultCreationDate(store, id, i);
            }
            for (int q = 0; q < this.core[i].imageCount; ++q) {
                store.setPlaneTimingExposureTime((Float)this.exposureTimes.get(new Integer(i)), i, 0, q);
            }
            if (i < waves.size() && (waveIncrement = Integer.parseInt((String)waves.get(i))) > 0) {
                store.setDimensionsWaveIncrement(new Integer(waveIncrement), i, 0);
            }
            if (i >= types.size()) continue;
            store.setExperimentType((String)types.get(i), i);
        }
    }

    private int convertPixelType(int type) throws FormatException {
        switch (type) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
        }
        throw new FormatException("Unsupported data type: " + type);
    }

    private byte[] getMarker(byte[] s) throws IOException {
        int offset = this.findNextOffset(s, MARKER_0, 0);
        if (offset != -1) {
            return MARKER_0;
        }
        return MARKER_1;
    }

    private int findNextOffset(byte[] s, byte[] marker, int pos) throws IOException {
        for (int i = pos; i < s.length - marker.length; ++i) {
            boolean found = true;
            for (int q = 0; q < marker.length; ++q) {
                if (marker[q] == s[i + q]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return i + marker.length;
        }
        return -1;
    }
}

